/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.StorablePreparedStatement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

public class SPSDescriptor
extends UniqueSQLObjectDescriptor
implements Dependent,
Provider {
    public static final char SPS_TYPE_TRIGGER = 'T';
    public static final char SPS_TYPE_REGULAR = 'S';
    public static final char SPS_TYPE_EXPLAIN = 'X';
    private static final int RECOMPILE = 1;
    private static final int INVALIDATE = 0;
    private final SchemaDescriptor sd;
    private final String name;
    private final UUID compSchemaId;
    private final char type;
    private String text;
    private final String usingText;
    private final UUID uuid;
    private boolean valid;
    private ExecPreparedStatement preparedStatement;
    private DataTypeDescriptor[] params;
    private Timestamp compileTime;
    private Object[] paramDefaults;
    private final boolean initiallyCompilable;
    private boolean lookedUpParams;
    private UUIDFactory uuidFactory;

    public SPSDescriptor(DataDictionary dataDictionary, String name, UUID uuid, UUID suuid, UUID compSchemaUUID, char type, boolean valid, String text, boolean initiallyCompilable) throws StandardException {
        this(dataDictionary, name, uuid, suuid, compSchemaUUID, type, valid, text, null, null, null, initiallyCompilable);
    }

    public SPSDescriptor(DataDictionary dataDictionary, String name, UUID uuid, UUID suuid, UUID compSchemaUUID, char type, boolean valid, String text, String usingText, Timestamp compileTime, ExecPreparedStatement preparedStatement, boolean initiallyCompilable) throws StandardException {
        super(dataDictionary);
        if (uuid == null) {
            throw new IllegalArgumentException("UUID is null");
        }
        this.name = name;
        this.uuid = uuid;
        this.type = type;
        this.text = text;
        this.usingText = usingText;
        this.valid = valid;
        this.compileTime = DataTypeUtilities.clone(compileTime);
        this.sd = dataDictionary.getSchemaDescriptor(suuid, null);
        this.preparedStatement = preparedStatement;
        this.compSchemaId = compSchemaUUID;
        this.initiallyCompilable = initiallyCompilable;
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext lcc, TableDescriptor triggerTable, TransactionController tc) throws StandardException {
        if (triggerTable != null) {
            SanityManager.ASSERT(this.type == 'T', "only expect a table descriptor when we have a trigger");
        }
        this.compileStatement(lcc, triggerTable, tc);
        this.preparedStatement.makeInvalid(11, lcc);
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext lcc, TableDescriptor triggerTable) throws StandardException {
        this.prepareAndRelease(lcc, triggerTable, null);
    }

    public final synchronized void prepareAndRelease(LanguageConnectionContext lcc) throws StandardException {
        this.prepareAndRelease(lcc, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileStatement(LanguageConnectionContext lcc, TableDescriptor triggerTable, TransactionController tc) throws StandardException {
        String uuidStr;
        ContextManager cm = lcc.getContextManager();
        LanguageConnectionFactory lcf = lcc.getLanguageConnectionFactory();
        DataDictionary dd = this.getDataDictionary();
        if (this.type == 'T' && triggerTable == null && (triggerTable = dd.getTableDescriptor(this.recreateUUID(uuidStr = this.name.substring(49)))) == null) {
            SanityManager.THROWASSERT("couldn't find trigger table for trigger sps " + this.name);
        }
        if (triggerTable != null) {
            lcc.pushTriggerTable(triggerTable);
        }
        Statement stmt = lcf.getStatement(dd.getSchemaDescriptor(this.compSchemaId, null), this.text, true);
        try {
            this.preparedStatement = (ExecPreparedStatement)stmt.prepareStorable(lcc, this.preparedStatement, this.getParameterDefaults(), this.getSchemaDescriptor(), this.type == 'T');
        }
        finally {
            if (triggerTable != null) {
                lcc.popTriggerTable(triggerTable);
            }
        }
        if (this.preparedStatement.referencesSessionSchema()) {
            throw StandardException.newException("XCL51.S", new Object[0]);
        }
        this.setCompileTime();
        this.setParams(this.preparedStatement.getParameterTypes());
        if (!dd.isReadOnlyUpgrade()) {
            dd.startWriting(lcc);
            DependencyManager dm = dd.getDependencyManager();
            dm.clearDependencies(lcc, this, tc);
            dm.copyDependencies(this.preparedStatement, this, false, cm, tc);
            if (triggerTable != null) {
                dm.addDependency(this, triggerTable, lcc.getContextManager());
            }
        }
        this.valid = true;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String getQualifiedName() {
        return this.sd.getSchemaName() + "." + this.name;
    }

    @Override
    public final SchemaDescriptor getSchemaDescriptor() {
        return this.sd;
    }

    public final char getType() {
        return this.type;
    }

    public final String getTypeAsString() {
        return String.valueOf(this.type);
    }

    public boolean initiallyCompilable() {
        return this.initiallyCompilable;
    }

    public static boolean validType(char type) {
        return type == 'S' || type == 'T';
    }

    public final synchronized Timestamp getCompileTime() {
        return DataTypeUtilities.clone(this.compileTime);
    }

    public final synchronized void setCompileTime() {
        this.compileTime = new Timestamp(System.currentTimeMillis());
    }

    public final synchronized String getText() {
        return this.text;
    }

    public final synchronized void setText(String newText) {
        this.text = newText;
    }

    public final String getUsingText() {
        return this.usingText;
    }

    @Override
    public final UUID getUUID() {
        return this.uuid;
    }

    public final synchronized DataTypeDescriptor[] getParams() throws StandardException {
        if (this.params == null && !this.lookedUpParams) {
            ArrayList<DataValueDescriptor> tmpDefaults = new ArrayList<DataValueDescriptor>();
            this.params = this.getDataDictionary().getSPSParams(this, tmpDefaults);
            this.paramDefaults = tmpDefaults.toArray();
            this.lookedUpParams = true;
        }
        return ArrayUtil.copy(this.params);
    }

    public final synchronized void setParams(DataTypeDescriptor[] params) {
        this.params = ArrayUtil.copy(params);
    }

    public final synchronized Object[] getParameterDefaults() throws StandardException {
        if (this.paramDefaults == null) {
            this.getParams();
        }
        return ArrayUtil.copy(this.paramDefaults);
    }

    public final synchronized void setParameterDefaults(Object[] values) {
        this.paramDefaults = ArrayUtil.copy(values);
    }

    public final ExecPreparedStatement getPreparedStatement() throws StandardException {
        return this.getPreparedStatement(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized ExecPreparedStatement getPreparedStatement(boolean recompIfInvalid) throws StandardException {
        block11: {
            ContextManager cm;
            LanguageConnectionContext lcc;
            if (!(!recompIfInvalid || this.valid && this.preparedStatement != null || (lcc = (LanguageConnectionContext)(cm = SPSDescriptor.getContextService().getCurrentContextManager()).getContext("LanguageConnectionContext")).getDataDictionary().isReadOnlyUpgrade())) {
                TransactionController nestedTC;
                String savepoint = lcc.getUniqueSavepointName();
                try {
                    nestedTC = lcc.getTransactionCompile().startNestedUserTransaction(false, true);
                    nestedTC.setNoLockWait(true);
                    nestedTC.setSavePoint(savepoint, null);
                }
                catch (StandardException se) {
                    nestedTC = null;
                }
                try {
                    this.prepareAndRelease(lcc, null, nestedTC);
                    this.updateSYSSTATEMENTS(lcc, 1, nestedTC);
                }
                catch (StandardException se) {
                    if (nestedTC != null) {
                        nestedTC.rollbackToSavePoint(savepoint, false, null);
                    }
                    if (nestedTC != null && (se.isLockTimeout() || se.isSelfDeadlock())) {
                        nestedTC.commit();
                        nestedTC.destroy();
                        nestedTC = null;
                        this.prepareAndRelease(lcc, null, null);
                        this.updateSYSSTATEMENTS(lcc, 1, null);
                        break block11;
                    }
                    throw se;
                }
                finally {
                    if (nestedTC != null) {
                        nestedTC.commit();
                        nestedTC.destroy();
                    }
                }
            }
        }
        return this.preparedStatement;
    }

    public final UUID getCompSchemaId() {
        return this.compSchemaId;
    }

    public final String toString() {
        return "SPSDescriptor:\n\tname: " + this.sd.getSchemaName() + "." + this.name + "\n\tuuid: " + this.uuid + "\n\ttext: " + this.text + "\n\tvalid: " + (this.valid ? "TRUE" : "FALSE") + "\n\tpreparedStatement: " + this.preparedStatement + "\n";
    }

    @Override
    public final DependableFinder getDependableFinder() {
        return this.getDependableFinder(226);
    }

    @Override
    public final String getObjectName() {
        return this.name;
    }

    @Override
    public final UUID getObjectID() {
        return this.uuid;
    }

    @Override
    public final String getClassType() {
        return "StoredPreparedStatement";
    }

    @Override
    public final synchronized boolean isValid() {
        return this.valid;
    }

    @Override
    public final void prepareToInvalidate(Provider p, int action, LanguageConnectionContext lcc) throws StandardException {
        switch (action) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                break;
            }
            default: {
                DependencyManager dm = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0Y24.S", dm.getActionString(action), p.getObjectName(), this.name);
            }
        }
    }

    @Override
    public final synchronized void makeInvalid(int action, LanguageConnectionContext lcc) throws StandardException {
        DependencyManager dm = this.getDataDictionary().getDependencyManager();
        switch (action) {
            case 10: 
            case 11: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: {
                if (this.valid) {
                    this.valid = false;
                    this.preparedStatement = null;
                    this.updateSYSSTATEMENTS(lcc, 0, null);
                }
                dm.invalidateFor(this, 14, lcc);
                break;
            }
            case 13: {
                dm.clearDependencies(lcc, this);
                break;
            }
            default: {
                SanityManager.THROWASSERT("makeInvalid(" + dm.getActionString(action) + ") not expected to get called; should have failed in prepareToInvalidate()");
            }
        }
    }

    public final synchronized void revalidate(LanguageConnectionContext lcc) throws StandardException {
        this.valid = false;
        this.makeInvalid(14, lcc);
        this.prepareAndRelease(lcc);
        this.updateSYSSTATEMENTS(lcc, 1, null);
    }

    public void loadGeneratedClass() throws StandardException {
        if (this.preparedStatement != null) {
            ((StorablePreparedStatement)this.preparedStatement).loadGeneratedClass();
        }
    }

    private void updateSYSSTATEMENTS(LanguageConnectionContext lcc, int mode, TransactionController tc) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        if (dd.isReadOnlyUpgrade()) {
            return;
        }
        dd.startWriting(lcc);
        if (tc == null) {
            tc = lcc.getTransactionExecute();
        }
        dd.updateSPS(this, tc, mode == 1);
    }

    private UUID recreateUUID(String idString) {
        if (this.uuidFactory == null) {
            this.uuidFactory = DataDescriptorGenerator.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory.recreateUUID(idString);
    }

    @Override
    public String getDescriptorType() {
        return "Statement";
    }

    @Override
    public String getDescriptorName() {
        return this.name;
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }
}

