/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;
import org.apache.derby.shared.common.error.StandardException;

public class SpecificAuthenticationServiceImpl
extends AuthenticationServiceBase {
    private String specificAuthenticationScheme;

    @Override
    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        if (PropertyUtil.nativeAuthenticationEnabled(properties)) {
            return false;
        }
        this.specificAuthenticationScheme = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return this.specificAuthenticationScheme != null && this.specificAuthenticationScheme.length() != 0 && !StringUtil.SQLEqualsIgnoreCase(this.specificAuthenticationScheme, "BUILTIN") && !this.specificAuthenticationScheme.equalsIgnoreCase("LDAP");
    }

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        ReflectiveOperationException t;
        super.boot(create, properties);
        try {
            Class<?> sasClass = Class.forName(this.specificAuthenticationScheme);
            if (!UserAuthenticator.class.isAssignableFrom(sasClass)) {
                throw StandardException.newException("XBM0L.D", this.specificAuthenticationScheme, "org.apache.derby.authentication.UserAuthenticator");
            }
            UserAuthenticator aScheme = (UserAuthenticator)sasClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.setAuthenticationService(aScheme);
            return;
        }
        catch (ClassNotFoundException cnfe) {
            t = cnfe;
        }
        catch (InstantiationException ie) {
            t = ie;
        }
        catch (IllegalAccessException iae) {
            t = iae;
        }
        catch (NoSuchMethodException nsme) {
            t = nsme;
        }
        catch (InvocationTargetException ite) {
            t = ite;
        }
        String detail = t.getClass().getName() + ": " + t.getMessage();
        throw StandardException.newException("XBM0M.D", this.specificAuthenticationScheme, detail);
    }
}

