/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.util.ExceptionUtil;
import org.apache.poi.xssf.XSSFReadException;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class XSSFParser {
    private XSSFParser() {
    }

    public static XSSFWorkbook parse(InputStream stream) throws XSSFReadException, IOException {
        try {
            return new XSSFWorkbook(stream);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XSSFReadException("Exception reading XSSFWorkbook", e);
        }
        catch (Exception e) {
            throw new XSSFReadException("Exception reading XSSFWorkbook", e);
        }
    }

    public static XSSFWorkbook parse(InputStream stream, boolean closeStream) throws XSSFReadException, IOException {
        try {
            return new XSSFWorkbook(stream, closeStream);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XSSFReadException("Exception reading XSSFWorkbook", e);
        }
        catch (Exception e) {
            throw new XSSFReadException("Exception reading XSSFWorkbook", e);
        }
    }

    public static XSSFWorkbook parse(File file) throws XSSFReadException, IOException {
        try {
            return new XSSFWorkbook(file);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XSSFReadException("Exception reading XSSFWorkbook", e);
        }
        catch (Exception e) {
            throw new XSSFReadException("Exception reading XSSFWorkbook", e);
        }
    }

    public static XSSFWorkbook parse(OPCPackage pkg) throws XSSFReadException, IOException {
        try {
            return new XSSFWorkbook(pkg);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XSSFReadException("Exception reading XSSFWorkbook", e);
        }
        catch (Exception e) {
            throw new XSSFReadException("Exception reading XSSFWorkbook", e);
        }
    }

    public static XSSFWorkbook parse(PackagePart packagePart) throws XSSFReadException, IOException {
        try {
            return new XSSFWorkbook(packagePart);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            if (ExceptionUtil.isFatal((Throwable)e)) {
                throw e;
            }
            throw new XSSFReadException("Exception reading XSSFWorkbook", e);
        }
        catch (Exception e) {
            throw new XSSFReadException("Exception reading XSSFWorkbook", e);
        }
    }
}

