/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;

public class AreaBorders {
    public boolean isMergedCells;
    public int bottom;
    public int left;
    public int right;
    public int top;
    public int diagonal;
    public int antidiagonal;
    public CSSValue[] cssStyle = new CSSValue[6];
    public CSSValue[] cssWidth = new CSSValue[6];
    public CSSValue[] cssColour = new CSSValue[6];

    private AreaBorders(boolean isMergedCells, int bottom, int left, int right, int top, int diagonal, int antidiagonal, CSSValue[] cssStyle, CSSValue[] cssWidth, CSSValue[] cssColour) {
        this.isMergedCells = isMergedCells;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
        this.top = top;
        this.diagonal = diagonal;
        this.antidiagonal = antidiagonal;
        this.cssStyle = cssStyle;
        this.cssWidth = cssWidth;
        this.cssColour = cssColour;
    }

    public static AreaBorders create(int bottom, int left, int right, int top, int diagonal, int antidiagonal, BirtStyle borderStyle) {
        return AreaBorders.create(false, bottom, left, right, top, diagonal, antidiagonal, borderStyle);
    }

    public static AreaBorders createForMergedCells(int bottom, int left, int right, int top, int diagonal, int antidiagonal, BirtStyle borderStyle) {
        return AreaBorders.create(true, bottom, left, right, top, diagonal, antidiagonal, borderStyle);
    }

    public static AreaBorders create(boolean isMergedCells, int bottom, int left, int right, int top, int diagonal, int antidiagonal, BirtStyle borderStyle) {
        CSSValue borderStyleBottom = borderStyle.getProperty(21);
        CSSValue borderWidthBottom = borderStyle.getProperty(10);
        CSSValue borderColourBottom = borderStyle.getProperty(5);
        CSSValue borderStyleLeft = borderStyle.getProperty(65);
        CSSValue borderWidthLeft = borderStyle.getProperty(59);
        CSSValue borderColourLeft = borderStyle.getProperty(57);
        CSSValue borderStyleRight = borderStyle.getProperty(20);
        CSSValue borderWidthRight = borderStyle.getProperty(9);
        CSSValue borderColourRight = borderStyle.getProperty(4);
        CSSValue borderStyleTop = borderStyle.getProperty(45);
        CSSValue borderWidthTop = borderStyle.getProperty(35);
        CSSValue borderColourTop = borderStyle.getProperty(23);
        CSSValue borderStyleDiagonal = borderStyle.getProperty(22);
        CSSValue borderWidthDiagonal = borderStyle.getProperty(11);
        CSSValue borderColourDiagonal = borderStyle.getProperty(7);
        CSSValue borderStyleAntidiagonal = borderStyle.getProperty(25);
        CSSValue borderWidthAntidiagonal = borderStyle.getProperty(18);
        CSSValue borderColourAntidiagonal = borderStyle.getProperty(14);
        if (borderStyleBottom == null || "none".equals(borderStyleBottom.getCssText()) || borderWidthBottom == null || "0".equals(borderWidthBottom.getCssText()) || borderColourBottom == null || "transparent".equals(borderColourBottom.getCssText())) {
            borderStyleBottom = null;
            borderWidthBottom = null;
            borderColourBottom = null;
        }
        if (borderStyleLeft == null || "none".equals(borderStyleLeft.getCssText()) || borderWidthLeft == null || "0".equals(borderWidthLeft.getCssText()) || borderColourLeft == null || "transparent".equals(borderColourLeft.getCssText())) {
            borderStyleLeft = null;
            borderWidthLeft = null;
            borderColourLeft = null;
        }
        if (borderStyleRight == null || "none".equals(borderStyleRight.getCssText()) || borderWidthRight == null || "0".equals(borderWidthRight.getCssText()) || borderColourRight == null || "transparent".equals(borderColourRight.getCssText())) {
            borderStyleRight = null;
            borderWidthRight = null;
            borderColourRight = null;
        }
        if (borderStyleTop == null || "none".equals(borderStyleTop.getCssText()) || borderWidthTop == null || "0".equals(borderWidthTop.getCssText()) || borderColourTop == null || "transparent".equals(borderColourTop.getCssText())) {
            borderStyleTop = null;
            borderWidthTop = null;
            borderColourTop = null;
        }
        if (borderStyleDiagonal == null || "none".equals(borderStyleDiagonal.getCssText()) || borderWidthDiagonal == null || "0".equals(borderWidthDiagonal.getCssText()) || borderColourDiagonal == null || "transparent".equals(borderColourDiagonal.getCssText())) {
            borderStyleDiagonal = null;
            borderWidthDiagonal = null;
            borderColourDiagonal = null;
        }
        if (borderStyleAntidiagonal == null || "none".equals(borderStyleAntidiagonal.getCssText()) || borderWidthAntidiagonal == null || "0".equals(borderWidthAntidiagonal.getCssText()) || borderColourAntidiagonal == null || "transparent".equals(borderColourAntidiagonal.getCssText())) {
            borderStyleAntidiagonal = null;
            borderWidthAntidiagonal = null;
            borderColourAntidiagonal = null;
        }
        if (bottom >= 0 && (borderStyleBottom != null || borderWidthBottom != null || borderColourBottom != null) || left >= 0 && (borderStyleLeft != null || borderWidthLeft != null || borderColourLeft != null) || right >= 0 && (borderStyleRight != null || borderWidthRight != null || borderColourRight != null) || top >= 0 && (borderStyleTop != null || borderWidthTop != null || borderColourTop != null) || diagonal >= 0 && (borderStyleDiagonal != null || borderWidthDiagonal != null || borderColourDiagonal != null) || antidiagonal >= 0 && (borderStyleAntidiagonal != null || borderWidthAntidiagonal != null || borderColourAntidiagonal != null)) {
            CSSValue[] cssStyle = new CSSValue[]{borderStyleBottom, borderStyleLeft, borderStyleRight, borderStyleTop, borderStyleDiagonal, borderStyleAntidiagonal};
            CSSValue[] cssWidth = new CSSValue[]{borderWidthBottom, borderWidthLeft, borderWidthRight, borderWidthTop, borderWidthDiagonal, borderWidthAntidiagonal};
            CSSValue[] cssColour = new CSSValue[]{borderColourBottom, borderColourLeft, borderColourRight, borderColourTop, borderColourDiagonal, borderColourAntidiagonal};
            return new AreaBorders(isMergedCells, bottom, left, right, top, diagonal, antidiagonal, cssStyle, cssWidth, cssColour);
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.top).append(",").append(this.left).append("]");
        result.append("-");
        result.append("[").append(this.bottom).append(",").append(this.right).append("]");
        result.append("=");
        int i = 0;
        while (i < 6) {
            result.append("[");
            result.append(this.cssStyle[i]);
            result.append(";");
            result.append(this.cssWidth[i]);
            result.append(";");
            result.append(this.cssColour[i]);
            result.append("]");
            ++i;
        }
        return result.toString();
    }
}

