/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.util.BitSet;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.AbstractStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.FontManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;

public class BirtStyle {
    public static final int NUMBER_OF_STYLES = 72;
    public static final int TEXT_ROTATION = 71;
    protected static final String[] cssProperties = new String[]{"margin-left", "margin-right", "margin-top", "DATA_FORMAT", "border-right-color", "direction", "border-top-width", "padding-left", "border-right-width", "padding-bottom", "padding-top", "NUMBER_ALIGN", "padding-right", "CAN_SHRINK", "border-top-color", "background-repeat", "margin-bottom", "background-width", "background-height", "border-right-style", "border-bottom-color", "text-indent", "line-height", "border-bottom-width", "text-align", "background-color", "color", "overflow", "TEXT_LINETHROUGH", "border-left-color", "widows", "border-left-width", "border-bottom-style", "font-weight", "font-variant", "text-transform", "white-space", "TEXT_OVERLINE", "vertical-align", "BACKGROUND_POSITION_X", "border-left-style", "VISIBLE_FORMAT", "MASTER_PAGE", "orphans", "font-size", "font-style", "border-top-style", "page-break-before", "SHOW_IF_BLANK", "background-image", "BACKGROUND_POSITION_Y", "word-spacing", "background-attachment", "TEXT_UNDERLINE", "display", "font-family", "letter-spacing", "page-break-inside", "page-break-after", "Rotation", "border-diagonal-color", "border-diagonal-width", "border-diagonal-style", "border-antidiagonal-color", "border-antidiagonal-width", "border-antidiagonal-style", "text-decoration"};
    private IStyle elemStyle;
    private CSSValue[] propertyOverride = new CSSValue[72];
    private CSSEngine cssEngine;
    private boolean useTextIndent = true;
    private String textIndentMode = "";
    private static final BitSet SPECIAL_OVERLAY_PROPERTIES = BirtStyle.PrepareSpecialOverlayProperties();

    public BirtStyle(CSSEngine cssEngine) {
        this.cssEngine = cssEngine;
    }

    public BirtStyle(IContent element) {
        int prop;
        this.elemStyle = element.getComputedStyle();
        if (!(this.elemStyle instanceof AbstractStyle)) {
            throw new IllegalStateException("Unable to obtain CSSEngine from elemStyle: " + String.valueOf(this.elemStyle));
        }
        this.cssEngine = ((AbstractStyle)this.elemStyle).getCSSEngine();
        Float rotation = BirtStyle.extractRotation(element);
        if (rotation != null) {
            this.setFloat(71, (short)11, rotation.floatValue());
        }
        int i = 0;
        while (i < StyleManager.COMPARE_CSS_PROPERTIES.length) {
            prop = StyleManager.COMPARE_CSS_PROPERTIES[i];
            this.propertyOverride[prop] = this.elemStyle.getProperty(prop);
            ++i;
        }
        this.propertyOverride[3] = this.elemStyle.getProperty(3);
        i = 0;
        while (i < FontManager.COMPARE_CSS_PROPERTIES.length) {
            prop = FontManager.COMPARE_CSS_PROPERTIES[i];
            this.propertyOverride[prop] = this.elemStyle.getProperty(prop);
            ++i;
        }
    }

    private static Float extractRotation(IContent element) {
        Expression rotationExpression;
        ReportElementDesign generatorDesign;
        Map<String, Expression> userProps;
        Object generatorObject = element.getGenerateBy();
        if (generatorObject instanceof ReportElementDesign && (userProps = (generatorDesign = (ReportElementDesign)generatorObject).getUserProperties()) != null && (rotationExpression = userProps.get("ExcelEmitter.Rotation")) != null) {
            try {
                return Float.valueOf(rotationExpression.getScriptText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setProperty(int propIndex, CSSValue newValue) {
        if (this.propertyOverride == null) {
            this.propertyOverride = new CSSValue[72];
        }
        this.propertyOverride[propIndex] = newValue;
    }

    public CSSValue getProperty(int propIndex) {
        return this.propertyOverride[propIndex];
    }

    public void setFloat(int propIndex, short units, float newValue) {
        if (this.propertyOverride == null) {
            this.propertyOverride = new CSSValue[72];
        }
        this.propertyOverride[propIndex] = new FloatValue(units, newValue);
    }

    public void parseString(int propIndex, String newValue) {
        if (this.propertyOverride == null) {
            this.propertyOverride = new CSSValue[72];
        }
        this.propertyOverride[propIndex] = propIndex < 71 ? this.cssEngine.parsePropertyValue(propIndex, newValue) : new StringValue(19, newValue);
    }

    public String getString(int propIndex) {
        CSSValue value = this.getProperty(propIndex);
        if (value != null) {
            return value.getCssText();
        }
        return null;
    }

    protected BirtStyle clone() {
        BirtStyle result = new BirtStyle(this.cssEngine);
        result.propertyOverride = new CSSValue[72];
        int i = 0;
        while (i < 72) {
            CSSValue value = this.getProperty(i);
            if (value != null) {
                if (value instanceof DataFormatValue) {
                    value = StyleManagerUtils.cloneDataFormatValue((DataFormatValue)value);
                }
                result.propertyOverride[i] = value;
            }
            ++i;
        }
        return result;
    }

    private static BitSet PrepareSpecialOverlayProperties() {
        BitSet result = new BitSet(72);
        result.set(0);
        result.set(1);
        result.set(12);
        result.set(16);
        result.set(41);
        result.set(21);
        result.set(10);
        result.set(5);
        result.set(65);
        result.set(59);
        result.set(57);
        result.set(20);
        result.set(9);
        result.set(4);
        result.set(45);
        result.set(35);
        result.set(23);
        result.set(22);
        result.set(11);
        result.set(7);
        result.set(25);
        result.set(18);
        result.set(14);
        result.set(43);
        result.set(3);
        return result;
    }

    private void overlayBorder(IStyle style, int propStyle, int propWidth, int propColour) {
        CSSValue ovlStyle = style.getProperty(propStyle);
        CSSValue ovlWidth = style.getProperty(propWidth);
        CSSValue ovlColour = style.getProperty(propColour);
        if (ovlStyle != null && ovlWidth != null && ovlColour != null && !"none".equals(ovlStyle.getCssText())) {
            this.setProperty(propStyle, ovlStyle);
            this.setProperty(propWidth, ovlWidth);
            this.setProperty(propColour, ovlColour);
        }
    }

    public void overlay(IContent element) {
        Float rotation;
        CSSValue localDataFormat;
        CSSValue overlayDataFormat;
        CSSValue localValue;
        IStyle style = element.getComputedStyle();
        int propIndex = 0;
        while (propIndex < 71) {
            if (!SPECIAL_OVERLAY_PROPERTIES.get(propIndex)) {
                CSSValue overlayValue = style.getProperty(propIndex);
                CSSValue localValue2 = this.getProperty(propIndex);
                if (overlayValue != null && !overlayValue.equals(localValue2)) {
                    this.setProperty(propIndex, overlayValue);
                }
            }
            ++propIndex;
        }
        CSSValue overlayBgColour = style.getProperty(41);
        CSSValue localBgColour = this.getProperty(41);
        if (overlayBgColour != null && !"transparent".equals(overlayBgColour.getCssText()) && !overlayBgColour.equals(localBgColour)) {
            this.setProperty(41, overlayBgColour);
        }
        this.overlayBorder(style, 21, 10, 5);
        this.overlayBorder(style, 65, 59, 57);
        this.overlayBorder(style, 20, 9, 4);
        this.overlayBorder(style, 45, 35, 23);
        CSSValue verticalAlign = element.getStyle().getProperty(43);
        if (verticalAlign != null && !verticalAlign.equals(localValue = this.getProperty(43))) {
            this.setProperty(43, verticalAlign);
        }
        if (!StyleManagerUtils.dataFormatsEquivalent((DataFormatValue)(overlayDataFormat = style.getProperty(3)), (DataFormatValue)(localDataFormat = this.getProperty(3)))) {
            this.setProperty(3, StyleManagerUtils.cloneDataFormatValue((DataFormatValue)overlayDataFormat));
        }
        if ((rotation = BirtStyle.extractRotation(element)) != null) {
            this.setFloat(71, (short)11, rotation.floatValue());
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < 72) {
            CSSValue val = this.getProperty(i);
            if (val != null) {
                try {
                    result.append(cssProperties[i]).append(':').append(val.getCssText()).append("; ");
                }
                catch (Exception ex) {
                    result.append(cssProperties[i]).append(":{").append(ex.getMessage()).append("}; ");
                }
            }
            ++i;
        }
        return result.toString();
    }

    public void setTextIndentInUse(boolean useTextIndent) {
        this.useTextIndent = useTextIndent;
    }

    public boolean isTextIndentInUse() {
        return this.useTextIndent;
    }

    public void setTextIndentMode(String textIndentMode) {
        this.textIndentMode = textIndentMode;
    }

    public String getTextIndentMode() {
        return this.textIndentMode;
    }
}

