/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.util.ArrayList;

public class DiagonalLineInfo {
    private static final double CELL_MARGIN_COMPENSATION = 5.4;
    private int diagonalCount = -1;
    private String diagonalStyle = null;
    private int diagonalWidth = 0;
    private String diagonalColor = null;
    private int antidiagonalCount = -1;
    private String antidiagonalStyle = null;
    private int antidiagonalWidth = 0;
    private String antidiagonalColor = null;
    private String color = null;
    private static final double DEFAULT_COORDSIZEX = 100.0;
    private static final double DEFAULT_COORDSIZEY = 100.0;
    private double width = 100.0;
    private double height = 100.0;
    private double coordoriginX = 0.0;
    private double coordoriginY = 0.0;

    public void setDiagonalLine(int diagonalCount, String diagonalStyle, int diagonalWidth) {
        this.diagonalCount = diagonalCount > 3 ? 3 : diagonalCount;
        this.diagonalStyle = diagonalStyle;
        this.diagonalWidth = diagonalWidth;
    }

    public void setAntidiagonalLine(int antidiagonalCount, String antidiagonalStyle, int antidiagonalWidth) {
        this.antidiagonalCount = antidiagonalCount > 3 ? 3 : antidiagonalCount;
        this.antidiagonalStyle = antidiagonalStyle;
        this.antidiagonalWidth = antidiagonalWidth;
    }

    public void setCoordinateSize(double coordinateSizeX, double coordinateSizeY) {
        if (coordinateSizeX != 0.0) {
            this.width = coordinateSizeX;
        }
        if (coordinateSizeY != 0.0) {
            this.height = coordinateSizeY;
        }
    }

    public void setCoordinateOrigin(int coordinateOriginX, int coordinateOriginY) {
        this.coordoriginX = coordinateOriginX;
        this.coordoriginY = coordinateOriginY;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getColor() {
        return this.color;
    }

    public void setDiagonalColor(String color) {
        this.diagonalColor = color;
    }

    public String getDiagonalColor() {
        return this.diagonalColor;
    }

    public void setAntidiagonalColor(String color) {
        this.antidiagonalColor = color;
    }

    public String getAntidiagonalColor() {
        return this.antidiagonalColor;
    }

    public ArrayList<Line> getDiagonalLine() {
        ArrayList<Line> diagonalLine = new ArrayList<Line>();
        int num = this.diagonalCount >> 1;
        double x = 2.0 / (double)(this.diagonalCount + 1) * this.width;
        double y = 2.0 / (double)(this.diagonalCount + 1) * this.height;
        if ((this.diagonalCount & 1) == 1) {
            diagonalLine.add(new Line(this.coordoriginX - 5.4, this.coordoriginY, this.coordoriginX + this.width - 5.4, this.coordoriginY + this.height));
        }
        int i = 1;
        while (i <= num) {
            diagonalLine.add(new Line(this.coordoriginX + this.width - (double)i * x - 5.4, this.coordoriginY, this.coordoriginX + this.width - 5.4, this.coordoriginY + this.height));
            diagonalLine.add(new Line(this.coordoriginX - 5.4, this.coordoriginY + this.height - (double)i * y, this.coordoriginX + this.width - 5.4, this.coordoriginY + this.height));
            ++i;
        }
        return diagonalLine;
    }

    public ArrayList<Line> getAntidiagonalLine() {
        ArrayList<Line> antiDiagonalLine = new ArrayList<Line>();
        int num = this.antidiagonalCount >> 1;
        double x = 2.0 / (double)(this.antidiagonalCount + 1) * this.width;
        double y = 2.0 / (double)(this.antidiagonalCount + 1) * this.height;
        if ((this.antidiagonalCount & 1) == 1) {
            antiDiagonalLine.add(new Line(this.coordoriginX - 5.4, this.coordoriginY + this.height, this.coordoriginX + this.width - 5.4, this.coordoriginY));
        }
        int i = 1;
        while (i <= num) {
            antiDiagonalLine.add(new Line(this.coordoriginX - 5.4, this.coordoriginY + this.height, this.coordoriginX + (double)i * x - 5.4, this.coordoriginY));
            antiDiagonalLine.add(new Line(this.coordoriginX - 5.4, this.coordoriginY + this.height, this.coordoriginX + this.width - 5.4, this.coordoriginY + this.height - (double)i * y));
            ++i;
        }
        return antiDiagonalLine;
    }

    public int getDiagonalNumber() {
        return this.diagonalCount;
    }

    public int getAntidiagonalNumber() {
        return this.antidiagonalCount;
    }

    public String getDiagonalStyle() {
        return this.diagonalStyle;
    }

    public String getAntidiagonalStyle() {
        return this.antidiagonalStyle;
    }

    public double getDiagonalLineWidth() {
        return this.diagonalWidth;
    }

    public double getAntidiagonalLineWidth() {
        return this.antidiagonalWidth;
    }

    public static class Line {
        double xCoordinateFrom;
        double yCoordinateFrom;
        double xCoordinateTo;
        double yCoordinateTo;

        Line(double xFrom, double yFrom, double xTo, double yTo) {
            this.xCoordinateFrom = xFrom;
            this.yCoordinateFrom = yFrom;
            this.xCoordinateTo = xTo;
            this.yCoordinateTo = yTo;
        }

        public double getXCoordinateFrom() {
            return this.xCoordinateFrom;
        }

        public double getYCoordinateFrom() {
            return this.yCoordinateFrom;
        }

        public double getXCoordinateTo() {
            return this.xCoordinateTo;
        }

        public double getYCoordinateTo() {
            return this.yCoordinateTo;
        }
    }
}

