/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.data.DataEngineFactory;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.DteDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;

public class DataGenerationEngine
extends DteDataEngine {
    protected DataOutputStream dos;
    protected IDocArchiveWriter writer;

    public DataGenerationEngine(DataEngineFactory factory, ExecutionContext context, IDocArchiveWriter writer) throws Exception {
        super(factory, context, writer);
        this.writer = writer;
        DataSessionContext dteSessionContext = new DataSessionContext(1, context.getDesign(), context.getScriptContext(), context.getApplicationClassLoader());
        dteSessionContext.setDocumentWriter(writer);
        dteSessionContext.setAppContext(context.getAppContext());
        DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
        dteEngineContext.setLocale(context.getLocale());
        dteEngineContext.setTimeZone(context.getTimeZone());
        String tempDir = this.getTempDir(context);
        if (tempDir != null) {
            dteEngineContext.setTmpdir(tempDir);
        }
        this.dteSession = context.newSession(dteSessionContext);
        this.initialize();
    }

    protected void initialize() throws Exception {
        this.dos = new DataOutputStream(this.writer.createRandomAccessStream("/Data/hierarchy"));
        if (this.writer.exists("/Data/snap_hierarchy")) {
            this.writer.dropStream("/Data/snap_hierarchy");
        }
        DteMetaInfoIOUtil.startMetaInfo(this.dos);
    }

    @Override
    protected IBaseResultSet doExecuteQuery(IBaseResultSet parentResultSet, IQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        IBaseResultSet resultSet = super.doExecuteQuery(parentResultSet, query, queryOwner, useCache);
        if (resultSet != null) {
            this.storeMetaInfo(parentResultSet, query, resultSet);
        }
        return resultSet;
    }

    @Override
    protected IBaseResultSet doExecuteCube(IBaseResultSet parentResultSet, ICubeQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        IBaseResultSet resultSet = super.doExecuteCube(parentResultSet, query, queryOwner, useCache);
        if (resultSet != null) {
            this.storeMetaInfo(parentResultSet, query, resultSet);
        }
        return resultSet;
    }

    protected void storeMetaInfo(IBaseResultSet parentResultSet, IDataQueryDefinition query, IBaseResultSet resultSet) throws BirtException {
        String pRsetId = null;
        String rawId = "-1";
        String rowId = "-1";
        if (parentResultSet != null) {
            if (parentResultSet instanceof QueryResultSet) {
                QueryResultSet qrs = (QueryResultSet)parentResultSet;
                pRsetId = qrs.getQueryResultsID();
                rowId = String.valueOf(qrs.getRowIndex());
            } else {
                CubeResultSet crs = (CubeResultSet)parentResultSet;
                pRsetId = crs.getQueryResultsID();
                rowId = crs.getCellIndex();
            }
            rawId = parentResultSet.getRawID();
        }
        String queryID = (String)this.queryIDMap.get(query);
        this.storeDteMetaInfo(pRsetId, rawId, queryID, resultSet.getQueryResults().getID(), rowId);
    }

    @Override
    public void shutdown() {
        if (this.dos != null) {
            try {
                this.dos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dos = null;
        }
        super.shutdown();
    }

    private void storeDteMetaInfo(String pRsetId, String rawId, String queryId, String rsetId, String rowId) {
        try {
            if (this.context.isExecutingMasterPage() && pRsetId == null) {
                rawId = "-1";
            }
            DteMetaInfoIOUtil.storeMetaInfo(this.dos, pRsetId, rawId, queryId, rsetId, rowId);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
        }
    }
}

