/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.AbstractExpressionCompiler;
import org.eclipse.birt.data.engine.expression.AggregateExpression;
import org.eclipse.birt.data.engine.expression.BytecodeExpression;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.InvalidExpression;
import org.eclipse.birt.data.engine.impl.aggregation.AggregateRegistry;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ScriptNode;

public class ExpressionCompiler
extends AbstractExpressionCompiler {
    private AggregateRegistry registry;
    private static final String AGGR_VALUE = "_aggr_value";

    public CompiledExpression compile(String expression, AggregateRegistry registry, ScriptContext context) {
        try {
            if (expression == null || expression.trim().length() == 0) {
                throw new DataException("data.engine.EmptyExpression");
            }
            this.registry = registry;
            return super.compileExpression(expression, context);
        }
        catch (Exception e) {
            if (e instanceof DataException) {
                return new InvalidExpression((DataException)e);
            }
            DataException dataException = new DataException("data.engine.InvalidJSExpr", (Throwable)e, (Object)expression);
            return new InvalidExpression(dataException);
        }
    }

    private void extractArguments(Context context, AggregateExpression aggregateExpression, Node callNode) throws DataException {
        Node arg = callNode.getFirstChild().getNext();
        while (arg != null) {
            Node nextArg = arg.getNext();
            CompiledExpression expr = this.processChild(context, false, callNode, arg, null);
            if (!(expr instanceof BytecodeExpression)) {
                aggregateExpression.addArgument(expr);
                arg = nextArg;
                continue;
            }
            AstRoot tree = new AstRoot(150);
            Node exprNode = new Node(148);
            exprNode.addChildToFront(arg);
            tree.addChildrenToFront(exprNode);
            this.compileForBytecodeExpr(context, (ScriptNode)tree, expr);
            aggregateExpression.addArgument(expr);
            arg = nextArg;
        }
    }

    private void replaceAggregateNode(AggregateExpression aggregateExpression, Node parent, Node aggregateCallNode) throws DataException {
        if (this.registry == null) {
            throw new DataException("data.engine.NoAggrFunc");
        }
        int aggregateId = this.registry.register(aggregateExpression);
        Node newFirstChild = Node.newString((int)44, (String)AGGR_VALUE);
        Node newSecondChild = Node.newNumber((double)aggregateId);
        Node aggregateNode = new Node(39, newFirstChild, newSecondChild);
        parent.replaceChild(aggregateCallNode, aggregateNode);
    }

    @Override
    protected AggregateExpression compileAggregateExpr(Context context, Node parent, Node callNode) throws DataException {
        assert (callNode.getType() == 43);
        IAggrFunction aggregation = this.getAggregationFunction(callNode);
        if (aggregation == null) {
            return null;
        }
        AggregateExpression aggregateExpression = new AggregateExpression(aggregation);
        this.extractArguments(context, aggregateExpression, callNode);
        this.replaceAggregateNode(aggregateExpression, parent, callNode);
        return aggregateExpression;
    }

    @Override
    protected CompiledExpression compileDirectColRefExpr(Node parent, Node refNode, Node grandFather, boolean customerChecked, Context context) throws DataException {
        assert (refNode.getType() == 33 || refNode.getType() == 39);
        Node rowName = refNode.getFirstChild();
        assert (rowName != null);
        if (rowName.getType() != 44) {
            return null;
        }
        String str = rowName.getString();
        assert (str != null);
        if (!str.equals(this.rowIndicator)) {
            return null;
        }
        Node rowColumn = rowName.getNext();
        assert (rowColumn != null);
        if (refNode.getType() == 33 && rowColumn.getType() == 46) {
            if ("_outer".equals(rowColumn.getString()) || "__rownum".equals(rowColumn.getString()) || "0".equals(rowColumn.getString())) {
                return null;
            }
            return new ColumnReferenceExpression(this.getDataSetMode() ? "row" : "dataSetRow", rowColumn.getString());
        }
        if (refNode.getType() == 39) {
            if (rowColumn.getType() == 45) {
                if (0.0 == rowColumn.getDouble()) {
                    return null;
                }
                return new ColumnReferenceExpression(this.getDataSetMode() ? "row" : "dataSetRow", (int)rowColumn.getDouble());
            }
            if (rowColumn.getType() == 46) {
                if ("_rownum".equals(rowColumn.getString())) {
                    return null;
                }
                return new ColumnReferenceExpression(this.getDataSetMode() ? "row" : "dataSetRow", rowColumn.getString());
            }
        }
        return null;
    }
}

