/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportFlowLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Scrollable;

public abstract class AbstractPageFlowLayout
extends ReportFlowLayout {
    public static final int MINLEFTSPACE = 20;
    public static final int MINRIGHTSPACE = 20;
    public static final int MINTOPSPACE = 20;
    public static final int MINBOTTOMSPACE = 20;
    private GraphicalEditPart owner;
    private Rectangle initSize = new Rectangle();
    private Insets initInsets = new Insets();

    public AbstractPageFlowLayout(final GraphicalEditPart owner) {
        assert (owner != null);
        this.owner = owner;
        final ControlListener listener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                AbstractPageFlowLayout.this.layouRootLayer();
            }
        };
        owner.getViewer().getControl().addControlListener(listener);
        owner.addEditPartListener(new EditPartListener(){

            public void childAdded(EditPart child, int index) {
            }

            public void partActivated(EditPart editpart) {
            }

            public void partDeactivated(EditPart editpart) {
                owner.getViewer().getControl().removeControlListener(listener);
            }

            public void removingChild(EditPart child, int index) {
            }

            public void selectedStateChanged(EditPart editpart) {
            }
        });
        this.getZoomManager().addZoomListener(new ZoomListener(){

            public void zoomChanged(double zoom) {
                if (AbstractPageFlowLayout.this.getOwner().getParent() == null) {
                    return;
                }
                AbstractPageFlowLayout.this.layouRootLayer();
            }
        });
    }

    private void layouRootLayer() {
        if (this.getOwner().getFigure() instanceof ReportElementFigure) {
            ((ReportElementFigure)this.getOwner().getFigure()).fireMoved();
        }
        this.layout(this.getOwner().getFigure());
    }

    protected GraphicalEditPart getOwner() {
        return this.owner;
    }

    protected void setOwner(GraphicalEditPart owner) {
        this.owner = owner;
    }

    public ZoomManager getZoomManager() {
        return (ZoomManager)this.owner.getViewer().getProperty(ZoomManager.class.toString());
    }

    public Rectangle getInitSize() {
        return this.initSize;
    }

    public void setInitSize(Rectangle initSize) {
        this.initSize = initSize;
    }

    protected void setViewProperty(Rectangle caleBounds, Rectangle ownerBounds) {
        this.getOwner().getViewer().setProperty("Report Size", (Object)caleBounds);
        this.getOwner().getViewer().setProperty("Layout Size", (Object)ownerBounds);
        this.getOwner().getViewer().setProperty("Ruler Size", (Object)new Rectangle(ownerBounds.x, ownerBounds.y, this.getInitSize().width, ownerBounds.height));
    }

    protected Result getReportBounds(Rectangle reportSize) {
        Result revValue = new Result();
        revValue.reportSize.y = 20;
        revValue.reportSize.width = reportSize.width;
        revValue.reportSize.height = reportSize.height;
        EditPartViewer viewer = this.owner.getViewer();
        Scrollable control = viewer == null ? null : (Scrollable)viewer.getControl();
        Rectangle containerSize = control == null ? new Rectangle() : new Rectangle(control.getClientArea());
        PrecisionDimension dim = new PrecisionDimension((double)containerSize.width, (double)containerSize.height);
        double scale = this.getZoomManager().getZoom();
        dim.performScale(1.0 / scale);
        if (dim.width > reportSize.width + 20 + 20) {
            revValue.reportSize.x = (dim.width - reportSize.width) / 2;
            revValue.rightSpace = (dim.width - reportSize.width) / 2;
        } else {
            revValue.reportSize.x = 20;
            revValue.rightSpace = 20;
        }
        revValue.bottomSpace = dim.height > reportSize.height + 20 + 20 ? dim.height - reportSize.height - revValue.reportSize.y : 20;
        return revValue;
    }

    public Insets getInitInsets() {
        return this.initInsets;
    }

    public void setInitInsets(Insets initInsets) {
        this.initInsets = initInsets;
    }

    protected static class Result {
        public Rectangle reportSize = new Rectangle();
        public int rightSpace;
        public int bottomSpace;

        protected Result() {
        }
    }
}

