/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.List;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.metadata.StructureDefn;

public class StructureRefUtil {
    public static Structure findNativeStructure(Module module, StructureDefn targetDefn, String name) {
        if (StringUtil.isBlank(name) || targetDefn == null) {
            return null;
        }
        ElementPropertyDefn defn = module.getReferencablePropertyDefn(targetDefn.getName());
        if (defn == null) {
            return null;
        }
        assert (defn.getTypeCode() == 16);
        if (defn.isList()) {
            List<Object> list = module.getListProperty(module, defn.getName());
            if (list == null) {
                return null;
            }
            int i = 0;
            while (i < list.size()) {
                Structure struct = (Structure)list.get(i);
                if (name.equals(struct.getReferencableProperty())) {
                    return struct;
                }
                ++i;
            }
        } else {
            Structure struct = (Structure)module.getProperty(module, defn.getName());
            if (name.equals(struct.getReferencableProperty())) {
                return struct;
            }
        }
        return null;
    }

    public static Structure findStructure(Module module, StructureDefn targetDefn, String name) {
        Object retValue = StructureRefUtil.resolveStructureWithName(module, targetDefn, name);
        if (retValue instanceof StructRefValue) {
            return ((StructRefValue)retValue).getStructure();
        }
        return (Structure)retValue;
    }

    private static Object resolveStructureWithName(Module module, StructureDefn targetDefn, String name) {
        Structure emImage;
        if (StringUtil.isBlank(name) || targetDefn == null || module == null) {
            return null;
        }
        if ("EmbeddedImage".equalsIgnoreCase(targetDefn.getName()) && (emImage = StructureRefUtil.findNativeStructure(module, targetDefn, name)) != null) {
            String namespace = null;
            if (module instanceof Library) {
                namespace = ((Library)module).getNamespace();
            }
            StructRefValue refValue = new StructRefValue(namespace, emImage);
            return refValue;
        }
        String namespace = StringUtil.extractNamespace(name);
        String structName = StringUtil.extractName(name);
        Module moduleToSearch = null;
        if (!"EmbeddedImage".equalsIgnoreCase(targetDefn.getName())) {
            moduleToSearch = module;
        }
        if (namespace != null) {
            moduleToSearch = module.getLibraryWithNamespace(namespace);
        }
        if (moduleToSearch != null) {
            Structure retValue = StructureRefUtil.findNativeStructure(moduleToSearch, targetDefn, structName);
            if (retValue != null) {
                if ("EmbeddedImage".equalsIgnoreCase(targetDefn.getName())) {
                    return new StructRefValue(namespace, retValue);
                }
                return retValue;
            }
        } else if (module instanceof Library) {
            namespace = ((Library)module).getNamespace();
            structName = StructureRefUtil.stripNamespace(name, namespace);
        } else {
            namespace = null;
            structName = name;
        }
        if ("EmbeddedImage".equalsIgnoreCase(targetDefn.getName())) {
            return new StructRefValue(namespace, structName);
        }
        return null;
    }

    private static String stripNamespace(String name, String namespace) {
        if (name == null || namespace == null) {
            return name;
        }
        String tmpNamespace = StringUtil.extractNamespace(name);
        if (tmpNamespace == null || !namespace.equalsIgnoreCase(tmpNamespace)) {
            return name;
        }
        return StringUtil.extractName(name);
    }

    public static StructRefValue resolve(Module module, PropertyDefn defn, String name) {
        if (StringUtil.isBlank(name) || defn == null || module == null) {
            return null;
        }
        assert (defn.getTypeCode() == 19);
        StructureDefn targetDefn = (StructureDefn)defn.getStructDefn();
        assert (targetDefn != null);
        Structure target = null;
        Library targetModule = null;
        if ("libReference".equals(defn.getName())) {
            String structName = StringUtil.extractName(name);
            String namespace = StringUtil.extractNamespace(name);
            targetModule = module.getLibraryWithNamespace(namespace);
            if (targetModule != null && (target = StructureRefUtil.findStructure(targetModule, targetDefn, structName)) != null) {
                return new StructRefValue(namespace, target);
            }
            return new StructRefValue(namespace, structName);
        }
        StructRefValue refValue = (StructRefValue)StructureRefUtil.resolveStructureWithName(module, targetDefn, name);
        return refValue;
    }

    public static StructRefValue resolve(Module module, PropertyDefn defn, Structure target) throws PropertyValueException {
        if (target == null || module == null || defn == null) {
            return null;
        }
        assert (defn.getTypeCode() == 19);
        StructureDefn targetDefn = (StructureDefn)defn.getStructDefn();
        if (targetDefn != target.getDefn()) {
            throw new PropertyValueException((Object)target.getReferencableProperty(), "Error.PropertyValueException.WRONG_ITEM_TYPE", 19);
        }
        return StructureRefUtil.resolve(module, defn, target.getReferencableProperty());
    }
}

