/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class DateTimePropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(DateTimePropertyType.class.getName());
    private static final String DISPLAY_NAME_KEY = "Property.dateTime";
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", DEFAULT_LOCALE);

    public DateTimePropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    @Override
    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof String) {
            return this.validateInputString(module, element, defn, (String)value);
        }
        logger.log(Level.SEVERE, "Invalid date value type:" + String.valueOf(value));
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 11);
    }

    @Override
    public Object validateXml(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (value == null || value instanceof String);
        String tmpValue = (String)value;
        if ((tmpValue = StringUtil.trimString(tmpValue)) == null) {
            return null;
        }
        try {
            return formatter.parse(tmpValue);
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "Invalid date value:" + tmpValue);
            throw new PropertyValueException((Object)tmpValue, "Error.PropertyValueException.INVALID_VALUE", this.getTypeCode());
        }
    }

    @Override
    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        assert (value instanceof Date);
        ULocale locale = module == null ? ThreadResources.getLocale() : module.getLocale();
        DateFormat formatter = DateFormat.getDateInstance((int)3, (ULocale)locale);
        return formatter.format((Date)value);
    }

    @Override
    public int getTypeCode() {
        return 11;
    }

    @Override
    public String getName() {
        return "dateTime";
    }

    @Override
    public Object validateInputString(Module module, DesignElement element, PropertyDefn defn, String value) throws PropertyValueException {
        if (StringUtil.isBlank(value)) {
            return null;
        }
        ULocale locale = module == null ? ThreadResources.getLocale() : module.getLocale();
        DateFormat formatter = DateFormat.getDateInstance((int)3, (ULocale)locale);
        try {
            return formatter.parse(value);
        }
        catch (ParseException e) {
            logger.log(Level.SEVERE, "Invalid date value:" + value);
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 11);
        }
    }

    @Override
    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return formatter.format((Date)value);
    }
}

