/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.GregorianCalendar;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.internal.util.EclipseUtil;
import org.eclipse.birt.report.designer.core.DesignerConstants;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.CSSUtil;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.AbstractThemeHandle;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.ContentElementHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupElementFactory;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ReportItemThemeHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.VariableElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMetaDataDictionary;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.ISlotDefn;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.elements.interfaces.IStyleModel;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class DEUtil {
    public static final String ELEMENT_LABELCONTENT_PROPERTY = "labelContent";
    private static HashMap<String, String> propertiesMap = new HashMap();
    private static ArrayList<IElementDefn> notSupportList = new ArrayList();
    private static int defaultFontSite = -1;
    private static List<String> scalable_system_fonts = null;
    private static List<String> non_scalable_system_fonts = null;
    private static volatile String[] sorted_system_fonts = null;
    private static final DesignEngine designEngine = new DesignEngine(new DesignConfig());
    private static final String XMLDATE_PATTERN_FULL = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String XMLDATE_PATTERN_DATE_ONLY = "yyyy-MM-dd";
    private static final String XMLDATE_PATTERN_WITH_OUT_SECOND = "yyyy-MM-dd'T'HH:mm";
    private static final String XMLDATE_PATTERN_WITH_OUT_MILLISECOND = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String DEFAULT_LIBRARY = "/ThemesReportItems31.rptlibrary";
    private static List<String> paletteElementList = new ArrayList<String>();
    public static final IClassInfo TOTAL_CLASS = DEUtil.getMetaDataDictionary().getClass("Total");
    public static final String TYPE_GROUP_LISTING = "listing";
    public static final String TYPE_GROUP_GROUP = "group";
    public static final String TYPE_GROUP_NONE = "none";

    static {
        propertiesMap.put("text", ELEMENT_LABELCONTENT_PROPERTY);
        propertiesMap.put("content", ELEMENT_LABELCONTENT_PROPERTY);
        notSupportList.add(DEUtil.getMetaDataDictionary().getElement("Line"));
        notSupportList.add(DEUtil.getMetaDataDictionary().getElement("TemplateReportItem"));
        notSupportList.add(DEUtil.getMetaDataDictionary().getElement("FreeForm"));
        notSupportList.add(DEUtil.getMetaDataDictionary().getElement("GraphicMasterPage"));
        notSupportList.add(DEUtil.getMetaDataDictionary().getElement("AutoText"));
        notSupportList.add(DEUtil.getMetaDataDictionary().getElement("ExtendedItem"));
        paletteElementList.add("Label");
        paletteElementList.add("Text");
        paletteElementList.add("TextData");
        paletteElementList.add("Data");
        paletteElementList.add("Image");
        paletteElementList.add("Grid");
        paletteElementList.add("List");
        paletteElementList.add("Table");
    }

    public static List<IElementDefn> getElementSupportList(DesignElementHandle parent, int slotId) {
        ArrayList list = new ArrayList();
        ISlotDefn slotDefn = parent.getDefn().getSlot(slotId);
        if (slotDefn != null) {
            list.addAll(slotDefn.getContentExtendedElements());
            list.removeAll(notSupportList);
        }
        ArrayList<IElementDefn> availableList = new ArrayList<IElementDefn>();
        ArrayList<IElementDefn> extendedList = new ArrayList<IElementDefn>();
        for (IElementDefn elementDefn : list) {
            if (!parent.canContain(slotId, elementDefn.getName())) continue;
            if (elementDefn.isExtendedElement()) {
                extendedList.add(elementDefn);
                continue;
            }
            availableList.add(elementDefn);
        }
        Collections.sort(availableList, new Comparator<IElementDefn>(){

            @Override
            public int compare(IElementDefn o1, IElementDefn o2) {
                return paletteElementList.indexOf(o1.getName()) - paletteElementList.indexOf(o2.getName());
            }
        });
        Collections.sort(extendedList, new Comparator<IElementDefn>(){

            @Override
            public int compare(IElementDefn o1, IElementDefn o2) {
                return Collator.getInstance().compare(o1.getName(), o2.getName());
            }
        });
        availableList.addAll(extendedList);
        return availableList;
    }

    public static List<IElementDefn> getElementSupportList(SlotHandle slotHandle) {
        return DEUtil.getElementSupportList(slotHandle.getElementHandle(), slotHandle.getSlotID());
    }

    public static List<IElementDefn> getElementSupportList(PropertyHandle propertyHandle) {
        ArrayList list = new ArrayList();
        IElementPropertyDefn propertyDefn = propertyHandle.getPropertyDefn();
        if (propertyDefn != null) {
            list.addAll(propertyDefn.getAllowedElements(true));
            list.removeAll(notSupportList);
        }
        ArrayList<IElementDefn> availableList = new ArrayList<IElementDefn>();
        ArrayList<IElementDefn> extendedList = new ArrayList<IElementDefn>();
        for (IElementDefn elementDefn : list) {
            if (!propertyHandle.canContain(elementDefn.getName())) continue;
            if (elementDefn.isExtendedElement()) {
                extendedList.add(elementDefn);
                continue;
            }
            availableList.add(elementDefn);
        }
        Collections.sort(availableList, new Comparator<IElementDefn>(){

            @Override
            public int compare(IElementDefn o1, IElementDefn o2) {
                return paletteElementList.indexOf(o1.getName()) - paletteElementList.indexOf(o2.getName());
            }
        });
        Collections.sort(extendedList, new Comparator<IElementDefn>(){

            @Override
            public int compare(IElementDefn o1, IElementDefn o2) {
                return Collator.getInstance().compare(o1.getName(), o2.getName());
            }
        });
        availableList.addAll(extendedList);
        return availableList;
    }

    public static int findInsertPosition(DesignElementHandle parent, DesignElementHandle element, int slotID) {
        if (element == null) {
            SlotHandle slotHandle = parent.getSlot(slotID);
            if (slotHandle != null) {
                return slotHandle.getCount();
            }
            return -1;
        }
        return DEUtil.findPos(parent, slotID, element);
    }

    public static int findInsertPosition(DesignElementHandle parent, DesignElementHandle element, String content) {
        if (element == null) {
            return parent.getContentCount(content);
        }
        return element.getIndex();
    }

    public static int findPos(DesignElementHandle parent, int slotID, DesignElementHandle child) {
        assert (slotID >= 0);
        SlotHandle slotHandle = parent.getSlot(slotID);
        return slotHandle.findPosn(child);
    }

    public static String getElementName(Object obj) {
        if (obj instanceof Class) {
            obj = ((Class)obj).getName();
        }
        return obj.toString().substring(obj.toString().lastIndexOf(".") + 1);
    }

    public static IElementDefn getElementDefn(String elementName) {
        IElementDefn defn = DEUtil.getMetaDataDictionary().getElement(elementName);
        if (defn == null) {
            defn = DEUtil.getMetaDataDictionary().getExtension(elementName);
        }
        return defn;
    }

    public static String getDisplayLabel(Object obj) {
        return DEUtil.getDisplayLabel(obj, true);
    }

    public static String getDisplayLabel(Object obj, boolean includeElementName) {
        if (obj instanceof DesignElementHandle) {
            DesignElementHandle handle = (DesignElementHandle)obj;
            String elementName = handle.getDefn().getDisplayName();
            String displayName = handle.getQualifiedName() != null && !handle.getQualifiedName().equals(handle.getName()) ? handle.getQualifiedName() : handle.getName();
            if (!StringUtil.isBlank((String)displayName)) {
                if (includeElementName) {
                    return elementName + " - " + displayName;
                }
                return displayName;
            }
            return elementName;
        }
        return "";
    }

    public static int getMasterPageAccount() {
        SlotHandle slotHandle = SessionHandleAdapter.getInstance().getReportDesignHandle().getMasterPages();
        Iterator itor = slotHandle.iterator();
        int account = 0;
        while (itor.hasNext()) {
            ++account;
            itor.next();
        }
        return account;
    }

    public static String getDefaultContentName(Object parent) {
        List propDefns;
        if (parent instanceof DesignElementHandle && !(propDefns = ((DesignElementHandle)parent).getDefn().getContents()).isEmpty()) {
            return ((IPropertyDefn)propDefns.get(0)).getName();
        }
        return "";
    }

    public static int getDefaultSlotID(Object parent) {
        int slotID = -1;
        if (parent instanceof GraphicMasterPageHandle) {
            slotID = 0;
        } else if (parent instanceof ParameterGroupHandle) {
            slotID = 0;
        } else if (parent instanceof ReportDesignHandle) {
            slotID = 6;
        } else if (parent instanceof LibraryHandle) {
            slotID = 5;
        } else if (parent instanceof CellHandle) {
            slotID = 0;
        } else if (parent instanceof RowHandle) {
            slotID = 0;
        } else if (parent instanceof GridHandle) {
            slotID = 1;
        } else if (parent instanceof ThemeHandle) {
            slotID = 0;
        } else if (parent instanceof ReportItemThemeHandle) {
            slotID = 0;
        }
        return slotID;
    }

    public static int findSlotID(Object parent, Object child) {
        assert (parent instanceof DesignElementHandle);
        assert (child instanceof DesignElementHandle);
        int slotID = ((DesignElementHandle)parent).findContentSlot((DesignElementHandle)child);
        return slotID;
    }

    public static int getSlotID(Object parent, Object child) {
        assert (parent instanceof DesignElementHandle);
        int slotID = -1;
        slotID = child != null ? DEUtil.findSlotID(parent, child) : DEUtil.getDefaultSlotID(parent);
        return slotID;
    }

    public static String getContentProperty(Object parent, Object child) {
        assert (parent instanceof DesignElementHandle);
        String retValue = "";
        retValue = child != null ? ((DesignElementHandle)child).getContainerPropertyHandle().getDefn().getName() : DEUtil.getDefaultContentName(parent);
        return retValue;
    }

    public static int findInsertPosition(DesignElementHandle parent, DesignElementHandle element) {
        if (element == null) {
            SlotHandle slotHandle = parent.getSlot(DEUtil.getDefaultSlotID(parent));
            if (slotHandle != null) {
                return slotHandle.getCount();
            }
            return -1;
        }
        return DEUtil.findPos(parent, element.getContainerSlotHandle().getSlotID(), element);
    }

    public static String getGUIPropertyKey(String key) {
        if (key != null) {
            return propertiesMap.get(key);
        }
        return null;
    }

    public static double convertoToPixel(Object handle) {
        return DEUtil.convertToPixel(handle, 0, null);
    }

    public static double convertToPixel(Object object, int fontSize) {
        return DEUtil.convertToPixel(object, fontSize, null);
    }

    public static double convertToPixel(Object object, int refValue, String refUnit) {
        double px = 0.0;
        double measure = 0.0;
        double calcValue = 0.0;
        String units = "";
        if (object instanceof DimensionValue) {
            dimension = (DimensionValue)object;
            measure = dimension.getMeasure();
            units = dimension.getUnits();
        } else if (object instanceof DimensionHandle) {
            dimension = (DimensionHandle)object;
            measure = dimension.getMeasure();
            units = dimension.getUnits();
        }
        if ("px".equals(units)) {
            return measure;
        }
        if ("".equalsIgnoreCase(units)) {
            px = measure;
        }
        if (refValue == 0) {
            Font defaultFont = JFaceResources.getDefaultFont();
            FontData[] fontData = defaultFont.getFontData();
            refValue = fontData[0].getHeight();
        }
        if ("em".equals(units)) {
            px = DimensionUtil.convertTo((double)(measure * (double)refValue), (String)"pt", (String)"in").getMeasure();
        } else if ("ex".equals(units)) {
            px = DimensionUtil.convertTo((double)(measure * (double)refValue / 3.0), (String)"pt", (String)"in").getMeasure();
        } else if ("%".equals(units)) {
            calcValue = measure * (double)refValue / 100.0;
            if ("px".equals(refUnit)) {
                return calcValue;
            }
            px = DimensionUtil.convertTo((double)calcValue, (String)"pt", (String)"in").getMeasure();
        } else if ("".equals(units)) {
            units = SessionHandleAdapter.getInstance().getReportDesignHandle().getDefaultUnits();
            px = DimensionUtil.convertTo((double)measure, (String)units, (String)"in").getMeasure();
        } else {
            px = units == null ? 0.0 : DimensionUtil.convertTo((double)measure, (String)units, (String)"in").getMeasure();
        }
        return MetricUtility.inchToPixel(px);
    }

    public static double convertToValue(DimensionHandle handle, String targetUnit) {
        double retValue = 0.0;
        if (handle.isSet()) {
            retValue = DimensionUtil.convertTo((double)handle.getMeasure(), (String)handle.getUnits(), (String)targetUnit).getMeasure();
        }
        return retValue;
    }

    public static boolean isValidInteger(String val) {
        try {
            Integer.parseInt(val);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isValidNumber(String val) {
        try {
            Double.parseDouble(val);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String[] splitString(String value) {
        String[] spt = new String[2];
        if (value != null) {
            int i = value.length();
            while (i > 0) {
                if (DEUtil.isValidNumber(value.substring(0, i))) {
                    spt[0] = value.substring(0, i);
                    spt[1] = value.substring(i);
                    break;
                }
                --i;
            }
            if (spt[0] == null && spt[1] == null) {
                spt[1] = value;
            }
        }
        return spt;
    }

    public static String resolveNull(String value) {
        return value == null ? "" : value;
    }

    public static String getRGBText(RGB rgb) {
        if (rgb != null) {
            return rgb.red + "," + rgb.green + "," + rgb.blue;
        }
        return "";
    }

    public static RGB getRGBValue(String val) {
        if (val != null) {
            if (val.startsWith("#")) {
                int rgb = ColorUtil.parseColor((String)val);
                if (rgb != -1) {
                    return DEUtil.getRGBValue(rgb);
                }
            } else {
                String[] ss = val.split(",");
                if (ss.length == 3) {
                    try {
                        int r = Integer.parseInt(ss[0]);
                        int g = Integer.parseInt(ss[1]);
                        int b = Integer.parseInt(ss[2]);
                        return new RGB(r, g, b);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    public static RGB getRGBValue(int rgbValue) {
        if (rgbValue == -1) {
            return null;
        }
        return new RGB(rgbValue >> 16 & 0xFF, rgbValue >> 8 & 0xFF, rgbValue & 0xFF);
    }

    public static int getRGBInt(RGB rgb) {
        if (rgb == null) {
            return -1;
        }
        return (rgb.red & 0xFF) << 16 | (rgb.green & 0xFF) << 8 | rgb.blue & 0xFF;
    }

    public static List<DataSetHandle> getDataSetList(DesignElementHandle handle) {
        ArrayList<DataSetHandle> dataSetList = new ArrayList<DataSetHandle>();
        if (handle instanceof ReportElementHandle) {
            DataSetHandle dataSet;
            if (handle instanceof ReportItemHandle && (dataSet = ((ReportItemHandle)handle).getDataSet()) != null && !dataSetList.contains(dataSet)) {
                dataSetList.add(dataSet);
            }
            for (DataSetHandle dataSet2 : DEUtil.getDataSetList(handle.getContainer())) {
                if (dataSetList.contains(dataSet2)) continue;
                dataSetList.add(dataSet2);
            }
        }
        return dataSetList;
    }

    public static List<DesignElementHandle> getDataSetListExcludeSelf(DesignElementHandle handle) {
        ArrayList<DesignElementHandle> dataSetList = new ArrayList<DesignElementHandle>();
        if (handle instanceof ReportElementHandle) {
            for (DesignElementHandle designElementHandle : DEUtil.getDataSetList(handle.getContainer())) {
                if (dataSetList.contains(designElementHandle)) continue;
                dataSetList.add(designElementHandle);
            }
        }
        return dataSetList;
    }

    public static IElementPropertyDefn getPropertyDefn(String elementName, String propertyName) {
        IElementDefn elementDefn = DEUtil.getMetaDataDictionary().getElement(elementName);
        if (elementDefn != null) {
            return elementDefn.getProperty(propertyName);
        }
        return null;
    }

    public static String getExpression(Object model) {
        if (model instanceof ParameterHandle) {
            return ExpressionUtil.createJSParameterValueExpression((String)((ParameterHandle)model).getQualifiedName());
        }
        if (model instanceof LevelHandle) {
            LevelHandle handle = (LevelHandle)model;
            DesignElementHandle temp = handle.getContainer();
            String dimensionName = "";
            while (temp != null) {
                if (temp instanceof org.eclipse.birt.report.model.api.olap.DimensionHandle) {
                    dimensionName = ((org.eclipse.birt.report.model.api.olap.DimensionHandle)temp).getName();
                    break;
                }
                temp = temp.getContainer();
            }
            return ExpressionUtil.createJSDimensionExpression((String)dimensionName, (String)handle.getName());
        }
        if (model instanceof MeasureHandle) {
            return ExpressionUtil.createJSMeasureExpression((String)((MeasureHandle)model).getName());
        }
        if (model instanceof DataSetItemModel) {
            String colName = ((DataSetItemModel)model).getAlias();
            if (colName == null || colName.trim().length() == 0) {
                colName = ((DataSetItemModel)model).getName();
            }
            return DEUtil.getColumnExpression(colName);
        }
        if (model instanceof ComputedColumnHandle) {
            if (DEUtil.isBindingCube(((ComputedColumnHandle)model).getElementHandle())) {
                return DEUtil.getDataExpression(((ComputedColumnHandle)model).getName());
            }
            return DEUtil.getColumnExpression(((ComputedColumnHandle)model).getName());
        }
        if (model instanceof ResultSetColumnHandle) {
            return DEUtil.getResultSetColumnExpression(((ResultSetColumnHandle)model).getColumnName());
        }
        if (model instanceof DataSetParameterHandle) {
            return "outputParams[\"" + DEUtil.escape(((DataSetParameterHandle)model).getName()) + "\"]";
        }
        if (model instanceof LevelAttributeHandle) {
            LevelAttributeHandle levelAttri = (LevelAttributeHandle)model;
            String levelName = levelAttri.getElement().getName();
            DesignElementHandle temp = levelAttri.getElementHandle().getContainer();
            String dimensionName = "";
            while (temp != null) {
                if (temp instanceof org.eclipse.birt.report.model.api.olap.DimensionHandle) {
                    dimensionName = ((org.eclipse.birt.report.model.api.olap.DimensionHandle)temp).getName();
                    break;
                }
                temp = temp.getContainer();
            }
            return ExpressionUtil.createJSDimensionExpression((String)dimensionName, (String)levelName, (String)levelAttri.getName());
        }
        if (model instanceof VariableElementHandle) {
            VariableElementHandle variable = (VariableElementHandle)model;
            return "vars[\"" + variable.getName() + "\"]";
        }
        return null;
    }

    public static int getFontSize(String fontSize) {
        if ("larger".equals(fontSize)) {
            fontSize = "large";
        } else if ("smaller".equals(fontSize)) {
            fontSize = "small";
        } else if (fontSize == null) {
            fontSize = "medium";
        }
        String rt = (String)DesignerConstants.fontMap.get(fontSize);
        if (rt != null) {
            return Integer.parseInt(rt);
        }
        String[] sp = DEUtil.splitString(fontSize);
        if (sp[0] != null && DEUtil.isValidNumber(sp[0])) {
            return (int)CSSUtil.convertToPoint(new DimensionValue(Double.parseDouble(sp[0]), sp[1]));
        }
        return 10;
    }

    public static String getFontSize(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                return "medium";
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            return ((DimensionValue)fontSizeValue).toString();
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSize(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSize(handle.getContainer());
            }
            return fontSize;
        }
        return "medium";
    }

    private static String getLargerFontSize(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                int i = 0;
                while (i < DesignerConstants.fontSizes.length - 1) {
                    if ("medium".equals(DesignerConstants.fontSizes[i][0])) {
                        return DesignerConstants.fontSizes[i + 1][0];
                    }
                    ++i;
                }
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            int parentSize = DEUtil.getFontSizeIntValue(handle.getContainer());
            int size = (int)CSSUtil.convertToPoint(fontSizeValue, parentSize) + 1;
            DimensionValue dm = new DimensionValue((double)size, "pt");
            return dm.toString();
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSize(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSize(handle.getContainer());
            }
            int i = 0;
            while (i < DesignerConstants.fontSizes.length - 1) {
                if (fontSize.equals(DesignerConstants.fontSizes[i][0])) {
                    return DesignerConstants.fontSizes[i + 1][0];
                }
                ++i;
            }
            return DesignerConstants.fontSizes[DesignerConstants.fontSizes.length - 1][0];
        }
        return "medium";
    }

    private static String getSmallerFontSize(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                int i = DesignerConstants.fontSizes.length - 1;
                while (i > 0) {
                    if ("medium".equals(DesignerConstants.fontSizes[i][0])) {
                        return DesignerConstants.fontSizes[i - 1][0];
                    }
                    --i;
                }
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            int parentSize = DEUtil.getFontSizeIntValue(handle.getContainer());
            int size = (int)CSSUtil.convertToPoint(fontSizeValue, parentSize) - 1;
            size = size < 1 ? 1 : size;
            DimensionValue dm = new DimensionValue((double)size, "pt");
            return dm.toString();
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSize(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSize(handle.getContainer());
            }
            int i = DesignerConstants.fontSizes.length - 1;
            while (i > 0) {
                if (fontSize.equals(DesignerConstants.fontSizes[i][0])) {
                    return DesignerConstants.fontSizes[i - 1][0];
                }
                --i;
            }
            return DesignerConstants.fontSizes[0][0];
        }
        return "medium";
    }

    public static int getFontSizeIntValue(DesignElementHandle handle) {
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                String size = (String)DesignerConstants.fontMap.get("medium");
                return Integer.parseInt(size);
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if (handle.getPrivateStyle() != null && handle.getPrivateStyle().getFontSize().getAbsoluteValue() != null) {
            return (int)CSSUtil.convertToPoint(handle.getPrivateStyle().getFontSize().getAbsoluteValue(), DEUtil.getDefaultFontSize());
        }
        return DEUtil.getDefaultFontSize();
    }

    private static int getDefaultFontSize() {
        if (defaultFontSite == -1) {
            String size = (String)DesignerConstants.fontMap.get("medium");
            defaultFontSite = Integer.parseInt(size);
        }
        return defaultFontSite;
    }

    private static int getLargerFontSizeIntValue(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                String size = (String)DesignerConstants.fontMap.get("medium");
                return Integer.parseInt(size) + 1;
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            int size = DEUtil.getFontSizeIntValue(handle.getContainer());
            return (int)CSSUtil.convertToPoint(fontSizeValue, size) + 1;
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSizeIntValue(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSizeIntValue(handle.getContainer());
            }
            int i = 0;
            while (i < DesignerConstants.fontSizes.length - 1) {
                if (fontSize.equals(DesignerConstants.fontSizes[i][0])) {
                    return Integer.parseInt(DesignerConstants.fontSizes[i + 1][1]);
                }
                ++i;
            }
            return Integer.parseInt(DesignerConstants.fontSizes[DesignerConstants.fontSizes.length - 1][1]);
        }
        String size = (String)DesignerConstants.fontMap.get("medium");
        return Integer.parseInt(size) + 1;
    }

    private static int getSmallerFontSizeIntValue(DesignElementHandle handle) {
        Object fontSizeValue;
        if (!(handle instanceof ReportItemHandle)) {
            if (handle instanceof ModuleHandle) {
                String size = (String)DesignerConstants.fontMap.get("medium");
                return Integer.parseInt(size) - 1;
            }
            if (handle instanceof GroupHandle) {
                handle = handle.getContainer();
            }
        }
        if ((fontSizeValue = DEUtil.getModelFontSize(handle)) instanceof DimensionValue) {
            int gParentFontSize = DEUtil.getFontSizeIntValue(handle.getContainer());
            int size = (int)CSSUtil.convertToPoint(fontSizeValue, gParentFontSize) - 1;
            if (size < 1) {
                return 1;
            }
            return size;
        }
        if (fontSizeValue instanceof String) {
            String fontSize = (String)fontSizeValue;
            if (fontSize.equals("larger")) {
                return DEUtil.getLargerFontSizeIntValue(handle.getContainer());
            }
            if (fontSize.equals("smaller")) {
                return DEUtil.getSmallerFontSizeIntValue(handle.getContainer());
            }
            int i = DesignerConstants.fontSizes.length - 1;
            while (i > 0) {
                if (fontSize.equals(DesignerConstants.fontSizes[i][0])) {
                    return Integer.parseInt(DesignerConstants.fontSizes[i - 1][1]);
                }
                --i;
            }
            return Integer.parseInt(DesignerConstants.fontSizes[0][1]);
        }
        String size = (String)DesignerConstants.fontMap.get("medium");
        return Integer.parseInt(size) - 1;
    }

    public static String getEscapedMenuItemText(String src) {
        if (src != null && src.indexOf(38) != -1) {
            src = src.replaceAll("\\&", "&&");
        }
        return src;
    }

    public static String[] getSystemFontNames() {
        if (sorted_system_fonts == null) {
            sorted_system_fonts = DEUtil.getSystemFontNames(new AlphabeticallyComparator());
        }
        return sorted_system_fonts;
    }

    public static synchronized String[] getSystemFontNames(AlphabeticallyComparator comparator) {
        FontData fd;
        int n;
        int n2;
        FontData[] fontDataArray;
        FontData[] fontDatas;
        if (scalable_system_fonts == null) {
            fontDatas = Display.getCurrent().getFontList(null, true);
            scalable_system_fonts = new ArrayList<String>();
            fontDataArray = fontDatas;
            n2 = fontDatas.length;
            n = 0;
            while (n < n2) {
                fd = fontDataArray[n];
                scalable_system_fonts.add(fd.getName());
                ++n;
            }
        }
        if (non_scalable_system_fonts == null) {
            fontDatas = Display.getCurrent().getFontList(null, false);
            non_scalable_system_fonts = new ArrayList<String>();
            fontDataArray = fontDatas;
            n2 = fontDatas.length;
            n = 0;
            while (n < n2) {
                fd = fontDataArray[n];
                non_scalable_system_fonts.add(fd.getName());
                ++n;
            }
        }
        TreeSet<Object> set = new TreeSet<Object>(comparator);
        for (String fontName : scalable_system_fonts) {
            set.add(fontName);
        }
        for (String fontName : non_scalable_system_fonts) {
            set.add(fontName);
        }
        return set.toArray(new String[set.size()]);
    }

    public static GroupElementHandle getMultiSelectionHandle(List<?> modelList) {
        ModuleHandle designHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        GroupElementHandle handle = GroupElementFactory.newGroupElement((ModuleHandle)designHandle, modelList);
        return handle;
    }

    public static String escape(String str) {
        String[][] chars = new String[][]{{"\\\\", "\"", "'"}, {"\\\\\\\\", "\\\\\"", "\\\\'"}};
        String result = str;
        int i = 0;
        while (i < chars[0].length) {
            result = result.replaceAll(chars[0][i], chars[1][i]);
            ++i;
        }
        return result;
    }

    public static String getDecmalStr(int decPlaces) {
        String defaultDecs = "0000000000";
        String decStr = "";
        if (decPlaces > 0 && decPlaces < 10) {
            decStr = defaultDecs.substring(0, decPlaces);
        } else if (decPlaces >= 10) {
            if (decPlaces > 100) {
                decPlaces = 100;
            }
            int quotient = decPlaces / 10;
            int remainder = decPlaces % 10;
            StringBuilder s = new StringBuilder(100);
            int i = 0;
            while (i < quotient) {
                s.append(defaultDecs);
                ++i;
            }
            s.append(defaultDecs.substring(0, remainder));
            decStr = s.toString();
        }
        return decStr;
    }

    public static boolean isParameterGroup(Object transferSource) {
        return transferSource instanceof IDesignElement && (((IDesignElement)transferSource).getDefn().getName().equals("ParameterGroup") || ((IDesignElement)transferSource).getDefn().getName().equals("CascadingParameterGroup"));
    }

    public static Iterator<?> getStyles() {
        return DEUtil.getStyles(true, (Comparator<Object>)new AlphabeticallyComparator());
    }

    public static Iterator<?> getStyles(boolean showCurrent) {
        return DEUtil.getStyles(showCurrent, (Comparator<Object>)new AlphabeticallyComparator());
    }

    public static Iterator<Object> getStyles(boolean showCurrent, Comparator<Object> comparator) {
        ArrayList styles = null;
        ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (module instanceof ReportDesignHandle) {
            styles = module.getAllStyles();
        } else if (module instanceof LibraryHandle) {
            styles = new ArrayList();
            if (showCurrent) {
                ThemeHandle theme = ((LibraryHandle)module).getTheme();
                if (theme != null) {
                    styles.addAll(theme.getAllStyles());
                }
            } else {
                SlotHandle themeSlot = ((LibraryHandle)module).getThemes();
                styles = new ArrayList();
                for (Object obj : themeSlot.getContents()) {
                    if (!(obj instanceof AbstractThemeHandle)) continue;
                    AbstractThemeHandle theme = (AbstractThemeHandle)obj;
                    int i = 0;
                    while (i < theme.getAllCssStyleSheets().size()) {
                        styles.add(theme.getAllCssStyleSheets().get(i));
                        ++i;
                    }
                    i = 0;
                    while (i < theme.getStyles().getCount()) {
                        styles.add(theme.getStyles().getContents().get(i));
                        ++i;
                    }
                }
            }
        }
        if (styles == null || styles.isEmpty()) {
            return Collections.emptyList().iterator();
        }
        if (comparator == null) {
            return styles.iterator();
        }
        Object[] stylesArray = styles.toArray(new Object[styles.size()]);
        Arrays.sort(stylesArray, comparator);
        return Arrays.asList(stylesArray).iterator();
    }

    public static Iterator<?> getStyles(Comparator<Object> comparator) {
        return DEUtil.getStyles(true, comparator);
    }

    public static Iterator<Object> getLocalStyles() {
        return DEUtil.getLocalStyles(new AlphabeticallyComparator());
    }

    public static Iterator<Object> getLocalStyles(Comparator<Object> comparator) {
        Object[] stylesArray;
        ArrayList styles = null;
        ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (module instanceof ReportDesignHandle) {
            styles = module.getStyles().getContents();
        } else if (module instanceof LibraryHandle) {
            styles = new ArrayList();
            ThemeHandle theme = ((LibraryHandle)module).getTheme();
            if (theme != null) {
                styles.addAll(theme.getAllStyles());
            }
        }
        Object[] objectArray = stylesArray = styles == null ? new Object[]{} : styles.toArray();
        if (comparator != null) {
            Arrays.sort(stylesArray, comparator);
        }
        return Arrays.asList(stylesArray).iterator();
    }

    public static Iterator<Object> getStyles(AbstractThemeHandle theme) {
        return DEUtil.getStyles(theme, (Comparator<Object>)new AlphabeticallyComparator());
    }

    public static Iterator<Object> getStyles(AbstractThemeHandle theme, Comparator<Object> comparator) {
        ArrayList styles = new ArrayList();
        if (theme != null) {
            styles.addAll(theme.getAllStyles());
        } else {
            ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
            if (module instanceof LibraryHandle) {
                styles = new ArrayList();
                theme = ((LibraryHandle)module).getTheme();
                if (theme != null) {
                    styles.addAll(theme.getAllStyles());
                }
            }
        }
        Object[] stylesArray = styles.toArray(new Object[styles.size()]);
        if (comparator != null) {
            Arrays.sort(stylesArray, comparator);
        }
        return Arrays.asList(stylesArray).iterator();
    }

    public static boolean isSameString(String str1, String str2) {
        return str1 == null && str2 == null || str1 != null && str1.equals(str2);
    }

    public static String getColumnExpression(String columnName) {
        if (StringUtil.isBlank((String)columnName)) {
            return null;
        }
        return ExpressionUtil.createJSRowExpression((String)columnName);
    }

    public static String getDataExpression(String columnName) {
        if (StringUtil.isBlank((String)columnName)) {
            return null;
        }
        return ExpressionUtil.createJSDataExpression((String)columnName);
    }

    public static String getResultSetColumnExpression(String columnName) {
        if (StringUtil.isBlank((String)columnName)) {
            return null;
        }
        return ExpressionUtil.createJSDataSetRowExpression((String)columnName);
    }

    public static String getRelativedPath(String basePath, String path) {
        File baseFile = new File(basePath);
        if (baseFile.isFile()) {
            baseFile = baseFile.getParentFile();
        }
        return URIUtil.getRelativePath((String)baseFile.getAbsolutePath(), (String)path);
    }

    public static ActionHandle getActionHandle(ReportElementHandle element) {
        ActionHandle actionHandle = null;
        if (element instanceof LabelHandle) {
            actionHandle = ((LabelHandle)element).getActionHandle();
        } else if (element instanceof DataItemHandle) {
            actionHandle = ((DataItemHandle)element).getActionHandle();
        } else if (element instanceof ImageHandle) {
            actionHandle = ((ImageHandle)element).getActionHandle();
        } else if (element instanceof LevelHandle) {
            actionHandle = ((LevelHandle)element).getActionHandle();
        } else if (element instanceof MeasureHandle) {
            actionHandle = ((MeasureHandle)element).getActionHandle();
        }
        return actionHandle;
    }

    public static ActionHandle setAction(ReportElementHandle element, Action action) throws SemanticException {
        ActionHandle actionHandle = null;
        if (element instanceof LabelHandle) {
            actionHandle = ((LabelHandle)element).setAction(action);
        } else if (element instanceof DataItemHandle) {
            actionHandle = ((DataItemHandle)element).setAction(action);
        } else if (element instanceof ImageHandle) {
            actionHandle = ((ImageHandle)element).setAction(action);
        } else if (element instanceof LevelHandle) {
            actionHandle = ((LevelHandle)element).setAction(action);
        } else if (element instanceof MeasureHandle) {
            actionHandle = ((MeasureHandle)element).setAction(action);
        }
        return actionHandle;
    }

    private static Object getModelFontSize(DesignElementHandle handle) {
        StyleHandle styleHandle = handle.getPrivateStyle();
        Object fontSizeValue = null;
        if (styleHandle != null) {
            fontSizeValue = handle.getPrivateStyle().getFontSize().getValue();
        }
        return fontSizeValue;
    }

    public static Iterator<Object> getThemes() {
        return DEUtil.getThemes(new AlphabeticallyComparator());
    }

    private static Iterator<Object> getThemes(AlphabeticallyComparator comparator) {
        List themes = SessionHandleAdapter.getInstance().getReportDesignHandle().getVisibleThemes(1);
        Object[] themesArray = themes.toArray();
        if (comparator != null) {
            Arrays.sort(themesArray, comparator);
        }
        return Arrays.asList(themesArray).iterator();
    }

    public static GroupElementHandle getGroupElementHandle(List<?> modelList) {
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (handle == null) {
            return GroupElementFactory.newGroupElement((ModuleHandle)handle, (List)Collections.EMPTY_LIST);
        }
        return GroupElementFactory.newGroupElement((ModuleHandle)handle, modelList);
    }

    public static boolean isIncluded(LibraryHandle handle) {
        return handle.getNamespace() != null;
    }

    public static List<IClassInfo> getClasses() {
        return DEUtil.getClasses(new AlphabeticallyComparator());
    }

    public static List<IClassInfo> getClasses(AlphabeticallyComparator comp) {
        List classes = DEUtil.getMetaDataDictionary().getClasses();
        Collections.sort(classes, comp);
        classes.remove(TOTAL_CLASS);
        return classes;
    }

    public static List<IMethodInfo> getMethods(IClassInfo classInfo) {
        return DEUtil.getMethods(classInfo, false, new AlphabeticallyComparator());
    }

    public static List<IMethodInfo> getMethods(IClassInfo classInfo, AlphabeticallyComparator comp) {
        return DEUtil.getMethods(classInfo, false, comp);
    }

    public static List<IMethodInfo> getMethods(IClassInfo classInfo, boolean includeConstructor) {
        return DEUtil.getMethods(classInfo, includeConstructor, new AlphabeticallyComparator());
    }

    public static List<IMethodInfo> getMethods(IClassInfo classInfo, boolean includeConstructor, AlphabeticallyComparator comp) {
        IMethodInfo mi;
        ArrayList<IMethodInfo> mds = new ArrayList<IMethodInfo>();
        if (includeConstructor && (mi = classInfo.getConstructor()) != null) {
            mds.add(mi);
        }
        List methods = classInfo.getMethods();
        Collections.sort(methods, comp);
        mds.addAll(methods);
        return mds;
    }

    public static List<IMemberInfo> getMembers(IClassInfo classInfo) {
        return DEUtil.getMembers(classInfo, new AlphabeticallyComparator());
    }

    public static List<IMemberInfo> getMembers(IClassInfo classInfo, AlphabeticallyComparator comp) {
        List members = classInfo.getMembers();
        Collections.sort(members, comp);
        return members;
    }

    public static String getMethodArgumentType(DesignElementHandle handle, String methodName, int argIndex) {
        if (handle instanceof DataSetHandle) {
            return "DataSet";
        }
        if (handle instanceof DataSourceHandle) {
            return "DataSource";
        }
        List methods = handle.getDefn().getLocalMethods();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            IMethodInfo method = ((ElementPropertyDefn)iter.next()).getMethodInfo();
            if (!method.getName().equals(methodName)) continue;
            Iterator argumentListIterator = method.argumentListIterator();
            if (argumentListIterator.hasNext()) {
                IArgumentInfoList argumentInfoList = (IArgumentInfoList)argumentListIterator.next();
                int i = 0;
                Iterator iterator = argumentInfoList.argumentsIterator();
                while (iterator.hasNext()) {
                    Object arg = iterator.next();
                    if (argIndex == i) {
                        return ((IArgumentInfo)arg).getType();
                    }
                    ++i;
                }
            }
            return null;
        }
        return null;
    }

    public static List<IArgumentInfo> getDesignElementMethodArgumentsInfo(DesignElementHandle handle, String methodName) {
        List methods = handle.getDefn().getMethods();
        ArrayList<IArgumentInfo> args = new ArrayList<IArgumentInfo>();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            IArgumentInfoList argumentInfoList;
            Iterator argumentListIterator;
            IMethodInfo method = ((ElementPropertyDefn)iter.next()).getMethodInfo();
            if (!method.getName().equals(methodName) || !(argumentListIterator = method.argumentListIterator()).hasNext() || (argumentInfoList = (IArgumentInfoList)argumentListIterator.next()) == null) continue;
            Iterator iterator = argumentInfoList.argumentsIterator();
            while (iterator.hasNext()) {
                IArgumentInfo arg = (IArgumentInfo)iterator.next();
                args.add(arg);
            }
        }
        return args;
    }

    @Deprecated
    public static List<?> getDataSources() {
        ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (moduleHandle != null) {
            return moduleHandle.getVisibleDataSources();
        }
        return new ArrayList();
    }

    public static List<?> getAllColumnBindingList(DesignElementHandle handle) {
        return DEUtil.getAllColumnBindingList(handle, true);
    }

    public static List getAllColumnBindingList(DesignElementHandle handle, boolean includeSelf) {
        ArrayList bindingList = new ArrayList();
        if (handle instanceof ReportElementHandle || handle instanceof ContentElementHandle) {
            Iterator iterator = DEUtil.getBindingColumnIterator(handle);
            while (iterator.hasNext()) {
                bindingList.add(iterator.next());
            }
            bindingList.addAll(0, DEUtil.getAllColumnBindingList(handle.getContainer(), true));
        }
        return bindingList;
    }

    public static List<ComputedColumnHandle> getVisiableColumnBindingsList(DesignElementHandle handle) {
        return DEUtil.getVisiableColumnBindingsList(handle, true);
    }

    public static List getVisiableColumnBindingsList(DesignElementHandle handle, boolean includeSelf) {
        ReportItemHandle holder;
        ArrayList bindingList = new ArrayList();
        if (includeSelf) {
            Iterator iterator = DEUtil.getBindingColumnIterator(handle);
            while (iterator.hasNext()) {
                bindingList.add(iterator.next());
            }
        }
        if ((holder = DEUtil.getBindingHolder(handle)) != null) {
            DesignElementHandle elementHandle = handle.getContainer();
            while (elementHandle != holder.getContainer()) {
                ArrayList subBindingList = new ArrayList();
                Iterator iterator = DEUtil.getBindingColumnIterator(elementHandle);
                while (iterator.hasNext()) {
                    subBindingList.add(iterator.next());
                }
                bindingList.addAll(0, subBindingList);
                elementHandle = elementHandle.getContainer();
            }
        }
        return bindingList;
    }

    public static ReportItemHandle getBindingHolder(DesignElementHandle handle) {
        return DEUtil.getBindingHolder(handle, false);
    }

    public static ReportItemHandle getBindingHolder(DesignElementHandle handle, boolean skipSelf) {
        if (skipSelf || handle instanceof ContentElementHandle) {
            return DEUtil.getBindingHolder(handle.getContainer());
        }
        if (handle instanceof ReportElementHandle) {
            if (handle instanceof ReportItemHandle && (((ReportItemHandle)handle).getDataBindingReference() != null || ((ReportItemHandle)handle).getCube() != null || ((ReportItemHandle)handle).getDataSet() != null || ((ReportItemHandle)handle).columnBindingsIterator().hasNext())) {
                return (ReportItemHandle)handle;
            }
            ReportItemHandle result = DEUtil.getBindingHolder(handle.getContainer());
            if (result == null && handle instanceof ReportItemHandle) {
                result = (ReportItemHandle)handle;
            }
            return result;
        }
        return null;
    }

    public static ReportItemHandle getBindingRoot(DesignElementHandle handle) {
        return DEUtil.getBindingRoot(handle, false);
    }

    public static ReportItemHandle getBindingRoot(DesignElementHandle handle, boolean skipSelf) {
        if (skipSelf || handle instanceof ContentElementHandle) {
            return DEUtil.getBindingRoot(handle.getContainer());
        }
        if (handle instanceof ReportElementHandle) {
            if (handle instanceof ReportItemHandle && (((ReportItemHandle)handle).getDataBindingReference() != null || ((ReportItemHandle)handle).getCube() != null || ((ReportItemHandle)handle).getDataSet() != null)) {
                return (ReportItemHandle)handle;
            }
            ReportItemHandle result = DEUtil.getBindingRoot(handle.getContainer());
            return result;
        }
        return null;
    }

    public static DataSetHandle getFirstDataSet(DesignElementHandle handle) {
        DataSetHandle dataSetHandle = null;
        if (handle instanceof ReportItemHandle) {
            dataSetHandle = ((ReportItemHandle)handle).getDataSet();
        }
        if (dataSetHandle == null) {
            DesignElementHandle elementHandle = handle;
            while (elementHandle != null) {
                if (elementHandle instanceof ListingHandle && (dataSetHandle = ((ListingHandle)elementHandle).getDataSet()) != null) {
                    return dataSetHandle;
                }
                elementHandle = elementHandle.getContainer();
            }
        }
        return dataSetHandle;
    }

    public static Object getFirstDataSource(DesignElementHandle handle) {
        return DEUtil.getFirstDataSource(handle, true);
    }

    public static Object getFirstDataSource(DesignElementHandle handle, boolean findContainer) {
        if (handle instanceof ReportItemHandle) {
            ReportItemHandle item = (ReportItemHandle)handle;
            if (item.getDataBindingReference() != null) {
                return DEUtil.getFirstDataSource((DesignElementHandle)item.getDataBindingReference(), false);
            }
            if (item.getCube() != null) {
                return item.getCube();
            }
            if (item.getDataSet() != null) {
                return item.getDataSet();
            }
        }
        if (handle.getContainer() != null && findContainer) {
            return DEUtil.getFirstDataSource(handle.getContainer(), findContainer);
        }
        return null;
    }

    public static ListingHandle getListingContainer(DesignElementHandle container) {
        DesignElementHandle elementHandle = container;
        while (elementHandle != null) {
            if (elementHandle instanceof ListingHandle) {
                return (ListingHandle)elementHandle;
            }
            elementHandle = elementHandle.getContainer();
        }
        return null;
    }

    public static ComputedColumnHandle addColumn(DesignElementHandle handle, ComputedColumn column, boolean inForce) throws SemanticException {
        assert (handle instanceof ReportItemHandle);
        return ((ReportItemHandle)handle).addColumnBinding(column, inForce);
    }

    public static Iterator getBindingColumnIterator(DesignElementHandle handle) {
        if (handle instanceof ReportItemHandle) {
            return ((ReportItemHandle)handle).columnBindingsIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public static String getBindingexpression(DesignElementHandle baseElement, ComputedColumnHandle column) {
        return DEUtil.getBindingexpression(baseElement, column, true);
    }

    public static String getBindingexpression(DesignElementHandle baseElement, ComputedColumnHandle column, boolean checkOutLevel) {
        Object exp = "row";
        if (DEUtil.isBindingCube(column.getElementHandle())) {
            exp = "data";
        }
        if (checkOutLevel) {
            int i = 0;
            while (i < DEUtil.getBindingLevel(column.getElementHandle(), baseElement)) {
                exp = (String)exp + "._outer";
                ++i;
            }
        }
        exp = (String)exp + "[\"" + DEUtil.escape(column.getName()) + "\"]";
        return exp;
    }

    public static String getRowNumExpression(DesignElementHandle baseElement, DesignElementHandle elementHandle) {
        return DEUtil.getRowNumExpression(baseElement, elementHandle, true);
    }

    public static String getRowNumExpression(DesignElementHandle baseElement, DesignElementHandle elementHandle, boolean checkOutLevel) {
        Object exp = "row";
        if (checkOutLevel) {
            int i = 0;
            while (i < DEUtil.getBindingLevel(elementHandle, baseElement)) {
                exp = (String)exp + "._outer";
                ++i;
            }
        }
        exp = (String)exp + ".__rownum";
        return exp;
    }

    public static boolean isBindingCube(DesignElementHandle element) {
        if (element == null) {
            return false;
        }
        if (element instanceof ReportItemHandle) {
            if (((ReportItemHandle)element).getCube() != null) {
                return ((ReportItemHandle)element).getDataSet() == null || !(element instanceof TableHandle);
            }
            if (((ReportItemHandle)element).getDataBindingType() == 2) {
                return DEUtil.isBindingCube((DesignElementHandle)((ReportItemHandle)element).getDataBindingReference());
            }
            if (((ReportItemHandle)element).getDataBindingType() == 1) {
                return false;
            }
        }
        if (element.getContainer() != null) {
            return DEUtil.isBindingCube(element.getContainer());
        }
        return false;
    }

    public static int getBindingLevel(DesignElementHandle holder, DesignElementHandle baseElement) {
        int level = 0;
        DesignElementHandle elementHandle = baseElement;
        while (elementHandle.getContainer() != null) {
            ReportItemHandle bindingHolder = DEUtil.getBindingHolder(elementHandle);
            if (bindingHolder == holder || holder instanceof GroupHandle && bindingHolder == holder.getContainer() || bindingHolder == null) {
                return level;
            }
            elementHandle = DEUtil.getBindingHolder(elementHandle).getContainer();
            ++level;
        }
        return -1;
    }

    public static boolean isLinkedElement(DesignElementHandle handle) {
        if (handle != null && handle.getExtends() != null) {
            return handle.getExtends().getRoot() instanceof LibraryHandle;
        }
        return false;
    }

    @Deprecated
    public static List<DesignElementHandle> getGroups(DesignElementHandle handle) {
        ArrayList<DesignElementHandle> groupList = new ArrayList<DesignElementHandle>();
        if (handle instanceof ListingHandle) {
            SlotHandle groupSlotHandle = ((ListingHandle)handle).getGroups();
            for (GroupHandle group : groupSlotHandle) {
                groupList.add((DesignElementHandle)group);
            }
            return groupList;
        }
        DesignElementHandle result = handle.getContainer();
        if (result != null) {
            if (result instanceof GroupHandle) {
                groupList.add(result);
                return groupList;
            }
            return DEUtil.getGroups(result);
        }
        return groupList;
    }

    public static String getGroupControlType(DesignElementHandle handle) {
        if (handle instanceof ListingHandle) {
            return TYPE_GROUP_LISTING;
        }
        DesignElementHandle result = handle.getContainer();
        if (result != null) {
            if (result instanceof GroupHandle) {
                return TYPE_GROUP_GROUP;
            }
            return DEUtil.getGroupControlType(result);
        }
        return TYPE_GROUP_NONE;
    }

    public static String addQuote(String string) {
        if (!(string == null || string.startsWith("\"") && string.endsWith("\""))) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public static String removeQuote(String string) {
        if (string != null && string.length() >= 2 && string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static IMetaDataDictionary getMetaDataDictionary() {
        return designEngine.getMetaData();
    }

    public static String convertToXMLString(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        String pattern = XMLDATE_PATTERN_FULL;
        if (!cal.isSet(10)) {
            pattern = XMLDATE_PATTERN_DATE_ONLY;
        } else if (!cal.isSet(13)) {
            pattern = XMLDATE_PATTERN_WITH_OUT_SECOND;
        } else if (!cal.isSet(14)) {
            pattern = XMLDATE_PATTERN_WITH_OUT_MILLISECOND;
        }
        DateFormatter formater = new DateFormatter(pattern);
        return formater.format(date);
    }

    public static Date convertToDate(String xmlString) throws ParseException {
        if (StringUtil.isBlank((String)xmlString)) {
            return null;
        }
        String pattern = null;
        pattern = xmlString.indexOf(84) != -1 ? (xmlString.indexOf(46) != -1 ? XMLDATE_PATTERN_FULL : (xmlString.indexOf(58) == xmlString.lastIndexOf(58) ? XMLDATE_PATTERN_WITH_OUT_SECOND : XMLDATE_PATTERN_WITH_OUT_MILLISECOND)) : XMLDATE_PATTERN_DATE_ONLY;
        DateFormatter formater = new DateFormatter(pattern);
        return formater.parse(xmlString);
    }

    public static int getInputSize(Object input) {
        if (input instanceof GroupElementHandle) {
            return ((GroupElementHandle)input).getElements().size();
        }
        if (input instanceof List) {
            return DEUtil.getMultiSelectionHandle((List)input).getElements().size();
        }
        return -1;
    }

    public static Object getInputFirstElement(Object input) {
        if (input instanceof GroupElementHandle) {
            return ((GroupElementHandle)input).getElements().get(0);
        }
        if (input instanceof List) {
            return ((List)input).get(0);
        }
        return input;
    }

    public static Object getInputFirstElement(Object input, boolean notSame) {
        if (input instanceof GroupElementHandle) {
            if (notSame && ((GroupElementHandle)input).isSameType()) {
                return null;
            }
            return ((GroupElementHandle)input).getElements().get(0);
        }
        if (input instanceof List) {
            GroupElementHandle group = DEUtil.getGroupElementHandle((List)input);
            if (notSame && group != null && group.isSameType()) {
                return null;
            }
            return ((List)input).get(0);
        }
        return input;
    }

    public static Object getInputElement(Object input, int index) {
        if (input instanceof GroupElementHandle) {
            return ((GroupElementHandle)input).getElements().get(index);
        }
        if (input instanceof List) {
            return ((List)input).get(index);
        }
        return input;
    }

    public static List<?> getInputElements(Object input) {
        if (input instanceof GroupElementHandle) {
            return ((GroupElementHandle)input).getElements();
        }
        if (input instanceof List) {
            return (List)input;
        }
        return Collections.EMPTY_LIST;
    }

    public static ComputedColumnHandle getInputBinding(ReportItemHandle input, String bindingName) {
        List<ComputedColumnHandle> elementsList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)input);
        if (elementsList != null && elementsList.size() > 0) {
            int i = 0;
            while (i < elementsList.size()) {
                if (elementsList.get(i).getName().equals(bindingName)) {
                    return elementsList.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean enableRowNum(Object parent) {
        if (parent instanceof ReportItemHandle) {
            if (((ReportItemHandle)parent).getDataBindingReference() != null) {
                return DEUtil.enableRowNum(((ReportItemHandle)parent).getDataBindingReference());
            }
            if (((ReportItemHandle)parent).getCube() != null) {
                return false;
            }
            if (((ReportItemHandle)parent).getDataSet() != null) {
                return true;
            }
        }
        return false;
    }

    public static String getAggregateOn(ComputedColumnHandle element) {
        List aggregateOnList = element.getAggregateOnList();
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        Iterator iterator = aggregateOnList.iterator();
        while (iterator.hasNext()) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append((String)iterator.next());
            ++i;
        }
        String value = buffer.toString();
        if (value.equals("")) {
            return null;
        }
        return value;
    }

    public static String getFlatHirarchyPathName(Object object) {
        if (!(object instanceof DesignElementHandle)) {
            return null;
        }
        DesignElementHandle handle = (DesignElementHandle)object;
        DesignElementHandle container = handle.getContainer();
        Object flatHirarchyName = DEUtil.getCombinatedName(handle);
        while (!(handle instanceof ReportDesignHandle) && container != null && !(container instanceof ReportDesignHandle)) {
            SlotHandle slotHandle = handle.getContainerSlotHandle();
            if (slotHandle != null && (container instanceof ListingHandle || container instanceof GroupHandle) && !(handle instanceof GroupHandle)) {
                flatHirarchyName = slotHandle.getDefn().getDisplayName() + (String)flatHirarchyName;
            }
            flatHirarchyName = DEUtil.getCombinatedName(container) + "." + (String)flatHirarchyName;
            handle = container;
            container = container.getContainer();
        }
        return flatHirarchyName;
    }

    private static String getCombinatedName(DesignElementHandle handle) {
        String elementName = handle.getDefn().getDisplayName();
        String displayName = handle.getQualifiedName() != null && !handle.getQualifiedName().equals(handle.getName()) ? handle.getQualifiedName() : handle.getName();
        if (!StringUtil.isBlank((String)displayName)) {
            return elementName + "(" + displayName + ")";
        }
        return elementName + "(" + handle.getID() + ")";
    }

    @Deprecated
    public static boolean isReferenceElement(DesignElementHandle handle) {
        return DEUtil.isLinkedElement(handle);
    }

    public static String getFilePathFormURL(URL url) throws Exception {
        if (url != null) {
            URL localURL = FileLocator.resolve((URL)url);
            if ("bundleresource".equals(url.getProtocol())) {
                return localURL.getPath();
            }
            if (localURL != null && "file".equals(localURL.getProtocol())) {
                return localURL.toURI().getSchemeSpecificPart();
            }
        }
        return null;
    }

    public static boolean isFixLayout(Object model) {
        if (!(model instanceof DesignElementHandle)) {
            return false;
        }
        ModuleHandle handle = ((DesignElementHandle)model).getModuleHandle();
        if (!(handle instanceof ReportDesignHandle)) {
            return false;
        }
        return "fixed layout".equals(((ReportDesignHandle)handle).getLayoutPreference());
    }

    public static Insets getPadding(DesignElementHandle handle, Insets retValue) {
        retValue = retValue == null ? new Insets() : new Insets(retValue);
        int fontSize = DEUtil.getFontSizeIntValue(handle);
        DimensionValue dimensionValue = (DimensionValue)handle.getProperty("paddingTop");
        double px = DEUtil.convertToPixel(dimensionValue, fontSize);
        dimensionValue = (DimensionValue)handle.getProperty("paddingBottom");
        double py = DEUtil.convertToPixel(dimensionValue, fontSize);
        retValue.top = (int)px;
        retValue.bottom = (int)py;
        dimensionValue = (DimensionValue)handle.getProperty("paddingLeft");
        px = DEUtil.convertToPixel(dimensionValue, fontSize);
        dimensionValue = (DimensionValue)handle.getProperty("paddingRight");
        py = DEUtil.convertToPixel(dimensionValue, fontSize);
        retValue.left = (int)px;
        retValue.right = (int)py;
        return retValue;
    }

    public static LibraryHandle getDefaultLibraryHandle() {
        String libraryFileName;
        URL url = FileLocator.find((Bundle)EclipseUtil.getBundle((String)"org.eclipse.birt.resources"), (IPath)new Path(DEFAULT_LIBRARY), null);
        if (url == null) {
            return null;
        }
        try {
            libraryFileName = FileLocator.resolve((URL)url).getPath();
        }
        catch (IOException e1) {
            return null;
        }
        File file = new File(libraryFileName);
        if (!file.exists()) {
            return null;
        }
        libraryFileName = file.getAbsolutePath();
        try {
            return SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(libraryFileName);
        }
        catch (DesignFileException e) {
            return null;
        }
    }

    public static void setDefaultTheme(DesignElementHandle elementHandle) {
        ReportDesignHandle designHandle;
        PropertyHandle propertyHandle;
        if (elementHandle instanceof ReportDesignHandle && DEUtil.hasDefaultLibrary(elementHandle.getModuleHandle()) && (propertyHandle = (designHandle = (ReportDesignHandle)elementHandle).getPropertyHandle("theme")).getValue() == null) {
            List list = propertyHandle.getReferenceableElementList();
            String preFileName = DEUtil.getDefultLibraryFileName();
            int i = 0;
            while (i < list.size()) {
                ThemeHandle itemHandle = (ThemeHandle)list.get(i);
                if (itemHandle.getQualifiedName().startsWith(preFileName)) {
                    try {
                        propertyHandle.setValue((Object)itemHandle.getQualifiedName());
                        break;
                    }
                    catch (SemanticException semanticException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    private static String getDefultLibraryFileName() {
        LibraryHandle defaulthandle = DEUtil.getDefaultLibraryHandle();
        if (defaulthandle == null) {
            return null;
        }
        String fileName = new File(defaulthandle.getFileName()).getAbsolutePath();
        int index = fileName.lastIndexOf(".");
        int start = fileName.lastIndexOf(File.separator);
        defaulthandle.close();
        return fileName.substring(start + 1, index);
    }

    private static boolean hasDefaultLibrary(ModuleHandle handle) {
        LibraryHandle defaulthandle = DEUtil.getDefaultLibraryHandle();
        if (defaulthandle == null) {
            return false;
        }
        String defaultFileName = defaulthandle.getFileName();
        List list = handle.getLibraries();
        int i = 0;
        while (i < list.size()) {
            LibraryHandle temp = (LibraryHandle)list.get(i);
            String fileName = null;
            try {
                fileName = FileLocator.resolve((URL)new URL(temp.getFileName())).getPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (fileName != null && new File(defaultFileName).getAbsolutePath().equals(new File(fileName).getAbsolutePath())) {
                defaulthandle.close();
                return true;
            }
            ++i;
        }
        defaulthandle.close();
        return false;
    }

    public static void resetAllStyleProperties(DesignElementHandle handle) throws SemanticException {
        if (handle == null) {
            return;
        }
        Field[] fields = IStyleModel.class.getFields();
        int i = 0;
        while (i < fields.length) {
            if ((fields[i].getModifiers() & 8) != 0 && (fields[i].getModifiers() & 0x10) != 0) {
                String propertyName = null;
                try {
                    propertyName = (String)fields[i].get(IStyleModel.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!"width".equals(propertyName) && !"height".equals(propertyName) && propertyName != null && handle.getPropertyDefn(propertyName) != null && handle.getProperty(propertyName) != null) {
                    handle.setProperty(propertyName, null);
                }
            }
            ++i;
        }
    }
}

