/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.MultipleSeriesComponent;
import org.eclipse.birt.chart.ui.swt.wizard.data.MultipleSeriesSelectorComponent;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.ITask;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class SelectDataDynamicArea
implements ISelectDataCustomizeUI {
    private ITask task = null;
    protected List<ISelectDataComponent> subLeftAreas = new ArrayList<ISelectDataComponent>();
    protected List<ISelectDataComponent> subRightAreas = new ArrayList<ISelectDataComponent>();
    protected Composite cmpLeftArea = null;
    protected Composite cmpRightArea = null;
    protected Composite cmpBottomArea = null;
    protected ISelectDataComponent bottomArea;
    private int[] seriesIndex = new int[0];

    public SelectDataDynamicArea(ITask task) {
        this.task = task;
    }

    protected ChartWizardContext getContext() {
        return (ChartWizardContext)this.task.getContext();
    }

    protected Chart getChartModel() {
        return this.getContext().getModel();
    }

    public void selectLeftBindingArea(boolean selected, Object data) {
        int i = 0;
        while (i < this.subLeftAreas.size()) {
            this.subLeftAreas.get(i).selectArea(selected, data);
            ++i;
        }
    }

    public void selectRightBindingArea(boolean selected, Object data) {
        int i = 0;
        while (i < this.subRightAreas.size()) {
            this.subRightAreas.get(i).selectArea(selected, data);
            ++i;
        }
    }

    public void selectBottomBindingArea(boolean selected, Object data) {
        this.bottomArea.selectArea(selected, data);
    }

    public void dispose() {
        List<ISelectDataComponent> list = this.subLeftAreas;
        list.addAll(this.subRightAreas);
        int i = 0;
        while (i < list.size()) {
            list.get(i).dispose();
            ++i;
        }
        if (this.bottomArea != null) {
            this.bottomArea.dispose();
        }
        list.clear();
    }

    public ISelectDataComponent getAreaComponent(int areaType, SeriesDefinition seriesdefinition, ChartWizardContext context, String sTitle) {
        return ChartUIUtil.getSeriesUIProvider((Series)seriesdefinition.getDesignTimeSeries()).getSeriesDataComponent(areaType, seriesdefinition, context, sTitle);
    }

    public void refreshLeftBindingArea() {
        this.subLeftAreas.clear();
        Composite cmpContainer = this.cmpLeftArea.getParent();
        this.cmpLeftArea.dispose();
        this.createLeftBindingArea(cmpContainer);
        cmpContainer.layout();
    }

    public void refreshRightBindingArea() {
        this.subRightAreas.clear();
        Composite cmpContainer = this.cmpRightArea.getParent();
        this.cmpRightArea.dispose();
        this.createRightBindingArea(cmpContainer);
        cmpContainer.layout();
    }

    public void refreshBottomBindingArea() {
        Composite cmpContainer = this.cmpBottomArea.getParent();
        this.cmpBottomArea.dispose();
        this.createBottomBindingArea(cmpContainer);
        cmpContainer.layout();
    }

    protected MultipleSeriesSelectorComponent createMultipleSeriesSelectorComponent(EList<SeriesDefinition>[] seriesDefnsArray, ChartWizardContext wizardContext, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        return new MultipleSeriesSelectorComponent(seriesDefnsArray, this.getContext(), "", this);
    }

    public void createLeftBindingArea(Composite parent) {
        this.cmpLeftArea = ChartUIUtil.createCompositeWrapper((Composite)parent);
        GridData gd = new GridData(772);
        gd.minimumWidth = 100;
        this.cmpLeftArea.setLayoutData((Object)gd);
        if (this.getChartModel() instanceof ChartWithAxes) {
            int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChartModel());
            EList[] seriesDefnArray = new EList[axisNum];
            EList<Axis> axisList = this.getYAxisListForProcessing();
            if (axisList != null && !axisList.isEmpty()) {
                int i = 0;
                while (i < axisList.size()) {
                    seriesDefnArray[i] = ((Axis)axisList.get(i)).getSeriesDefinitions();
                    ++i;
                }
            }
            MultipleSeriesSelectorComponent component = this.createMultipleSeriesSelectorComponent(seriesDefnArray, this.getContext(), "", this);
            this.subLeftAreas.add((ISelectDataComponent)component);
            component.createArea(this.cmpLeftArea);
        } else {
            MultipleSeriesSelectorComponent component = this.createMultipleSeriesSelectorComponent(new EList[]{this.getValueSeriesDefinitionForProcessing()}, this.getContext(), "", this);
            component.createArea(this.cmpLeftArea);
            this.subLeftAreas.add((ISelectDataComponent)component);
        }
    }

    public void createRightBindingArea(Composite parent) {
        this.cmpRightArea = ChartUIUtil.createCompositeWrapper((Composite)parent);
        this.cmpRightArea.setLayoutData((Object)new GridData(772));
        if (this.getChartModel() instanceof ChartWithAxes) {
            int axisNum = ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChartModel());
            EList[] seriesDefnArray = new EList[axisNum];
            EList<Axis> axisList = this.getYAxisListForProcessing();
            if (axisList != null && !axisList.isEmpty()) {
                int i = 0;
                while (i < axisList.size()) {
                    seriesDefnArray[i] = ((Axis)axisList.get(i)).getSeriesDefinitions();
                    ++i;
                }
            }
            MultipleSeriesComponent component = new MultipleSeriesComponent(seriesDefnArray, this.getContext(), Messages.getString("AbstractSelectDataCustomizeUI.Label.SeriesGrouping"), (ISelectDataCustomizeUI)this);
            this.subRightAreas.add((ISelectDataComponent)component);
            component.createArea(this.cmpRightArea);
        } else {
            MultipleSeriesComponent component = new MultipleSeriesComponent(this.getValueSeriesDefinitionForProcessing(), this.getContext(), Messages.getString("AbstractSelectDataCustomizeUI.Label.SeriesGrouping"), (ISelectDataCustomizeUI)this);
            this.subRightAreas.add((ISelectDataComponent)component);
            component.createArea(this.cmpRightArea);
        }
    }

    private EList<Axis> getYAxisListForProcessing() {
        return ((Axis)((ChartWithAxes)this.getChartModel()).getAxes().get(0)).getAssociatedAxes();
    }

    public void createBottomBindingArea(Composite parent) {
        this.bottomArea = this.getContext().getChartType().getBaseUI(this.getChartModel(), (ISelectDataCustomizeUI)this, this.getContext(), "");
        this.cmpBottomArea = this.bottomArea.createArea(parent);
    }

    private SeriesDefinition getBaseSeriesDefinitionForProcessing() {
        return (SeriesDefinition)((ChartWithoutAxes)this.getChartModel()).getSeriesDefinitions().get(0);
    }

    private EList<SeriesDefinition> getValueSeriesDefinitionForProcessing() {
        return this.getBaseSeriesDefinitionForProcessing().getSeriesDefinitions();
    }

    public void layoutAll() {
        if (this.cmpBottomArea != null && !this.cmpBottomArea.isDisposed()) {
            this.cmpBottomArea.getParent().getParent().layout();
        }
    }

    public int[] getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSeriesIndex(int[] seriesIndex) {
        this.seriesIndex = seriesIndex;
    }

    public void init() {
        this.seriesIndex = new int[ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChartModel())];
    }

    public void notifyChange(Notification notification) {
    }
}

