/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.ModelUtil;

public class StyleUtil {
    public static DesignElementHandle copyStyles(DesignElementHandle source, DesignElementHandle target, boolean isCascaded) {
        return StyleUtil.copyStyleProperties(source, target, isCascaded, false);
    }

    public static DesignElementHandle copyStyles(DesignElementHandle source, DesignElementHandle target) {
        return StyleUtil.copyStyleProperties(source, target, false, false);
    }

    public static DesignElementHandle copyLocalStyles(DesignElementHandle source, DesignElementHandle target) {
        return StyleUtil.copyStyleProperties(source, target, false, true);
    }

    private static DesignElementHandle copyStyleProperties(DesignElementHandle source, DesignElementHandle target, boolean isCascaded, boolean isLocal) {
        if (source == null) {
            return null;
        }
        IElementDefn elementDefn = source.getDefn();
        if (target == null) {
            target = source.getElementFactory().newElement(elementDefn.getName(), null);
        }
        if (target.getDefn() != elementDefn || source == target || !elementDefn.hasStyle()) {
            return target;
        }
        DesignElement copiedElement = target.getElement();
        DesignElement sourceElement = source.getElement();
        Module module = source.getModule();
        ElementPropertyDefn propDefn = sourceElement.getPropertyDefn("style");
        copiedElement.setProperty(propDefn, sourceElement.getProperty(module, propDefn));
        IElementDefn styleDefn = MetaDataDictionary.getInstance().getStyle();
        List<IElementPropertyDefn> styleProps = styleDefn.getProperties();
        int i = 0;
        while (i < styleProps.size()) {
            propDefn = (ElementPropertyDefn)styleProps.get(i);
            if (propDefn.isStyleProperty()) {
                ElementPropertyDefn sourcePropDefn = sourceElement.getPropertyDefn(propDefn.getName());
                ElementPropertyDefn targetPropDefn = copiedElement.getPropertyDefn(propDefn.getName());
                if (sourcePropDefn != null && targetPropDefn != null) {
                    Object value = null;
                    value = isLocal ? sourceElement.getLocalProperty(module, sourcePropDefn) : (isCascaded ? sourceElement.getProperty(module, sourcePropDefn) : sourceElement.getFactoryProperty(module, sourcePropDefn));
                    if (value != null) {
                        boolean needCopy = false;
                        if (value instanceof IStructure) {
                            needCopy = true;
                        } else if (value instanceof List) {
                            needCopy = !((List)value).isEmpty();
                            for (Object item : (List)value) {
                                if (item instanceof Structure) continue;
                                needCopy = false;
                                break;
                            }
                        }
                        if (needCopy) {
                            value = ModelUtil.copyValue(targetPropDefn, value);
                        }
                        copiedElement.setProperty(targetPropDefn, value);
                    }
                }
            }
            ++i;
        }
        return target;
    }

    public static void addExtensionSelectors(ReportDesignHandle designHandle) {
        if (designHandle == null) {
            return;
        }
        DesignSessionImpl.addExtensionDefaultStyles((ReportDesign)designHandle.getModule(), true);
    }

    private static boolean hasExternalCSSURI(Iterator<IncludedCssStyleSheetHandle> iter) {
        while (iter != null && iter.hasNext()) {
            IncludedCssStyleSheetHandle includedCssStyleSheet = iter.next();
            String externalCSSURI = includedCssStyleSheet.getExternalCssURI();
            boolean useExternalCSS = includedCssStyleSheet.isUseExternalCss();
            if (externalCSSURI == null && !useExternalCSS) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExternalCSSURI(Module module) {
        ReportDesignHandle handle;
        Iterator iter;
        if (module instanceof ReportDesign && StyleUtil.hasExternalCSSURI(iter = (handle = (ReportDesignHandle)module.getHandle(module)).includeCssesIterator())) {
            return true;
        }
        Theme theme = module.getTheme();
        if (theme != null) {
            ThemeHandle themeHandle = (ThemeHandle)theme.getHandle(module);
            Iterator iter2 = themeHandle.includeCssesIterator();
            return StyleUtil.hasExternalCSSURI(iter2);
        }
        return false;
    }
}

