/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.views.provider;

import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.dialogs.NewSectionDialog;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.EditpartExtensionManager;
import org.eclipse.birt.report.designer.internal.ui.extension.experimental.PaletteEntryExtension;
import org.eclipse.birt.report.designer.internal.ui.processor.ElementProcessorFactory;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.DeleteAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.PasteAction;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.CopyCrosstabCellContentsAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.internal.ui.views.provider.CrosstabPropertyHandleWrapper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.gef.Request;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class CrossTabCellNodeProvider
extends DefaultNodeProvider {
    public Object[] getChildren(Object model) {
        ExtendedItemHandle element = (ExtendedItemHandle)model;
        try {
            CrosstabCellHandle cell = (CrosstabCellHandle)element.getReportItem();
            if (cell != null) {
                return cell.getContents().toArray();
            }
        }
        catch (ExtendedElementException extendedElementException) {
            // empty catch block
        }
        return new Object[0];
    }

    public Object getParent(Object model) {
        ExtendedItemHandle element = (ExtendedItemHandle)model;
        try {
            CrosstabCellHandle cell = (CrosstabCellHandle)element.getReportItem();
            if (cell.getContainer() != null) {
                if (cell.getContainer() instanceof MeasureViewHandle) {
                    MeasureViewHandle measure = (MeasureViewHandle)cell.getContainer();
                    PropertyHandle property = cell.getModelHandle().getContainerPropertyHandle();
                    return new CrosstabPropertyHandleWrapper(measure.getModelHandle().getPropertyHandle(property.getPropertyDefn().getName()));
                }
                if (cell.getContainer() instanceof LevelViewHandle || cell.getContainer() instanceof CrosstabViewHandle || cell.getContainer() instanceof CrosstabReportItemHandle) {
                    return cell.getContainer().getModelHandle();
                }
            }
        }
        catch (ExtendedElementException extendedElementException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasChildren(Object model) {
        return this.getChildren(model).length != 0;
    }

    public String getNodeDisplayName(Object model) {
        return Messages.getString("CrossTabCellNodeProvider.Cell");
    }

    public Image getNodeIcon(Object element) {
        if (element instanceof DesignElementHandle && ((DesignElementHandle)element).getSemanticErrors().size() > 0) {
            return ReportPlatformUIImages.getImage((String)"IMG_OBJS_ERROR_TSK");
        }
        return CrosstabUIHelper.getImage("icons/pal/cell.gif");
    }

    public boolean performRequest(Object model, Request request) throws Exception {
        if (request.getType().equals("insert")) {
            Map extendsData = request.getExtendedData();
            PropertyHandle propertyHandle = (PropertyHandle)extendsData.get("insert-property");
            String type = (String)extendsData.get("insert-type");
            String position = (String)extendsData.get("insert-position");
            return this.performInsert(model, propertyHandle, type, position, extendsData);
        }
        return super.performRequest(model, request);
    }

    protected boolean performInsert(Object model, PropertyHandle propertyHandle, String type, String position, Map extendData) throws Exception {
        if (type == null) {
            List supportList;
            if (propertyHandle == null) {
                DesignElementHandle handle = ((CrosstabCellHandle)((ExtendedItemHandle)model).getReportItem()).getModelHandle();
                propertyHandle = ((ExtendedItemHandle)model).getPropertyHandle(DEUtil.getDefaultContentName((Object)handle));
            }
            if ((supportList = UIUtil.getUIElementSupportList((PropertyHandle)propertyHandle)).size() == 0) {
                ExceptionUtil.openMessage((String)WARNING_DIALOG_TITLE, (String)WARNING_DIALOG_MESSAGE_EMPTY_LIST, (int)8);
                return false;
            }
            if (supportList.size() == 1) {
                type = ((IElementDefn)supportList.get(0)).getName();
            } else {
                NewSectionDialog dialog = new NewSectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), supportList);
                if (dialog.open() == 1) {
                    return false;
                }
                type = (String)dialog.getResult()[0];
            }
        }
        PaletteEntryExtension[] entries = EditpartExtensionManager.getPaletteEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getItemName().equals(type)) {
                extendData.put("result", entries[i].executeCreate());
                return true;
            }
            ++i;
        }
        DesignElementHandle elementHandle = this.createElement(type);
        if (extendData != null) {
            extendData.put("result", elementHandle);
        }
        if (elementHandle == null) {
            return false;
        }
        int pos = DNDUtil.calculateNextPosition((Object)model, (int)DNDUtil.handleValidateTargetCanContain((Object)model, (Object)elementHandle, (boolean)true));
        if (pos > 0 && position.equals("above")) {
            --pos;
        }
        if (pos == -1) {
            propertyHandle.add(elementHandle);
        } else {
            propertyHandle.add(elementHandle, pos);
        }
        if (elementHandle instanceof ExtendedItemHandle && ElementProcessorFactory.createProcessor((DesignElementHandle)elementHandle) != null && !ElementProcessorFactory.createProcessor((DesignElementHandle)elementHandle).editElement(elementHandle)) {
            return false;
        }
        DEUtil.setDefaultTheme((DesignElementHandle)elementHandle);
        return true;
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        menu.add((IAction)new InsertAction(object));
        menu.add((IAction)new CopyCrosstabCellContentsAction(object));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IAction)new DeleteAction(object));
        menu.add((IAction)new PasteAction(object));
    }
}

