/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.io.EOFException;
import java.io.IOException;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.RAInputStream;

public class ByteArrayRAInputStream
extends RAInputStream {
    byte[] buffer;
    int offset;

    public ByteArrayRAInputStream(byte[] buffer) {
        this.buffer = buffer;
    }

    public int available() throws IOException {
        return this.buffer.length - this.offset;
    }

    public long getOffset() throws IOException {
        return this.offset;
    }

    public long length() throws IOException {
        return this.buffer.length;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        if (len + this.offset > this.buffer.length) {
            throw new EOFException();
        }
        System.arraycopy(this.buffer, this.offset, b, off, len);
        this.offset += len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.offset > this.buffer.length) {
            return -1;
        }
        if (len + this.offset > this.buffer.length) {
            len = this.buffer.length - this.offset;
        }
        System.arraycopy(this.buffer, this.offset, b, off, len);
        this.offset += len;
        return len;
    }

    public int readInt() throws IOException {
        if (this.offset + 4 > this.buffer.length) {
            throw new EOFException();
        }
        int v = ArchiveUtil.bytesToInteger((byte[])this.buffer, (int)this.offset);
        this.offset += 4;
        return v;
    }

    public long readLong() throws IOException {
        if (this.offset + 8 > this.buffer.length) {
            throw new EOFException();
        }
        long v = ArchiveUtil.bytesToLong((byte[])this.buffer, (int)this.offset);
        this.offset += 8;
        return v;
    }

    public void refresh() throws IOException {
    }

    public void seek(long localPos) throws IOException {
        if (localPos > (long)this.buffer.length) {
            throw new EOFException();
        }
        this.offset = (int)localPos;
    }

    public int read() throws IOException {
        if (this.offset < this.buffer.length) {
            return this.buffer[this.offset++] & 0xFF;
        }
        return -1;
    }
}

