/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutTest;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.LineArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;

public class PDFLineAreaLMTest
extends PDFLayoutTest {
    public void testMutipleLineBreakHeight() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/pdf/168804.xml";
        IReportRunnable report = this.openReportDesign(designFile);
        List pageAreas = this.getPageAreas(report);
        PDFLineAreaLMTest.assertEquals((int)1, (int)pageAreas.size());
        PageArea pageArea = (PageArea)pageAreas.get(0);
        Iterator logicContainers = pageArea.getBody().getChildren();
        IContainerArea blockContainer = (IContainerArea)logicContainers.next();
        PDFLineAreaLMTest.assertTrue((String)"3 lines", (blockContainer.getChildrenCount() == 3 ? 1 : 0) != 0);
        PDFLineAreaLMTest.assertTrue((String)"Line height is right", (blockContainer.getHeight() >= 27000 ? 1 : 0) != 0);
    }

    public void estForeignContent() throws EngineException {
        String designFile = "org/eclipse/birt/report/engine/layout/pdf/LineAreaLMTest-157189.xml";
        IReportRunnable report = this.openReportDesign(designFile);
        List pageAreas = this.getPageAreas(report);
        PDFLineAreaLMTest.assertEquals((int)2, (int)pageAreas.size());
        PageArea pageArea = (PageArea)pageAreas.get(1);
        Iterator logicContainers = pageArea.getBody().getChildren();
        IContainerArea blockContains = (IContainerArea)logicContainers.next();
        logicContainers = blockContains.getChildren();
        IContainerArea blockContains1 = (IContainerArea)logicContainers.next();
        Iterator lineAreas = blockContains1.getChildren();
        lineAreas.next();
        LineArea emptyLine = (LineArea)lineAreas.next();
        PDFLineAreaLMTest.assertTrue((String)"Second line is not an empty line.", (boolean)this.isEmpty((ContainerArea)emptyLine));
        LineArea lineArea = (LineArea)lineAreas.next();
        PDFLineAreaLMTest.assertEquals((String)" ", (String)this.getText(lineArea, 2));
        PDFLineAreaLMTest.assertEquals((String)"paragraph 22.", (String)this.getText(lineArea, 5));
    }
}

