/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.ListValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.layout.pdf.util.HTMLConstants;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertiesProcessor;
import org.eclipse.birt.report.engine.layout.pdf.util.StyleProperties;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public abstract class Tag2Style
implements HTMLConstants {
    private static Map<String, Tag2Style> tag2Style = new HashMap<String, Tag2Style>();

    static {
        tag2Style.put("i", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setFontStyle(sp.getStyle(), CSSValueConstants.ITALIC_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("font", new Tag2Style(){
            String[] properties = new String[]{"color", "face", "size"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setInlineDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("b", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setFontWeight(sp.getStyle(), CSSValueConstants.BOLD_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("a", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("code", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setFontFamily(sp.getStyle(), CSSValueConstants.MONOSPACE_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("em", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setFontStyle(sp.getStyle(), CSSValueConstants.ITALIC_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("object", new Tag2Style(){
            String[] properties = new String[]{"align", "width", "height", "border"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setInlineDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("img", new Tag2Style(){
            String[] properties = new String[]{"align", "width", "height", "border", "alt", "src"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setInlineDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("ins", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setProperty(sp.getStyle(), 60, CSSValueConstants.UNDERLINE_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("span", new Tag2Style(){
            String[] properties = new String[]{"align"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setInlineDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("strong", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setFontWeight(sp.getStyle(), CSSValueConstants.BOLD_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("sub", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setProperty(sp.getStyle(), 43, CSSValueConstants.BOTTOM_VALUE);
                this.setProperty(sp.getStyle(), 54, 12.createPercentageValue(75.0f));
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("sup", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setProperty(sp.getStyle(), 43, CSSValueConstants.TOP_VALUE);
                this.setProperty(sp.getStyle(), 54, 13.createPercentageValue(75.0f));
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("tt", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setFontFamily(sp.getStyle(), CSSValueConstants.MONOSPACE_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("u", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setProperty(sp.getStyle(), 60, CSSValueConstants.UNDERLINE_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("del", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setProperty(sp.getStyle(), 32, CSSValueConstants.LINE_THROUGH_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("strike", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setProperty(sp.getStyle(), 32, CSSValueConstants.LINE_THROUGH_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("s", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setProperty(sp.getStyle(), 32, CSSValueConstants.LINE_THROUGH_VALUE);
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("big", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setProperty(sp.getStyle(), 54, 19.createPercentageValue(200.0f));
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("small", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setProperty(sp.getStyle(), 54, 20.createPercentageValue(50.0f));
                this.setInlineDisplay(sp.getStyle());
            }
        });
        tag2Style.put("dd", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
            }
        });
        tag2Style.put("div", new Tag2Style(){
            String[] properties = new String[]{"align"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("dl", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setMarginTopAndBottom(sp.getStyle(), 1.0f);
                this.setBlockDisplay(sp.getStyle());
            }
        });
        tag2Style.put("dt", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
            }
        });
        tag2Style.put("h1", new Tag2Style(){
            String[] properties = new String[]{"align"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setHStyle(sp.getStyle(), 2.0f, 0.67f);
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("h2", new Tag2Style(){
            String[] properties = new String[]{"align"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setHStyle(sp.getStyle(), 1.5f, 0.75f);
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("h3", new Tag2Style(){
            String[] properties = new String[]{"align"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setHStyle(sp.getStyle(), 1.17f, 0.83f);
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("h4", new Tag2Style(){
            String[] properties = new String[]{"align"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setHStyle(sp.getStyle(), 1.12f, 1.12f);
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("h5", new Tag2Style(){
            String[] properties = new String[]{"align"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setHStyle(sp.getStyle(), 0.83f, 1.5f);
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("h6", new Tag2Style(){
            String[] properties = new String[]{"align"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setHStyle(sp.getStyle(), 0.75f, 1.67f);
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("hr", new Tag2Style(){
            String[] properties = new String[]{"width"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("ol", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
            }
        });
        tag2Style.put("p", new Tag2Style(){
            String[] properties = new String[]{"align"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setMarginTopAndBottom(sp.getStyle(), 1.33f);
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("pre", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setFontFamily(sp.getStyle(), CSSValueConstants.MONOSPACE_VALUE);
                this.setBlockDisplay(sp.getStyle());
            }
        });
        tag2Style.put("ul", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
            }
        });
        tag2Style.put("li", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
            }
        });
        tag2Style.put("address", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setFontStyle(sp.getStyle(), CSSValueConstants.ITALIC_VALUE);
                this.setBlockDisplay(sp.getStyle());
            }
        });
        tag2Style.put("body", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
            }
        });
        tag2Style.put("center", new Tag2Style(){

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setProperty(sp.getStyle(), 37, CSSValueConstants.CENTER_VALUE);
                this.setBlockDisplay(sp.getStyle());
            }
        });
        tag2Style.put("table", new Tag2Style(){
            String[] properties = new String[]{"width", "bgcolor", "cellpadding", "border"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("td", new Tag2Style(){
            String[] properties = new String[]{"rowspan", "colspan", "bgcolor", "align", "valign"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("col", new Tag2Style(){
            String[] properties = new String[]{"width"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
        tag2Style.put("tr", new Tag2Style(){
            String[] properties = new String[]{"bgcolor", "align", "valign"};

            @Override
            public void process(Element ele, StyleProperties sp) {
                this.setBlockDisplay(sp.getStyle());
                PropertiesProcessor.process(this.properties, ele, sp);
            }
        });
    }

    abstract void process(Element var1, StyleProperties var2);

    protected void setProperty(IStyle style, int index, CSSValue value) {
        CSSValue v = style.getProperty(index);
        if (v == null) {
            style.setProperty(index, value);
        }
    }

    protected void setHStyle(IStyle style, float fontSize, float margin) {
        this.setMarginTopAndBottom(style, margin);
        this.setProperty(style, 54, Tag2Style.createEmValue(fontSize));
        this.setProperty(style, 47, CSSValueConstants.BOLD_VALUE);
        this.setProperty(style, 67, CSSValueConstants.AVOID_VALUE);
    }

    protected void setMarginTopAndBottom(IStyle style, float margin) {
        this.setProperty(style, 6, Tag2Style.createEmValue(margin));
        this.setProperty(style, 2, Tag2Style.createEmValue(margin));
    }

    protected void setFontFamily(IStyle style, Value font) {
        ListValue fonts = new ListValue();
        fonts.append(font);
        this.setProperty(style, 69, fonts);
    }

    protected void setFontStyle(IStyle style, Value fontStyle) {
        this.setProperty(style, 55, fontStyle);
    }

    protected void setFontWeight(IStyle style, Value fontWeight) {
        this.setProperty(style, 47, fontWeight);
    }

    protected void setInlineDisplay(IStyle style) {
        this.setProperty(style, 63, CSSValueConstants.INLINE_VALUE);
    }

    protected void setBlockDisplay(IStyle style) {
        this.setProperty(style, 63, CSSValueConstants.BLOCK_VALUE);
    }

    protected void processProperites(String[] properties, Element ele, StyleProperties sp) {
        PropertiesProcessor.process(properties, ele, sp);
    }

    public static Tag2Style getStyleProcess(String tagName) {
        return tag2Style.get(tagName);
    }

    public static FloatValue createEmValue(float value) {
        return Tag2Style.createFloatValue((short)3, value);
    }

    public static FloatValue createPercentageValue(float value) {
        return Tag2Style.createFloatValue((short)2, value);
    }

    private static FloatValue createFloatValue(short unitType, float value) {
        return new FloatValue(unitType, value);
    }
}

