/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.emitter;

import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.PageArea;
import org.eclipse.birt.report.engine.layout.pdf.emitter.ContainerLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.InlineStackingLayout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.Layout;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutContextFactory;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.RepeatableLayout;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;

public class PDFLayoutEmitter
extends LayoutEmitterAdapter
implements IContentEmitter {
    IContentEmitter emitter;
    Stack layoutStack = new Stack();
    ContainerLayout current;
    LayoutContextFactory factory;
    LayoutEngineContext context;
    protected boolean isFirst = true;
    protected ILayoutPageHandler pageHandler;

    public PDFLayoutEmitter(IReportExecutor executor, IContentEmitter emitter, LayoutEngineContext context) {
        this.emitter = emitter;
        this.context = context;
        this.factory = new LayoutContextFactory(executor, context);
    }

    public PDFLayoutEmitter(LayoutEngineContext context) {
        this.context = context;
        this.factory = new LayoutContextFactory(null, context);
    }

    @Override
    public void initialize(IEmitterServices service) throws BirtException {
        this.emitter.initialize(service);
    }

    @Override
    public String getOutputFormat() {
        return this.emitter.getOutputFormat();
    }

    @Override
    public void start(IReportContent report) throws BirtException {
        this.emitter.start(report);
        this.context.setReport(report);
    }

    @Override
    public void end(IReportContent report) throws BirtException {
        this.resolveTotalPage(this.emitter);
        if (this.pageHandler != null) {
            this.pageHandler.onPage(this.context.pageNumber, this.context);
        }
        this.emitter.end(report);
    }

    @Override
    public ILayoutPageHandler getPageHandler() {
        return this.pageHandler;
    }

    @Override
    public void setPageHandler(ILayoutPageHandler pageHandler) {
        this.pageHandler = pageHandler;
    }

    protected void resolveTotalPage(IContentEmitter emitter) throws BirtException {
        IContent con = this.context.getUnresolvedContent();
        if (!(con instanceof IAutoTextContent)) {
            return;
        }
        IAutoTextContent totalPageContent = (IAutoTextContent)con;
        if (totalPageContent != null) {
            int spacing;
            String align;
            boolean isRightAligned;
            DataFormatValue format = totalPageContent.getComputedStyle().getDataFormat();
            NumberFormatter nf = null;
            if (format == null) {
                nf = new NumberFormatter();
            } else {
                String pattern = format.getNumberPattern();
                String locale = format.getNumberLocale();
                nf = locale == null ? new NumberFormatter(pattern) : new NumberFormatter(pattern, new ULocale(locale));
            }
            long totalPageCount = 0L;
            totalPageCount = this.context.autoPageBreak ? this.context.pageCount : (this.context.totalPage > 0L ? this.context.totalPage : this.context.pageCount);
            totalPageContent.setText(nf.format(totalPageCount));
            AbstractArea totalPageArea = null;
            ChunkGenerator cg = new ChunkGenerator(this.context.getFontManager(), totalPageContent, true, true);
            if (cg.hasMore()) {
                Chunk c = cg.getNext();
                Dimension d = new Dimension((int)(c.getFontInfo().getWordWidth(c.getText()) * 1000.0f), (int)(c.getFontInfo().getWordHeight() * 1000.0f));
                totalPageArea = (AbstractArea)AreaFactory.createTextArea((ITextContent)totalPageContent, c.getFontInfo(), false);
                totalPageArea.setWidth(Math.min(this.context.getMaxWidth(), d.getWidth()));
                totalPageArea.setHeight(Math.min(this.context.getMaxHeight(), d.getHeight()));
            }
            if (((isRightAligned = BidiAlignmentResolver.isRightAligned((IContent)totalPageContent, align = totalPageContent.getComputedStyle().getTextAlign(), false)) || "center".equalsIgnoreCase(align)) && (spacing = this.context.getTotalPageTemplateWidth() - totalPageArea.getWidth()) > 0) {
                if (isRightAligned) {
                    totalPageArea.setAllocatedPosition(spacing + totalPageArea.getAllocatedX(), totalPageArea.getAllocatedY());
                } else if ("center".equalsIgnoreCase(align)) {
                    totalPageArea.setAllocatedPosition(spacing / 2 + totalPageArea.getAllocatedX(), totalPageArea.getAllocatedY());
                }
            }
            totalPageContent.setExtension(1, totalPageArea);
            emitter.startAutoText(totalPageContent);
        }
    }

    @Override
    public void startContainer(IContainerContent container) throws BirtException {
        this._startContainer(container);
    }

    public void _startContainer(IContent container) throws BirtException {
        Layout layout;
        boolean isInline = PropertyUtil.isInlineElement(container);
        if (isInline) {
            if (!(this.current instanceof InlineStackingLayout)) {
                Layout lineLayout = this.factory.createLayoutManager(this.current, null);
                lineLayout.initialize();
                this.current = (ContainerLayout)lineLayout;
            }
        } else if (this.current instanceof InlineStackingLayout) {
            while (this.current instanceof InlineStackingLayout) {
                this.current.closeLayout();
                this.current = this.current.getParent();
            }
        }
        if ((layout = this.factory.createLayoutManager(this.current, container)) != null) {
            this.current = (ContainerLayout)layout;
            layout.initialize();
        }
    }

    @Override
    public void endContainer(IContainerContent container) throws BirtException {
        this._endContainer(container);
    }

    private void _endContainer(IContent container) throws BirtException {
        boolean isInline = PropertyUtil.isInlineElement(container);
        if (!isInline) {
            while (this.current instanceof InlineStackingLayout) {
                this.current.closeLayout();
                this.current = this.current.getParent();
            }
        }
        this.current.closeLayout();
        this.current = this.current.getParent();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startContent(IContent content) throws BirtException {
        block5: {
            isInline = PropertyUtil.isInlineElement(content);
            if (!isInline) ** GOTO lbl10
            if (this.current instanceof InlineStackingLayout) break block5;
            lineLayout = (ContainerLayout)this.factory.createLayoutManager(this.current, null);
            lineLayout.initialize();
            this.current = lineLayout;
            break block5;
lbl-1000:
            // 1 sources

            {
                this.current.closeLayout();
                this.current = this.current.getParent();
lbl10:
                // 2 sources

                ** while (this.current instanceof InlineStackingLayout)
            }
        }
        if ((layout = this.factory.createLayoutManager(this.current, content)) != null) {
            layout.initialize();
            layout.layout();
            layout.closeLayout();
        }
    }

    @Override
    public void endContent(IContent content) {
    }

    @Override
    public void startListBand(IListBandContent listBand) {
        if (this.current instanceof RepeatableLayout) {
            ((RepeatableLayout)this.current).bandStatus = listBand.getBandType();
        }
    }

    @Override
    public void startListGroup(IListGroupContent listGroup) throws BirtException {
        if (this.current instanceof RepeatableLayout) {
            ((RepeatableLayout)this.current).bandStatus = 0;
        }
        super.startListGroup(listGroup);
    }

    @Override
    public void endListBand(IListBandContent listBand) {
    }

    @Override
    public void startPage(IPageContent page) throws BirtException {
        long number;
        if (!this.context.autoPageBreak && (number = page.getPageNumber()) > 0L) {
            this.context.pageNumber = number;
        }
        super.startPage(page);
    }

    boolean showPageFooter(SimpleMasterPageDesign masterPage, IPageContent page) {
        boolean showFooter = true;
        if (!masterPage.isShowFooterOnLast() && page.getPageNumber() == this.context.totalPage) {
            showFooter = false;
        }
        return showFooter;
    }

    @Override
    public void outputPage(IPageContent page) throws BirtException {
        Object obj;
        MasterPageDesign mp = (MasterPageDesign)page.getGenerateBy();
        if (mp instanceof SimpleMasterPageDesign && (obj = page.getExtension(1)) instanceof PageArea) {
            PageArea pageArea = (PageArea)obj;
            if (this.isFirst && !((SimpleMasterPageDesign)mp).isShowHeaderOnFirst()) {
                pageArea.removeHeader();
                this.isFirst = false;
            }
            if (!this.showPageFooter((SimpleMasterPageDesign)mp, page)) {
                pageArea.removeFooter();
            }
            if (((SimpleMasterPageDesign)mp).isFloatingFooter()) {
                ContainerArea footer = (ContainerArea)((Object)page.getFooter());
                IContainerArea body = pageArea.getBody();
                IContainerArea header = pageArea.getHeader();
                if (footer != null) {
                    footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
                }
            }
        }
        this.emitter.startPage(page);
        this.emitter.endPage(page);
        ++this.context.pageCount;
    }

    protected void startTableContainer(IContainerContent container) throws BirtException {
        ContainerLayout layout;
        this.current = layout = (ContainerLayout)this.factory.createLayoutManager(this.current, container);
        this.current.initialize();
    }

    protected void endTableContainer(IContainerContent container) throws BirtException {
        this.current.closeLayout();
        this.current = this.current.getParent();
    }

    @Override
    public void startRow(IRowContent row) throws BirtException {
        this.startTableContainer(row);
    }

    @Override
    public void endRow(IRowContent row) throws BirtException {
        this.endTableContainer(row);
    }

    @Override
    public void startTableBand(ITableBandContent band) throws BirtException {
        if (this.current instanceof RepeatableLayout) {
            ((RepeatableLayout)this.current).bandStatus = band.getBandType();
        }
        this.startTableContainer(band);
    }

    @Override
    public void startTableGroup(ITableGroupContent group) throws BirtException {
        if (this.current instanceof RepeatableLayout) {
            ((RepeatableLayout)this.current).bandStatus = 0;
        }
        this.startTableContainer(group);
    }

    @Override
    public void endTableBand(ITableBandContent band) throws BirtException {
        this.endTableContainer(band);
    }

    @Override
    public void endTableGroup(ITableGroupContent group) throws BirtException {
        this.endTableContainer(group);
    }

    @Override
    public void startCell(ICellContent cell) throws BirtException {
        this.startTableContainer(cell);
    }

    @Override
    public void endCell(ICellContent cell) throws BirtException {
        this.endContainer(cell);
    }

    protected void visitContent(IContent content, IContentEmitter emitter) throws BirtException {
        ContentEmitterUtil.startContent(content, emitter);
        Collection<IContent> children = content.getChildren();
        if (children != null && !children.isEmpty()) {
            for (IContent child : children) {
                this.visitContent(child, emitter);
            }
        }
        ContentEmitterUtil.endContent(content, emitter);
    }

    @Override
    public void startForeign(IForeignContent foreign) throws BirtException {
        if ("text/html".equals(foreign.getRawType())) {
            this._startContainer(foreign);
            HTML2Content.html2Content(foreign);
            Collection<IContent> children = foreign.getChildren();
            if (children != null && !children.isEmpty()) {
                Iterator<IContent> iter = children.iterator();
                IContent child = iter.next();
                this.visitContent(child, this);
            }
            foreign.getChildren().clear();
            this._endContainer(foreign);
        } else {
            this.startContent(foreign);
        }
    }
}

