/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.birt.report.engine.api.impl.LogHandler;
import org.eclipse.birt.report.engine.api.impl.LoggerSetting;

public class LoggerSettingManager {
    private static LoggerSettingManager instance = null;
    private static final String BIRT_NAME_SPACE = "org.eclipse.birt";
    private static final Logger ROOT_LOGGER = Logger.getLogger("org.eclipse.birt");
    private List<LoggerSetting> settingList = new LinkedList<LoggerSetting>();
    private Map<String, LogHandler> handlerMap = new HashMap<String, LogHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoggerSettingManager getInstance() {
        if (instance != null) return instance;
        Class<LoggerSettingManager> clazz = LoggerSettingManager.class;
        synchronized (LoggerSettingManager.class) {
            if (instance != null) return instance;
            instance = new LoggerSettingManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LoggerSettingManager() {
    }

    public synchronized LoggerSetting createLoggerSetting(Logger logger, String directoryName, String fileName, Level logLevel, int rollingSize, int maxBackupIndex) {
        String logFileName = null;
        LogHandler logHandler = null;
        if (directoryName != null || fileName != null) {
            logFileName = this.generateUniqueLogFileName(directoryName, fileName);
        }
        if (logFileName != null && logLevel != Level.OFF) {
            logHandler = this.getLogHandler(logFileName, rollingSize, maxBackupIndex, logLevel);
        }
        LoggerSetting setting = new LoggerSetting(logger, logFileName, logHandler == null ? null : logHandler.getHandler(), logLevel, rollingSize, maxBackupIndex);
        this.settingList.add(setting);
        return setting;
    }

    public synchronized void removeLoggerSetting(LoggerSetting loggerSetting) {
        int i = this.settingList.size() - 1;
        while (i >= 0) {
            if (this.settingList.get(i) == loggerSetting) {
                this.settingList.remove(i);
                break;
            }
            --i;
        }
        String logFileName = loggerSetting.getLogFileName();
        if (logFileName != null) {
            this.releaseLogHandler(logFileName);
        }
    }

    public synchronized void changeSettingLevel(LoggerSetting loggerSetting, Level newLevel) {
        int index = this.settingList.indexOf(loggerSetting);
        this.settingList.remove(index);
        this.settingList.add(loggerSetting);
        loggerSetting.setLogLevel(newLevel);
        if (newLevel != Level.OFF && loggerSetting.getHandlers()[0] == null && loggerSetting.getLogFileName() != null) {
            LogHandler logHandler = this.getLogHandler(loggerSetting.getLogFileName(), loggerSetting.getRollingSize(), loggerSetting.getMaxBackupIndex(), newLevel);
            loggerSetting.setHandler(logHandler.getHandler());
        }
    }

    public synchronized void setLogger(LoggerSetting loggerSetting, Logger logger) {
        loggerSetting.setUserLogger(logger);
    }

    public synchronized LoggerSetting getMergedSetting() {
        Level mergedLevel = null;
        if (this.settingList.size() == 0) {
            return null;
        }
        HashSet<Object> userLoggerSet = new HashSet<Object>();
        HashSet<Handler> handlerSet = new HashSet<Handler>();
        int i = 0;
        while (i < this.settingList.size()) {
            LoggerSetting setting = this.settingList.get(i);
            Level settingLevel = setting.getLogLevel();
            if (settingLevel != null) {
                mergedLevel = settingLevel;
            }
            Object[] objectArray = setting.getHandlers();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Handler handler = objectArray[n2];
                if (handler != null) {
                    handler.setLevel(settingLevel);
                    handlerSet.add(handler);
                }
                ++n2;
            }
            objectArray = setting.getUserLoggers();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object logger = objectArray[n2];
                if (logger != null) {
                    userLoggerSet.add(logger);
                }
                ++n2;
            }
            ++i;
        }
        return new LoggerSetting(userLoggerSet.toArray(new Logger[0]), handlerSet.toArray(new FileHandler[0]), mergedLevel);
    }

    private LogHandler getLogHandler(String logFileName, int rollingSize, int maxBackupIndex, Level logLevel) {
        LogHandler logHandler = this.handlerMap.get(logFileName);
        if (logHandler != null) {
            logHandler.increaseRefCount();
        } else {
            logHandler = this.createLogFileHandler(logFileName, rollingSize, maxBackupIndex, logLevel);
            if (logHandler != null) {
                this.handlerMap.put(logFileName, logHandler);
            }
        }
        return logHandler;
    }

    private void releaseLogHandler(String logFileName) {
        if (logFileName != null) {
            LogHandler logHandler = this.handlerMap.get(logFileName);
            if (logHandler != null) {
                logHandler.decreaseRefCount();
                if (logHandler.getRefCount() == 0) {
                    this.handlerMap.remove(logFileName);
                }
            } else {
                ROOT_LOGGER.severe(logFileName + " does not exist.");
            }
        }
    }

    private String generateUniqueLogFileName(String directoryName, String fileName) {
        if (fileName == null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            String dateTimeString = df.format(new Date());
            fileName = "ReportEngine_" + dateTimeString + ".log";
        }
        if (directoryName == null || directoryName.length() == 0) {
            return fileName;
        }
        File folder = new File(directoryName);
        File file = new File(folder, (String)fileName);
        return file.getPath();
    }

    private LogHandler createLogFileHandler(String fileName, int rollingSize, int logMaxBackupIndex, Level level) {
        try {
            File path = new File(fileName).getParentFile();
            if (path != null) {
                path.mkdirs();
            }
            if (logMaxBackupIndex <= 0) {
                logMaxBackupIndex = 1;
            }
            if (rollingSize < 0) {
                rollingSize = 0;
            }
            FileHandler fileHandler = new FileHandler(fileName, rollingSize, logMaxBackupIndex, true);
            fileHandler.setFormatter(new SimpleFormatter());
            if (level == null) {
                fileHandler.setLevel(Level.WARNING);
            } else {
                fileHandler.setLevel(level);
            }
            fileHandler.setEncoding("utf-8");
            return new LogHandler(fileHandler);
        }
        catch (IOException | SecurityException e) {
            ROOT_LOGGER.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }
}

