/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util.xpathparser;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.util.xpathparser.ParseException;
import org.eclipse.birt.report.model.util.xpathparser.TokenMgrError;
import org.eclipse.birt.report.model.util.xpathparser.XDepthParser;

public class XPathParser {
    private static final int INVALID = 0;
    private static final int ELEMENT = 1;
    private static final int SLOT = 2;
    private static final int PROPERTY = 4;
    private static final int VALUE = 16;
    private static final int STRUCTURE = 32;
    private Object parsedHandle = null;
    private DesignElementHandle currentElement = null;
    private ModuleHandle module = null;
    private int valueType = 0;
    private int slotID = -1;
    private String propertyName = null;
    private boolean isValid = true;

    public XPathParser(ModuleHandle module) {
        this.module = module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(String input) {
        XDepthParser parser_1 = new XDepthParser(input);
        try {
            parser_1.parse();
        }
        catch (ParseException | TokenMgrError e) {
            return null;
        }
        List depthInfo = parser_1.getDepthInfo();
        int index = -1;
        this.currentElement = this.module;
        int lastValueType = 0;
        int i = 0;
        while (i < depthInfo.size()) {
            block20: {
                String attrValue;
                String tagName;
                block23: {
                    int typeCode;
                    ElementDefn elementDefn;
                    String attrName;
                    block22: {
                        block21: {
                            block19: {
                                XDepthParser.DepthInfo oneDepth = (XDepthParser.DepthInfo)depthInfo.get(i);
                                lastValueType = this.valueType;
                                this.valueType = XPathParser.getNextValueType(this.valueType);
                                tagName = oneDepth.getTagName();
                                index = oneDepth.getIndex();
                                attrName = oneDepth.getPropertyName();
                                attrValue = oneDepth.getPropertyValue();
                                elementDefn = (ElementDefn)this.currentElement.getDefn();
                                if (i != 0 || !tagName.equalsIgnoreCase(elementDefn.getXmlName()) || this.module != this.currentElement) break block19;
                                this.valueType = 1;
                                break block20;
                            }
                            if ((this.valueType & 0x10) == 0 || tagName == null || !tagName.equalsIgnoreCase("value")) break block21;
                            this.valueType = 16;
                            break block20;
                        }
                        if ((this.valueType & 2) == 0) break block22;
                        this.slotID = this.getSlotId(elementDefn, tagName, true);
                        if (this.slotID == -1) break block22;
                        this.valueType = 2;
                        break block20;
                    }
                    if ((this.valueType & 1) == 0) break block23;
                    if (lastValueType != 2) {
                        this.slotID = XPathParser.getSlotId(elementDefn, tagName);
                        if (this.slotID != -1) {
                            this.valueType = 1;
                        }
                    }
                    if (lastValueType == 4 && this.propertyName != null && ((typeCode = elementDefn.getProperty(this.propertyName).getTypeCode()) == 23 || typeCode == 24)) {
                        this.valueType = 1;
                    }
                    if (this.valueType != 1 || attrName != null && !"id".equalsIgnoreCase(attrName) && !"slotName".equalsIgnoreCase(attrName)) break block23;
                    this.currentElement = this.findElement(tagName, attrName, attrValue);
                    if (this.currentElement == null) {
                        this.valueType = 0;
                        break;
                    }
                    if ("slotName".equalsIgnoreCase(attrName)) {
                        this.slotID = this.getSlotId(this.currentElement.getDefn(), attrValue, false);
                        if (this.slotID != -1) {
                            this.valueType = 2;
                        }
                    }
                    break block20;
                }
                if ((this.valueType & 0x20) != 0 && XPathParser.isStructureTag(tagName)) {
                    this.valueType = 32;
                    this.parsedHandle = this.parsePropertyValue(tagName, attrValue, index);
                }
                if (((this.valueType & 1) != 0 || (this.valueType & 4) != 0) && XPathParser.isPropertyTag(tagName)) {
                    this.valueType = 4;
                    this.parsedHandle = this.parsePropertyValue(tagName, attrValue, index);
                }
                if (this.valueType == 0) break;
            }
            ++i;
        }
        switch (this.valueType) {
            case 2: {
                return this.currentElement.getSlot(this.slotID);
            }
            case 1: {
                return this.currentElement;
            }
            case 4: 
            case 32: {
                return this.getRespectivePropertyHandle(index);
            }
            case 16: {
                if (lastValueType != 4) {
                    return null;
                }
                Object temp = this.getRespectivePropertyHandle(-1);
                assert (temp instanceof PropertyHandle);
                return ((PropertyHandle)temp).get(index);
            }
        }
        return null;
    }

    private static int getSlotId(IElementDefn defn, String tagName) {
        int j = 0;
        while (j < defn.getSlotCount()) {
            SlotDefn slot = (SlotDefn)defn.getSlot(j);
            if (XPathParser.isContentType(slot, tagName)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private int getSlotId(IElementDefn defn, String slotName, boolean isXmlName) {
        int j = 0;
        while (j < defn.getSlotCount()) {
            SlotDefn slot = (SlotDefn)defn.getSlot(j);
            String name = null;
            name = isXmlName ? slot.getXmlName() : slot.getName();
            if (slotName.equalsIgnoreCase(name)) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    private static int getNextValueType(int tmpValueType) {
        int retValueType = 0;
        switch (tmpValueType) {
            case 2: {
                retValueType = 1;
                break;
            }
            case 1: {
                retValueType = 39;
                break;
            }
            case 4: {
                retValueType = 53;
                break;
            }
            case 32: {
                retValueType = 4;
                break;
            }
            default: {
                retValueType = 7;
            }
        }
        return retValueType;
    }

    private Object getRespectivePropertyHandle(int index) {
        if (!this.isValid) {
            return null;
        }
        if (this.parsedHandle == null) {
            if (this.propertyName == null) {
                return null;
            }
            return new PropertyHandle(this.currentElement, this.propertyName);
        }
        if (this.valueType == 32) {
            if (this.parsedHandle instanceof PropertyHandle) {
                PropertyHandle propHandle = (PropertyHandle)this.parsedHandle;
                if (index < 0 || index >= propHandle.getListValue().size()) {
                    return null;
                }
                return propHandle.getAt(index);
            }
            if (this.parsedHandle instanceof MemberHandle) {
                MemberHandle memberHandle = (MemberHandle)this.parsedHandle;
                if (index < 0 || index >= memberHandle.getListValue().size()) {
                    return null;
                }
                return memberHandle.getAt(index);
            }
            if (this.parsedHandle instanceof StructureHandle) {
                return this.parsedHandle;
            }
            return null;
        }
        if (this.parsedHandle instanceof PropertyHandle || this.parsedHandle instanceof StructureHandle) {
            return this.parsedHandle;
        }
        return null;
    }

    private Object parsePropertyValue(String tagName, String propName, int index) {
        if (!this.isValid) {
            return this.parsedHandle;
        }
        if (this.propertyName == null) {
            IElementPropertyDefn propDefn = this.currentElement.getPropertyDefn(propName);
            if (propDefn == null) {
                this.isValid = false;
                return null;
            }
            this.propertyName = propName;
            if (propDefn.getTypeCode() == 16) {
                this.parsedHandle = new PropertyHandle(this.currentElement, (ElementPropertyDefn)propDefn);
            }
            return this.parsedHandle;
        }
        if (this.parsedHandle == null && this.propertyName != null && "key".equalsIgnoreCase(propName)) {
            String newPropName = this.propertyName + "ID";
            ElementDefn elementDefn = (ElementDefn)this.currentElement.getDefn();
            IElementPropertyDefn propDefn = elementDefn.getProperty(newPropName);
            this.propertyName = propDefn != null ? newPropName : null;
            return null;
        }
        if (this.parsedHandle == null && this.propertyName != null && "simple-property-list".equalsIgnoreCase(tagName)) {
            IElementPropertyDefn propDefn = this.currentElement.getPropertyDefn(propName);
            if (propDefn == null) {
                this.isValid = false;
                return null;
            }
            this.propertyName = propName;
            if (index > 0 && propDefn.getTypeCode() == 20) {
                this.parsedHandle = new PropertyHandle(this.currentElement, (ElementPropertyDefn)propDefn);
            }
            return this.parsedHandle;
        }
        if (this.parsedHandle instanceof PropertyHandle && "structure".equalsIgnoreCase(tagName)) {
            PropertyHandle propHandle = (PropertyHandle)this.parsedHandle;
            if (index < 0 || index >= propHandle.getListValue().size()) {
                this.isValid = false;
            } else {
                this.parsedHandle = propHandle.getAt(index);
            }
            return this.parsedHandle;
        }
        if ("list-property".equalsIgnoreCase(tagName)) {
            if (this.parsedHandle instanceof PropertyHandle) {
                PropertyHandle propHandle = (PropertyHandle)this.parsedHandle;
                Object value = propHandle.getValue();
                if (value instanceof Structure) {
                    Structure struct = (Structure)value;
                    StructureHandle structHandle = struct.getHandle(propHandle);
                    this.parsedHandle = structHandle.getMember(propName);
                    if (this.parsedHandle == null) {
                        this.isValid = false;
                    }
                }
            } else if (this.parsedHandle instanceof StructureHandle) {
                StructureHandle structHandle = (StructureHandle)this.parsedHandle;
                this.parsedHandle = structHandle.getMember(propName);
                if (this.parsedHandle == null) {
                    this.isValid = false;
                }
            }
            return this.parsedHandle;
        }
        if (this.parsedHandle instanceof MemberHandle && "structure".equalsIgnoreCase(tagName)) {
            MemberHandle memberHandle = (MemberHandle)this.parsedHandle;
            if (index < 0 || index >= memberHandle.getListValue().size()) {
                this.isValid = false;
            } else {
                this.parsedHandle = memberHandle.getAt(index);
            }
            return this.parsedHandle;
        }
        return null;
    }

    private static boolean isContentType(SlotDefn slot, String elementDefnName) {
        List<IElementDefn> tmpElementDefns = slot.getContentElements();
        int i = 0;
        while (i < tmpElementDefns.size()) {
            ElementDefn tmpContentDefn = (ElementDefn)tmpElementDefns.get(i);
            if (elementDefnName.equalsIgnoreCase(tmpContentDefn.getXmlName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private DesignElementHandle findElement(String contentDefnName, String attrName, String attrValue) {
        long id = 0L;
        if ("id".equalsIgnoreCase(attrName)) {
            try {
                id = Long.parseLong(attrValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (this.slotID != -1) {
            SlotHandle slot = this.currentElement.getSlot(this.slotID);
            int i = 0;
            while (i < slot.getCount()) {
                DesignElementHandle tmpElement = slot.get(i);
                ElementDefn tmpDefn = (ElementDefn)tmpElement.getDefn();
                if ((0L == id || tmpElement.getID() == id) && tmpDefn.getXmlName().equalsIgnoreCase(contentDefnName)) {
                    return tmpElement;
                }
                ++i;
            }
        }
        PropertyHandle prop = this.currentElement.getPropertyHandle(this.propertyName);
        if (this.propertyName != null && prop != null) {
            List contents = prop.getContents();
            int i = 0;
            while (i < contents.size()) {
                DesignElementHandle tmpElement = (DesignElementHandle)contents.get(i);
                ElementDefn tmpDefn = (ElementDefn)tmpElement.getDefn();
                if ((0L == id || tmpElement.getID() == id) && tmpDefn.getXmlName().equalsIgnoreCase(contentDefnName)) {
                    return tmpElement;
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean isStructureTag(String tagName) {
        return "structure".equalsIgnoreCase(tagName);
    }

    private static boolean isPropertyTag(String tagName) {
        if (tagName == null) {
            return true;
        }
        if ("property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("list-property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("method".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("expression".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("encrypted-property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("text-property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("html-property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("xml-property".equalsIgnoreCase(tagName)) {
            return true;
        }
        if ("simple-property-list".equalsIgnoreCase(tagName)) {
            return true;
        }
        return "ex-property".equalsIgnoreCase(tagName);
    }
}

