/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.parameter.node;

import java.util.List;
import org.eclipse.birt.report.designer.ui.preview.parameter.IParamGroup;
import org.eclipse.birt.report.designer.ui.preview.parameter.IParameter;
import org.eclipse.birt.report.designer.ui.preview.parameter.ParameterFactory;
import org.eclipse.birt.report.designer.ui.preview.parameter.node.CompositeNode;
import org.eclipse.birt.report.designer.ui.preview.parameter.node.IParamNode;
import org.eclipse.birt.report.designer.ui.preview.parameter.node.ParamLeaf;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;

public class ParamNodeFactory {
    public static IParamNode buildParamTree(IGetParameterDefinitionTask task) {
        ParameterFactory factory = new ParameterFactory(task);
        List children = factory.getRootChildren();
        CompositeNode rootNode = new CompositeNode();
        for (Object obj : children) {
            if (obj instanceof IParameter) {
                IParameter param = (IParameter)obj;
                ParamLeaf leaf = new ParamLeaf(param);
                rootNode.add(leaf);
                continue;
            }
            if (!(obj instanceof IParamGroup)) continue;
            IParamGroup paramGroup = (IParamGroup)obj;
            CompositeNode node = new CompositeNode();
            List childList = paramGroup.getChildren();
            rootNode.add(node);
            ParamNodeFactory.buildParamGroup(node, childList);
        }
        return rootNode;
    }

    private static void buildParamGroup(CompositeNode node, List childList) {
        assert (node != null);
        assert (childList != null);
        for (IParameter param : childList) {
            ParamLeaf leaf = new ParamLeaf(param);
            node.add(leaf);
        }
    }
}

