/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.report.designer.core.commands.DeleteCommand;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.LabelEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.testutil.BaseTestCase;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DNDUtilTest
extends BaseTestCase {
    private DataItemHandle[] dataItems;
    private TableHandle table;

    private void createSource() {
        this.dataItems = new DataItemHandle[4];
        int i = 0;
        while (i < this.dataItems.length) {
            this.dataItems[i] = this.getElementFactory().newDataItem("DataItem" + (i + 1));
            ++i;
        }
        this.table = this.getElementFactory().newTableItem("Table1", 3, 2, 2, 2);
    }

    private void setTable() {
        try {
            this.getCellForSingle().addElement((DesignElementHandle)this.dataItems[0], 0);
            this.getCellForMultiple().addElement((DesignElementHandle)this.dataItems[1], 0);
            this.getCellForMultiple().addElement((DesignElementHandle)this.dataItems[2], 0);
            this.getCellForMultiple().addElement((DesignElementHandle)this.dataItems[3], 0);
            this.getReportDesignHandle().getBody().add((DesignElementHandle)this.table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dropSource() {
        Arrays.fill(this.dataItems, null);
        this.table = null;
    }

    private StructuredSelection getSelection() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.table);
        list.add(this.dataItems[0]);
        list.add(this.dataItems[1]);
        list.add(this.dataItems[2]);
        StructuredSelection selection = new StructuredSelection(list);
        return selection;
    }

    private ElementFactory getElementFactory() {
        return this.getReportDesignHandle().getElementFactory();
    }

    private CellHandle getCell() {
        return (CellHandle)((RowHandle)this.table.getHeader().get(0)).getCells().get(0);
    }

    private CellHandle getCellForMultiple() {
        return this.getCell(2, 1, 1);
    }

    private CellHandle getCellForSingle() {
        return this.getCell(0, 0, 1);
    }

    private CellHandle getCell(int type, int row, int column) {
        SlotHandle rows = null;
        if (type == 0) {
            rows = this.table.getHeader();
        } else if (type == 2) {
            rows = this.table.getHeader();
        } else if (type == 3) {
            rows = this.table.getHeader();
        } else {
            return null;
        }
        return (CellHandle)((RowHandle)rows.get(row)).getCells().get(column);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.createSource();
        this.setTable();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.dropSource();
    }

    public void testCloneSource() {
        DNDUtilTest.assertTrue((String)"Clone duplicated elements", (this.getLength(DNDUtil.cloneSource((Object)this.getSelection())) == 1 ? 1 : 0) != 0);
        SlotHandle listDetail = this.getElementFactory().newList("list").getDetail();
        try {
            listDetail.add((DesignElementHandle)this.getElementFactory().newLabel("label"));
            listDetail.add((DesignElementHandle)this.getElementFactory().newDataItem("data"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DNDUtilTest.assertTrue((String)"Clone list detail", (this.getLength(DNDUtil.cloneSource((Object)listDetail)) == 2 ? 1 : 0) != 0);
    }

    private int getLength(Object obj) {
        if (obj instanceof Object[]) {
            return ((Object[])obj).length;
        }
        if (obj instanceof SlotHandle) {
            return ((SlotHandle)obj).getCount();
        }
        if (obj instanceof CellHandle) {
            return ((CellHandle)obj).getContent().getCount();
        }
        return 0;
    }

    public void testHandleValidateTargetCanContain() {
        DNDUtilTest.assertFalse((String)"Validate null", (boolean)DNDUtil.handleValidateTargetCanContain(null, null));
        DNDUtilTest.assertTrue((String)"Validate container", (boolean)DNDUtil.handleValidateTargetCanContain((Object)this.getCell(), (Object)this.dataItems[3]));
        DNDUtilTest.assertTrue((String)"Validate brothers", (boolean)DNDUtil.handleValidateTargetCanContain((Object)this.dataItems[0], (Object)this.dataItems[3]));
        ParameterGroupHandle groupChild = this.getElementFactory().newParameterGroup("child");
        ParameterGroupHandle groupParent = this.getElementFactory().newParameterGroup("parent");
        DNDUtilTest.assertTrue((String)"Validate parameter group", (boolean)DNDUtil.handleValidateTargetCanContain((Object)groupChild, (Object)groupParent));
        SlotHandle listDetailSlot = this.getElementFactory().newList("list").getDetail();
        DataItemHandle dataItem = this.getElementFactory().newDataItem("data");
        DNDUtilTest.assertTrue((String)"Validate list detail", (boolean)DNDUtil.handleValidateTargetCanContain((Object)listDetailSlot, (Object)dataItem));
        LabelHandle label = this.getElementFactory().newLabel("label");
        try {
            listDetailSlot.add((DesignElementHandle)label);
            DNDUtilTest.assertTrue((String)"Validate list detail brothers", (DNDUtil.handleValidateTargetCanContain((Object)label, (Object)dataItem, (boolean)true) == 2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testHandleValidateTargetCanContainMore() {
        DNDUtilTest.assertFalse((String)"Validate null", (boolean)DNDUtil.handleValidateTargetCanContainMore(null, (int)0));
        DNDUtilTest.assertTrue((String)"Validate contain 1", (boolean)DNDUtil.handleValidateTargetCanContainMore((Object)this.getCell(), (int)1));
        DNDUtilTest.assertTrue((String)"Validate contain 2", (boolean)DNDUtil.handleValidateTargetCanContainMore((Object)this.getCell(), (int)2));
        SimpleMasterPageHandle masterPage = (SimpleMasterPageHandle)this.getReportDesignHandle().getMasterPages().get(0);
        DNDUtilTest.assertTrue((String)"Validate master page 0", (boolean)DNDUtil.handleValidateTargetCanContainMore((Object)masterPage.getPageHeader(), (int)0));
        DNDUtilTest.assertTrue((String)"Validate master page 1", (boolean)DNDUtil.handleValidateTargetCanContainMore((Object)masterPage.getPageHeader(), (int)1));
        DNDUtilTest.assertFalse((String)"Validate master page 2", (boolean)DNDUtil.handleValidateTargetCanContainMore((Object)masterPage.getPageHeader(), (int)2));
    }

    public void testHandleValidateTargetCanContainType() {
        SimpleMasterPageHandle masterPage = (SimpleMasterPageHandle)this.getReportDesignHandle().getMasterPages().get(0);
        DNDUtilTest.assertFalse((String)"Validate null", (boolean)DNDUtil.handleValidateTargetCanContainType(null, (String)"Text"));
        DNDUtilTest.assertTrue((String)"Validate text", (boolean)DNDUtil.handleValidateTargetCanContainType((Object)masterPage.getPageHeader(), (String)"Text"));
        DNDUtilTest.assertTrue((String)"Validate grid", (boolean)DNDUtil.handleValidateTargetCanContainType((Object)masterPage.getPageHeader(), (String)"Grid"));
        DNDUtilTest.assertTrue((String)"Validate label", (boolean)DNDUtil.handleValidateTargetCanContainType((Object)masterPage.getPageHeader(), (String)"Label"));
        DNDUtilTest.assertTrue((String)"Validate data", (boolean)DNDUtil.handleValidateTargetCanContainType((Object)masterPage.getPageHeader(), (String)"Data"));
        DNDUtilTest.assertTrue((String)"Validate image", (boolean)DNDUtil.handleValidateTargetCanContainType((Object)masterPage.getPageHeader(), (String)"Image"));
        DNDUtilTest.assertFalse((String)"Validate table", (boolean)DNDUtil.handleValidateTargetCanContainType((Object)masterPage.getPageHeader(), (String)"Table"));
    }

    public void testHandleValidateDragInOutline() {
        DNDUtilTest.assertFalse((boolean)DNDUtil.handleValidateDragInOutline(null));
        DNDUtilTest.assertFalse((boolean)DNDUtil.handleValidateDragInOutline((Object)new Object[0]));
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.getElementFactory().newDataItem(""));
        list.add(this.getElementFactory().newLabel(""));
        list.add(this.getElementFactory().newTableItem(""));
        list.add(this.getElementFactory().newOdaDataSource(""));
        list.add(this.getElementFactory().newOdaDataSet(""));
        list.add(this.getElementFactory().newScalarParameter(""));
        list.add(this.getElementFactory().newParameterGroup(""));
        list.add(this.getElementFactory().newTableGroup());
        list.add(this.getElementFactory().newListGroup());
        ListHandle listHandle = this.getElementFactory().newList("");
        list.add(listHandle);
        DNDUtilTest.assertTrue((boolean)DNDUtil.handleValidateDragInOutline((Object)new StructuredSelection(list)));
        DNDUtilTest.assertFalse((String)"can't copy empty list band", (boolean)DNDUtil.handleValidateDragInOutline((Object)listHandle.getHeader()));
        try {
            listHandle.getHeader().add((DesignElementHandle)this.getElementFactory().newLabel("listband"));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        DNDUtilTest.assertTrue((String)"can't copy content list band", (boolean)DNDUtil.handleValidateDragInOutline((Object)listHandle.getHeader()));
        list.clear();
        list.add(listHandle.getDetail());
        DNDUtilTest.assertFalse((String)"can't drag empty list detail", (boolean)DNDUtil.handleValidateDragInOutline((Object)new StructuredSelection(list)));
        list.clear();
        try {
            listHandle.getDetail().add((DesignElementHandle)this.getElementFactory().newLabel(""));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        list.add(listHandle.getDetail());
        DNDUtilTest.assertTrue((String)"can drag not empty list detail", (boolean)DNDUtil.handleValidateDragInOutline((Object)new StructuredSelection(list)));
        list.clear();
        try {
            listHandle.getDetail().add((DesignElementHandle)this.getElementFactory().newDataItem("data"));
        }
        catch (ContentException | NameException e) {
            e.printStackTrace();
        }
        list.add(listHandle.getDetail());
        DNDUtilTest.assertTrue((String)"can drag list detail", (boolean)DNDUtil.handleValidateDragInOutline((Object)new StructuredSelection(list)));
        list.clear();
        list.add(this.getElementFactory().newTableItem("").getDetail());
        DNDUtilTest.assertFalse((String)"can't drag table detail", (boolean)DNDUtil.handleValidateDragInOutline((Object)new StructuredSelection(list)));
        list.clear();
        list.add(this.getElementFactory().newCell());
        DNDUtilTest.assertFalse((String)"can't drag cell", (boolean)DNDUtil.handleValidateDragInOutline((Object)new StructuredSelection(list)));
    }

    public void testCopyHandles() {
        SlotHandle container = this.dataItems[0].getContainerSlotHandle();
        int count = container.getCount();
        DNDUtilTest.assertTrue((String)"Cell is blank before", (this.getCell().getContent().getCount() == 0 ? 1 : 0) != 0);
        DNDUtil.copyHandles((Object)this.dataItems[0], (Object)this.getCell(), (int)0);
        DNDUtilTest.assertTrue((String)"Cell has one after", (this.getCell().getContent().getCount() == 1 ? 1 : 0) != 0);
        DNDUtilTest.assertTrue((String)"copy item's container has same contents", (container.getCount() == count ? 1 : 0) != 0);
    }

    public void testMoveHandles() {
        SlotHandle container = this.dataItems[0].getContainerSlotHandle();
        int count = container.getCount();
        DNDUtilTest.assertTrue((String)"Cell is blank before", (this.getCell().getContent().getCount() == 0 ? 1 : 0) != 0);
        DNDUtil.moveHandles((Object)this.dataItems[0], (Object)this.getCell(), (int)0);
        DNDUtilTest.assertTrue((String)"Cell has one after", (this.getCell().getContent().getCount() == 1 ? 1 : 0) != 0);
        DNDUtilTest.assertTrue((String)"copy item's container has less contents than before", (container.getCount() == count - 1 ? 1 : 0) != 0);
    }

    public void testEditPart2Model() {
        ArrayList<Object> list = new ArrayList<Object>();
        ListHandle listHandle = this.getElementFactory().newList("");
        list.add(new ListBandEditPart((Object)new ListBandProxy(listHandle.getHeader())));
        list.add(new LabelEditPart((Object)this.getElementFactory().newLabel("")));
        IStructuredSelection result = InsertInLayoutUtil.editPart2Model((ISelection)new StructuredSelection(list));
        for (Object obj : result) {
            DNDUtilTest.assertTrue((String)obj.toString(), (obj instanceof DesignElementHandle || obj instanceof SlotHandle ? 1 : 0) != 0);
        }
    }

    public void testMoveHandlesParameterGroup() {
        try {
            ParameterGroupHandle groupChild = this.getElementFactory().newParameterGroup("child");
            groupChild.addElement((DesignElementHandle)this.getElementFactory().newScalarParameter("c1"), 0);
            groupChild.addElement((DesignElementHandle)this.getElementFactory().newScalarParameter("c2"), 0);
            this.getReportDesignHandle().addElement((DesignElementHandle)groupChild, 1);
            ParameterGroupHandle groupParent = this.getElementFactory().newParameterGroup("parent");
            groupParent.addElement((DesignElementHandle)this.getElementFactory().newScalarParameter("p1"), 0);
            groupParent.addElement((DesignElementHandle)this.getElementFactory().newScalarParameter("p2"), 0);
            this.getReportDesignHandle().addElement((DesignElementHandle)groupParent, 1);
            DNDUtil.moveHandles((Object)groupChild, (Object)groupParent, (int)0);
            int childCount = groupChild.getParameters().getCount();
            int parentCount = groupParent.getParameters().getCount();
            DNDUtilTest.assertTrue((String)"parameter group paste test--child", (childCount == 0 ? 1 : 0) != 0);
            DNDUtilTest.assertTrue((String)"parameter group paste test--parent", (parentCount == 4 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testMoveHandlesPosition() {
        DataItemHandle data = this.dataItems[0];
        String value = "aa";
        try {
            int i = 0;
            while (i < this.dataItems.length) {
                this.dataItems[i].setResultSetColumn("0");
                ++i;
            }
            data.setResultSetColumn(value);
        }
        catch (SemanticException e) {
            e.printStackTrace();
        }
        int pos = 2;
        DNDUtil.moveHandles((Object)data, (Object)this.getCellForMultiple(), (int)pos);
        DataItemHandle newHandle = (DataItemHandle)this.getCellForMultiple().getContent().get(pos);
        DNDUtilTest.assertTrue((String)"validate move position--from outside", (boolean)newHandle.getResultSetColumn().equals(value));
        DNDUtilTest.assertTrue((String)"check count", (this.getCellForMultiple().getContent().getCount() == 4 ? 1 : 0) != 0);
        pos = 0;
        DNDUtil.moveHandles((Object)newHandle, (Object)this.getCellForMultiple(), (int)pos);
        newHandle = (DataItemHandle)this.getCellForMultiple().getContent().get(pos);
        DNDUtilTest.assertTrue((String)"validate move position--move forward", (boolean)newHandle.getResultSetColumn().equals(value));
        DNDUtilTest.assertTrue((String)"check count", (this.getCellForMultiple().getContent().getCount() == 4 ? 1 : 0) != 0);
        pos = 2;
        DNDUtil.moveHandles((Object)newHandle, (Object)this.getCellForMultiple(), (int)pos);
        newHandle = (DataItemHandle)this.getCellForMultiple().getContent().get(pos - 1);
        DNDUtilTest.assertTrue((String)"validate move position--move backward", (boolean)newHandle.getResultSetColumn().equals(value));
        DNDUtilTest.assertTrue((String)"check count", (this.getCellForMultiple().getContent().getCount() == 4 ? 1 : 0) != 0);
    }

    public void testMoveHandlesRename() {
        try {
            ParameterGroupHandle groupChild = this.getElementFactory().newParameterGroup("child");
            groupChild.addElement((DesignElementHandle)this.getElementFactory().newScalarParameter("c1"), 0);
            groupChild.addElement((DesignElementHandle)this.getElementFactory().newScalarParameter("c2"), 0);
            this.getReportDesignHandle().addElement((DesignElementHandle)groupChild, 1);
            ParameterGroupHandle groupParent = this.getElementFactory().newParameterGroup("parent");
            groupParent.addElement((DesignElementHandle)this.getElementFactory().newScalarParameter("p1"), 0);
            groupParent.addElement((DesignElementHandle)this.getElementFactory().newScalarParameter("p2"), 0);
            this.getReportDesignHandle().addElement((DesignElementHandle)groupParent, 1);
            DNDUtil.moveHandles((Object)groupChild, (Object)groupParent, (int)0);
            SlotHandle parameters = groupParent.getParameters();
            DNDUtilTest.assertTrue((String)"validate rename", (boolean)parameters.get(0).getName().equals("p1"));
            DNDUtilTest.assertTrue((String)"validate rename", (boolean)parameters.get(1).getName().equals("p2"));
            DNDUtilTest.assertTrue((String)"validate rename", (boolean)parameters.get(2).getName().equals("c1"));
            DNDUtilTest.assertTrue((String)"validate rename", (boolean)parameters.get(3).getName().equals("c2"));
        }
        catch (ContentException | NameException e) {
            e.printStackTrace();
        }
    }

    public void testMoveHandlesSlotContent() {
        ListHandle listHandle = this.getElementFactory().newList("list");
        SlotHandle transfer = listHandle.getDetail();
        SlotHandle target = listHandle.getFooter();
        try {
            transfer.add((DesignElementHandle)this.getElementFactory().newLabel("label"));
            transfer.add((DesignElementHandle)this.getElementFactory().newDataItem("data"));
            DNDUtilTest.assertTrue((String)"move list slot handle", (this.getLength(transfer) == 2 ? 1 : 0) != 0);
            DNDUtil.moveHandles((Object)transfer, (Object)target, (int)-1);
            DNDUtilTest.assertTrue((String)"move list slot handle", (this.getLength(transfer) == 0 ? 1 : 0) != 0);
            DNDUtilTest.assertTrue((String)"move list slot handle", (this.getLength(target) == 2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testDropSource() {
        ListHandle listHandle = this.getElementFactory().newList("list");
        SlotHandle transfer = listHandle.getDetail();
        try {
            transfer.add((DesignElementHandle)this.getElementFactory().newLabel("label"));
            transfer.add((DesignElementHandle)this.getElementFactory().newDataItem("data"));
            DNDUtilTest.assertTrue((String)"drop list slot handle", (this.getLength(transfer) == 2 ? 1 : 0) != 0);
            DNDUtil.dropSource((Object)transfer);
            DNDUtilTest.assertTrue((String)"drop list slot handle", (this.getLength(transfer) == 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DeleteCommand command = new DeleteCommand((Object)this.getElementFactory().newSimpleMasterPage("master page"));
        DNDUtilTest.assertFalse((String)"can't delete master page", (boolean)command.canExecute());
        command = new DeleteCommand((Object)this.getElementFactory().newOdaDataSource("data source"));
        DNDUtilTest.assertTrue((String)"can delete data source", (boolean)command.canExecute());
        command = new DeleteCommand((Object)this.getElementFactory().newOdaDataSet("data set"));
        DNDUtilTest.assertTrue((String)"can delete data set", (boolean)command.canExecute());
        command = new DeleteCommand((Object)this.getElementFactory().newParameterGroup("parameter group"));
        DNDUtilTest.assertTrue((String)"can delete parameter group", (boolean)command.canExecute());
        command = new DeleteCommand((Object)this.getElementFactory().newScalarParameter("parameter"));
        DNDUtilTest.assertTrue((String)"can delete parameter", (boolean)command.canExecute());
        command = new DeleteCommand((Object)this.getElementFactory().newLabel("label"));
        DNDUtilTest.assertTrue((String)"can delete label", (boolean)command.canExecute());
        command = new DeleteCommand((Object)this.getElementFactory().newTableItem("table"));
        DNDUtilTest.assertTrue((String)"can delete table", (boolean)command.canExecute());
        command = new DeleteCommand((Object)this.getElementFactory().newTableRow());
        DNDUtilTest.assertTrue((String)"can delete table row", (boolean)command.canExecute());
        command = new DeleteCommand((Object)this.getElementFactory().newTableColumn());
        DNDUtilTest.assertTrue((String)"can delete table column", (boolean)command.canExecute());
        command = new DeleteCommand((Object)this.getElementFactory().newCell());
        DNDUtilTest.assertFalse((String)"can't delete empty table cell", (boolean)command.canExecute());
        try {
            this.getCell().addElement((DesignElementHandle)this.getElementFactory().newDataItem("ss"), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        command = new DeleteCommand((Object)this.getCell());
        DNDUtilTest.assertTrue((String)"can delete table cell", (boolean)command.canExecute());
        command = new DeleteCommand((Object)listHandle);
        DNDUtilTest.assertTrue((String)"can delete list", (boolean)command.canExecute());
        command = new DeleteCommand((Object)listHandle.getHeader());
        DNDUtilTest.assertFalse((String)"can't delete empty list band", (boolean)command.canExecute());
        try {
            listHandle.getHeader().add((DesignElementHandle)this.getElementFactory().newLabel(""));
        }
        catch (ContentException | NameException e1) {
            e1.printStackTrace();
        }
        command = new DeleteCommand((Object)listHandle.getHeader());
        DNDUtilTest.assertTrue((String)"can delete list band", (boolean)command.canExecute());
        ListGroupHandle lg = this.getElementFactory().newListGroup();
        try {
            listHandle.addElement((DesignElementHandle)lg, 1);
            lg.addElement((DesignElementHandle)this.getElementFactory().newLabel("lg"), 0);
        }
        catch (ContentException | NameException e1) {
            e1.printStackTrace();
        }
        command = new DeleteCommand((Object)lg.getHeader());
        DNDUtilTest.assertTrue((String)"can delete list group", (boolean)command.canExecute());
    }

    public void testCopyHandlesSibling() {
        int position;
        ListHandle listHandle = this.getElementFactory().newList("list");
        TextItemHandle text = this.getElementFactory().newTextItem("text");
        LabelHandle label = this.getElementFactory().newLabel("label");
        SlotHandle detail = listHandle.getDetail();
        try {
            detail.add((DesignElementHandle)label);
            detail.add((DesignElementHandle)this.getElementFactory().newDataItem("data"));
            position = DNDUtil.calculateNextPosition((Object)label, (int)2);
            DNDUtil.copyHandles((Object)text, (Object)label);
            DNDUtilTest.assertTrue((String)"length is right", (this.getLength(detail) == 3 ? 1 : 0) != 0);
            DNDUtilTest.assertTrue((String)"position is right", (boolean)(detail.get(position) instanceof TextItemHandle));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            text = this.getElementFactory().newTextItem("text2");
            position = DNDUtil.calculateNextPosition((Object)this.dataItems[2], (int)2);
            DNDUtil.copyHandles((Object)text, (Object)this.dataItems[2]);
            DNDUtilTest.assertTrue((String)"length is right", (this.getLength(this.getCellForMultiple()) == 4 ? 1 : 0) != 0);
            DNDUtilTest.assertTrue((String)"position is right", (boolean)(this.getCellForMultiple().getContent().get(position) instanceof TextItemHandle));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        label = this.getElementFactory().newLabel("label1");
        text = this.getElementFactory().newTextItem("text3");
        Object[] array = new Object[]{label, text};
        Object cloneElements = DNDUtil.cloneSource((Object)array);
        DNDUtil.copyHandles((Object)cloneElements, (Object)this.dataItems[0]);
        DNDUtil.copyHandles((Object)cloneElements, (Object)this.dataItems[0]);
        DNDUtilTest.assertTrue((String)"multiple order", (boolean)(this.getCellForSingle().getContent().get(0) instanceof DataItemHandle));
        DNDUtilTest.assertTrue((String)"multiple order", (boolean)(this.getCellForSingle().getContent().get(1) instanceof LabelHandle));
        DNDUtilTest.assertTrue((String)"multiple order", (boolean)(this.getCellForSingle().getContent().get(2) instanceof TextItemHandle));
        DNDUtilTest.assertTrue((String)"multiple order", (boolean)(this.getCellForSingle().getContent().get(1) instanceof LabelHandle));
        DNDUtilTest.assertTrue((String)"multiple order", (boolean)(this.getCellForSingle().getContent().get(2) instanceof TextItemHandle));
    }

    public void testCheckContainerExists() {
        CellHandle cell00 = this.getCell();
        DesignElementHandle row0 = this.table.getHeader().get(0);
        DesignElementHandle row1 = this.table.getHeader().get(1);
        DesignElementHandle column0 = this.table.getColumns().get(0);
        DesignElementHandle column1 = this.table.getColumns().get(1);
        DNDUtilTest.assertTrue((String)"test cell row in", (boolean)DNDUtil.checkContainerExists((Object)cell00, (Object[])new Object[]{cell00, row0}));
        DNDUtilTest.assertTrue((String)"test cell column in", (boolean)DNDUtil.checkContainerExists((Object)cell00, (Object[])new Object[]{cell00, column0}));
        DNDUtilTest.assertTrue((String)"test cell table in", (boolean)DNDUtil.checkContainerExists((Object)cell00, (Object[])new Object[]{cell00, this.table}));
        DNDUtilTest.assertFalse((String)"test cell row out", (boolean)DNDUtil.checkContainerExists((Object)cell00, (Object[])new Object[]{cell00, row1}));
        DNDUtilTest.assertFalse((String)"test cell column out", (boolean)DNDUtil.checkContainerExists((Object)cell00, (Object[])new Object[]{cell00, column1}));
        TableGroupHandle tg = this.getElementFactory().newTableGroup();
        RowHandle tgRow = this.getElementFactory().newTableRow();
        try {
            tg.addElement((DesignElementHandle)tgRow, 0);
            this.table.addElement((DesignElementHandle)tg, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DNDUtilTest.assertTrue((String)"test table group in", (boolean)DNDUtil.checkContainerExists((Object)tg, (Object[])new Object[]{tg, this.table}));
        DNDUtilTest.assertTrue((String)"test table group row in", (boolean)DNDUtil.checkContainerExists((Object)tgRow, (Object[])new Object[]{tgRow, this.table}));
        DNDUtilTest.assertTrue((String)"test table group row in", (boolean)DNDUtil.checkContainerExists((Object)tgRow, (Object[])new Object[]{tgRow, tg}));
        ListHandle list = this.getElementFactory().newList("list");
        ListGroupHandle lg = this.getElementFactory().newListGroup();
        DataItemHandle datal = this.getElementFactory().newDataItem("dl");
        try {
            lg.addElement((DesignElementHandle)datal, 0);
            list.addElement((DesignElementHandle)lg, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DNDUtilTest.assertTrue((String)"test list group in", (boolean)DNDUtil.checkContainerExists((Object)lg, (Object[])new Object[]{lg, list}));
        DNDUtilTest.assertTrue((String)"test list group content in", (boolean)DNDUtil.checkContainerExists((Object)datal, (Object[])new Object[]{datal, lg}));
        DNDUtilTest.assertTrue((String)"test list group content in", (boolean)DNDUtil.checkContainerExists((Object)datal, (Object[])new Object[]{datal, list}));
    }

    public void testIsInSameColumn() {
        CellHandle cell00 = this.getCell();
        DesignElementHandle row0 = this.table.getHeader().get(0);
        DesignElementHandle column0 = this.table.getColumns().get(0);
        DesignElementHandle column1 = this.table.getColumns().get(1);
        DesignElementHandle column3 = this.getElementFactory().newTableItem("2", 3).getColumns().get(0);
        DNDUtilTest.assertTrue((String)"test cell column in", (boolean)DNDUtil.isInSameColumn((Object[])new Object[]{cell00, column0}));
        DNDUtilTest.assertFalse((String)"test cell column out", (boolean)DNDUtil.isInSameColumn((Object[])new Object[]{cell00, column1}));
        DNDUtilTest.assertFalse((String)"test cell column out", (boolean)DNDUtil.isInSameColumn((Object[])new Object[]{cell00, column3}));
        DNDUtilTest.assertFalse((String)"test cell other out", (boolean)DNDUtil.isInSameColumn((Object[])new Object[]{cell00, row0}));
        DNDUtilTest.assertFalse((String)"test cell 3 out", (boolean)DNDUtil.isInSameColumn((Object[])new Object[]{cell00, column0, column1}));
        DNDUtilTest.assertTrue((String)"test cell 3 in", (boolean)DNDUtil.isInSameColumn((Object[])new Object[]{cell00, column0, column0}));
        GridHandle grid = this.getElementFactory().newGridItem("grid", 3, 3);
        CellHandle gridCell00 = grid.getCell(0, 0);
        DesignElementHandle gc0 = grid.getColumns().get(0);
        DesignElementHandle gc1 = grid.getColumns().get(1);
        DNDUtilTest.assertTrue((String)"test grid cell column in", (boolean)DNDUtil.isInSameColumn((Object[])new Object[]{gridCell00, gc0}));
        DNDUtilTest.assertFalse((String)"test grid cell column out", (boolean)DNDUtil.isInSameColumn((Object[])new Object[]{gridCell00, gc1}));
    }
}

