/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.FileSystems;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.engine.api.ReportRunner;

public abstract class EngineCase
extends TestCase {
    private String caseName;
    protected static final String BUNDLE_NAME = "org.eclipse.birt.report.tests.engine.messages";
    protected static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.eclipse.birt.report.tests.engine.messages");
    protected static final String PLUGIN_NAME = "org.eclipse.birt.report.tests.engine";
    protected static final String PLUGINLOC = "/org.eclipse.birt.report.tests.engine/";
    protected static final String PLUGIN_PATH = System.getProperty("user.dir") + "/plugins/" + "/org.eclipse.birt.report.tests.engine/".substring("/org.eclipse.birt.report.tests.engine/".indexOf("/") + 1) + "bin/";
    protected static final String TEST_FOLDER = "src/";
    protected static final String OUTPUT_FOLDER = "output";
    protected static final String INPUT_FOLDER = "input";
    protected static final String GOLDEN_FOLDER = "golden";
    protected IReportEngine engine = null;
    protected IEngineTask engineTask = null;
    private static final String FORMAT_HTML = "html";
    private static final String FORMAT_PDF = "pdf";
    private static final String ENCODING_UTF8 = "UTF-8";
    private String IMAGE_DIR = "image";
    private boolean pagination = false;
    private Locale locale = Locale.ENGLISH;
    private static final Pattern PATTERN_ID_AUTOBOOKMARK = Pattern.compile("id[\\s]*=[\\s]*\"AUTOGENBOOKMARK_[\\d]+\"");
    private static final Pattern PATTERN_NAME_AUTOBOOKMARK = Pattern.compile("name[\\s]*=[\\s]*\"AUTOGENBOOKMARK_[\\d]+\"");
    private static final Pattern PATTERN_IID = Pattern.compile("iid[\\s]*=[\\s]*\"/.*(.*)\"");
    private static final Pattern PATTERN_BG_IMAGE = Pattern.compile("background-image[\\s]*:url[(]image.*[)]");
    private static final Pattern PATTERN_BG_IMAGE2 = Pattern.compile("background-image[\\s]*:[\\s]*url[(]'image.*'[)]");
    private static final Pattern PATTERN_IMAGE_SOURCE = Pattern.compile("src=\"image.*\"");
    private static Object[][] FILTER_PATTERNS = new Object[][]{{PATTERN_ID_AUTOBOOKMARK, "REPLACEMENT_ID_AUTOBOOKMARK"}, {PATTERN_NAME_AUTOBOOKMARK, "REPLACEMENT_NAME_AUTOBOOKMARK"}, {PATTERN_IID, "REPLACEMENT_IID"}, {PATTERN_BG_IMAGE, "REPLACEMENT_BG_IMAGE"}, {PATTERN_BG_IMAGE2, "REPLACEMENT_BG_IMAGE2"}, {PATTERN_IMAGE_SOURCE, "REPLACEMENT_IMAGE_SOURCE"}};

    protected void setUp() throws Exception {
        super.setUp();
        EngineConfig config = new EngineConfig();
        this.engine = this.createReportEngine(config);
    }

    public IReportEngine createReportEngine(EngineConfig config) throws BirtException {
        this.setScriptingPath();
        if (config == null) {
            config = new EngineConfig();
        }
        Platform.startup((PlatformConfig)new PlatformConfig());
        Object factory = Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
        if (factory instanceof IReportEngineFactory) {
            return ((IReportEngineFactory)factory).createReportEngine(config);
        }
        return null;
    }

    public EngineCase() {
        super(null);
    }

    public EngineCase(String name) {
        super(name);
    }

    protected void setCase(String caseName) {
        this.caseName = caseName;
    }

    protected void runCase(String[] args) {
        Vector<Object> runArgs = new Vector<Object>();
        String input = PLUGIN_PATH + FileSystems.getDefault().getSeparator() + RESOURCE_BUNDLE.getString("CASE_INPUT");
        input = input + FileSystems.getDefault().getSeparator() + this.caseName + ".rptdesign";
        System.out.println("input is : " + input);
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                runArgs.add(args[i]);
                ++i;
            }
        }
        runArgs.add("-f");
        runArgs.add("test");
        runArgs.add(input);
        args = runArgs.toArray(new String[runArgs.size()]);
        ReportRunner.main((String[])args);
    }

    protected final void copyFile(String from, String to) throws IOException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            new File(to).createNewFile();
            bis = new BufferedInputStream(new FileInputStream(from));
            bos = new BufferedOutputStream(new FileOutputStream(to));
            int nextByte = 0;
            while ((nextByte = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(nextByte);
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected void copyResource(String src, String tgt, String folder) {
        InputStream in;
        String className = this.getFullQualifiedClassName();
        tgt = this.getInputResourceFolder() + File.separator + className + "/" + folder + "/" + (String)tgt;
        className = className.replace('.', '/');
        src = className + "/" + folder + "/" + (String)src;
        File parent = new File((String)tgt).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        EngineCase.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)src)) != null ? 1 : 0) != 0);
        try {
            FileOutputStream fos = new FileOutputStream((String)tgt);
            byte[] fileData = new byte[5120];
            int readCount = -1;
            while ((readCount = in.read(fileData)) != -1) {
                fos.write(fileData, 0, readCount);
            }
            fos.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EngineCase.fail();
        }
    }

    protected void copyResource_INPUT(String input_resource, String input) {
        this.copyResource(input_resource, input, INPUT_FOLDER);
    }

    protected void copyResource_GOLDEN(String input_resource, String golden) {
        this.copyResource(input_resource, golden, GOLDEN_FOLDER);
    }

    protected void copyResource_SCRIPT(String input_resource, String script) {
        this.copyResource(input_resource, script, "input/scripts");
    }

    public void removeFile(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.removeFile(children[i]);
                ++i;
            }
        }
        if (file.exists() && !file.delete()) {
            System.out.println(file.toString() + " can't be removed");
        }
    }

    public void removeFile(String file) {
        this.removeFile(new File(file));
    }

    public void removeResource() {
        this.removeFile(this.getInputResourceFolder());
    }

    protected String getClassFolder() {
        CodeSource source;
        Object pathBase = null;
        ProtectionDomain domain = ((Object)((Object)this)).getClass().getProtectionDomain();
        if (domain != null && (source = domain.getCodeSource()) != null) {
            URL url = source.getLocation();
            pathBase = url.getPath();
            if (((String)pathBase).endsWith("bin/")) {
                pathBase = ((String)pathBase).substring(0, ((String)pathBase).length() - 4);
            }
            if (((String)pathBase).endsWith("bin")) {
                pathBase = ((String)pathBase).substring(0, ((String)pathBase).length() - 3);
            }
        }
        pathBase = pathBase + TEST_FOLDER;
        Object className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = ((String)className).lastIndexOf(".");
        className = ((String)className).substring(0, lastDotIndex);
        className = (String)pathBase + ((String)className).replace('.', '/');
        return className;
    }

    protected boolean compareHTML(String golden, String output) throws Exception {
        InputStreamReader readerA = null;
        InputStreamReader readerB = null;
        boolean same = true;
        StringBuilder errorText = new StringBuilder();
        try {
            try {
                String outputFile = this.genOutputFile(output);
                String goldenFile = this.genGoldenFile(golden);
                readerA = new FileReader(goldenFile);
                readerB = new FileReader(outputFile);
                same = this.compareTextFile(readerA, readerB, output);
            }
            catch (IOException e) {
                errorText.append(e.toString());
                errorText.append("\n");
                e.printStackTrace();
                try {
                    readerA.close();
                    readerB.close();
                }
                catch (Exception e2) {
                    readerA = null;
                    readerB = null;
                    errorText.append(e2.toString());
                    throw new Exception(errorText.toString());
                }
            }
        }
        finally {
            try {
                readerA.close();
                readerB.close();
            }
            catch (Exception e) {
                readerA = null;
                readerB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    protected boolean compareHTML_STRING(String output, String checkstring, int checktimes) {
        StringBuilder errorText = new StringBuilder();
        String outputFile = this.genOutputFile(output);
        String line = null;
        int count = 0;
        boolean same = true;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(new File(outputFile)));
            while ((line = reader.readLine()) != null) {
                if (line.indexOf(checkstring) <= 0) continue;
                ++count;
            }
            same = this.compareString(checktimes, count);
        }
        catch (IOException e) {
            errorText.append(e.toString());
            errorText.append("\n");
            e.printStackTrace();
        }
        return same;
    }

    protected ArrayList runAndRender_HTML(String input, String output) throws EngineException {
        this.pagination = false;
        return this.runAndRender(input, output, null, FORMAT_HTML);
    }

    protected ArrayList runAndRender_HTMLWithPagination(String input, String output) throws EngineException {
        this.pagination = true;
        return this.runAndRender(input, output, null, FORMAT_HTML);
    }

    protected void runAndRender_PDF(String input, String output) throws EngineException {
        this.runAndRender(input, output, null, FORMAT_PDF);
    }

    protected String getFullQualifiedClassName() {
        Object className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = ((String)className).lastIndexOf(".");
        className = PLUGIN_NAME + ((String)className).substring(PLUGIN_NAME.length(), lastDotIndex).replace('.', '/');
        return className;
    }

    protected final ArrayList runAndRender(String input, String output, Map paramValues, String format) throws EngineException {
        String outputFile = this.genOutputFile(output);
        input = this.genInputFile(input);
        IReportRunnable runnable = this.engine.openReportDesign(input);
        IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
        this.engineTask = task;
        if (paramValues != null) {
            for (String key : paramValues.keySet()) {
                task.setParameterValue(key, paramValues.get(key));
            }
        }
        task.setLocale(this.locale);
        RenderOptionBase options = null;
        if (FORMAT_PDF.equals(format)) {
            options = new RenderOptionBase();
            options.setOutputFileName(outputFile);
        } else {
            options = new HTMLRenderOption();
            options.setOutputFileName(outputFile);
            ((HTMLRenderOption)options).setHtmlPagination(this.pagination);
            HTMLRenderContext renderContext = new HTMLRenderContext();
            renderContext.setImageDirectory(this.IMAGE_DIR);
            HashMap<String, HTMLRenderContext> appContext = new HashMap<String, HTMLRenderContext>();
            appContext.put("HTML_RENDER_CONTEXT", renderContext);
            task.setAppContext(appContext);
        }
        options.setOutputFormat(format);
        options.getOutputSetting().put("url-encoding", ENCODING_UTF8);
        task.setRenderOption((IRenderOption)options);
        task.run();
        ArrayList errors = (ArrayList)task.getErrors();
        task.close();
        return errors;
    }

    protected final ArrayList run(String input, String output) throws EngineException {
        String outputFile = this.genOutputFile(output);
        input = this.genInputFile(input);
        IReportRunnable runnable = this.engine.openReportDesign(input);
        IRunTask task = this.engine.createRunTask(runnable);
        task.setAppContext(new HashMap());
        task.setLocale(this.locale);
        FileArchiveWriter archive = null;
        try {
            archive = new FileArchiveWriter(outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        task.run((IDocArchiveWriter)archive);
        ArrayList errors = (ArrayList)task.getErrors();
        task.close();
        return errors;
    }

    protected ArrayList render_HTML(String doc, String output, String pageRange) throws EngineException {
        this.pagination = true;
        return this.render(FORMAT_HTML, doc, output, pageRange);
    }

    protected ArrayList render_PDF(String doc, String output, String pageRange) throws EngineException {
        return this.render(FORMAT_PDF, doc, output, pageRange);
    }

    private ArrayList render(String format, String doc, String output, String pageRange) throws EngineException {
        String outputFile = this.genOutputFile(output);
        doc = this.genInputFile(doc);
        String encoding = ENCODING_UTF8;
        IReportDocument document = this.engine.openReportDocument(doc);
        IRenderTask task = this.engine.createRenderTask(document);
        task.setLocale(this.locale);
        HTMLRenderOption options = new HTMLRenderOption();
        options.setOutputFileName(outputFile);
        options.setOutputFormat(format);
        options.getOutputSetting().put("url-encoding", encoding);
        if (!format.equalsIgnoreCase(FORMAT_PDF)) {
            options.setHtmlPagination(this.pagination);
        }
        HTMLRenderContext renderContext = new HTMLRenderContext();
        renderContext.setImageDirectory(this.IMAGE_DIR);
        HashMap<String, Object> appContext = new HashMap<String, Object>();
        appContext.put("HTML_RENDER_CONTEXT", renderContext);
        appContext.put("PARENT_CLASSLOADER", EngineCase.class.getClassLoader());
        task.setAppContext(appContext);
        task.setRenderOption((IRenderOption)options);
        task.setPageRange(pageRange);
        task.render();
        ArrayList errors = (ArrayList)task.getErrors();
        task.close();
        return errors;
    }

    protected final ArrayList runAndThenRender(String input, String output, String pageRange, String format) throws Exception {
        String tempDoc = "temp_123aaabbbccc789.rptdocument";
        ArrayList errors = this.run(input, tempDoc);
        if (errors.size() > 0) {
            return errors;
        }
        String from = this.genOutputFile(tempDoc);
        this.copyFile(from, this.genInputFile(tempDoc));
        if (FORMAT_PDF.equals(format)) {
            return this.render_PDF(tempDoc, output, pageRange);
        }
        return this.render_HTML(tempDoc, output, pageRange);
    }

    protected boolean compareTextFile(Reader golden, Reader output, String fileName) throws Exception {
        StringBuilder errorText = new StringBuilder();
        BufferedReader lineReaderA = null;
        BufferedReader lineReaderB = null;
        boolean same = true;
        int lineNo = 1;
        try {
            lineReaderA = new BufferedReader(golden);
            lineReaderB = new BufferedReader(output);
            String strA = lineReaderA.readLine().trim();
            String strB = lineReaderB.readLine().trim();
            while (strA != null) {
                String filterA = this.filterLine(strA);
                String filterB = this.filterLine(strB);
                same = filterA.trim().equals(filterB.trim());
                if (!same) {
                    StringBuilder message = new StringBuilder();
                    message.append("line=");
                    message.append(lineNo);
                    message.append("(");
                    message.append(fileName);
                    message.append(")");
                    message.append(" is different:\n");
                    message.append(" The line from golden file: ");
                    message.append(strA);
                    message.append("\n");
                    message.append(" The line from result file: ");
                    message.append(strB);
                    message.append("\n");
                    message.append("Text after filtering: \n");
                    message.append(" golden file: ");
                    message.append(filterA);
                    message.append("\n");
                    message.append(" result file: ");
                    message.append(filterB);
                    throw new Exception(message.toString());
                }
                strA = lineReaderA.readLine();
                strB = lineReaderB.readLine();
                ++lineNo;
            }
            same = strA == null && strB == null;
        }
        finally {
            try {
                lineReaderA.close();
                lineReaderB.close();
            }
            catch (Exception e) {
                lineReaderA = null;
                lineReaderB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    private boolean compareString(int checktimes, int countstring) {
        boolean same = true;
        StringBuilder errorText = new StringBuilder();
        try {
            same = checktimes == countstring;
        }
        catch (Exception e) {
            errorText.append(e.toString());
        }
        return same;
    }

    protected String filterLine(String str) {
        String result = str;
        int i = 0;
        while (i < FILTER_PATTERNS.length) {
            Pattern pattern = (Pattern)FILTER_PATTERNS[i][0];
            String replacement = (String)FILTER_PATTERNS[i][1];
            Matcher matcher = pattern.matcher(result);
            while (matcher.find()) {
                result = matcher.replaceFirst(replacement);
            }
            ++i;
        }
        return result;
    }

    protected String getBaseFolder() {
        String className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        className = className.substring(0, lastDotIndex);
        return PLUGIN_PATH + className.replace('.', '/');
    }

    protected URL getResource(String name) {
        return ((Object)((Object)this)).getClass().getResource(name);
    }

    protected void setScriptingPath() {
    }

    protected void setLocale(Locale loc) {
        this.locale = loc;
    }

    protected void setImageDir(String imageDir) {
        this.IMAGE_DIR = imageDir;
    }

    protected void tearDown() throws Exception {
        this.engine.destroy();
        super.tearDown();
    }

    protected String genOutputFolder() {
        String outputFolder = this.getOutputResourceFolder() + File.separator + this.getFullQualifiedClassName() + "/output";
        return outputFolder;
    }

    protected String genInputFolder() {
        String inputFolder = this.getInputResourceFolder() + File.separator + this.getFullQualifiedClassName() + "/input";
        return inputFolder;
    }

    protected String genGoldenFolder() {
        String goldenFolder = this.getInputResourceFolder() + File.separator + this.getFullQualifiedClassName() + "/golden";
        return goldenFolder;
    }

    protected String genOutputFile(String output) {
        String outputFile = this.genOutputFolder() + File.separator + output;
        return outputFile;
    }

    protected String genInputFile(String input) {
        String inputFile = this.genInputFolder() + File.separator + input;
        return inputFile;
    }

    protected String genGoldenFile(String golden) {
        String goldenFile = this.genGoldenFolder() + File.separator + golden;
        return goldenFile;
    }

    private void copyFolder(File from, File to) throws Exception {
        if (!from.isDirectory() || !from.exists()) {
            throw new Exception("Input foler: " + String.valueOf(from) + " doesn't exist.");
        }
        File[] files = from.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return true;
            }
        });
        if (!to.exists()) {
            to.mkdir();
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.copyFolder(files[i], new File(to.getPath() + "/" + files[i].getName()));
            }
            File outFile = new File(to.getPath());
            try {
                DataInputStream instr = new DataInputStream(new BufferedInputStream(new FileInputStream(files[i])));
                DataOutputStream outstr = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(outFile) + File.separator + files[i].getName())));
                try {
                    while (true) {
                        int data = instr.readUnsignedByte();
                        outstr.writeByte(data);
                    }
                }
                catch (EOFException eof) {
                    outstr.close();
                    instr.close();
                }
            }
            catch (FileNotFoundException nfx) {
                System.out.println("Problem opening files:" + String.valueOf(files[i]));
            }
            catch (IOException iox) {
                System.out.println("IO Problems");
            }
            System.out.println(files[i]);
            ++i;
        }
    }

    public void copyFolder(String from, String to) throws Exception {
        this.copyFolder(new File(from), new File(to));
    }

    protected String getBasePath() {
        return new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
    }

    public String tempFolder() {
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        return tempDir;
    }

    public String getInputResourceFolder() {
        String resourceFolder = this.tempFolder() + "org.eclipse.birt.report.tests.engine.RESOURCE";
        return resourceFolder;
    }

    public String getOutputResourceFolder() {
        String outputFolder = this.tempFolder() + "org.eclipse.birt.report.tests.engine.OUTPUT";
        return outputFolder;
    }
}

