/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.CollectionConditionalExpression;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.api.timefunction.IReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.ITimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.ITimePeriod;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeFunction;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriod;
import org.eclipse.birt.data.engine.api.timefunction.TimePeriodType;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.TestFactTable;
import org.eclipse.birt.data.engine.olap.api.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.CubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IMeasureDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.cursor.DateCube;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerMap;
import org.eclipse.birt.data.engine.olap.data.api.cube.DocManagerReleaser;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.AddingNestAggregations;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.SubCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.junit.Assert;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import testutil.BaseTestCase;

public class CubeFeaturesTest
extends BaseTestCase {
    private static String cubeName = "cube";

    @Test
    public void testBasic() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testQueryWithoutMeasure() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, null);
        engine.shutdown();
    }

    @Test
    public void testBasic1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testBasic3() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("WEIGHTEDAVE");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        binding6.addArgument((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"][\"attr21\"]"));
        cqd.addBinding((IBinding)binding6);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, "rowGrandTotal", null);
        engine.shutdown();
    }

    @Test
    public void testAddingNestAggregations() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("total");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("sumTotal1");
        binding7.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        Binding binding8 = new Binding("sumTotal2");
        binding8.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding8.setAggrFunction("SUM");
        binding8.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        Binding binding9 = new Binding("sumSumTotal1");
        binding9.setExpression((IBaseExpression)new ScriptExpression("data[\"sumTotal1\"]"));
        binding9.setAggrFunction("SUM");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        Binding binding10 = new Binding("maxTotal1");
        binding10.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding10.setAggrFunction("MAX");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        Binding binding11 = new Binding("maxTotal2");
        binding11.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding11.setAggrFunction("MAX");
        AddingNestAggregations cubeOperation1 = new AddingNestAggregations(new IBinding[]{binding7, binding8, binding10, binding11});
        AddingNestAggregations cubeOperation2 = new AddingNestAggregations(new IBinding[]{binding9});
        cqd.addCubeOperation((ICubeOperation)cubeOperation1);
        cqd.addCubeOperation((ICubeOperation)cubeOperation2);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", new String[0]);
        this.checkOutputFile();
        cursor.close();
        engine.shutdown();
    }

    @Test
    public void testAddingNestAggregationsWithExpression() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("total");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("sumTotal1");
        binding7.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        Binding binding8 = new Binding("sumTotal2");
        binding8.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding8.setAggrFunction("SUM");
        binding8.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        Binding binding9 = new Binding("sumSumTotal1");
        binding9.setExpression((IBaseExpression)new ScriptExpression("data[\"sumTotal1\"]"));
        binding9.setAggrFunction("SUM");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        Binding binding10 = new Binding("maxTotal1");
        binding10.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]+\"/\"+dimension[\"dimension1\"][\"level12\"][\"level12\"]+data[\"total\"]"));
        binding10.setAggrFunction("MAX");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        Binding binding11 = new Binding("maxTotal2");
        binding11.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding11.setAggrFunction("MAX");
        AddingNestAggregations cubeOperation1 = new AddingNestAggregations(new IBinding[]{binding7, binding8, binding10, binding11});
        AddingNestAggregations cubeOperation2 = new AddingNestAggregations(new IBinding[]{binding9});
        cqd.addCubeOperation((ICubeOperation)cubeOperation1);
        cqd.addCubeOperation((ICubeOperation)cubeOperation2);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", new String[0]);
        this.checkOutputFile();
        cursor.close();
        engine.shutdown();
    }

    @Test
    public void testAddingNestAggregationsWithExpressionFromBindings() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("total");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("sumTotal1");
        binding7.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        Binding binding8 = new Binding("sumTotal2");
        binding8.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding8.setAggrFunction("SUM");
        binding8.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        Binding binding9 = new Binding("sumSumTotal1");
        binding9.setExpression((IBaseExpression)new ScriptExpression("data[\"sumTotal1\"]"));
        binding9.setAggrFunction("SUM");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        Binding binding10 = new Binding("maxTotal1");
        binding10.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]+\"/\"+dimension[\"dimension1\"][\"level12\"][\"level12\"]+data[\"total\"]"));
        binding10.setAggrFunction("MAX");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        Binding binding11 = new Binding("maxTotal2");
        binding11.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding11.setAggrFunction("MAX");
        cqd.addBinding((IBinding)binding7);
        cqd.addBinding((IBinding)binding8);
        cqd.addBinding((IBinding)binding9);
        cqd.addBinding((IBinding)binding10);
        cqd.addBinding((IBinding)binding11);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", new String[0]);
        this.checkOutputFile();
        cursor.close();
        engine.shutdown();
    }

    @Test
    public void testCubeRankAggregation() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("total");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("totalRankInCountry");
        binding7.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding7.setAggrFunction("RANK");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        Binding binding8 = new Binding("totalRankInCountryDesc");
        binding8.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding8.setAggrFunction("RANK");
        binding8.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding8.addArgument((IBaseExpression)new ScriptExpression("false"));
        Binding binding9 = new Binding("referRankAggr");
        binding9.setExpression((IBaseExpression)new ScriptExpression("data[\"totalRankInCountry\"]"));
        cqd.addBinding((IBinding)binding7);
        cqd.addBinding((IBinding)binding8);
        cqd.addBinding((IBinding)binding9);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCubeWithRank((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", new String[0]);
        this.checkOutputFile();
        cursor.close();
        engine.shutdown();
    }

    @Test
    public void testCubeRankAggregation2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding5.setAggrFunction("SUM");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding5.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("total");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("totalRankInCountry");
        binding7.setExpression((IBaseExpression)new ScriptExpression("data[\"measure1\"]"));
        binding7.setAggrFunction("RANK");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        ConditionalExpression expr = new ConditionalExpression("data[\"totalRankInCountry\"]", 14, "3", null);
        CubeFilterDefinition filter = new CubeFilterDefinition((IBaseExpression)expr);
        filter.setAxisQualifierLevels(new ILevelDefinition[]{level11, level12, level13});
        filter.setAxisQualifierValues(new Object[]{"CN", "BJ", "HD"});
        filter.setTargetLevel(level21);
        cqd.addFilter((IFilterDefinition)filter);
        cqd.addBinding((IBinding)binding7);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        ArrayList<String> measureList = new ArrayList<String>();
        measureList.add("measure1");
        measureList.add("totalRankInCountry");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureList, null, null, null, true);
        this.checkOutputFile();
        cursor.close();
        engine.shutdown();
    }

    @Test
    public void testValidateBinding() throws Exception {
        this.checkDuplicateBindingName();
        this.checkInexistentReference();
        this.checkReferenceCycle();
    }

    private void checkDuplicateBindingName() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("measure1");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding6);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        try {
            try {
                IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
                Assert.assertTrue((boolean)false);
            }
            catch (BirtException e) {
                Assert.assertTrue((boolean)true);
                engine.shutdown();
            }
        }
        finally {
            engine.shutdown();
        }
    }

    private void checkInexistentReference() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("test");
        binding6.setExpression((IBaseExpression)new ScriptExpression("data[\"measure1\"] + data[\"nothing\"]"));
        cqd.addBinding((IBinding)binding6);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        try {
            try {
                IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
                Assert.assertTrue((boolean)false);
            }
            catch (BirtException e) {
                Assert.assertTrue((boolean)true);
                engine.shutdown();
            }
        }
        finally {
            engine.shutdown();
        }
    }

    private void checkReferenceCycle() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("test1");
        binding6.setExpression((IBaseExpression)new ScriptExpression("data[\"measure1\"] + data[\"test2\"]"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("test2");
        binding7.setExpression((IBaseExpression)new ScriptExpression("data[\"measure1\"] + data[\"test1\"]"));
        cqd.addBinding((IBinding)binding7);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        try {
            try {
                IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
                Assert.assertTrue((boolean)false);
            }
            catch (BirtException e) {
                Assert.assertTrue((boolean)true);
                engine.shutdown();
            }
        }
        finally {
            engine.shutdown();
        }
    }

    @Test
    public void testAddingNestAggregationsBoundary() throws Exception {
        this.checkNonexistentDimensionException();
        this.checkNonexistentLevelException();
    }

    private void checkNonexistentDimensionException() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("total");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("nestTotal1");
        binding7.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension2\"][\"level11\"]");
        AddingNestAggregations cubeOperation1 = new AddingNestAggregations(new IBinding[]{binding7});
        cqd.addCubeOperation((ICubeOperation)cubeOperation1);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = null;
        try {
            cursor = queryResults.getCubeCursor();
            Assert.assertTrue((boolean)false);
        }
        catch (DataException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    private void checkNonexistentLevelException() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("total");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding6.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("nestTotal1");
        binding7.setExpression((IBaseExpression)new ScriptExpression("data[\"total\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level21\"]");
        AddingNestAggregations cubeOperation1 = new AddingNestAggregations(new IBinding[]{binding7});
        cqd.addCubeOperation((ICubeOperation)cubeOperation1);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = null;
        try {
            cursor = queryResults.getCubeCursor();
            Assert.assertTrue((boolean)false);
        }
        catch (DataException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testBasic4() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("attr21");
        binding6.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"][\"attr21\"]"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("rowGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("WEIGHTEDAVE");
        binding7.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        binding7.addArgument((IBaseExpression)new ScriptExpression("data[\"attr21\"]"));
        cqd.addBinding((IBinding)binding7);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, "rowGrandTotal", null);
        engine.shutdown();
    }

    @Test
    public void testBasic5() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IEdgeDefinition pageEdge = cqd.createEdge(3);
        IDimensionDefinition dim0 = pageEdge.createDimension("dimension1");
        IHierarchyDefinition hier0 = dim0.createHierarchy("dimension1");
        hier0.createLevel("level11");
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension2");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension2");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension3");
        hier2.createLevel("level13");
        IDimensionDefinition dim3 = rowEdge.createDimension("dimension4");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension4");
        hier3.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension4\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("attr21");
        binding6.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension4\"][\"level21\"][\"attr21\"]"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("rowGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("WEIGHTEDAVE");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension4\"][\"level21\"]");
        binding7.addArgument((IBaseExpression)new ScriptExpression("data[\"attr21\"]"));
        cqd.addBinding((IBinding)binding7);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube1(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> pageEdgeBindingNames = new ArrayList<String>();
        pageEdgeBindingNames.add("edge1level1");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCubeWithPage((CubeCursor)cursor, pageEdgeBindingNames, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, "rowGrandTotal", null);
        engine.shutdown();
    }

    @Test
    public void testBasic6() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IEdgeDefinition pageEdge = cqd.createEdge(3);
        IDimensionDefinition dim0 = pageEdge.createDimension("dimension1");
        IHierarchyDefinition hier0 = dim0.createHierarchy("dimension1");
        hier0.createLevel("level11");
        IDimensionDefinition dim1 = pageEdge.createDimension("dimension2");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension2");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = columnEdge.createDimension("dimension3");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension3");
        hier2.createLevel("level13");
        IDimensionDefinition dim3 = rowEdge.createDimension("dimension4");
        IHierarchyDefinition hier3 = dim3.createHierarchy("dimension4");
        hier3.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension3\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension4\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("attr21");
        binding6.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension4\"][\"level21\"][\"attr21\"]"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("rowGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("WEIGHTEDAVE");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension2\"][\"level12\"]");
        binding7.addAggregateOn("dimension[\"dimension4\"][\"level21\"]");
        binding7.addArgument((IBaseExpression)new ScriptExpression("data[\"attr21\"]"));
        cqd.addBinding((IBinding)binding7);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube1(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> pageEdgeBindingNames = new ArrayList<String>();
        pageEdgeBindingNames.add("edge1level1");
        pageEdgeBindingNames.add("edge1level2");
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCubeWithPage((CubeCursor)cursor, pageEdgeBindingNames, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, "rowGrandTotal", null);
        engine.shutdown();
    }

    @Test
    public void testInvalidBinding() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"bad\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"bad\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"bad\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        binding6.addArgument((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"][\"attr21\"]"));
        cqd.addBinding((IBinding)binding6);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        try {
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults queryResults = pcq.execute(null);
            queryResults.getCubeCursor();
            Assert.fail((String)"Should not arrive here");
        }
        catch (Exception exception) {
            // empty catch block
        }
        engine.shutdown();
    }

    @Test
    public void testFilter1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level11\"]", 1, "\"CN\""));
        cqd.addFilter((IFilterDefinition)filter);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testDimensionQuery1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level11\"]", 1, "\"CN\""));
        cqd.addFilter((IFilterDefinition)filter);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        ArrayList rowEdgeBindingNames = new ArrayList();
        columnEdgeBindingNames.add("edge1level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, null);
        engine.shutdown();
    }

    @Test
    public void testDimensionQuery2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        ArrayList rowEdgeBindingNames = new ArrayList();
        columnEdgeBindingNames.add("edge1level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, null);
        engine.shutdown();
    }

    @Test
    public void testDimensionQuery3() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level11\"]", 1, "\"CN\""));
        cqd.addFilter((IFilterDefinition)filter);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        ArrayList rowEdgeBindingNames = new ArrayList();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, null);
        engine.shutdown();
    }

    @Test
    public void testFilter2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        FilterDefinition filter1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level11\"]", 1, "\"CN\""));
        FilterDefinition filter2 = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension2\"][\"level21\"]", 5, "2000"));
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter3() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        FilterDefinition filter1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("data[\"edge1level1\"]", 1, "\"CN\""));
        FilterDefinition filter2 = new FilterDefinition((IBaseExpression)new ConditionalExpression("data[\"edge2level1\"]", 5, "2000"));
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter4() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        FilterDefinition filter1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("data[\"edge1level1\"]", 1, "\"CNK\""));
        cqd.addFilter((IFilterDefinition)filter1);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        try {
            this.createCube(engine);
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults queryResults = pcq.execute(null);
            queryResults.getCubeCursor();
        }
        catch (Exception e) {
            Assert.fail((String)"Should not arrive here");
        }
        engine.shutdown();
    }

    @Test
    public void testFilter5() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        CubeFilterDefinition filter = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level11\"]", 1, "\"US\""));
        cqd.addFilter((IFilterDefinition)filter);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter6() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level11\"]", 1, "\"US\""));
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level12\"]", 1, "\"CS\""));
        CubeFilterDefinition filter3 = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("data[\"measure1\"]", 5, "38.0"));
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        cqd.addFilter((IFilterDefinition)filter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter7() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        ArrayList<ScriptExpression> exprs = new ArrayList<ScriptExpression>();
        exprs.add(new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        exprs.add(new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        ArrayList targets = new ArrayList();
        ArrayList<ScriptExpression> CNBJ = new ArrayList<ScriptExpression>();
        CNBJ.add(new ScriptExpression("\"CN\""));
        CNBJ.add(new ScriptExpression("\"BJ\""));
        ArrayList<ScriptExpression> JPTK = new ArrayList<ScriptExpression>();
        JPTK.add(new ScriptExpression("\"JP\""));
        JPTK.add(new ScriptExpression("\"TK\""));
        targets.add(CNBJ);
        targets.add(JPTK);
        CollectionConditionalExpression filterExpr = new CollectionConditionalExpression(exprs, 22, targets);
        FilterDefinition filter = new FilterDefinition((IBaseExpression)filterExpr);
        cqd.addFilter((IFilterDefinition)filter);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter8() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        ArrayList<ScriptExpression> exprs = new ArrayList<ScriptExpression>();
        exprs.add(new ScriptExpression("data[\"edge1level1\"]"));
        exprs.add(new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        ArrayList targets = new ArrayList();
        ArrayList<ScriptExpression> CNBJ = new ArrayList<ScriptExpression>();
        CNBJ.add(new ScriptExpression("\"CN\""));
        CNBJ.add(new ScriptExpression("\"BJ\""));
        ArrayList<ScriptExpression> JPTK = new ArrayList<ScriptExpression>();
        JPTK.add(new ScriptExpression("\"JP\""));
        JPTK.add(new ScriptExpression("\"TK\""));
        targets.add(CNBJ);
        targets.add(JPTK);
        CollectionConditionalExpression filterExpr = new CollectionConditionalExpression(exprs, 23, targets);
        FilterDefinition filter = new FilterDefinition((IBaseExpression)filterExpr);
        cqd.addFilter((IFilterDefinition)filter);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter9() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"rowGrandTotal\"] > 420"));
        filter1.setAxisQualifierLevels(null);
        filter1.setAxisQualifierValues(null);
        filter1.setTargetLevel(level21);
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"derived1\"] > 0.5"));
        filter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter2.setAxisQualifierValues(new Object[]{"2000"});
        filter2.setTargetLevel(level12);
        CubeFilterDefinition filter3 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"country_year_total\"] < 300"));
        filter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter3.setAxisQualifierValues(new Object[]{"2002"});
        filter3.setTargetLevel(level11);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addFilter((IFilterDefinition)filter2);
        DataEngineContext context = this.createPresentationContext();
        context.setTmpdir(CubeFeaturesTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter10() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"derived2\"] < 0.3"));
        filter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter2.setTargetLevel(level12);
        cqd.addFilter((IFilterDefinition)filter2);
        DataEngineContext context = this.createPresentationContext();
        context.setTmpdir(CubeFeaturesTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter11() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"derived1\"] > 0.3"));
        filter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter2.setAxisQualifierValues(new Object[]{"2000"});
        filter2.setTargetLevel(level12);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("data[\"derived2\"]");
        sorter4.setTargetLevel(level12);
        sorter4.setSortDirection(0);
        cqd.addFilter((IFilterDefinition)filter2);
        cqd.addSort((ISortDefinition)sorter4);
        DataEngineContext context = this.createPresentationContext();
        context.setTmpdir(CubeFeaturesTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter12() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"rowGrandTotal\"] > 420"));
        filter1.setAxisQualifierLevels(null);
        filter1.setAxisQualifierValues(null);
        filter1.setTargetLevel(level21);
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"derived1\"] > 0.3"));
        filter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter2.setAxisQualifierValues(new Object[]{"2000"});
        filter2.setTargetLevel(level12);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("data[\"derived2\"]");
        sorter4.setTargetLevel(level12);
        sorter4.setSortDirection(0);
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        cqd.addSort((ISortDefinition)sorter4);
        DataEngineContext context = this.createPresentationContext();
        context.setTmpdir(CubeFeaturesTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter13() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        Binding binding = new Binding("derivedBinding");
        binding.setExpression((IBaseExpression)new ScriptExpression("if( data[\"edge1level1\"].equals(\"CN\")) \"profit\"; else \"lose\";"));
        cqd.addBinding((IBinding)binding);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"derivedBinding\"] ==\"profit\""));
        filter1.setAxisQualifierLevels(new ILevelDefinition[]{level11, level12, level13});
        filter1.setAxisQualifierValues(new Object[]{"CN", "SH", "PD"});
        filter1.setTargetLevel(level21);
        cqd.addFilter((IFilterDefinition)filter1);
        DataEngineContext context = this.createPresentationContext();
        context.setTmpdir(CubeFeaturesTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrFilter() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"rowGrandTotal\"] > 420"));
        filter1.setAxisQualifierLevels(null);
        filter1.setAxisQualifierValues(null);
        filter1.setTargetLevel(level21);
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"city_year_total\"] < 65"));
        filter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter2.setAxisQualifierValues(new Object[]{"2002"});
        filter2.setTargetLevel(level12);
        CubeFilterDefinition filter3 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"country_year_total\"] < 300"));
        filter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter3.setAxisQualifierValues(new Object[]{"2002"});
        filter3.setTargetLevel(level11);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        cqd.addFilter((IFilterDefinition)filter3);
        cqd.addSort((ISortDefinition)sorter4);
        cqd.addSort((ISortDefinition)sorter5);
        DataEngineContext context = this.createPresentationContext();
        context.setTmpdir(CubeFeaturesTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrFilter1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"rowGrandTotal\"] > 420"));
        filter1.setAxisQualifierLevels(null);
        filter1.setAxisQualifierValues(null);
        filter1.setTargetLevel(level21);
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"country_year_total\"] != 120"));
        filter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter2.setAxisQualifierValues(new Object[]{"2002"});
        filter2.setTargetLevel(level11);
        CubeFilterDefinition filter3 = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("data[\"country_year_total\"]", 16, "50"));
        filter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter3.setAxisQualifierValues(new Object[]{"2002"});
        filter3.setTargetLevel(level11);
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        cqd.addFilter((IFilterDefinition)filter3);
        DataEngineContext context = this.createPresentationContext();
        context.setTmpdir(CubeFeaturesTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrFilter2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension2\"][\"level21\"]", 15, "3"));
        filter1.setTargetLevel(level21);
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level12\"]", 14, "2"));
        filter2.setTargetLevel(level12);
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        DataEngineContext context = this.createPresentationContext();
        context.setTmpdir(CubeFeaturesTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testMeasureFilter() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"city_year_total\"] > 30"));
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"country_year_total\"] > 100"));
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testMeasureFilter1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("data[\"measure1\"]", 15, "10"));
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("data[\"rowGrandTotal\"]", 16, "20"));
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testSort1() throws Exception {
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        CubeSortDefinition sorter = new CubeSortDefinition();
        sorter.setExpression("dimension[\"dimension2\"][\"level21\"]");
        sorter.setSortDirection(1);
        sorter.setTargetLevel(level21);
        cqd.addSort((ISortDefinition)sorter);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testSort2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("dimension[\"dimension2\"][\"level21\"]");
        sorter1.setSortDirection(1);
        sorter1.setTargetLevel(level21);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter2.setSortDirection(1);
        sorter2.setTargetLevel(level11);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("dimension[\"dimension1\"][\"level12\"]");
        sorter3.setSortDirection(1);
        sorter3.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testSort3() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"edge2level1\"]");
        sorter1.setSortDirection(1);
        sorter1.setTargetLevel(level21);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("data[\"edge1level1\"]");
        sorter2.setSortDirection(1);
        sorter2.setTargetLevel(level11);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("data[\"edge1level2\"]");
        sorter3.setSortDirection(1);
        sorter3.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testSort4() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("data[\"derived2\"]");
        sorter4.setSortDirection(0);
        sorter4.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter4);
        DataEngineContext context = this.createPresentationContext();
        context.setTmpdir(CubeFeaturesTest.getTempDir());
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testSortWithExpr() throws Exception {
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        CubeSortDefinition sorter = new CubeSortDefinition();
        sorter.setExpression("dimension[\"dimension2\"][\"level21\"]-1");
        sorter.setSortDirection(1);
        sorter.setTargetLevel(level21);
        cqd.addSort((ISortDefinition)sorter);
        sorter = new CubeSortDefinition();
        sorter.setExpression("dimension[\"dimension1\"][\"level12\"]+\"T\"");
        sorter.setSortDirection(1);
        sorter.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testSortWithExpr1() throws Exception {
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        CubeSortDefinition sorter = new CubeSortDefinition();
        sorter.setExpression("dimension[\"dimension2\"][\"level21\"][\"attr21\"]");
        sorter.setSortDirection(1);
        sorter.setTargetLevel(level21);
        cqd.addSort((ISortDefinition)sorter);
        sorter = new CubeSortDefinition();
        sorter.setExpression("dimension[\"dimension2\"][\"level21\"]+1");
        sorter.setSortDirection(0);
        sorter.setTargetLevel(level21);
        cqd.addSort((ISortDefinition)sorter);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testSortWithExpr2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"country_year_total\"]");
        sorter1.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter1.setAxisQualifierValues(new Object[]{"2002"});
        sorter1.setTargetLevel(level11);
        sorter1.setSortDirection(0);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("dimension[\"dimension2\"][\"level21\"]-1");
        sorter2.setTargetLevel(level21);
        sorter2.setSortDirection(1);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("dimension[\"dimension1\"][\"level11\"]+1");
        sorter3.setTargetLevel(level11);
        sorter3.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testSortWithExpr3() throws Exception {
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("level21attr21");
        binding5.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"][\"attr21\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("measure1");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding6);
        CubeSortDefinition sorter = new CubeSortDefinition();
        sorter.setExpression("data[\"level21attr21\"]");
        sorter.setSortDirection(1);
        sorter.setTargetLevel(level21);
        cqd.addSort((ISortDefinition)sorter);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testGrandTotal() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("columnGrandTotal");
        binding7.addArgument((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("grandTotal");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding8.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding8);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("dimension[\"dimension2\"][\"level21\"]");
        sorter1.setSortDirection(1);
        sorter1.setTargetLevel(level21);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter2.setSortDirection(1);
        sorter2.setTargetLevel(level11);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("dimension[\"dimension1\"][\"level12\"]");
        sorter3.setSortDirection(1);
        sorter3.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", "columnGrandTotal", "rowGrandTotal", "grandTotal");
        engine.shutdown();
    }

    @Test
    public void testQueryWithoutEdge() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding = new Binding("grandTotal");
        binding.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        Object o = cursor.getObject("grandTotal");
        Assert.assertEquals((Object)"2146.0", (Object)o.toString());
        cursor.close();
        engine.shutdown();
    }

    @Test
    public void testGrandTotal1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        binding6.setFilter((IBaseExpression)new ScriptExpression("measure[\"measure1\"] > 60"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("columnGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding7.setFilter((IBaseExpression)new ScriptExpression("measure[\"measure1\"] > 60"));
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("grandTotal");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding8.setAggrFunction("SUM");
        binding8.setFilter((IBaseExpression)new ScriptExpression("measure[\"measure1\"] > 60"));
        cqd.addBinding((IBinding)binding8);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("dimension[\"dimension2\"][\"level21\"]");
        sorter1.setSortDirection(1);
        sorter1.setTargetLevel(level21);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter2.setSortDirection(1);
        sorter2.setTargetLevel(level11);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("dimension[\"dimension1\"][\"level12\"]");
        sorter3.setSortDirection(1);
        sorter3.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", "columnGrandTotal", "rowGrandTotal", "grandTotal");
        engine.shutdown();
    }

    @Test
    public void testAggrSort() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"rowGrandTotal\"]");
        sorter1.setAxisQualifierLevels(null);
        sorter1.setAxisQualifierValues(null);
        sorter1.setTargetLevel(level21);
        sorter1.setSortDirection(1);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("data[\"city_year_total\"]");
        sorter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter2.setAxisQualifierValues(new Object[]{"2002"});
        sorter2.setTargetLevel(level12);
        sorter2.setSortDirection(1);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("data[\"country_year_total\"]");
        sorter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter3.setAxisQualifierValues(new Object[]{"2002"});
        sorter3.setTargetLevel(level11);
        sorter3.setSortDirection(1);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        cqd.addSort((ISortDefinition)sorter4);
        cqd.addSort((ISortDefinition)sorter5);
        DataEngineContext context = this.createPresentationContext();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    private DataEngineContext createPresentationContext() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(CubeFeaturesTest.getTempDir());
        return context;
    }

    @Test
    public void testAggrSort1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"rowGrandTotal\"]");
        sorter1.setAxisQualifierLevels(null);
        sorter1.setAxisQualifierValues(null);
        sorter1.setTargetLevel(level21);
        sorter1.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrSort2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"rowGrandTotal\"]");
        sorter1.setAxisQualifierLevels(null);
        sorter1.setAxisQualifierValues(null);
        sorter1.setTargetLevel(level21);
        sorter1.setSortDirection(1);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("data[\"city_year_total\"]");
        sorter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter2.setAxisQualifierValues(new Object[]{"2002"});
        sorter2.setTargetLevel(level12);
        sorter2.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrSort3() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"rowGrandTotal\"]");
        sorter1.setAxisQualifierLevels(null);
        sorter1.setAxisQualifierValues(null);
        sorter1.setTargetLevel(level21);
        sorter1.setSortDirection(1);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("data[\"city_year_total\"]");
        sorter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter2.setAxisQualifierValues(new Object[]{"2002"});
        sorter2.setTargetLevel(level12);
        sorter2.setSortDirection(1);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("data[\"country_year_total\"]");
        sorter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter3.setAxisQualifierValues(new Object[]{"2002"});
        sorter3.setTargetLevel(level11);
        sorter3.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrSort5() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"measure1\"]");
        sorter1.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter1.setAxisQualifierValues(new Object[]{"1998"});
        sorter1.setTargetLevel(level13);
        sorter1.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrSort6() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"rowGrandTotal\"]");
        sorter1.setAxisQualifierLevels(null);
        sorter1.setAxisQualifierValues(null);
        sorter1.setTargetLevel(level21);
        sorter1.setSortDirection(1);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("data[\"country_year_total\"]");
        sorter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter2.setAxisQualifierValues(new Object[]{"2002"});
        sorter2.setTargetLevel(level11);
        sorter2.setSortDirection(0);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("data[\"country_year_total\"]");
        sorter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter3.setAxisQualifierValues(new Object[]{"2001"});
        sorter3.setTargetLevel(level11);
        sorter3.setSortDirection(0);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testBindingRowReference() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("columnGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("grandTotal");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding8.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding8);
        Binding binding9 = new Binding("row_rowGrandTotal");
        binding9.setExpression((IBaseExpression)new ScriptExpression("data[\"rowGrandTotal\"]*10"));
        cqd.addBinding((IBinding)binding9);
        Binding binding10 = new Binding("row_columnGrandTotal");
        binding10.setExpression((IBaseExpression)new ScriptExpression("data[\"columnGrandTotal\"]*10"));
        cqd.addBinding((IBinding)binding10);
        Binding binding11 = new Binding("row_grandTotal");
        binding11.setExpression((IBaseExpression)new ScriptExpression("data[\"grandTotal\"]*10"));
        cqd.addBinding((IBinding)binding11);
        Binding binding12 = new Binding("row_measure1");
        binding12.setExpression((IBaseExpression)new ScriptExpression("data[\"measure1\"]*10"));
        cqd.addBinding((IBinding)binding12);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("dimension[\"dimension2\"][\"level21\"]");
        sorter1.setSortDirection(1);
        sorter1.setTargetLevel(level21);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter2.setSortDirection(1);
        sorter2.setTargetLevel(level11);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("dimension[\"dimension1\"][\"level12\"]");
        sorter3.setSortDirection(1);
        sorter3.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "row_measure1", "row_columnGrandTotal", "row_rowGrandTotal", "row_grandTotal");
        engine.shutdown();
    }

    @Test
    public void testComputedMeasure() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createComputedMeasure("measure2", 3, (IBaseExpression)new ScriptExpression("measure[\"measure1\"] + measure[\"measure1\"]"));
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure2");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure2\"]"));
        binding5.setAggrFunction("SUM");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding5.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure2");
        engine.shutdown();
    }

    @Test
    public void testNestedComputedMeasure() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createComputedMeasure("measure2", 3, (IBaseExpression)new ScriptExpression("measure[\"measure1\"] + measure[\"measure3\"]"));
        cqd.createComputedMeasure("measure3", 3, (IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure2");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure2\"]"));
        binding5.setAggrFunction("SUM");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding5.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure2");
        engine.shutdown();
    }

    @Test
    public void testGrandTotalWithComputedMeasure() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        cqd.createComputedMeasure("measure2", 3, (IBaseExpression)new ScriptExpression("measure[\"measure1\"] + measure[\"measure3\"]"));
        cqd.createComputedMeasure("measure3", 3, (IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure2");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure2\"]"));
        binding5.setAggrFunction("SUM");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding5.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure2\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("columnGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure2\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("grandTotal");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure2\"]"));
        binding8.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding8);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("dimension[\"dimension2\"][\"level21\"]");
        sorter1.setSortDirection(1);
        sorter1.setTargetLevel(level21);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter2.setSortDirection(1);
        sorter2.setTargetLevel(level11);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("dimension[\"dimension1\"][\"level12\"]");
        sorter3.setSortDirection(1);
        sorter3.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure2", "columnGrandTotal", "rowGrandTotal", "grandTotal");
        engine.shutdown();
    }

    @Test
    public void testInvalidComputedMeasure1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createComputedMeasure("measure1", 3, (IBaseExpression)new ScriptExpression("measure[\"measure1\"] + measure[\"measure1\"]"));
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure2");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        try {
            queryResults.getCubeCursor();
            Assert.fail((String)"Should not arrive here");
        }
        catch (Exception exception) {
            // empty catch block
        }
        engine.shutdown();
    }

    @Test
    public void testBasicCache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testBasic1Cache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testTwoCaches() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        IPreparedCubeQuery pcq1 = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults1 = pcq1.execute(null);
        ICubeCursor cursor1 = queryResults1.getCubeCursor();
        cqd.setQueryResultsID(null);
        IPreparedCubeQuery pcq2 = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults2 = pcq2.execute(null);
        ICubeCursor cursor2 = queryResults2.getCubeCursor();
        cqd.setQueryResultsID(queryResults1.getID());
        pcq1 = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults1 = pcq1.execute(null);
        cursor1 = queryResults1.getCubeCursor();
        cqd.setQueryResultsID(queryResults2.getID());
        pcq2 = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults2 = pcq2.execute(null);
        cursor2 = queryResults2.getCubeCursor();
        this.printCube((CubeCursor)cursor1, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, null, null, false);
        this.printCube((CubeCursor)cursor2, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", null, null, null, true);
        engine.shutdown();
    }

    @Test
    public void testFilter1Cache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        FilterDefinition filter = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level11\"]", 1, "\"CN\""));
        cqd.addFilter((IFilterDefinition)filter);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testFilter2Cache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        FilterDefinition filter1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level11\"]", 1, "\"CN\""));
        FilterDefinition filter2 = new FilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension2\"][\"level21\"]", 5, "2000"));
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testSort1Cache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        CubeSortDefinition sorter = new CubeSortDefinition();
        sorter.setExpression("dimension[\"dimension2\"][\"level21\"]");
        sorter.setSortDirection(1);
        sorter.setTargetLevel(level21);
        cqd.addSort((ISortDefinition)sorter);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testSort2Cache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("dimension[\"dimension2\"][\"level21\"]");
        sorter1.setSortDirection(1);
        sorter1.setTargetLevel(level21);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter2.setSortDirection(1);
        sorter2.setTargetLevel(level11);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("dimension[\"dimension1\"][\"level12\"]");
        sorter3.setSortDirection(1);
        sorter3.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testGrandTotalCache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("columnGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("grandTotal");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding8.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding8);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("dimension[\"dimension2\"][\"level21\"]");
        sorter1.setSortDirection(1);
        sorter1.setTargetLevel(level21);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter2.setSortDirection(1);
        sorter2.setTargetLevel(level11);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("dimension[\"dimension1\"][\"level12\"]");
        sorter3.setSortDirection(1);
        sorter3.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1", "columnGrandTotal", "rowGrandTotal", "grandTotal");
        engine.shutdown();
    }

    @Test
    public void testAggrSortCache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"rowGrandTotal\"]");
        sorter1.setAxisQualifierLevels(null);
        sorter1.setAxisQualifierValues(null);
        sorter1.setTargetLevel(level21);
        sorter1.setSortDirection(1);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("data[\"city_year_total\"]");
        sorter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter2.setAxisQualifierValues(new Object[]{"2002"});
        sorter2.setTargetLevel(level12);
        sorter2.setSortDirection(1);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("data[\"country_year_total\"]");
        sorter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter3.setAxisQualifierValues(new Object[]{"2002"});
        sorter3.setTargetLevel(level11);
        sorter3.setSortDirection(1);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        cqd.addSort((ISortDefinition)sorter4);
        cqd.addSort((ISortDefinition)sorter5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrSort1Cache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"rowGrandTotal\"]");
        sorter1.setAxisQualifierLevels(null);
        sorter1.setAxisQualifierValues(null);
        sorter1.setTargetLevel(level21);
        sorter1.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrSort2Cache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"rowGrandTotal\"]");
        sorter1.setAxisQualifierLevels(null);
        sorter1.setAxisQualifierValues(null);
        sorter1.setTargetLevel(level21);
        sorter1.setSortDirection(1);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("data[\"city_year_total\"]");
        sorter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter2.setAxisQualifierValues(new Object[]{"2002"});
        sorter2.setTargetLevel(level12);
        sorter2.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrSort3Cache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"rowGrandTotal\"]");
        sorter1.setAxisQualifierLevels(null);
        sorter1.setAxisQualifierValues(null);
        sorter1.setTargetLevel(level21);
        sorter1.setSortDirection(1);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("data[\"city_year_total\"]");
        sorter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter2.setAxisQualifierValues(new Object[]{"2002"});
        sorter2.setTargetLevel(level12);
        sorter2.setSortDirection(1);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("data[\"country_year_total\"]");
        sorter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter3.setAxisQualifierValues(new Object[]{"2002"});
        sorter3.setTargetLevel(level11);
        sorter3.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testAggrSort5Cache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("data[\"measure1\"]");
        sorter1.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        sorter1.setAxisQualifierValues(new Object[]{"1998"});
        sorter1.setTargetLevel(level13);
        sorter1.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter1);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1");
        engine.shutdown();
    }

    @Test
    public void testBindingRowReferenceCache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("columnGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("grandTotal");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding8.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding8);
        Binding binding9 = new Binding("row_rowGrandTotal");
        binding9.setExpression((IBaseExpression)new ScriptExpression("data[\"rowGrandTotal\"]*10"));
        cqd.addBinding((IBinding)binding9);
        Binding binding10 = new Binding("row_columnGrandTotal");
        binding10.setExpression((IBaseExpression)new ScriptExpression("data[\"columnGrandTotal\"]*10"));
        cqd.addBinding((IBinding)binding10);
        Binding binding11 = new Binding("row_grandTotal");
        binding11.setExpression((IBaseExpression)new ScriptExpression("data[\"grandTotal\"]*10"));
        cqd.addBinding((IBinding)binding11);
        Binding binding12 = new Binding("row_measure1");
        binding12.setExpression((IBaseExpression)new ScriptExpression("data[\"measure1\"]*10"));
        cqd.addBinding((IBinding)binding12);
        CubeSortDefinition sorter1 = new CubeSortDefinition();
        sorter1.setExpression("dimension[\"dimension2\"][\"level21\"]");
        sorter1.setSortDirection(1);
        sorter1.setTargetLevel(level21);
        CubeSortDefinition sorter2 = new CubeSortDefinition();
        sorter2.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter2.setSortDirection(1);
        sorter2.setTargetLevel(level11);
        CubeSortDefinition sorter3 = new CubeSortDefinition();
        sorter3.setExpression("dimension[\"dimension1\"][\"level12\"]");
        sorter3.setSortDirection(1);
        sorter3.setTargetLevel(level12);
        cqd.addSort((ISortDefinition)sorter1);
        cqd.addSort((ISortDefinition)sorter2);
        cqd.addSort((ISortDefinition)sorter3);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "row_measure1", "row_columnGrandTotal", "row_rowGrandTotal", "row_grandTotal");
        engine.shutdown();
    }

    @Test
    public void testComputedMeasureCache() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createComputedMeasure("measure2", 3, (IBaseExpression)new ScriptExpression("measure[\"measure1\"] + measure[\"measure1\"]"));
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure2");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure2\"]"));
        binding5.setAggrFunction("SUM");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding5.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        cqd.setQueryResultsID(queryResults.getID());
        pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        queryResults = pcq.execute(null);
        cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure2");
        engine.shutdown();
    }

    @Test
    public void testAggregationOnCalculatedMeasure() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createMeasure("measure1");
        cqd.createDerivedMeasure("measure2", 3, (IBaseExpression)new ScriptExpression("measure[\"measure1\"] + measure[\"measure1\"]"));
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure2");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure2\"]"));
        binding5.setAggrFunction("SUM");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding5.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("aggregationOnMeasure2");
        binding6.setExpression((IBaseExpression)new ScriptExpression("data[\"measure2\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding6);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure2", null, "aggregationOnMeasure2", null);
        engine.shutdown();
    }

    @Test
    public void testAggregationOnDerivedMeasure() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        cqd.createMeasure("measure1");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding5.setAggrFunction("SUM");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding5.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("derivedMeasure");
        binding6.setExpression((IBaseExpression)new ScriptExpression("data[\"measure1\"]+100"));
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("aggregationOnMeasure");
        binding7.setExpression((IBaseExpression)new ScriptExpression("data[\"derivedMeasure\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding7);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        cqd.setCacheQueryResults(true);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "derivedMeasure", null, "aggregationOnMeasure", null);
        engine.shutdown();
    }

    @Test
    public void testNestedCrossTab() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"rowGrandTotal\"] > 420"));
        filter1.setAxisQualifierLevels(null);
        filter1.setAxisQualifierValues(null);
        filter1.setTargetLevel(level21);
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"city_year_total\"] == data._outer[\"column1\"]"));
        filter2.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter2.setAxisQualifierValues(new Object[]{"2002"});
        filter2.setTargetLevel(level12);
        CubeFilterDefinition filter3 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"country_year_total\"] < 300"));
        filter3.setAxisQualifierLevels(new ILevelDefinition[]{level21});
        filter3.setAxisQualifierValues(new Object[]{"2002"});
        filter3.setTargetLevel(level11);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        cqd.addFilter((IFilterDefinition)filter3);
        cqd.addSort((ISortDefinition)sorter4);
        cqd.addSort((ISortDefinition)sorter5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        this.defineDataSourceDataSet((DataEngine)engine);
        IQueryDefinition query = this.createScriptDataSetQuery();
        IPreparedQuery pq = engine.prepare(query);
        IQueryResults queryResults = pq.execute(null);
        IResultIterator it = queryResults.getResultIterator();
        while (it.next()) {
            if (((Number)it.getValue("column1")).intValue() != 55 && ((Number)it.getValue("column1")).intValue() != 34) continue;
            this.testPrintln("\nOUTER RESULT:" + it.getValue("column1").toString());
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults cqResults = pcq.execute((IBaseQueryResults)queryResults, null);
            ICubeCursor cursor = cqResults.getCubeCursor();
            ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
            columnEdgeBindingNames.add("edge1level1");
            columnEdgeBindingNames.add("edge1level2");
            columnEdgeBindingNames.add("edge1level3");
            this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1", false);
        }
        this.checkOutputFile();
        engine.shutdown();
    }

    @Test
    public void testNestedCrossTab1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"measure1\"] > data._outer[\"column1\"]"));
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addSort((ISortDefinition)sorter4);
        cqd.addSort((ISortDefinition)sorter5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        this.defineDataSourceDataSet((DataEngine)engine);
        IQueryDefinition query = this.createScriptDataSetQuery();
        IPreparedQuery pq = engine.prepare(query);
        IQueryResults queryResults = pq.execute(null);
        IResultIterator it = queryResults.getResultIterator();
        while (it.next()) {
            if (((Number)it.getValue("column1")).intValue() != 55 && ((Number)it.getValue("column1")).intValue() != 34) continue;
            this.testPrintln("\nOUTER RESULT:" + it.getValue("column1").toString());
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults cqResults = pcq.execute((IBaseQueryResults)queryResults, null);
            ICubeCursor cursor = cqResults.getCubeCursor();
            ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
            columnEdgeBindingNames.add("edge1level1");
            columnEdgeBindingNames.add("edge1level2");
            columnEdgeBindingNames.add("edge1level3");
            this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1", false);
        }
        this.checkOutputFile();
        engine.shutdown();
    }

    @Test
    public void testNestedCrossTab2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter4);
        cqd.addSort((ISortDefinition)sorter5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults cqResults = pcq.execute(null);
        ICubeCursor outerCursor = cqResults.getCubeCursor();
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("data[\"edge1level3\"]", 1, "data._outer[\"edge1level3\"]"));
        filter1.setTargetLevel(level13);
        cqd.addFilter((IFilterDefinition)filter1);
        Binding out = new Binding("out");
        out.setExpression((IBaseExpression)new ScriptExpression("data._outer[\"edge1level3\"]"));
        cqd.addBinding((IBinding)out);
        int depth = 0;
        EdgeCursor edge1 = (EdgeCursor)outerCursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = (EdgeCursor)outerCursor.getOrdinateEdge().get(1);
        edge1.beforeFirst();
        block0: while (edge2.next()) {
            if (depth > 5) break;
            edge1.beforeFirst();
            while (edge1.next()) {
                if (++depth > 5) continue block0;
                this.testPrintln("\nOUTER RESULT:" + outerCursor.getObject("edge1level3").toString());
                IPreparedCubeQuery pcq1 = engine.prepare((ICubeQueryDefinition)cqd, null);
                ICubeQueryResults cqResults1 = pcq1.execute((IBaseQueryResults)cqResults, null);
                ICubeCursor cursor = cqResults1.getCubeCursor();
                this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1", false);
                this.testPrintln("\nout:" + String.valueOf(cursor.getObject("out")));
            }
        }
        this.checkOutputFile();
        engine.shutdown();
    }

    @Test
    public void testNestedCrossTab3() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addSort((ISortDefinition)sorter4);
        cqd.addSort((ISortDefinition)sorter5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults cqResults = pcq.execute(null);
        ICubeCursor outerCursor = cqResults.getCubeCursor();
        this.defineDataSourceDataSet((DataEngine)engine);
        IQueryDefinition query = this.createScriptDataSetQuery();
        query.getFilters().add(new FilterDefinition((IBaseExpression)new ScriptExpression("row.column1 == row._outer[\"measure1\"]")));
        IPreparedQuery pq = engine.prepare(query);
        int depth = 0;
        EdgeCursor edge1 = (EdgeCursor)outerCursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = (EdgeCursor)outerCursor.getOrdinateEdge().get(1);
        edge1.beforeFirst();
        while (edge2.next()) {
            edge1.beforeFirst();
            while (edge1.next()) {
                ++depth;
                this.testPrintln("\nOUTER RESULT:" + outerCursor.getObject("measure1").toString());
                IResultIterator it = pq.execute((IBaseQueryResults)cqResults, null).getResultIterator();
                while (it.next()) {
                    this.testPrintln("\n    INNER RESULT:" + it.getString("column1"));
                }
            }
        }
        this.checkOutputFile();
        engine.shutdown();
    }

    @Test
    public void testNestedCrossTab4() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"measure1\"] > data._outer._outer[\"column1\"]"));
        CubeSortDefinition sorter4 = new CubeSortDefinition();
        sorter4.setExpression("dimension[\"dimension1\"][\"level13\"]");
        sorter4.setAxisQualifierLevels(null);
        sorter4.setAxisQualifierValues(null);
        sorter4.setTargetLevel(level13);
        sorter4.setSortDirection(1);
        CubeSortDefinition sorter5 = new CubeSortDefinition();
        sorter5.setExpression("dimension[\"dimension1\"][\"level11\"]");
        sorter5.setAxisQualifierLevels(null);
        sorter5.setAxisQualifierValues(null);
        sorter5.setTargetLevel(level11);
        sorter5.setSortDirection(1);
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addSort((ISortDefinition)sorter4);
        cqd.addSort((ISortDefinition)sorter5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        this.defineDataSourceDataSet((DataEngine)engine);
        IQueryDefinition query = this.createScriptDataSetQuery();
        SubqueryDefinition subQuery = new SubqueryDefinition("Test", (IBaseQueryDefinition)query);
        subQuery.setApplyOnGroupFlag(false);
        subQuery.addBinding((IBinding)new Binding("TestBinding", (IBaseExpression)new ScriptExpression("row._outer.column1")));
        ((QueryDefinition)query).addSubquery(subQuery);
        IPreparedQuery pq = engine.prepare(query);
        IQueryResults queryResults = pq.execute(null);
        IResultIterator it = queryResults.getResultIterator();
        while (it.next()) {
            IResultIterator subIt = it.getSecondaryIterator("Test", null);
            IQueryResults subQueryResults = subIt.getQueryResults();
            while (subIt.next()) {
                if (((Number)it.getValue("column1")).intValue() != 55 && ((Number)it.getValue("column1")).intValue() != 34) continue;
                this.testPrintln("\nOUTER RESULT:" + subIt.getValue("column1").toString());
                IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
                ICubeQueryResults cqResults = pcq.execute((IBaseQueryResults)subQueryResults, null);
                ICubeCursor cursor = cqResults.getCubeCursor();
                ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
                columnEdgeBindingNames.add("edge1level1");
                columnEdgeBindingNames.add("edge1level2");
                columnEdgeBindingNames.add("edge1level3");
                this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level3"}, "edge2level1", "measure1", false);
            }
        }
        this.checkOutputFile();
        engine.shutdown();
    }

    @Test
    public void testNestedCrossTab5() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding5.setAggrFunction("SUM");
        binding5.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("columnGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("grandTotal");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding8.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding8);
        Binding binding9 = new Binding("country_year_total");
        binding9.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding9.setAggrFunction("SUM");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding9.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding9);
        Binding binding10 = new Binding("city_year_total");
        binding10.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding10.setAggrFunction("SUM");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding10.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding10);
        Binding binding11 = new Binding("dist_total");
        binding11.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding11.setAggrFunction("SUM");
        binding11.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding11.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding11);
        Binding binding12 = new Binding("city_total");
        binding12.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding12.setAggrFunction("SUM");
        binding12.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding12.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding12);
        Binding binding13 = new Binding("country_total");
        binding13.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding13.setAggrFunction("SUM");
        binding13.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        cqd.addBinding((IBinding)binding13);
        CubeFilterDefinition filter1 = new CubeFilterDefinition((IBaseExpression)new ConditionalExpression("dimension[\"dimension1\"][\"level13\"]", 1, "data._outer[\"column2\"]"));
        CubeFilterDefinition filter2 = new CubeFilterDefinition((IBaseExpression)new ScriptExpression("data[\"measure1\"] > data._outer[\"column1\"]"));
        cqd.addFilter((IFilterDefinition)filter1);
        cqd.addFilter((IFilterDefinition)filter2);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        this.defineDataSourceDataSet((DataEngine)engine);
        IQueryDefinition query = this.createScriptDataSetQuery();
        IPreparedQuery pq = engine.prepare(query);
        IQueryResults queryResults = pq.execute(null);
        IResultIterator it = queryResults.getResultIterator();
        while (it.next()) {
            if (((Number)it.getValue("column1")).intValue() != 55 && ((Number)it.getValue("column1")).intValue() != 34) continue;
            this.testPrintln("\nOUTER RESULT:" + it.getValue("column1").toString());
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults cqResults = pcq.execute((IBaseQueryResults)queryResults, null);
            ICubeCursor cursor = cqResults.getCubeCursor();
            ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
            columnEdgeBindingNames.add("edge1level1");
            columnEdgeBindingNames.add("edge1level2");
            this.printCube((CubeCursor)cursor, "country_year_total", "city_year_total", "dist_total", "city_total", "country_total", "rowGrandTotal", "grandTotal", new String[]{"edge1level1", "edge1level2", "edge1level2"}, "edge2level1", "measure1", false);
        }
        this.checkOutputFile();
        engine.shutdown();
    }

    @Test
    public void testMirroredCrosstab() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        hier1.createLevel("level11");
        hier1.createLevel("level12");
        ILevelDefinition leve113 = hier1.createLevel("level13");
        columnEdge.setMirrorStartingLevel(leve113);
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        hier2.createLevel("level21");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding5);
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        this.createCube(engine);
        IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
        ICubeQueryResults queryResults = pcq.execute(null);
        ICubeCursor cursor = queryResults.getCubeCursor();
        ArrayList<String> columnEdgeBindingNames = new ArrayList<String>();
        columnEdgeBindingNames.add("edge1level1");
        columnEdgeBindingNames.add("edge1level2");
        columnEdgeBindingNames.add("edge1level3");
        ArrayList<String> rowEdgeBindingNames = new ArrayList<String>();
        rowEdgeBindingNames.add("edge2level1");
        this.printCube((CubeCursor)cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testSubQueryWithNestAggregation() throws BirtException, IOException, OLAPException {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        Binding binding = new Binding("maxTotal");
        binding.setExpression((IBaseExpression)new ScriptExpression("data[\"country_year_total\"]"));
        binding.setAggrFunction("MAX");
        AddingNestAggregations cubeOperation1 = new AddingNestAggregations(new IBinding[]{binding});
        cqd.addCubeOperation((ICubeOperation)cubeOperation1);
        Context cx = null;
        try {
            cx = Context.enter();
            ScriptableObject sharedScope = cx.initStandardObjects();
            DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, (Scriptable)sharedScope, null, null));
            this.createCube(engine);
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults cqResults = pcq.execute((Scriptable)sharedScope);
            ICubeCursor cubeCursor = cqResults.getCubeCursor();
            Scriptable subScope = cx.newObject((Scriptable)sharedScope);
            subScope.setParentScope((Scriptable)sharedScope);
            SubCubeQueryDefinition subQuery1 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level11\"]", "dimension[\"dimension2\"][\"level21\"]");
            EdgeCursor edge1 = (EdgeCursor)cubeCursor.getOrdinateEdge().get(0);
            EdgeCursor edge2 = (EdgeCursor)cubeCursor.getOrdinateEdge().get(1);
            edge1.beforeFirst();
            ICubeCursor subCubeCursor = null;
            this.testPrint("\n All total values: ");
            while (edge2.next()) {
                edge1.beforeFirst();
                while (edge1.next()) {
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery1, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    EdgeCursor subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    EdgeCursor subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.first();
                    subEdge1.first();
                    List dimensions = edge1.getDimensionCursor();
                    int start = (int)((DimensionCursor)dimensions.get(0)).getEdgeStart();
                    if ((long)start != edge1.getPosition()) continue;
                    this.testPrint(subCubeCursor.getObject("country_year_total").toString() + "   ");
                }
            }
            this.testPrint("\n All total values: ");
            this.testPrint(subCubeCursor.getObject("maxTotal").toString());
            this.checkOutputFile();
            engine.shutdown();
        }
        finally {
            if (cx != null) {
                Context.exit();
            }
        }
    }

    @Test
    public void testSubQuery1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        Context cx = null;
        try {
            cx = Context.enter();
            ScriptableObject sharedScope = cx.initStandardObjects();
            DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, (Scriptable)sharedScope, null, null));
            this.createCube(engine);
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults cqResults = pcq.execute((Scriptable)sharedScope);
            ICubeCursor cubeCursor = cqResults.getCubeCursor();
            Scriptable subScope = cx.newObject((Scriptable)sharedScope);
            subScope.setParentScope((Scriptable)sharedScope);
            SubCubeQueryDefinition subQuery1 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level11\"]", "dimension[\"dimension2\"][\"level21\"]");
            SubCubeQueryDefinition subQuery2 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level12\"]", "dimension[\"dimension2\"][\"level21\"]");
            SubCubeQueryDefinition subQuery3 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level13\"]", "dimension[\"dimension2\"][\"level21\"]");
            SubCubeQueryDefinition subQuery4 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level11\"]", null);
            SubCubeQueryDefinition subQuery5 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level12\"]", null);
            SubCubeQueryDefinition subQuery6 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level13\"]", null);
            SubCubeQueryDefinition subQuery7 = new SubCubeQueryDefinition("", null, "dimension[\"dimension2\"][\"level21\"]");
            SubCubeQueryDefinition subQuery8 = new SubCubeQueryDefinition("", null, null);
            EdgeCursor edge1 = (EdgeCursor)cubeCursor.getOrdinateEdge().get(0);
            EdgeCursor edge2 = (EdgeCursor)cubeCursor.getOrdinateEdge().get(1);
            edge1.beforeFirst();
            while (edge2.next()) {
                edge1.beforeFirst();
                while (edge1.next()) {
                    this.testPrintln("\n\nParent result:" + cubeCursor.getObject("measure1").toString());
                    ICubeCursor subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery1, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    EdgeCursor subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    EdgeCursor subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result1 ");
                    while (subEdge2.next()) {
                        List dimension = subEdge2.getDimensionCursor();
                        int i = 0;
                        while (i < dimension.size()) {
                            DimensionCursor dim = (DimensionCursor)dimension.get(i);
                            System.out.println("####dim" + i + "Edge start=" + dim.getEdgeStart() + "Edge end=" + dim.getEdgeEnd() + "   ");
                            ++i;
                        }
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            List dimensions = subEdge1.getDimensionCursor();
                            int i2 = 0;
                            while (i2 < dimensions.size()) {
                                DimensionCursor dim = (DimensionCursor)dimensions.get(i2);
                                System.out.println("****dim" + i2 + "Edge start=" + dim.getEdgeStart() + "Edge end=" + dim.getEdgeEnd() + "   ");
                                ++i2;
                            }
                            this.testPrint(subCubeCursor.getObject("measure1").toString() + "   ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery2, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result2 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(subCubeCursor.getObject("measure1").toString() + " ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery3, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result3 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(subCubeCursor.getObject("measure1").toString() + " ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery4, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result4 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(subCubeCursor.getObject("measure1").toString() + " ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery5, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result5 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(subCubeCursor.getObject("measure1").toString() + " ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery6, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result6 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(subCubeCursor.getObject("measure1").toString() + " ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery7, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result7 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(subCubeCursor.getObject("measure1").toString() + " ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery8, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result8 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(subCubeCursor.getObject("measure1").toString() + " ");
                        }
                    }
                }
            }
            this.close((CubeCursor)cubeCursor);
            engine.shutdown();
        }
        finally {
            if (cx != null) {
                Context.exit();
            }
        }
        this.checkOutputFile();
    }

    @Test
    public void testSubQuery2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        columnEdge.setMirrorStartingLevel(level13);
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        Context cx = null;
        try {
            cx = Context.enter();
            ScriptableObject sharedScope = cx.initStandardObjects();
            DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, (Scriptable)sharedScope, null, null));
            this.createCube(engine);
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults cqResults = pcq.execute((Scriptable)sharedScope);
            ICubeCursor cubeCursor = cqResults.getCubeCursor();
            Scriptable subScope = cx.newObject((Scriptable)sharedScope);
            subScope.setParentScope((Scriptable)sharedScope);
            SubCubeQueryDefinition subQuery1 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level11\"]", "dimension[\"dimension2\"][\"level21\"]");
            SubCubeQueryDefinition subQuery2 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level12\"]", "dimension[\"dimension2\"][\"level21\"]");
            SubCubeQueryDefinition subQuery3 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level13\"]", "dimension[\"dimension2\"][\"level21\"]");
            SubCubeQueryDefinition subQuery4 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level11\"]", null);
            SubCubeQueryDefinition subQuery5 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level12\"]", null);
            SubCubeQueryDefinition subQuery6 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level13\"]", null);
            SubCubeQueryDefinition subQuery7 = new SubCubeQueryDefinition("", null, "dimension[\"dimension2\"][\"level21\"]");
            SubCubeQueryDefinition subQuery8 = new SubCubeQueryDefinition("", null, null);
            boolean depth = false;
            EdgeCursor edge1 = (EdgeCursor)cubeCursor.getOrdinateEdge().get(0);
            EdgeCursor edge2 = (EdgeCursor)cubeCursor.getOrdinateEdge().get(1);
            edge1.beforeFirst();
            while (edge2.next()) {
                edge1.beforeFirst();
                while (edge1.next()) {
                    Object value = cubeCursor.getObject("measure1");
                    if (value == null) continue;
                    this.testPrintln("\n\nParent result:" + String.valueOf(value));
                    ICubeCursor subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery1, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    EdgeCursor subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    EdgeCursor subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result1 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(String.valueOf(subCubeCursor.getObject("measure1")) + "   ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery2, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result2 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(String.valueOf(subCubeCursor.getObject("measure1")) + "   ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery3, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result3 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(String.valueOf(subCubeCursor.getObject("measure1")) + "   ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery4, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result4 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(String.valueOf(subCubeCursor.getObject("measure1")) + "   ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery5, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result5 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(String.valueOf(subCubeCursor.getObject("measure1")) + "   ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery6, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result6 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(String.valueOf(subCubeCursor.getObject("measure1")) + "   ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery7, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result7 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(String.valueOf(subCubeCursor.getObject("measure1")) + "   ");
                        }
                    }
                    subCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery8, null).execute((IBaseQueryResults)cqResults, subScope).getCubeCursor();
                    subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    this.testPrintln("\nsubQuery Result8 ");
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrint(String.valueOf(subCubeCursor.getObject("measure1")) + "   ");
                        }
                    }
                }
            }
            this.close((CubeCursor)cubeCursor);
            engine.shutdown();
        }
        finally {
            if (cx != null) {
                Context.exit();
            }
        }
        this.checkOutputFile();
    }

    @Test
    public void testSubQuery3() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition(cubeName);
        IEdgeDefinition columnEdge = cqd.createEdge(2);
        IEdgeDefinition rowEdge = cqd.createEdge(1);
        IDimensionDefinition dim1 = columnEdge.createDimension("dimension1");
        IHierarchyDefinition hier1 = dim1.createHierarchy("dimension1");
        ILevelDefinition level11 = hier1.createLevel("level11");
        ILevelDefinition level12 = hier1.createLevel("level12");
        ILevelDefinition level13 = hier1.createLevel("level13");
        IDimensionDefinition dim2 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition hier2 = dim2.createHierarchy("dimension2");
        ILevelDefinition level21 = hier2.createLevel("level21");
        this.createSortTestBindings((ICubeQueryDefinition)cqd);
        Context cx = null;
        try {
            cx = Context.enter();
            ScriptableObject sharedScope = cx.initStandardObjects();
            DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)DataEngineContext.newInstance((int)3, (Scriptable)sharedScope, null, null));
            this.createCube(engine);
            IPreparedCubeQuery pcq = engine.prepare((ICubeQueryDefinition)cqd, null);
            ICubeQueryResults cqResults = pcq.execute((Scriptable)sharedScope);
            ICubeCursor cubeCursor = cqResults.getCubeCursor();
            Scriptable subScope = cx.newObject((Scriptable)sharedScope);
            subScope.setParentScope((Scriptable)sharedScope);
            Scriptable subSubScope = cx.newObject((Scriptable)sharedScope);
            subSubScope.setParentScope((Scriptable)sharedScope);
            SubCubeQueryDefinition subQuery1 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level11\"]", "dimension[\"dimension2\"][\"level21\"]");
            SubCubeQueryDefinition subQuery2 = new SubCubeQueryDefinition("", "dimension[\"dimension1\"][\"level12\"]", "dimension[\"dimension2\"][\"level21\"]");
            int depth = 0;
            EdgeCursor edge1 = (EdgeCursor)cubeCursor.getOrdinateEdge().get(0);
            EdgeCursor edge2 = (EdgeCursor)cubeCursor.getOrdinateEdge().get(1);
            edge1.beforeFirst();
            while (edge2.next()) {
                edge1.beforeFirst();
                while (edge1.next()) {
                    this.testPrintln("\n\nParent result:" + cubeCursor.getObject("measure1").toString());
                    ICubeQueryResults subResult = engine.prepare((ISubCubeQueryDefinition)subQuery1, null).execute((IBaseQueryResults)cqResults, subScope);
                    ICubeCursor subCubeCursor = subResult.getCubeCursor();
                    EdgeCursor subEdge1 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(0);
                    EdgeCursor subEdge2 = (EdgeCursor)subCubeCursor.getOrdinateEdge().get(1);
                    subEdge2.beforeFirst();
                    while (subEdge2.next()) {
                        subEdge1.beforeFirst();
                        while (subEdge1.next()) {
                            this.testPrintln("\nsubQuery Result1 " + subCubeCursor.getObject("measure1").toString() + "   ");
                            ICubeCursor subSubCubeCursor = engine.prepare((ISubCubeQueryDefinition)subQuery2, null).execute((IBaseQueryResults)subResult, subScope).getCubeCursor();
                            EdgeCursor subSubEdge1 = (EdgeCursor)subSubCubeCursor.getOrdinateEdge().get(0);
                            EdgeCursor subSubEdge2 = (EdgeCursor)subSubCubeCursor.getOrdinateEdge().get(1);
                            subSubEdge2.beforeFirst();
                            this.testPrintln("\nsubSubQuery Result1 ");
                            while (subSubEdge2.next()) {
                                subSubEdge1.beforeFirst();
                                while (subSubEdge1.next()) {
                                    ++depth;
                                    this.testPrint(subSubCubeCursor.getObject("measure1").toString() + "   ");
                                }
                            }
                        }
                    }
                }
            }
            this.close((CubeCursor)cubeCursor);
            engine.shutdown();
        }
        finally {
            if (cx != null) {
                Context.exit();
            }
        }
        this.checkOutputFile();
    }

    @Test
    public void testRelativeTimePeriod1() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1999, 8, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level14\"]");
        binding2.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod2() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1999, 7, 19).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding2.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod3() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.MONTH);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1998, 7, 19).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod12() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.WEEK);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1998, 7, 19).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod5() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(-3, TimePeriodType.MONTH);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1998, 10, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod9() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(-3, TimePeriodType.DAY);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1998, 8, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod6() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(-2, TimePeriodType.YEAR);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1999, 10, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod13() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(3, TimePeriodType.YEAR);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1998, 11, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod14() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(3, TimePeriodType.YEAR);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1998, 11, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding2);
        timeFunction = new TimeFunction();
        timePeriod = new TimePeriod(0, TimePeriodType.MONTH);
        referenceDate = new ReferenceDate(new GregorianCalendar(1999, 7, 19).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding3 = new Binding("measure2");
        binding3.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding3.setTimeFunction((ITimeFunction)timeFunction);
        binding3.setAggrFunction("SUM");
        binding3.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding3);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        ArrayList<String> measureNameList = new ArrayList<String>();
        measureNameList.add("measure1");
        measureNameList.add("measure2");
        this.printCube1(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureNameList);
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod15() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1999, 8, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level14\"]");
        binding2.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("measure2");
        binding3.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding3.setTimeFunction((ITimeFunction)timeFunction);
        binding3.setAggrFunction("SUM");
        binding3.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding3.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding3.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding3.addAggregateOn("dimension[\"dimension1\"][\"level14\"]");
        binding3.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding3);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        ArrayList<String> measureNameList = new ArrayList<String>();
        measureNameList.add("measure1");
        measureNameList.add("measure2");
        this.printCube1(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureNameList);
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod16() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1999, 8, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding2.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("measure2");
        binding3.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        timeFunction = new TimeFunction();
        timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        referenceDate = new ReferenceDate(new GregorianCalendar(1999, 11, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        binding3.setTimeFunction((ITimeFunction)timeFunction);
        binding3.setAggrFunction("SUM");
        binding3.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding3.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding3);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        ArrayList<String> measureNameList = new ArrayList<String>();
        measureNameList.add("measure1");
        measureNameList.add("measure2");
        this.printCube1(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureNameList);
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod17() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.WEEK);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1998, 7, 19).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding2);
        timeFunction = new TimeFunction();
        timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        referenceDate = new ReferenceDate(new GregorianCalendar(1998, 10, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        timePeriod = new TimePeriod(-3, TimePeriodType.MONTH);
        timeFunction.setRelativeTimePeriod((ITimePeriod)timePeriod);
        Binding binding3 = new Binding("measure2");
        binding3.setTimeFunction((ITimeFunction)timeFunction);
        binding3.setAggrFunction("SUM");
        binding3.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding3.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding3.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding3.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding3);
        timeFunction = new TimeFunction();
        timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        referenceDate = new ReferenceDate(new GregorianCalendar(1998, 10, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        timePeriod = new TimePeriod(-3, TimePeriodType.MONTH);
        timeFunction.setRelativeTimePeriod((ITimePeriod)timePeriod);
        Binding binding4 = new Binding("measure3");
        binding4.setTimeFunction((ITimeFunction)timeFunction);
        binding4.setAggrFunction("SUM");
        binding4.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding4.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding4.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding4.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding4);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        ArrayList<String> measureNameList = new ArrayList<String>();
        measureNameList.add("measure1");
        measureNameList.add("measure2");
        measureNameList.add("measure3");
        this.printCube1(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureNameList);
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod18() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        timeFunction.setReferenceDate(null);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level14\"]");
        binding2.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod19() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        timeFunction.setReferenceDate(null);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding2);
        timeFunction = new TimeFunction();
        timePeriod = new TimePeriod(-2, TimePeriodType.QUARTER);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1998, 10, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding3 = new Binding("measure2");
        binding3.setTimeFunction((ITimeFunction)timeFunction);
        binding3.setAggrFunction("SUM");
        binding3.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding3.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding3.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        cqd.addBinding((IBinding)binding3);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        ArrayList<String> measureNameList = new ArrayList<String>();
        measureNameList.add("measure1");
        measureNameList.add("measure2");
        this.printCube1(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureNameList);
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod7() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1998, 10, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        timePeriod = new TimePeriod(-3, TimePeriodType.MONTH);
        timeFunction.setRelativeTimePeriod((ITimePeriod)timePeriod);
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod10() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.YEAR);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1999, 9, 9).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        timePeriod = new TimePeriod(-3, TimePeriodType.WEEK);
        timeFunction.setRelativeTimePeriod((ITimePeriod)timePeriod);
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod8() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.MONTH);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1999, 7, 20).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    @Test
    public void testRelativeTimePeriod11() throws Exception {
        CubeQueryDefinition cqd = new CubeQueryDefinition("DateCube");
        IEdgeDefinition rowEdge = cqd.createEdge(2);
        IDimensionDefinition productLineDim1 = rowEdge.createDimension("dimension2");
        IHierarchyDefinition porductLineHie1 = productLineDim1.createHierarchy("dimension2");
        porductLineHie1.createLevel("level21");
        IEdgeDefinition columnEdge = cqd.createEdge(1);
        IDimensionDefinition dateDim = columnEdge.createDimension("dimension1");
        IHierarchyDefinition dateHier = dateDim.createHierarchy("dimension1");
        dateHier.createLevel("level11");
        dateHier.createLevel("level12");
        dateHier.createLevel("level13");
        dateHier.createLevel("level14");
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        TimeFunction timeFunction = new TimeFunction();
        TimePeriod timePeriod = new TimePeriod(0, TimePeriodType.QUARTER);
        ReferenceDate referenceDate = new ReferenceDate(new GregorianCalendar(1998, 2, 1).getTime());
        timeFunction.setReferenceDate((IReferenceDate)referenceDate);
        timeFunction.setBaseTimePeriod((ITimePeriod)timePeriod);
        timeFunction.setTimeDimension("dimension1");
        Binding binding2 = new Binding("measure1");
        binding2.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding2.setTimeFunction((ITimeFunction)timeFunction);
        binding2.setAggrFunction("SUM");
        binding2.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding2);
        DateCube util = new DateCube();
        DataEngineImpl engine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)this.createPresentationContext());
        util.createCube(engine);
        ICube cube = util.getCube("DateCube", engine);
        BirtCubeView cubeView = new BirtCubeView(new CubeQueryExecutor(null, (ICubeQueryDefinition)cqd, engine.getSession(), (Scriptable)new ImporterTopLevel(), engine.getContext()), cube, null, null);
        CubeCursor cursor = cubeView.getCubeCursor(new StopSign(), cube);
        ArrayList columnEdgeBindingNames = new ArrayList();
        ArrayList rowEdgeBindingNames = new ArrayList();
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, "measure1");
        engine.shutdown();
    }

    private void createSortTestBindings(ICubeQueryDefinition cqd) throws DataException {
        IMeasureDefinition measure = cqd.createMeasure("measure1");
        measure.setAggrFunction("SUM");
        Binding binding1 = new Binding("edge1level1");
        binding1.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level11\"]"));
        cqd.addBinding((IBinding)binding1);
        Binding binding2 = new Binding("edge1level2");
        binding2.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level12\"]"));
        cqd.addBinding((IBinding)binding2);
        Binding binding3 = new Binding("edge1level3");
        binding3.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension1\"][\"level13\"]"));
        cqd.addBinding((IBinding)binding3);
        Binding binding4 = new Binding("edge2level1");
        binding4.setExpression((IBaseExpression)new ScriptExpression("dimension[\"dimension2\"][\"level21\"]"));
        cqd.addBinding((IBinding)binding4);
        Binding binding5 = new Binding("measure1");
        binding5.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding5.setAggrFunction("SUM");
        binding5.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding5.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding5);
        Binding binding6 = new Binding("rowGrandTotal");
        binding6.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding6.setAggrFunction("SUM");
        binding6.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding6);
        Binding binding7 = new Binding("columnGrandTotal");
        binding7.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding7.setAggrFunction("SUM");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding7.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding7);
        Binding binding8 = new Binding("grandTotal");
        binding8.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding8.setAggrFunction("SUM");
        cqd.addBinding((IBinding)binding8);
        Binding binding9 = new Binding("country_year_total");
        binding9.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding9.setAggrFunction("SUM");
        binding9.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding9.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding9);
        Binding binding10 = new Binding("city_year_total");
        binding10.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding10.setAggrFunction("SUM");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding10.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding10.addAggregateOn("dimension[\"dimension2\"][\"level21\"]");
        cqd.addBinding((IBinding)binding10);
        Binding binding11 = new Binding("dist_total");
        binding11.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding11.setAggrFunction("SUM");
        binding11.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding11.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        binding11.addAggregateOn("dimension[\"dimension1\"][\"level13\"]");
        cqd.addBinding((IBinding)binding11);
        Binding binding12 = new Binding("city_total");
        binding12.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding12.setAggrFunction("SUM");
        binding12.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        binding12.addAggregateOn("dimension[\"dimension1\"][\"level12\"]");
        cqd.addBinding((IBinding)binding12);
        Binding binding13 = new Binding("country_total");
        binding13.setExpression((IBaseExpression)new ScriptExpression("measure[\"measure1\"]"));
        binding13.setAggrFunction("SUM");
        binding13.addAggregateOn("dimension[\"dimension1\"][\"level11\"]");
        cqd.addBinding((IBinding)binding13);
        Binding binding14 = new Binding("derived1");
        binding14.setExpression((IBaseExpression)new ScriptExpression("data[\"city_year_total\"]/data[\"country_year_total\"]"));
        cqd.addBinding((IBinding)binding14);
        Binding binding15 = new Binding("derived2");
        binding15.setExpression((IBaseExpression)new ScriptExpression("data[\"city_total\"]/data[\"country_total\"]"));
        cqd.addBinding((IBinding)binding15);
    }

    private void printCube(CubeCursor cursor, String country_year_total, String city_year_total, String dist_total, String city_total, String country_total, String year_total, String grand_total, String[] columns, String row, String measure) throws OLAPException, IOException {
        this.printCube(cursor, country_year_total, city_year_total, dist_total, city_total, country_total, year_total, grand_total, columns, row, measure, true);
    }

    private void printCube(CubeCursor cursor, String country_year_total, String city_year_total, String dist_total, String city_total, String country_total, String year_total, String grand_total, String[] columns, String row, String measure, boolean checkOutput) throws OLAPException, IOException {
        long cityEnd;
        long countryEnd;
        EdgeCursor edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(1);
        Object[] lines = new String[columns.length];
        Arrays.fill(lines, "\t\t");
        while (edge1.next()) {
            long countryEnd2 = ((DimensionCursor)edge1.getDimensionCursor().get(0)).getEdgeEnd();
            long cityEnd2 = ((DimensionCursor)edge1.getDimensionCursor().get(1)).getEdgeEnd();
            lines[0] = String.valueOf(lines[0]) + String.valueOf(cursor.getObject(columns[0])) + "\t\t";
            lines[1] = String.valueOf(lines[1]) + String.valueOf(cursor.getObject(columns[1])) + "\t\t";
            lines[2] = String.valueOf(lines[2]) + String.valueOf(cursor.getObject(columns[2])) + "\t\t";
            if (cityEnd2 == edge1.getPosition()) {
                lines[0] = String.valueOf(lines[0]) + String.valueOf(cursor.getObject(columns[0])) + "\t\t";
                lines[1] = String.valueOf(lines[1]) + String.valueOf(cursor.getObject(columns[1])) + "\t\t";
                lines[2] = String.valueOf(lines[2]) + "[Total]\t\t";
            }
            if (countryEnd2 != edge1.getPosition()) continue;
            lines[0] = String.valueOf(lines[0]) + String.valueOf(cursor.getObject(columns[0])) + "\t\t";
            lines[1] = String.valueOf(lines[1]) + "[Total]\t\t";
            lines[2] = String.valueOf(lines[2]) + "    \t\t";
        }
        lines[0] = String.valueOf(lines[0]) + "[Total]";
        Object output = "";
        int i = 0;
        while (i < lines.length) {
            output = (String)output + "\n" + (String)lines[i];
            ++i;
        }
        while (edge2.next()) {
            String line = cursor.getObject(row).toString() + "\t\t";
            edge1.beforeFirst();
            while (edge1.next()) {
                countryEnd = ((DimensionCursor)edge1.getDimensionCursor().get(0)).getEdgeEnd();
                cityEnd = ((DimensionCursor)edge1.getDimensionCursor().get(1)).getEdgeEnd();
                line = line + String.valueOf(cursor.getObject(measure)) + "\t\t";
                if (cityEnd == edge1.getPosition()) {
                    line = line + "[" + String.valueOf(cursor.getObject(city_year_total)) + "]\t\t";
                }
                if (countryEnd != edge1.getPosition()) continue;
                line = line + "[" + String.valueOf(cursor.getObject(country_year_total)) + "]\t\t";
            }
            line = line + "[" + String.valueOf(cursor.getObject(year_total)) + "]";
            output = (String)output + "\n" + line;
        }
        Object line = "[Total]\t\t";
        edge1.beforeFirst();
        while (edge1.next()) {
            countryEnd = ((DimensionCursor)edge1.getDimensionCursor().get(0)).getEdgeEnd();
            cityEnd = ((DimensionCursor)edge1.getDimensionCursor().get(1)).getEdgeEnd();
            line = (String)line + String.valueOf(cursor.getObject(dist_total)) + "\t\t";
            if (cityEnd == edge1.getPosition()) {
                line = (String)line + "[" + String.valueOf(cursor.getObject(city_total)) + "]\t\t";
            }
            if (countryEnd != edge1.getPosition()) continue;
            line = (String)line + "[" + String.valueOf(cursor.getObject(country_total)) + "]\t\t";
        }
        line = (String)line + "[" + String.valueOf(cursor.getObject(grand_total)) + "]\t\t";
        output = (String)output + "\n" + (String)line;
        this.testPrint((String)output);
        if (checkOutput) {
            this.checkOutputFile();
        }
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames) throws Exception {
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, null, null, null);
    }

    private void printCube1(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, List<String> measureBindingNameList) throws Exception {
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNameList, null, null, null);
    }

    private void printCubeWithPage(CubeCursor cursor, List pageEdgeBindingNames, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames, String columnAggr, String rowAggr, String overallAggr) throws Exception {
        if (!cursor.getPageEdge().isEmpty()) {
            EdgeCursor pageCursor = (EdgeCursor)cursor.getPageEdge().toArray()[0];
            pageCursor.beforeFirst();
            Object output = "";
            while (pageCursor.next()) {
                int i = 0;
                while (i < pageEdgeBindingNames.size()) {
                    output = (String)output + "\n" + String.valueOf(cursor.getObject(pageEdgeBindingNames.get(i).toString())) + "\t\t";
                    ++i;
                }
                cursor.synchronizePages();
                output = (String)output + this.getOutputFromCursor(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, columnAggr, rowAggr, overallAggr);
            }
            this.testPrint((String)output);
            this.checkOutputFile();
            this.close(cursor);
        } else {
            this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, columnAggr, rowAggr, overallAggr);
        }
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames, String columnAggr, String rowAggr, String overallAggr, boolean checkOutput) throws Exception {
        String output = this.getOutputFromCursor(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, columnAggr, rowAggr, overallAggr);
        this.testPrint(output);
        if (checkOutput) {
            this.checkOutputFile();
        }
        this.close(cursor);
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, List<String> measureBindingNameList, String columnAggr, String rowAggr, String overallAggr, boolean checkOutput) throws Exception {
        String output = this.getOutputFromCursor(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNameList, columnAggr, rowAggr, overallAggr);
        this.testPrint(output);
        if (checkOutput) {
            this.checkOutputFile();
        }
        this.close(cursor);
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, List<String> measureBindingNameList, String columnAggr, String rowAggr, String overallAggr) throws Exception {
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNameList, columnAggr, rowAggr, overallAggr, true);
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames, String columnAggr, String rowAggr, String overallAggr) throws Exception {
        this.printCube(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingNames, columnAggr, rowAggr, overallAggr, true);
    }

    private void printCube(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingName, String[] columnAggrs) throws Exception {
        String output = this.getOutputFromCursor(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingName, columnAggrs);
        this.testPrint(output);
    }

    private void printCubeWithRank(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingName, String[] columnAggrs) throws Exception {
        String output = this.getOutputFromCursorWithRank(cursor, columnEdgeBindingNames, rowEdgeBindingNames, measureBindingName, columnAggrs);
        this.testPrint(output);
    }

    private String getOutputFromCursor(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingNames, String columnAggr, String rowAggr, String overallAggr) throws OLAPException {
        EdgeCursor edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = null;
        if (cursor.getOrdinateEdge().size() > 1) {
            edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(1);
        }
        String[] lines = new String[columnEdgeBindingNames.size()];
        int i = 0;
        while (i < columnEdgeBindingNames.size()) {
            lines[i] = "\t\t";
            ++i;
        }
        while (edge1.next()) {
            i = 0;
            while (i < columnEdgeBindingNames.size()) {
                int n = i;
                lines[n] = String.valueOf(lines[n]) + String.valueOf(cursor.getObject(columnEdgeBindingNames.get(i).toString())) + "\t\t";
                ++i;
            }
        }
        if (rowAggr != null) {
            int n = lines.length - 1;
            lines[n] = String.valueOf(lines[n]) + "Total";
        }
        Object output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = (String)output + "\n" + lines[i2];
            ++i2;
        }
        while (edge2 != null && edge2.next()) {
            Object line = "";
            int i3 = 0;
            while (i3 < rowEdgeBindingNames.size()) {
                line = (String)line + cursor.getObject(rowEdgeBindingNames.get(i3).toString()).toString() + "\t\t";
                ++i3;
            }
            edge1.beforeFirst();
            while (edge1.next()) {
                if (measureBindingNames == null) continue;
                line = (String)line + String.valueOf(cursor.getObject(measureBindingNames)) + "\t\t";
            }
            if (rowAggr != null) {
                line = (String)line + String.valueOf(cursor.getObject(rowAggr));
            }
            output = (String)output + "\n" + (String)line;
        }
        if (columnAggr != null) {
            Object line = "Total\t\t";
            edge1.beforeFirst();
            while (edge1.next()) {
                line = (String)line + String.valueOf(cursor.getObject(columnAggr)) + "\t\t";
            }
            if (overallAggr != null) {
                line = (String)line + String.valueOf(cursor.getObject(overallAggr));
            }
            output = (String)output + "\n" + (String)line;
        }
        return output;
    }

    private String getOutputFromCursor(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, List<String> measureBindingNameList, String columnAggr, String rowAggr, String overallAggr) throws OLAPException {
        EdgeCursor edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = null;
        if (cursor.getOrdinateEdge().size() > 1) {
            edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(1);
        }
        String[] lines = new String[columnEdgeBindingNames.size()];
        int i = 0;
        while (i < columnEdgeBindingNames.size()) {
            lines[i] = "\t\t";
            ++i;
        }
        while (edge1.next()) {
            i = 0;
            while (i < columnEdgeBindingNames.size()) {
                int n = i;
                lines[n] = String.valueOf(lines[n]) + String.valueOf(cursor.getObject(columnEdgeBindingNames.get(i).toString())) + "\t\t";
                ++i;
            }
        }
        if (rowAggr != null) {
            int n = lines.length - 1;
            lines[n] = String.valueOf(lines[n]) + "Total";
        }
        Object output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = (String)output + "\n" + lines[i2];
            ++i2;
        }
        while (edge2 != null && edge2.next()) {
            Object line = "";
            int i3 = 0;
            while (i3 < rowEdgeBindingNames.size()) {
                line = (String)line + cursor.getObject(rowEdgeBindingNames.get(i3).toString()).toString() + "\t\t";
                ++i3;
            }
            edge1.beforeFirst();
            while (edge1.next()) {
                for (String measureBindingNames : measureBindingNameList) {
                    if (measureBindingNames == null) continue;
                    line = (String)line + String.valueOf(cursor.getObject(measureBindingNames)) + "\t\t";
                }
            }
            if (rowAggr != null) {
                line = (String)line + String.valueOf(cursor.getObject(rowAggr));
            }
            output = (String)output + "\n" + (String)line;
        }
        if (columnAggr != null) {
            Object line = "Total\t\t";
            edge1.beforeFirst();
            while (edge1.next()) {
                line = (String)line + String.valueOf(cursor.getObject(columnAggr)) + "\t\t";
            }
            if (overallAggr != null) {
                line = (String)line + String.valueOf(cursor.getObject(overallAggr));
            }
            output = (String)output + "\n" + (String)line;
        }
        return output;
    }

    private String getOutputFromCursor(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingName, String[] columnAggrs) throws OLAPException {
        EdgeCursor edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(1);
        String[] lines = new String[columnEdgeBindingNames.size()];
        int i = 0;
        while (i < columnEdgeBindingNames.size()) {
            lines[i] = "\t\t";
            ++i;
        }
        while (edge1.next()) {
            i = 0;
            while (i < columnEdgeBindingNames.size()) {
                int n = i;
                lines[n] = String.valueOf(lines[n]) + String.valueOf(cursor.getObject(columnEdgeBindingNames.get(i).toString())) + "\t\t";
                ++i;
            }
        }
        Object output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = (String)output + "\n" + lines[i2];
            ++i2;
        }
        while (edge2.next()) {
            Object line = "";
            int i3 = 0;
            while (i3 < rowEdgeBindingNames.size()) {
                line = (String)line + cursor.getObject(rowEdgeBindingNames.get(i3).toString()).toString() + "\t\t";
                ++i3;
            }
            edge1.beforeFirst();
            while (edge1.next()) {
                line = (String)line + String.valueOf(cursor.getObject(measureBindingName)) + "\t\t";
            }
            output = (String)output + "\n" + (String)line;
        }
        Object line = "total\t\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = (String)line + String.valueOf(cursor.getObject("total")) + "\t\t";
        }
        output = (String)output + "\n" + (String)line;
        line = "maxTotal1\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = (String)line + String.valueOf(cursor.getObject("maxTotal1")) + "\t\t";
        }
        output = (String)output + "\n" + (String)line;
        line = "maxTotal2\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = (String)line + String.valueOf(cursor.getObject("maxTotal2")) + "\t\t";
        }
        output = (String)output + "\n" + (String)line;
        line = "sumTotal1\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = (String)line + String.valueOf(cursor.getObject("sumTotal1")) + "\t\t";
        }
        output = (String)output + "\n" + (String)line;
        line = "sumTotal2\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = (String)line + String.valueOf(cursor.getObject("sumTotal2")) + "\t\t";
        }
        output = (String)output + "\n" + (String)line;
        line = "sumSumTotal1\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = (String)line + String.valueOf(cursor.getObject("sumSumTotal1")) + "\t\t";
        }
        output = (String)output + "\n" + (String)line;
        return output;
    }

    private String getOutputFromCursorWithRank(CubeCursor cursor, List columnEdgeBindingNames, List rowEdgeBindingNames, String measureBindingName, String[] columnAggrs) throws OLAPException {
        EdgeCursor edge1 = (EdgeCursor)cursor.getOrdinateEdge().get(0);
        EdgeCursor edge2 = (EdgeCursor)cursor.getOrdinateEdge().get(1);
        String[] lines = new String[columnEdgeBindingNames.size()];
        int i = 0;
        while (i < columnEdgeBindingNames.size()) {
            lines[i] = "\t\t";
            ++i;
        }
        while (edge1.next()) {
            i = 0;
            while (i < columnEdgeBindingNames.size()) {
                int n = i;
                lines[n] = String.valueOf(lines[n]) + String.valueOf(cursor.getObject(columnEdgeBindingNames.get(i).toString())) + "\t\t";
                ++i;
            }
        }
        Object output = "";
        int i2 = 0;
        while (i2 < lines.length) {
            output = (String)output + "\n" + lines[i2];
            ++i2;
        }
        while (edge2.next()) {
            Object line = "";
            int i3 = 0;
            while (i3 < rowEdgeBindingNames.size()) {
                line = (String)line + cursor.getObject(rowEdgeBindingNames.get(i3).toString()).toString() + "\t\t";
                ++i3;
            }
            edge1.beforeFirst();
            while (edge1.next()) {
                line = (String)line + String.valueOf(cursor.getObject(measureBindingName)) + "\t\t";
            }
            output = (String)output + "\n" + (String)line;
        }
        Object line = "total\t\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = (String)line + String.valueOf(cursor.getObject("total")) + "\t\t";
        }
        output = (String)output + "\n" + (String)line;
        line = "rankInCountryA\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = (String)line + String.valueOf(cursor.getObject("totalRankInCountry")) + "\t\t";
        }
        output = (String)output + "\n" + (String)line;
        line = "referBinding\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = (String)line + String.valueOf(cursor.getObject("referRankAggr")) + "\t\t";
        }
        output = (String)output + "\n" + (String)line;
        line = "rankInCountryD\t";
        edge1.beforeFirst();
        edge2.first();
        while (edge1.next()) {
            line = (String)line + String.valueOf(cursor.getObject("totalRankInCountryDesc")) + "\t\t";
        }
        output = (String)output + "\n" + (String)line;
        return output;
    }

    private void defineDataSourceDataSet(DataEngine engine) throws BirtException {
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        ColumnDefinition col = new ColumnDefinition("column1");
        col.setDataType(2);
        dataSet.addResultSetHint((IColumnDefinition)col);
        dataSet.setOpenScript("i = 57;");
        dataSet.setFetchScript(" i--; if ( i < 27 ) return false; row.column1 = i; return true;");
        engine.defineDataSource((IBaseDataSourceDesign)dataSource);
        engine.defineDataSet((IBaseDataSetDesign)dataSet);
    }

    private IQueryDefinition createScriptDataSetQuery() throws DataException {
        QueryDefinition query = new QueryDefinition();
        query.setDataSetName("test");
        query.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("dataSetRow.column1")));
        query.addBinding((IBinding)new Binding("column2", (IBaseExpression)new ScriptExpression("\"A1\"")));
        return query;
    }

    private void close(CubeCursor dataCursor) throws OLAPException {
        int i = 0;
        while (i < dataCursor.getOrdinateEdge().size()) {
            EdgeCursor edge = (EdgeCursor)dataCursor.getOrdinateEdge().get(i);
            edge.close();
            ++i;
        }
        dataCursor.close();
    }

    private void createCube(DataEngineImpl engine) throws BirtException, IOException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager((String)engine.getSession().getTempDir(), (String)String.valueOf(engine.hashCode()));
        DocManagerMap.getDocManagerMap().set(String.valueOf(engine.hashCode()), engine.getSession().getTempDir() + engine.hashCode(), documentManager);
        engine.addShutdownListener((IShutdownListener)new DocManagerReleaser((DataEngine)engine));
        Dimension[] dimensions = new Dimension[2];
        String[] levelNames = new String[]{"level11", "level12", "level13"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable.DIM0_L1Col);
        iterator.setLevelMember(1, TestFactTable.DIM0_L2Col);
        iterator.setLevelMember(2, TestFactTable.DIM0_L3Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null), new LevelDefinition("level12", new String[]{"level12"}, null), new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        Assert.assertEquals((long)dimensions[0].length(), (long)13L);
        levelNames = new String[]{"level21", "attr21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, this.distinct(TestFactTable.DIM1_L1Col));
        iterator.setLevelMember(1, TestFactTable.ATTRIBUTE_Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, new String[]{"attr21"})};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        Assert.assertEquals((long)dimensions[1].length(), (long)5L);
        TestFactTable factTable2 = new TestFactTable();
        String[] measureColumnName = new String[]{"measure1"};
        Cube cube = new Cube(cubeName, documentManager);
        cube.create(CubeFeaturesTest.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        cube.close();
        documentManager.flush();
    }

    private void createCube1(DataEngineImpl engine) throws BirtException, IOException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager((String)engine.getSession().getTempDir(), (String)String.valueOf(engine.hashCode()));
        DocManagerMap.getDocManagerMap().set(String.valueOf(engine.hashCode()), engine.getSession().getTempDir() + engine.hashCode(), documentManager);
        engine.addShutdownListener((IShutdownListener)new DocManagerReleaser((DataEngine)engine));
        Dimension[] dimensions = new Dimension[4];
        String[] levelNames = new String[]{"level11"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable.DIM0_L1Col);
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("level11", new String[]{"level11"}, null)};
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        levelNames = new String[]{"level12"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable.DIM0_L2Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level12", new String[]{"level12"}, null)};
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        levelNames = new String[]{"level13"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, TestFactTable.DIM0_L3Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level13", new String[]{"level13"}, null)};
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        levelNames = new String[]{"level21", "attr21"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, this.distinct(TestFactTable.DIM1_L1Col));
        iterator.setLevelMember(1, TestFactTable.ATTRIBUTE_Col);
        levelDefs = new ILevelDefn[]{new LevelDefinition("level21", new String[]{"level21"}, new String[]{"attr21"})};
        dimensions[3] = (Dimension)DimensionFactory.createDimension((String)"dimension4", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[3].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension4");
        Assert.assertEquals((long)dimensions[3].length(), (long)5L);
        TestFactTable factTable2 = new TestFactTable();
        String[] measureColumnName = new String[]{"measure1"};
        Cube cube = new Cube(cubeName, documentManager);
        cube.create(CubeFeaturesTest.getKeyColNames((IDimension[])dimensions), (IDimension[])dimensions, (IDatasetIterator)factTable2, measureColumnName, new StopSign());
        cube.close();
        documentManager.flush();
    }

    private static String[][] getKeyColNames(IDimension[] dimensions) {
        String[][] keyColumnName = new String[dimensions.length][];
        int i = 0;
        while (i < dimensions.length) {
            ILevel[] levels = dimensions[i].getHierarchy().getLevels();
            ILevel detailLevel = levels[levels.length - 1];
            keyColumnName[i] = detailLevel.getKeyNames();
            ++i;
        }
        return keyColumnName;
    }

    private String[] distinct(String[] values) {
        Object[] lValues = new String[values.length];
        System.arraycopy(values, 0, lValues, 0, values.length);
        Arrays.sort(lValues);
        ArrayList<Object> tempList = new ArrayList<Object>();
        tempList.add(lValues[0]);
        int i = 1;
        while (i < lValues.length) {
            if (!((String)lValues[i]).equals(lValues[i - 1])) {
                tempList.add(lValues[i]);
            }
            ++i;
        }
        String[] result = new String[tempList.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (String)tempList.get(i2);
            ++i2;
        }
        return result;
    }
}

