/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Properties;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.ColumnHint;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionTest;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odaconsumer.ResultSetTest;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectedColumnsTest
extends ConnectionTest {
    private static String[] RESULTS = new String[]{"blah blah blah, 1.212312", "hahahahahahhahaha, 3.14", "niem, 1.23", "null, null", "seven zero six, 12.3636"};
    private static Double[] DOUBLE_RESULTS;
    private PreparedStatement m_statement;
    private DataResourceHandle resourceHandle = DataResourceHandle.getInstance();

    static {
        Double[] doubleArray = new Double[5];
        doubleArray[0] = new Double(1.212312);
        doubleArray[1] = new Double(3.14);
        doubleArray[2] = new Double(1.23);
        doubleArray[4] = new Double(12.3636);
        DOUBLE_RESULTS = doubleArray;
    }

    @Before
    public void projectedColumnsSetUp() throws Exception {
        String command = "select * from \"testtable\"";
        this.m_statement = this.getConnection().prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
    }

    public final void testProjectedColumns() throws Exception {
        String[] projectedColumns = new String[]{"stringColumn", "doubleColumn"};
        this.m_statement.setColumnsProjection(projectedColumns);
        IResultClass metadata = this.m_statement.getMetaData();
        this.checkMetaData(metadata);
        Assert.assertTrue((boolean)this.m_statement.execute());
        ResultSet resultset = this.m_statement.getResultSet();
        Assert.assertNotNull((Object)resultset);
        Assert.assertEquals((Object)metadata, (Object)this.m_statement.getMetaData());
        Assert.assertEquals((Object)metadata, (Object)resultset.getMetaData());
        IResultObject resultObject = null;
        int count = 1;
        while ((resultObject = resultset.fetch()) != null) {
            Assert.assertEquals((Object)metadata, (Object)resultObject.getResultClass());
            this.testFields(resultObject, metadata, count, false);
            this.testFields(resultObject, metadata, count, true);
            ++count;
        }
    }

    public final void testProjectedColumnValidation() throws Exception {
        try {
            String[] projectedColumns = new String[]{"MadeUpColumn"};
            this.m_statement.setColumnsProjection(projectedColumns);
            this.m_statement.getMetaData();
            Assert.fail();
        }
        catch (DataException ex) {
            Assert.assertEquals((Object)"Unrecognized projected column name: MadeUpColumn.", (Object)ex.getMessage());
        }
    }

    public final void testAlias() throws Exception {
        String[] projectedColumns = new String[]{"stringColumn", "doubleColumn"};
        ColumnHint columnHint = new ColumnHint("doubleColumn");
        columnHint.setAlias("Column2");
        this.m_statement.addColumnHint(columnHint);
        this.m_statement.setColumnsProjection(projectedColumns);
        IResultClass metadata = this.m_statement.getMetaData();
        this.checkMetaData(metadata);
        Assert.assertEquals((long)2L, (long)metadata.getFieldIndex("Column2"));
        Assert.assertEquals(Double.class, (Object)metadata.getFieldValueClass("Column2"));
        Assert.assertTrue((boolean)this.m_statement.execute());
        ResultSet resultset = this.m_statement.getResultSet();
        Assert.assertNotNull((Object)resultset);
        IResultObject resultObject = null;
        int count = 1;
        while ((resultObject = resultset.fetch()) != null) {
            Assert.assertEquals((Object)metadata, (Object)resultObject.getResultClass());
            this.testFields(resultObject, metadata, count, false);
            this.testFields(resultObject, metadata, count, true);
            Object value = resultObject.getFieldValue("Column2");
            Assert.assertEquals((Object)DOUBLE_RESULTS[count - 1], (Object)value);
            ++count;
        }
    }

    @Test
    public void testAliasValidation1() throws Exception {
        ColumnHint columnHint = new ColumnHint("doubleColumn");
        columnHint.setAlias("doubleColumn");
        this.m_statement.addColumnHint(columnHint);
        this.m_statement.getMetaData();
    }

    @Test
    public void testAliasValidation2() throws Exception {
        try {
            ColumnHint columnHint = new ColumnHint("doubleColumn");
            columnHint.setAlias("stringColumn");
            this.m_statement.addColumnHint(columnHint);
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.ColumnNameOrAliasAlreadyUsed", new Object[]{"stringColumn", new Integer(3)});
            Assert.assertEquals((Object)msg, (Object)ex.getMessage());
        }
    }

    @Test
    public void testAliasValidation3() throws Exception {
        try {
            ColumnHint columnHint = new ColumnHint("doubleColumn");
            columnHint.setAlias("MyColumn");
            this.m_statement.addColumnHint(columnHint);
            columnHint = new ColumnHint("stringColumn");
            columnHint.setAlias("MyColumn");
            this.m_statement.addColumnHint(columnHint);
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.ColumnNameOrAliasAlreadyUsed", new Object[]{"MyColumn", new Integer(2)});
            Assert.assertEquals((Object)msg, (Object)ex.getMessage());
        }
    }

    private void checkMetaData(IResultClass metadata) throws DataException {
        Assert.assertEquals((long)2L, (long)metadata.getFieldCount());
        String[] fieldNames = metadata.getFieldNames();
        Assert.assertEquals((Object)"stringColumn", (Object)fieldNames[0]);
        Assert.assertEquals((Object)"doubleColumn", (Object)fieldNames[1]);
        Assert.assertEquals((Object)"stringColumn", (Object)metadata.getFieldName(1));
        Assert.assertEquals((Object)"doubleColumn", (Object)metadata.getFieldName(2));
        Assert.assertEquals((long)1L, (long)metadata.getFieldIndex("stringColumn"));
        Assert.assertEquals((long)2L, (long)metadata.getFieldIndex("doubleColumn"));
        Assert.assertEquals(String.class, (Object)metadata.getFieldValueClass(1));
        Assert.assertEquals(Double.class, (Object)metadata.getFieldValueClass(2));
        Assert.assertEquals(String.class, (Object)metadata.getFieldValueClass("stringColumn"));
        Assert.assertEquals(Double.class, (Object)metadata.getFieldValueClass("doubleColumn"));
        Assert.assertEquals((Object)"stringColumn", (Object)metadata.getFieldLabel(1));
        Assert.assertEquals((Object)"doubleColumn", (Object)metadata.getFieldLabel(2));
    }

    private void testFields(IResultObject resultObject, IResultClass resultClass, int rowPosition, boolean useFieldName) throws DataException {
        Object row = "";
        int i = 1;
        while (i <= resultClass.getFieldCount()) {
            Object value = null;
            if (!useFieldName) {
                value = resultObject.getFieldValue(i);
            } else {
                Object object = value = i == 1 ? resultObject.getFieldValue("stringColumn") : resultObject.getFieldValue("doubleColumn");
            }
            if (i > 1) {
                row = (String)row + ", ";
            }
            row = (String)row + (value == null ? "null" : value.toString());
            ++i;
        }
        Assert.assertEquals((Object)RESULTS[rowPosition - 1], (Object)row);
    }

    public final void testGetAllDataByAlias() throws Exception {
        ColumnHint columnHint = new ColumnHint("doubleColumn");
        columnHint.setAlias("Column2");
        this.m_statement.addColumnHint(columnHint);
        columnHint = new ColumnHint("intColumn");
        columnHint.setAlias("Column1");
        this.m_statement.addColumnHint(columnHint);
        columnHint = new ColumnHint("stringColumn");
        columnHint.setAlias("Column3");
        this.m_statement.addColumnHint(columnHint);
        columnHint = new ColumnHint("dateColumn");
        columnHint.setAlias("Column4");
        this.m_statement.addColumnHint(columnHint);
        columnHint = new ColumnHint("decimalColumn");
        columnHint.setAlias("Column5");
        this.m_statement.addColumnHint(columnHint);
        Assert.assertTrue((boolean)this.m_statement.execute());
        ResultSet resultset = this.m_statement.getResultSet();
        Assert.assertNotNull((Object)resultset);
        IResultObject resultObject = null;
        int count = 0;
        while ((resultObject = resultset.fetch()) != null) {
            Object value1 = resultObject.getFieldValue("Column1");
            Object value2 = resultObject.getFieldValue("Column2");
            Object value3 = resultObject.getFieldValue("Column3");
            Object value4 = resultObject.getFieldValue("Column4");
            Object value5 = resultObject.getFieldValue("Column5");
            String row = String.valueOf(value1) + ", " + String.valueOf(value2) + ", " + String.valueOf(value3) + ", " + String.valueOf(value4) + ", " + String.valueOf(value5);
            Assert.assertEquals((Object)row, (Object)ResultSetTest.RESULTS[count++]);
        }
    }

    @Test
    public void testChangeMetadataWithNewProjection() throws Exception {
        IResultClass metadata = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((boolean)this.m_statement.execute());
        ResultSet resultSet = this.m_statement.getResultSet();
        Assert.assertSame((Object)metadata, (Object)resultSet.getMetaData());
        String[] projectedColumns = new String[]{"stringColumn", "doubleColumn"};
        this.m_statement.setColumnsProjection(projectedColumns);
        IResultClass newMetadata1 = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)newMetadata1);
        Assert.assertFalse((boolean)metadata.equals(newMetadata1));
        this.checkMetaData(newMetadata1);
        ColumnHint columnHint = new ColumnHint("doubleColumn");
        columnHint.setAlias("Column2");
        columnHint.setDataType(String.class);
        this.m_statement.addColumnHint(columnHint);
        IResultClass newMetadata2 = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)newMetadata2);
        Assert.assertFalse((boolean)metadata.equals(newMetadata2));
        Assert.assertSame((Object)newMetadata1, (Object)newMetadata2);
        this.checkMetaData(newMetadata2);
        Assert.assertTrue((boolean)this.m_statement.execute());
        resultSet = this.m_statement.getResultSet();
        Assert.assertSame((Object)newMetadata2, (Object)resultSet.getMetaData());
    }

    @Test
    public void testChangeMetadataWithAdditionalCustomColumns() throws Exception {
        IResultClass metadata = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)5L, (long)metadata.getFieldCount());
        this.m_statement.declareCustomColumn("MyColumn", BigDecimal.class);
        metadata = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)6L, (long)metadata.getFieldCount());
        Assert.assertEquals((long)6L, (long)metadata.getFieldIndex("MyColumn"));
        Assert.assertEquals(BigDecimal.class, (Object)metadata.getFieldValueClass(6));
        Assert.assertEquals(BigDecimal.class, (Object)metadata.getFieldValueClass("MyColumn"));
        Assert.assertEquals((Object)"MyColumn", (Object)metadata.getFieldLabel(6));
        Assert.assertEquals((Object)"MyColumn", (Object)metadata.getFieldName(6));
        Assert.assertTrue((boolean)metadata.isCustomField(6));
        Assert.assertTrue((boolean)metadata.isCustomField("MyColumn"));
    }

    @Test
    public void testCustomColumnValidation1() throws Exception {
        try {
            this.m_statement.declareCustomColumn("intColumn", Integer.class);
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.ColumnNameOrAliasAlreadyUsed", new Object[]{"intColumn", new Integer(1)});
            Assert.assertEquals((Object)msg, (Object)ex.getMessage());
        }
    }

    @Test
    public void testCustomColumnValidation2() throws Exception {
        try {
            ColumnHint columnHint = new ColumnHint("decimalColumn");
            columnHint.setAlias("My Decimal Column");
            this.m_statement.addColumnHint(columnHint);
            this.m_statement.declareCustomColumn("My Decimal Column", Integer.class);
        }
        catch (DataException ex) {
            String msg = this.resourceHandle.getMessage("odaconsumer.ColumnNameOrAliasAlreadyUsed", new Object[]{"My Decimal Column", new Integer(5)});
            Assert.assertEquals((Object)msg, (Object)ex.getMessage());
        }
    }

    @Test
    public void testCustomColumnWithProjection1() throws Exception {
        String[] projectedColumns = new String[]{"stringColumn", "doubleColumn"};
        this.m_statement.setColumnsProjection(projectedColumns);
        IResultClass metadata = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)2L, (long)metadata.getFieldCount());
        this.m_statement.declareCustomColumn("My Decimal Column", BigDecimal.class);
        metadata = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)3L, (long)metadata.getFieldCount());
        Assert.assertEquals((long)3L, (long)metadata.getFieldIndex("My Decimal Column"));
    }

    @Test
    public void testCustomColumnWithProjection2() throws Exception {
        String[] projectedColumns = new String[]{"stringColumn", "My Decimal Column", "doubleColumn"};
        this.m_statement.declareCustomColumn("My Decimal Column", null);
        this.m_statement.setColumnsProjection(projectedColumns);
        IResultClass metadata = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)3L, (long)metadata.getFieldCount());
        Assert.assertEquals((long)3L, (long)metadata.getFieldIndex("My Decimal Column"));
    }

    @Test
    public void testWithClearParameters1() throws Exception {
        this.doTestWithClearParameters(this.getConnection());
    }

    @Test
    public void testWithClearParameters2() throws Exception {
        Properties connProperties = this.getJdbcConnProperties();
        Connection connection = this.getManager().openConnection("org.eclipse.birt.report.data.oda.jdbc", connProperties, null);
        this.doTestWithClearParameters(connection);
    }

    private void doTestWithClearParameters(Connection connection) throws Exception {
        Object value;
        String command = "select * from \"testtable\" where \"stringColumn\" > ? OR \"stringColumn\" IS NULL";
        this.m_statement = connection.prepareStatement(command, "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        String[] projectedColumns = new String[]{"stringColumn", "My Decimal Column", "doubleColumn"};
        this.m_statement.declareCustomColumn("My Decimal Column", null);
        this.m_statement.setColumnsProjection(projectedColumns);
        ColumnHint columnHint = new ColumnHint("doubleColumn");
        columnHint.setAlias("My Double Column");
        this.m_statement.addColumnHint(columnHint);
        IResultClass metadata = this.m_statement.getMetaData();
        Assert.assertNotNull((Object)metadata);
        Assert.assertEquals((long)3L, (long)metadata.getFieldCount());
        this.m_statement.setParameterValue(1, (Object)"c");
        Assert.assertTrue((boolean)this.m_statement.execute());
        ResultSet resultset = this.m_statement.getResultSet();
        Assert.assertNotNull((Object)resultset);
        IResultObject resultObject = null;
        int index = 1;
        while ((resultObject = resultset.fetch()) != null) {
            value = resultObject.getFieldValue("My Double Column");
            Assert.assertEquals((Object)DOUBLE_RESULTS[index], (Object)value);
            ++index;
        }
        this.m_statement.clearParameterValues();
        metadata = this.m_statement.getMetaData();
        Assert.assertEquals((long)3L, (long)metadata.getFieldCount());
        this.m_statement.setParameterValue(1, (Object)"i");
        Assert.assertTrue((boolean)this.m_statement.execute());
        resultset = this.m_statement.getResultSet();
        Assert.assertNotNull((Object)resultset);
        resultObject = null;
        index = 2;
        while ((resultObject = resultset.fetch()) != null) {
            value = resultObject.getFieldValue("My Double Column");
            Assert.assertEquals((Object)DOUBLE_RESULTS[index], (Object)value);
            ++index;
        }
    }

    @Test
    public void testChangeColumnTypeWithHint() throws Exception {
        String customColumnName = "My null Column";
        this.m_statement.declareCustomColumn(customColumnName, null);
        IResultClass metadata = this.m_statement.getMetaData();
        Class fieldType = metadata.getFieldValueClass(customColumnName);
        Assert.assertNotNull((Object)fieldType);
        Assert.assertEquals(String.class, (Object)fieldType);
        ColumnHint columnHint = new ColumnHint(customColumnName);
        columnHint.setDataType(Integer.class);
        this.m_statement.addColumnHint(columnHint);
        metadata = this.m_statement.getMetaData();
        fieldType = metadata.getFieldValueClass(customColumnName);
        Assert.assertNotNull((Object)fieldType);
        Assert.assertEquals(Integer.class, (Object)fieldType);
        columnHint = new ColumnHint(customColumnName);
        columnHint.setDataType(Double.class);
        this.m_statement.addColumnHint(columnHint);
        metadata = this.m_statement.getMetaData();
        fieldType = metadata.getFieldValueClass(customColumnName);
        Assert.assertEquals(Double.class, (Object)fieldType);
        columnHint = new ColumnHint(customColumnName);
        columnHint.setDataType(Date.class);
        this.m_statement.addColumnHint(columnHint);
        metadata = this.m_statement.getMetaData();
        fieldType = metadata.getFieldValueClass(customColumnName);
        Assert.assertEquals(Date.class, (Object)fieldType);
        columnHint = new ColumnHint(customColumnName);
        columnHint.setDataType(Boolean.class);
        this.m_statement.addColumnHint(columnHint);
        metadata = this.m_statement.getMetaData();
        fieldType = metadata.getFieldValueClass(customColumnName);
        Assert.assertEquals(Boolean.class, (Object)fieldType);
    }

    @Test
    public void testChangeColumnTypeWithNativeTypeHint() throws Exception {
        String customColumnName = "My custom Column";
        this.m_statement.declareCustomColumn(customColumnName, null);
        IResultClass metadata = this.m_statement.getMetaData();
        Class fieldType = metadata.getFieldValueClass(customColumnName);
        Assert.assertNotNull((Object)fieldType);
        Assert.assertEquals(String.class, (Object)fieldType);
        ColumnHint columnHint = new ColumnHint(customColumnName);
        columnHint.setDataType(Integer.class);
        columnHint.setNativeDataType(91);
        this.m_statement.addColumnHint(columnHint);
        metadata = this.m_statement.getMetaData();
        fieldType = metadata.getFieldValueClass(customColumnName);
        Assert.assertNotNull((Object)fieldType);
        Assert.assertEquals(Date.class, (Object)fieldType);
    }
}

