/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.DimensionRowAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.FilterUtil;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.IntRange;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.LevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.SimpleLevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.ValueObject;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.OrderedDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.SelectionUtil;
import org.eclipse.birt.data.engine.olap.data.util.SetUtil;
import org.eclipse.birt.data.engine.olap.util.filter.IJSDimensionFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSTopBottomFilterHelper;

public class LevelFilterHelper {
    private Dimension dimension;
    private IDiskArray dimPosition;
    private List simplelevelFilters;
    private List levelFilters;
    private DimensionRowAccessor rowAccessor;

    public LevelFilterHelper(Dimension dimension, List simpleLevelFilters, List levelFilters) throws DataException, IOException {
        this.dimension = dimension;
        this.simplelevelFilters = simpleLevelFilters;
        this.levelFilters = levelFilters;
        this.rowAccessor = new DimensionRowAccessor(dimension);
        this.populatePositions();
    }

    public IDiskArray getJSFilterResult(List jsFilters, boolean isBreakHierarchy) throws DataException, IOException {
        if (!(this.simplelevelFilters != null && this.simplelevelFilters.size() != 0 || this.levelFilters != null && this.levelFilters.size() != 0 || jsFilters != null && jsFilters.size() != 0)) {
            return null;
        }
        ArrayList dimFilterList = new ArrayList();
        ArrayList topBottomfilterList = new ArrayList();
        int j = 0;
        while (j < jsFilters.size()) {
            Object filterHelper = jsFilters.get(j);
            if (filterHelper instanceof IJSDimensionFilterHelper) {
                dimFilterList.add(filterHelper);
            } else if (filterHelper instanceof IJSTopBottomFilterHelper) {
                topBottomfilterList.add(filterHelper);
            }
            ++j;
        }
        IDiskArray result = this.getDimFilterPositions(dimFilterList);
        if (topBottomfilterList.isEmpty()) {
            return result;
        }
        IDiskArray result2 = this.getTopbottomFilterPositions(topBottomfilterList, isBreakHierarchy);
        return SetUtil.getIntersection(result, result2);
    }

    private IDiskArray getDimFilterPositions(List dimFilterList) throws IOException, DataException {
        BufferedPrimitiveDiskArray result = new BufferedPrimitiveDiskArray(this.dimPosition.size());
        int i = 0;
        while (i < this.dimPosition.size()) {
            Integer pos = (Integer)this.dimPosition.get(i);
            if (dimFilterList.size() == 0) {
                result.add(pos);
            } else if (this.isDimPositionSelected(pos, dimFilterList)) {
                result.add(pos);
            }
            ++i;
        }
        return result;
    }

    private IDiskArray getTopbottomFilterPositions(List filterList, boolean isBreakHierarchy) throws IOException, DataException {
        IDiskArray result = null;
        ILevel[] levels = this.dimension.getHierarchy().getLevels();
        int i = 0;
        while (i < filterList.size()) {
            IJSTopBottomFilterHelper filter = (IJSTopBottomFilterHelper)filterList.get(i);
            List dimValueArrayList = this.evaluateFilter(levels, filter, isBreakHierarchy);
            IDiskArray dimPositionArray = this.fetchDimPositions(dimValueArrayList, filter);
            result = result == null ? dimPositionArray : SetUtil.getIntersection(result, dimPositionArray);
            ++i;
        }
        return result == null ? this.dimPosition : result;
    }

    private IDiskArray fetchDimPositions(List dimValueArrayList, IJSTopBottomFilterHelper filterHelper) throws IOException {
        OrderedDiskArray dimPositionArray = new OrderedDiskArray();
        for (IDiskArray dimValues : dimValueArrayList) {
            int size = dimValues.size();
            int start = 0;
            int end = size;
            if (filterHelper.isPercent()) {
                int n = FilterUtil.getTargetN(size, filterHelper.getN());
                if (filterHelper.isTop()) {
                    start = size - n;
                } else {
                    end = n;
                }
            }
            int j = start;
            while (j < end) {
                ValueObject aggrValue = (ValueObject)dimValues.get(j);
                IntRange range = (IntRange)aggrValue.index;
                int k = range.start;
                while (k <= range.end) {
                    dimPositionArray.add((Object)k);
                    ++k;
                }
                ++j;
            }
        }
        return dimPositionArray;
    }

    private boolean isDimPositionSelected(int pos, List dimFilterList) throws IOException, DataException {
        this.rowAccessor.seek(pos);
        int j = 0;
        while (j < dimFilterList.size()) {
            IJSDimensionFilterHelper filterHelper = (IJSDimensionFilterHelper)dimFilterList.get(j);
            if (!filterHelper.evaluateFilter(this.rowAccessor)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private List evaluateFilter(ILevel[] levels, IJSTopBottomFilterHelper filter, boolean isBreakHierarchy) throws DataException, IOException {
        ArrayList<IDiskArray> dimValueArrayList = new ArrayList<IDiskArray>();
        int index = this.getIndex(levels, filter.getTargetLevel().getLevelName());
        if (index < 0) {
            index = 0;
        }
        Member[] preMembers = null;
        Object[] preValue = null;
        IDiskArray dimValueArray = null;
        int n = -1;
        if (!filter.isPercent()) {
            n = (int)filter.getN();
        }
        if (isBreakHierarchy) {
            dimValueArray = new OrderedDiskArray(n, filter.isTop());
            dimValueArrayList.add(dimValueArray);
        }
        IntRange range = null;
        int j = 0;
        while (j < this.dimPosition.size()) {
            boolean shareParentLevels;
            Integer pos = (Integer)this.dimPosition.get(j);
            this.rowAccessor.seek(pos);
            DimensionRow dimRow = this.rowAccessor.getCurrentRow();
            boolean bl = shareParentLevels = preMembers != null && FilterUtil.shareParentLevels(dimRow.getMembers(), preMembers, index);
            if (!isBreakHierarchy) {
                if (shareParentLevels) {
                    dimValueArray = (IDiskArray)dimValueArrayList.get(dimValueArrayList.size() - 1);
                } else {
                    dimValueArray = new OrderedDiskArray(n, filter.isTop());
                    dimValueArrayList.add(dimValueArray);
                }
            }
            preMembers = dimRow.getMembers();
            Object[] levelValue = dimRow.getMembers()[index].getKeyValues();
            if (preValue == null || !shareParentLevels || CompareUtil.compare(preValue, levelValue) != 0) {
                Object value = filter.evaluateFilterExpr(this.rowAccessor);
                range = new IntRange(pos, pos);
                dimValueArray.add(new ValueObject(value, range));
            } else {
                range.end = pos;
            }
            preValue = levelValue;
            ++j;
        }
        return dimValueArrayList;
    }

    private IDiskArray populateValidPositions(Map validFilterMap) throws IOException {
        BufferedPrimitiveDiskArray selectedPositions = new BufferedPrimitiveDiskArray();
        ILevel[] levels = this.dimension.getHierarchy().getLevels();
        int i = 0;
        while (i < this.dimPosition.size()) {
            DimensionRow row = this.dimension.getRowByPosition((Integer)this.dimPosition.get(i));
            Member[] curMembers = row.getMembers();
            boolean isSelectedByAll = true;
            for (String levelName : validFilterMap.keySet()) {
                boolean isSelectedByAny = false;
                List filterList = (List)validFilterMap.get(levelName);
                assert (filterList.size() > 0);
                LevelFilter firstFilter = (LevelFilter)filterList.get(0);
                int targetIndex = this.getIndex(levels, firstFilter.getLevelName());
                assert (targetIndex >= 0);
                for (LevelFilter filter : filterList) {
                    Member[] dimMembers = filter.getDimMembers();
                    if (dimMembers == null || FilterUtil.shareParentLevels(curMembers, dimMembers, targetIndex)) {
                        ISelection[] selectins = filter.getSelections();
                        int k = 0;
                        while (k < selectins.length) {
                            if (selectins[k].isSelected(curMembers[targetIndex].getKeyValues())) {
                                isSelectedByAny = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (isSelectedByAny) break;
                }
                if (isSelectedByAny) continue;
                isSelectedByAll = false;
                break;
            }
            if (isSelectedByAll) {
                selectedPositions.add((Integer)this.dimPosition.get(i));
            }
            ++i;
        }
        return selectedPositions;
    }

    private void populatePositions() throws DataException, IOException {
        if (this.simplelevelFilters != null && this.simplelevelFilters.size() > 0) {
            this.getSimpleFilterResult();
        } else {
            this.dimPosition = this.dimension.findAll();
        }
        Map validFilterMap = this.getValidFilterMap();
        if (validFilterMap.isEmpty()) {
            return;
        }
        this.dimPosition = this.populateValidPositions(validFilterMap);
    }

    private void getSimpleFilterResult() throws DataException, IOException {
        ILevel[] levels = this.dimension.getHierarchy().getLevels();
        ISelection[][] selections = new ISelection[levels.length][];
        int filterCount = 0;
        int i = 0;
        while (i < this.simplelevelFilters.size()) {
            int index;
            SimpleLevelFilter filter = (SimpleLevelFilter)this.simplelevelFilters.get(i);
            if (filter.getDimensionName().equals(this.dimension.getName()) && (index = this.getIndex(levels, filter.getLevelName())) >= 0) {
                if (selections[index] == null) {
                    selections[index] = filter.getSelections();
                    ++filterCount;
                } else {
                    selections[index] = SelectionUtil.intersect(selections[index], filter.getSelections());
                }
            }
            ++i;
        }
        if (filterCount == 0) {
            this.dimPosition = this.dimension.findAll();
            return;
        }
        Level[] filterLevel = new Level[filterCount];
        ISelection[][] selects = new ISelection[filterCount][];
        int pos = 0;
        int i2 = 0;
        while (i2 < selections.length) {
            if (selections[i2] != null) {
                filterLevel[pos] = (Level)levels[i2];
                selects[pos] = selections[i2];
                ++pos;
            }
            ++i2;
        }
        this.dimPosition = this.dimension.find(filterLevel, selects);
    }

    private int getIndex(ILevel[] levels, String levelName) {
        return FilterUtil.getTargetLevelIndex(levels, levelName);
    }

    private Map getValidFilterMap() {
        HashMap validFilterMap = new HashMap();
        for (LevelFilter filter : this.levelFilters) {
            if (!filter.getDimensionName().equals(this.dimension.getName())) continue;
            String keyName = this.createLevelKey(filter, filter.getLevelName());
            this.addFilter(validFilterMap, filter, keyName);
        }
        return validFilterMap;
    }

    private String createLevelKey(LevelFilter filter, String levelName) {
        IJSFilterHelper filterHelper = filter.getFilterHelper();
        if (filterHelper != null) {
            levelName = (String)levelName + "_" + filterHelper.hashCode();
        }
        return levelName;
    }

    private void addFilter(Map validFilterMap, LevelFilter filter, String levelName) {
        List<LevelFilter> filterList = null;
        if (validFilterMap.containsKey(levelName)) {
            filterList = (List)validFilterMap.get(levelName);
        } else {
            filterList = new ArrayList();
            validFilterMap.put(levelName, filterList);
        }
        filterList.add(filter);
    }
}

