/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.LayoutProcessor;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FontHandlingPdfTest {
    private static String baseFontName = "C:/temp/Fonts/calibri.ttf";

    public static void main(String[] args) throws DocumentException, IOException {
        FontHandlingPdfTest.createPDFLigaturePara("pflicht - wo spacing", "C:/temp/pdf_para_ligatures_enabled.pdf");
        FontHandlingPdfTest.createPdfLigatureCB("pflicht", "C:/temp/pdf_cb_ligatures_enabled.pdf", "enableKernAndLig");
        FontHandlingPdfTest.createPdfLigatureCB("pflicht", "C:/temp/pdf_cb_ligatures_disabled.pdf", "disableKernAndLig");
        FontHandlingPdfTest.createPdfLigatureCB("pflicht", "C:/temp/pdf_cb_layout_processor_disabled.pdf", "disableLayoutProcessor");
        System.out.println("PDF generated successfully!");
    }

    public static void setFont(String font) {
        baseFontName = font;
    }

    public static String getFont() {
        return baseFontName;
    }

    private static BaseFont getBaseFontCreated() throws IOException {
        return BaseFont.createFont((String)FontHandlingPdfTest.getFont(), (String)"Identity-H", (boolean)true);
    }

    private static BaseFont getBaseFontFontFactory() {
        return FontFactory.getFont((String)FontHandlingPdfTest.getFont(), (String)"Identity-H", (boolean)true, (float)14.0f, (int)0).getBaseFont();
    }

    public static void createPDFLigaturePara(String docText, String exportPath) throws IOException, DocumentException {
        Document document = new Document();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(exportPath));
        }
        catch (DocumentException | FileNotFoundException e) {
            e.printStackTrace();
        }
        document.open();
        BaseFont bf = FontHandlingPdfTest.getBaseFontCreated();
        Font font = new Font(bf, 14.0f);
        if (!LayoutProcessor.isEnabled()) {
            LayoutProcessor.enableKernLiga();
        }
        document.add((Element)new Paragraph(docText, font));
        document.close();
    }

    public static void createPdfLigatureCB(String docText, String exportPath, String handlingMode) throws IOException, DocumentException {
        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(exportPath));
        document.open();
        PdfContentByte cb = writer.getDirectContent();
        BaseFont bf = FontHandlingPdfTest.getBaseFontFontFactory();
        bf.setIncludeCidSet(true);
        float x = 36.0f;
        float y = 750.0f;
        cb.saveState();
        cb.setCharacterSpacing(5.0f);
        cb.setColorFill(Color.BLACK);
        cb.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, 20.0f, 20.0f);
        cb.beginText();
        cb.setFontAndSize(bf, 20.0f);
        cb.setTextMatrix(x, y + 20.0f);
        if (!LayoutProcessor.isEnabled()) {
            if (handlingMode.equals("enableKernAndLig")) {
                LayoutProcessor.enableKernLiga();
            } else if (handlingMode.equals("disableKernAndLig")) {
                LayoutProcessor.enable((int)0);
            } else if (handlingMode.equals("disableLayoutProcessor")) {
                LayoutProcessor.enableKernLiga();
            }
        }
        cb.showText(docText);
        cb.endText();
        cb.restoreState();
        document.close();
    }
}

