/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.iv;

import java.io.File;
import java.io.IOException;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;

public class ReportletIVTest
extends EngineCase {
    public static final String RESOURCE_REPORTLET_IV_DESIGN = "org/eclipse/birt/report/engine/api/iv/reportlet_iv.rptdesign";
    public static final String RESOURCE_REPORTLET_SUBQUERY_IV_DESIGN = "org/eclipse/birt/report/engine/api/iv/reportlet_iv_subquery.rptdesign";
    public static final String RESOURCE_REPORTLET_QUERY_IV_DESIGN = "org/eclipse/birt/report/engine/api/iv/reportlet_iv_query.rptdesign";
    public static final String RESOURCE_REPORTLET_NESTQUERY_IV_DESIGN = "org/eclipse/birt/report/engine/api/iv/reportlet_iv_nestquery.rptdesign";
    public static final String REPORTLET_IV_DESIGN = "./utest/reportlet_iv.rptdesign";
    public static final String REPORTLET_SUBQUERY_IV_DESIGN = "./utest/reportlet_subquery_iv.rptdesign";
    public static final String REPORTLET_QUERY_IV_DESIGN = "./utest/reportlet_query_iv.rptdesign";
    public static final String REPORTLET_NESTQUERY_IV_DESIGN = "./utest/reportlet_nestquery_iv.rptdesign";
    public static final String REPORTLET_IV_DOCUMENT = "./utest/reportlet_iv.rptdocument";
    public static final String REPORTLET_SUBQUERY_IV_DOCUMENT = "./utest/reportlet_subquery_iv.rptdocument";
    public static final String REPORTLET_QUERY_IV_DOCUMENT = "./utest/reportlet_query_iv.rptdocument";
    public static final String REPORTLET_NESTQUERY_IV_DOCUMENT = "./utest/reportlet_nestquery_iv.rptdocument";

    public void setUp() throws Exception {
        super.setUp();
        new File("./utest").mkdirs();
        this.copyResource(RESOURCE_REPORTLET_IV_DESIGN, REPORTLET_IV_DESIGN);
        this.copyResource(RESOURCE_REPORTLET_QUERY_IV_DESIGN, REPORTLET_QUERY_IV_DESIGN);
        this.copyResource(RESOURCE_REPORTLET_SUBQUERY_IV_DESIGN, REPORTLET_SUBQUERY_IV_DESIGN);
        this.copyResource(RESOURCE_REPORTLET_NESTQUERY_IV_DESIGN, REPORTLET_NESTQUERY_IV_DESIGN);
        try {
            this.createReportDocument(REPORTLET_IV_DESIGN, REPORTLET_IV_DOCUMENT);
        }
        catch (EngineException ex) {
            ReportletIVTest.fail((String)ex.getMessage());
        }
    }

    public void tearDown() throws Exception {
        this.removeFile("./utest");
        super.tearDown();
    }

    public void testQuery() throws Exception {
        this.ivRunReport(REPORTLET_QUERY_IV_DESIGN, REPORTLET_IV_DOCUMENT, "REPORTLET_QUERY", REPORTLET_QUERY_IV_DOCUMENT);
        String output = this.ivRenderDocument(REPORTLET_QUERY_IV_DOCUMENT, "REPORTLET_QUERY");
        ReportletIVTest.assertTrue((output.indexOf("REPORTLET_QUERY") != -1 ? 1 : 0) != 0);
        ReportletIVTest.assertTrue((output.indexOf("REPORTLET_NESTQUERY") == -1 ? 1 : 0) != 0);
        ReportletIVTest.assertTrue((output.indexOf("REPORTLET_SUBQUERY") == -1 ? 1 : 0) != 0);
    }

    public void testNestQuery() throws Exception {
        this.ivRunReport(REPORTLET_NESTQUERY_IV_DESIGN, REPORTLET_IV_DOCUMENT, "REPORTLET_NESTQUERY_2", REPORTLET_NESTQUERY_IV_DOCUMENT);
        String output = this.ivRenderDocument(REPORTLET_NESTQUERY_IV_DOCUMENT, "REPORTLET_NESTQUERY_2");
        ReportletIVTest.assertTrue((output.indexOf("REPORTLET_NESTQUERY_2") != -1 ? 1 : 0) != 0);
        ReportletIVTest.assertTrue((output.indexOf("REPORTLET_QUERY") == -1 ? 1 : 0) != 0);
        ReportletIVTest.assertTrue((output.indexOf("REPORTLET_SUBQUERY") == -1 ? 1 : 0) != 0);
    }

    public void testSubQuery() throws Exception {
        this.ivRunReport(REPORTLET_SUBQUERY_IV_DESIGN, REPORTLET_IV_DOCUMENT, "REPORTLET_SUBQUERY_2", REPORTLET_SUBQUERY_IV_DOCUMENT);
        String output = this.ivRenderDocument(REPORTLET_SUBQUERY_IV_DOCUMENT, "REPORTLET_SUBQUERY_2");
        ReportletIVTest.assertTrue((output.indexOf("REPORTLET_SUBQUERY_2") != -1 ? 1 : 0) != 0);
        ReportletIVTest.assertTrue((output.indexOf("REPORTLET_NESTQUERY") == -1 ? 1 : 0) != 0);
        ReportletIVTest.assertTrue((output.indexOf("REPORTLET_QUERY") == -1 ? 1 : 0) != 0);
    }

    protected void ivRunReport(String designFile, String dataSource, String reportlet, String reportDocument) throws EngineException, IOException {
        try (IArchiveFile af = this.archiveFactory.openArchive(dataSource, "r");
             IArchiveFile av = this.archiveFactory.createView(reportDocument, af);){
            IReportRunnable runnable = this.engine.openReportDesign(designFile);
            try (IRunTask runTask = this.engine.createRunTask(runnable);){
                runTask.setDataSource((IDocArchiveReader)new ArchiveReader(af), reportlet);
                runTask.run((IDocArchiveWriter)new ArchiveWriter(av));
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected String ivRenderDocument(String document, String reportlet) throws EngineException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

