/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.chart;

import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.HashMap;
import junit.framework.TestCase;
import utility.ImageUtil;

public class ChartTestCase
extends TestCase {
    protected static final String TEST_FOLDER = "src";
    protected static final String OUTPUT_FOLDER = "output";
    protected static final String INPUT_FOLDER = "input";
    protected static final String GOLDEN_FOLDER = "golden" + ChartTestCase.getOSName();
    protected static final String PLUGIN_NAME = "org.eclipse.birt.report.tests.chart";

    private static String getOSName() {
        String name = System.getProperty("os.name").toLowerCase();
        if (name.indexOf("win") >= 0) {
            return "";
        }
        return "_" + name;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        String outputPath = this.genOutputFolder();
        outputPath = outputPath.replace('\\', '/');
        File outputFolder = new File(outputPath);
        File parent = new File(outputPath).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (!outputFolder.exists() && !outputFolder.mkdir()) {
            throw new IOException("Can not create the output folder");
        }
    }

    protected boolean compare(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        int i = 0;
        while (i < bytes1.length) {
            if (bytes1[i] != bytes2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean compareBytes(String golden, String output) throws Exception {
        FileInputStream is2;
        String className = this.getFullQualifiedClassName();
        className = className.replace('.', '/');
        golden = className + "/" + GOLDEN_FOLDER + "/" + (String)golden;
        InputStream is1 = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)golden);
        boolean compareResult = this.compare(is1, is2 = new FileInputStream(this.genOutputFile(output)));
        if (!compareResult) {
            InputStream in;
            Object goldenFrom = golden;
            String goldenTo = this.getOutputResourceFolder() + "/" + this.getFullQualifiedClassName() + "/diffGolden/" + output;
            String outputFrom = this.genOutputFile(output);
            String outputTo = this.getOutputResourceFolder() + "/" + this.getFullQualifiedClassName() + "/diffOutput/" + output;
            File parentOutput = new File(outputTo).getParentFile();
            if (parentOutput != null) {
                parentOutput.mkdirs();
            }
            this.copyFile(outputFrom, outputTo);
            File parentGolden = new File(goldenTo).getParentFile();
            if (parentGolden != null) {
                parentGolden.mkdirs();
            }
            ChartTestCase.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)goldenFrom)) != null ? 1 : 0) != 0);
            try {
                FileOutputStream fos = new FileOutputStream(goldenTo);
                byte[] fileData = new byte[5120];
                int readCount = -1;
                while ((readCount = in.read(fileData)) != -1) {
                    fos.write(fileData, 0, readCount);
                }
                fos.close();
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ChartTestCase.fail();
            }
        }
        return compareResult;
    }

    protected boolean compare(InputStream golden, InputStream output) throws Exception {
        int goldenChar = -1;
        while ((goldenChar = golden.read()) != -1) {
            if (goldenChar == output.read()) continue;
            return false;
        }
        return true;
    }

    protected String getClassFolder() {
        CodeSource source;
        Object pathBase = null;
        ProtectionDomain domain = ((Object)((Object)this)).getClass().getProtectionDomain();
        if (domain != null && (source = domain.getCodeSource()) != null) {
            URL url = source.getLocation();
            pathBase = url.getPath();
            if (((String)pathBase).endsWith("bin/")) {
                pathBase = ((String)pathBase).substring(0, ((String)pathBase).length() - 4);
            }
            if (((String)pathBase).endsWith("bin")) {
                pathBase = ((String)pathBase).substring(0, ((String)pathBase).length() - 3);
            }
        }
        pathBase = pathBase + TEST_FOLDER;
        Object className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = ((String)className).lastIndexOf(".");
        className = ((String)className).substring(0, lastDotIndex);
        className = (String)pathBase + "/" + ((String)className).replace('.', '/');
        return className;
    }

    protected String getClassFolder2() {
        Object className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = ((String)className).lastIndexOf(".");
        className = ((String)className).substring(0, lastDotIndex);
        className = TEST_FOLDER + ((String)className).replace('.', '/');
        return className;
    }

    protected String getFullQualifiedClassName() {
        Object className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = ((String)className).lastIndexOf(".");
        className = PLUGIN_NAME + ((String)className).substring(PLUGIN_NAME.length(), lastDotIndex).replace('.', '/');
        return className;
    }

    public String tempFolder() {
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        return tempDir;
    }

    public String getInputResourceFolder() {
        String resourceFolder = this.tempFolder() + "org.eclipse.birt.report.tests.chart.RESOURCE";
        return resourceFolder;
    }

    public String getOutputResourceFolder() {
        String outputFolder = this.tempFolder() + "org.eclipse.birt.report.tests.chart.OUTPUT";
        return outputFolder;
    }

    protected String genOutputFolder() {
        String outputFolder = this.getOutputResourceFolder() + File.separator + this.getFullQualifiedClassName() + "/output";
        return outputFolder;
    }

    protected String genInputFolder() {
        String inputFolder = this.getInputResourceFolder() + File.separator + this.getFullQualifiedClassName() + "/input";
        return inputFolder;
    }

    protected String genGoldenFolder() {
        String goldenFolder = this.getInputResourceFolder() + File.separator + this.getFullQualifiedClassName() + "/" + GOLDEN_FOLDER;
        return goldenFolder;
    }

    protected String genOutputFile(String output) {
        String outputFile = this.genOutputFolder() + File.separator + output;
        return outputFile;
    }

    protected String genInputFile(String input) {
        String inputFile = this.genInputFolder() + File.separator + input;
        return inputFile;
    }

    protected String genGoldenFile(String golden) {
        String goldenFile = this.genGoldenFolder() + File.separator + golden;
        return goldenFile;
    }

    protected void copyResource(String src, String tgt, String folder) {
        InputStream in;
        String className = this.getFullQualifiedClassName();
        tgt = this.getInputResourceFolder() + File.separator + className + "/" + folder + "/" + (String)tgt;
        className = className.replace('.', '/');
        src = className + "/" + folder + "/" + (String)src;
        File parent = new File((String)tgt).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        ChartTestCase.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)src)) != null ? 1 : 0) != 0);
        try {
            FileOutputStream fos = new FileOutputStream((String)tgt);
            byte[] fileData = new byte[5120];
            int readCount = -1;
            while ((readCount = in.read(fileData)) != -1) {
                fos.write(fileData, 0, readCount);
            }
            fos.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ChartTestCase.fail();
        }
    }

    protected void copyResource_INPUT(String input_resource, String input) {
        this.copyResource(input_resource, input, INPUT_FOLDER);
    }

    protected void copyResource_GOLDEN(String input_resource, String golden) {
        this.copyResource(input_resource, golden, GOLDEN_FOLDER);
    }

    protected void copyResource_SCRIPT(String input_resource, String script) {
        this.copyResource(input_resource, script, "input/scripts");
    }

    public void removeFile(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.removeFile(children[i]);
                ++i;
            }
        }
        if (file.exists() && !file.delete()) {
            System.out.println(file.toString() + " can't be removed");
        }
    }

    public void removeFile(String file) {
        this.removeFile(new File(file));
    }

    public void removeResource() {
        this.removeFile(this.getInputResourceFolder());
    }

    protected final void copyFile(String from, String to) throws IOException {
        File parent = new File(to).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            new File(to).createNewFile();
            bis = new BufferedInputStream(new FileInputStream(from));
            bos = new BufferedOutputStream(new FileOutputStream(to));
            int nextByte = 0;
            while ((nextByte = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(nextByte);
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected boolean compareImages(String golden, String output) throws Exception {
        String goldenFile = TEST_FOLDER + File.separator + this.getFullQualifiedClassName().replace('.', '/') + File.separator + GOLDEN_FOLDER + File.separator + golden;
        String outputFile = this.genOutputFolder() + File.separator + output;
        HashMap<ImageUtil.ImageCompParam, Integer> params = new HashMap<ImageUtil.ImageCompParam, Integer>();
        params.put(ImageUtil.ImageCompParam.TOLERANCE, 4);
        Image result = ImageUtil.compare((String)new File(goldenFile).getAbsolutePath(), (String)new File(outputFile).getAbsolutePath(), params);
        if (result == null) {
            return true;
        }
        System.err.println("saving>" + new File(goldenFile).getAbsolutePath());
        Files.copy(Path.of(new File(outputFile).getAbsolutePath(), new String[0]), Path.of(new File(goldenFile).getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        return false;
    }
}

