/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding.newbinding;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.binding.APITestCase;
import org.eclipse.birt.data.engine.core.DataException;
import org.junit.Assert;
import org.junit.Test;
import testutil.ConfigText;

public class MultiplePassTest
extends APITestCase {
    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(this, ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    @Test
    public void testTopBottomN() throws Exception {
        String[] bindingNameGroup = null;
        IBaseExpression[] bindingExprGroup = null;
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT", "FILTER_COUNTRY", "FILTER_SALE_DATE"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.SALE_DATE")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = null;
        SortDefinition[] sortDefn = null;
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_0", 0), new ScriptExpression("row.ROW_rowPosition ", 0), new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 15, "6")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_COUNTRY", 15, "5")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_SALE_DATE", 14, "3"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
    }

    private void createAndRunQuery(String[] bindingNameGroup, IBaseExpression[] bindingExprGroup, String[] bindingNameSort, IBaseExpression[] bindingExprSort, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, String[] bindingNameRow, IBaseExpression[] bindingExprRow, IBaseExpression[] expressions, GroupDefinition[] groupDefn, SortDefinition[] sortDefn, FilterDefinition[] filters) throws Exception, IOException {
        QueryDefinition queryDefn = this.createQueryDefn(bindingNameRow, expressions, groupDefn, sortDefn, filters);
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, queryDefn);
    }

    private void populateBindings(String[] bindingNameGroup, IBaseExpression[] bindingExprGroup, String[] bindingNameSort, IBaseExpression[] bindingExprSort, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, String[] bindingNameRow, IBaseExpression[] bindingExprRow, QueryDefinition queryDefn) {
        this.populateBindings(queryDefn, bindingNameGroup, bindingExprGroup);
        this.populateBindings(queryDefn, bindingNameSort, bindingExprSort);
        this.populateBindings(queryDefn, bindingNameFilter, bindingExprFilter);
        this.populateBindings(queryDefn, bindingNameRow, bindingExprRow);
    }

    private void populateBindings(QueryDefinition queryDefn, String[] name, IBaseExpression[] expr) {
        if (name != null && expr != null) {
            int i = 0;
            while (i < name.length) {
                queryDefn.addResultSetExpression(name[i], expr[i]);
                ++i;
            }
        }
    }

    @Test
    public void testTopBottomPercent() throws Exception {
        String[] bindingNameGroup = null;
        IBaseExpression[] bindingExprGroup = null;
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT", "FILTER_COUNTRY", "FILTER_SALE_DATE"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.SALE_DATE")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = null;
        SortDefinition[] sortDefn = null;
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_0", 0), new ScriptExpression("row.ROW_rowPosition ", 0), new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 17, "75")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_COUNTRY", 15, "5")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_SALE_DATE", 16, "60"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
    }

    @Test
    public void testTopBottmNwithOtherFilters() throws Exception {
        String[] bindingNameGroup = null;
        IBaseExpression[] bindingExprGroup = null;
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT", "FILTER_COUNTRY"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.COUNTRY")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = null;
        SortDefinition[] sortDefn = null;
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_0", 0), new ScriptExpression("row.ROW_rowPosition ", 0), new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 6, "100")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 6, "400")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 15, "16")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_COUNTRY", 15, "1"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
    }

    private void createAndRunQuery(String[] bindingNameGroup, IBaseExpression[] bindingExprGroup, String[] bindingNameSort, IBaseExpression[] bindingExprSort, String[] bindingNameFilter, IBaseExpression[] bindingExprFilter, String[] bindingNameRow, IBaseExpression[] bindingExprRow, IBaseExpression[] expressions, QueryDefinition queryDefn) throws Exception, IOException {
        this.populateBindings(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, queryDefn);
        this.executeQuery(queryDefn, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testTopBottmPercentWithOtherFilters() throws Exception {
        String[] bindingNameGroup = null;
        IBaseExpression[] bindingExprGroup = null;
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT", "FILTER_COUNTRY"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.COUNTRY")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = null;
        SortDefinition[] sortDefn = null;
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_0", 0), new ScriptExpression("row.ROW_rowPosition ", 0), new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 17, "100")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 6, "100")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_COUNTRY", 17, "75")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 6, "400"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
    }

    @Test
    public void testInvalidFilter() throws Exception {
        String[] bindingNameGroup = null;
        IBaseExpression[] bindingExprGroup = null;
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT")};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = null;
        SortDefinition[] sortDefn = null;
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_0", 0), new ScriptExpression("row.ROW_rowPosition ", 0), new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 14, "-1"))};
        try {
            this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
            Assert.fail((String)"Should not reach here");
        }
        catch (DataException dataException) {
            // empty catch block
        }
        filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 14, "abc"))};
        try {
            this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, sortDefn, filters);
            Assert.fail((String)"Should not reach here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAggrFilter1() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN"};
        QueryDefinition qd = this.newReportQuery();
        qd.addBinding((IBinding)new Binding(bindingNameRow[0], (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[1], (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[2], (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[3], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[4], (IBaseExpression)new ScriptExpression("row.b4")));
        Binding b4 = new Binding("b4", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b4.setAggrFunction("ISTOPN");
        b4.addArgument((IBaseExpression)new ScriptExpression("2"));
        b4.addAggregateOn("group0");
        qd.addBinding((IBinding)b4);
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        qd.addGroup((IGroupDefinition)groupDefn[0]);
        qd.addGroup((IGroupDefinition)groupDefn[1]);
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("row.b4", 11));
        qd.addFilter((IFilterDefinition)filterDefn);
        this.executeQuery(qd, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testAggrFilter2() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN", "ROW_BOTTOMN"};
        QueryDefinition qd = this.newReportQuery();
        qd.addBinding((IBinding)new Binding(bindingNameRow[0], (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[1], (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[2], (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[3], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[4], (IBaseExpression)new ScriptExpression("row.b4")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[5], (IBaseExpression)new ScriptExpression("row.b5")));
        Binding b4 = new Binding("b4", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b4.setAggrFunction("ISTOPN");
        b4.addArgument((IBaseExpression)new ScriptExpression("3"));
        b4.addAggregateOn("group0");
        qd.addBinding((IBinding)b4);
        Binding b5 = new Binding("b5", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b5.setAggrFunction("ISBOTTOMN");
        b5.addArgument((IBaseExpression)new ScriptExpression("3"));
        b5.addAggregateOn("group0");
        qd.addBinding((IBinding)b5);
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        qd.addGroup((IGroupDefinition)groupDefn[0]);
        qd.addGroup((IGroupDefinition)groupDefn[1]);
        FilterDefinition filterDefn1 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row.b4", 11));
        FilterDefinition filterDefn2 = new FilterDefinition((IBaseExpression)new ConditionalExpression("row.b5", 11));
        qd.addFilter((IFilterDefinition)filterDefn1);
        qd.addFilter((IFilterDefinition)filterDefn2);
        this.executeQuery(qd, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testGroupFiltering() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = null;
        IBaseExpression[] bindingExprSort = null;
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("Total.sum(row.ROW_AMOUNT,Total.NO_FILTER)>7000"));
        groupDefn[0].addFilter((IFilterDefinition)filterDefn);
        filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("Total.sum(row.ROW_AMOUNT,Total.NO_FILTER,2)<=400"));
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        ConditionalExpression ce = new ConditionalExpression("Total.sum(row.ROW_AMOUNT)", 15, "1");
        ce.setGroupName("group1");
        filterDefn = new FilterDefinition((IBaseExpression)ce);
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    @Test
    public void testGroupSorting() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,Total.NO_FILTER,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        groupDefn[0].setSortDirection(1);
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,Total.NO_FILTER,Total.CURRENT_GROUP)");
        sortDefn.setSortDirection(0);
        groupDefn[1].addSort(sortDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    @Test
    public void testGroupSorting2() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].setSortDirection(1);
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[1].setSortDirection(1);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    @Test
    public void testGroupFilteringSorting1() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,Total.CURRENT_GROUP)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("Total.sum(dataSetRow.AMOUNT,null,2)>400"));
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    @Test
    public void testGroupFilteringSorting2() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = new String[]{"FILTER_1", "FILTER_2", "FILTER_3"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("Total.sum(dataSetRow.AMOUNT,null,1)"), new ScriptExpression("Total.sum(dataSetRow.AMOUNT,null,2)"), new ScriptExpression("Total.sum(dataSetRow.AMOUNT,null,2)<7400")};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        FilterDefinition filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_1", 15, "2"));
        groupDefn[0].addFilter((IFilterDefinition)filterDefn);
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        filterDefn = new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_2", 14, "1"));
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        filterDefn = new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_3"));
        groupDefn[1].addFilter((IFilterDefinition)filterDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    @Test
    public void testGroupFilteringSorting3() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 17, "75")));
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 14, "2")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    @Test
    public void testGroupFilteringSorting4() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 17, "75")));
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 14, "2")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        QueryDefinition queryDefn = this.createQueryDefn(bindingNameRow, bindingExprRow, groupDefn, null, null);
        this.populateBindings(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, queryDefn);
        this.executeQuery(queryDefn, bindingNameRow);
        this.executeQuery(queryDefn, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testGroupFilteringSorting5() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 3, "5000")));
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 14, "1")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        QueryDefinition queryDefn = this.createQueryDefn(bindingNameRow, bindingExprRow, groupDefn, null, null);
        this.populateBindings(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, queryDefn);
        this.executeQuery(queryDefn, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testMixedFiltering() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = new String[]{"FILTER_1", "FILTER_2"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.AMOUNT")};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 17, "75")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_1", 15, "7")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_2", 3, "700"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, filters);
    }

    @Test
    public void testTotalCount() throws Exception {
        String[] bindingNameRow = new String[]{"amount", "amountTOTAL"};
        QueryDefinition qd = this.newReportQuery();
        qd.addBinding((IBinding)new Binding(bindingNameRow[0], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[1], (IBaseExpression)new ScriptExpression("Total.count(row[\"amount\"]<=500)")));
        IResultIterator itr = this.executeQuery((IQueryDefinition)qd);
        int count = 0;
        while (itr.next()) {
            Assert.assertTrue((itr.getInteger(bindingNameRow[1]) == 6 ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertTrue((count > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIndirectNestedTotal() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("Total.sum(dataSetRow.AMOUNT)"), new ScriptExpression("Total.isTopN(row.ROW_AMOUNT,3)")};
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0), new ScriptExpression("row.ROW_TOPN", 0)};
        this.createAndRunQuery(null, null, null, null, null, null, bindingNameRow, bindingExprRow, expressions, null, null, null);
    }

    @Test
    public void testSimpleNestedTotal() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_AMOUNT_TOTAL"};
        QueryDefinition qd = this.newReportQuery();
        qd.addBinding((IBinding)new Binding(bindingNameRow[0], (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[1], (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[2], (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[3], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[4], (IBaseExpression)new ScriptExpression("row.b4")));
        Binding b4 = new Binding("b4", (IBaseExpression)new ScriptExpression("row.b41"));
        b4.setAggrFunction("SUM");
        qd.addBinding((IBinding)b4);
        Binding b41 = new Binding("b41", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b41.setAggrFunction("SUM");
        b41.addAggregateOn("group0");
        qd.addBinding((IBinding)b41);
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        qd.addGroup((IGroupDefinition)groupDefn[0]);
        qd.addGroup((IGroupDefinition)groupDefn[1]);
        this.executeQuery(qd, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testNestedTotal() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN", "ROW_TOTALALL1", "ROW_TOTALALL2", "ROW_TOTALALL3", "ROW_TOTALALL4", "ROW_TOTALALL5", "ROW_TOTALALL6", "ROW_TOTALALL7", "ROW_TOTALALL8", "ROW_TOTALALL9", "ROW_TOTALALL10", "ROW_TOTALALL11"};
        QueryDefinition qd = this.newReportQuery();
        qd.addBinding((IBinding)new Binding(bindingNameRow[0], (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[1], (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[2], (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[3], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[4], (IBaseExpression)new ScriptExpression("row.b4")));
        Binding b4 = new Binding("b4", (IBaseExpression)new ScriptExpression("row.b41"));
        b4.setAggrFunction("ISTOPN");
        b4.addArgument((IBaseExpression)new ScriptExpression("2"));
        qd.addBinding((IBinding)b4);
        Binding b41 = new Binding("b41", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b41.setAggrFunction("SUM");
        b41.addAggregateOn("group1");
        qd.addBinding((IBinding)b41);
        Binding b5 = new Binding(bindingNameRow[5], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b5.setAggrFunction("SUM");
        qd.addBinding((IBinding)b5);
        qd.addBinding((IBinding)new Binding(bindingNameRow[6], (IBaseExpression)new ScriptExpression("row.b6")));
        Binding b6 = new Binding("b6", (IBaseExpression)new ScriptExpression("row.b61"));
        b6.setAggrFunction("SUM");
        qd.addBinding((IBinding)b6);
        Binding b61 = new Binding("b61", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b61.setAggrFunction("SUM");
        b61.addAggregateOn("group0");
        qd.addBinding((IBinding)b61);
        qd.addBinding((IBinding)new Binding(bindingNameRow[7], (IBaseExpression)new ScriptExpression("row.b7")));
        Binding b7 = new Binding("b7", (IBaseExpression)new ScriptExpression("row.b71"));
        b7.setAggrFunction("SUM");
        qd.addBinding((IBinding)b7);
        Binding b71 = new Binding("b71", (IBaseExpression)new ScriptExpression("row.b72"));
        b71.setAggrFunction("SUM");
        b71.addAggregateOn("group0");
        qd.addBinding((IBinding)b71);
        Binding b72 = new Binding("b72", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b72.setAggrFunction("SUM");
        b72.addAggregateOn("group1");
        qd.addBinding((IBinding)b72);
        qd.addBinding((IBinding)new Binding(bindingNameRow[8], (IBaseExpression)new ScriptExpression("row.b8")));
        Binding b8 = new Binding("b8", (IBaseExpression)new ScriptExpression("row.b81"));
        b8.setAggrFunction("SUM");
        qd.addBinding((IBinding)b8);
        Binding b81 = new Binding("b81", (IBaseExpression)new ScriptExpression("row.b82 + 1"));
        b81.setAggrFunction("SUM");
        b81.addAggregateOn("group0");
        qd.addBinding((IBinding)b81);
        Binding b82 = new Binding("b82", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b82.setAggrFunction("SUM");
        b82.addAggregateOn("group1");
        qd.addBinding((IBinding)b82);
        qd.addBinding((IBinding)new Binding(bindingNameRow[9], (IBaseExpression)new ScriptExpression("row.b9")));
        Binding b9 = new Binding("b9", (IBaseExpression)new ScriptExpression("row.b91+1"));
        b9.setAggrFunction("SUM");
        qd.addBinding((IBinding)b9);
        Binding b91 = new Binding("b91", (IBaseExpression)new ScriptExpression("row.b92"));
        b91.setAggrFunction("SUM");
        b91.addAggregateOn("group0");
        qd.addBinding((IBinding)b91);
        Binding b92 = new Binding("b92", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b92.setAggrFunction("SUM");
        b92.addAggregateOn("group1");
        qd.addBinding((IBinding)b92);
        qd.addBinding((IBinding)new Binding(bindingNameRow[10], (IBaseExpression)new ScriptExpression("row.b10")));
        Binding b10 = new Binding("b10", (IBaseExpression)new ScriptExpression("row.b101 + dataSetRow.AMOUNT"));
        b10.setAggrFunction("SUM");
        qd.addBinding((IBinding)b10);
        Binding b101 = new Binding("b101", (IBaseExpression)new ScriptExpression("row.b102"));
        b101.setAggrFunction("SUM");
        b101.addAggregateOn("group0");
        qd.addBinding((IBinding)b101);
        Binding b102 = new Binding("b102", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b102.setAggrFunction("SUM");
        b102.addAggregateOn("group1");
        qd.addBinding((IBinding)b102);
        qd.addBinding((IBinding)new Binding(bindingNameRow[11], (IBaseExpression)new ScriptExpression("row.b11")));
        Binding b11 = new Binding("b11", (IBaseExpression)new ScriptExpression("row.b111"));
        b11.setAggrFunction("SUM");
        qd.addBinding((IBinding)b11);
        Binding b111 = new Binding("b111", (IBaseExpression)new ScriptExpression("row.b112 + dataSetRow.AMOUNT"));
        b111.setAggrFunction("SUM");
        b111.addAggregateOn("group0");
        qd.addBinding((IBinding)b111);
        Binding b112 = new Binding("b112", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b112.setAggrFunction("SUM");
        b112.addAggregateOn("group1");
        qd.addBinding((IBinding)b112);
        qd.addBinding((IBinding)new Binding(bindingNameRow[12], (IBaseExpression)new ScriptExpression("row.b12")));
        Binding b12 = new Binding("b12", (IBaseExpression)new ScriptExpression("row.b121 + row.ROW_AMOUNT"));
        b12.setAggrFunction("SUM");
        qd.addBinding((IBinding)b12);
        Binding b121 = new Binding("b121", (IBaseExpression)new ScriptExpression("row.b122"));
        b121.setAggrFunction("SUM");
        b121.addAggregateOn("group0");
        qd.addBinding((IBinding)b121);
        Binding b122 = new Binding("b122", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b122.setAggrFunction("SUM");
        b122.addAggregateOn("group1");
        qd.addBinding((IBinding)b122);
        qd.addBinding((IBinding)new Binding(bindingNameRow[13], (IBaseExpression)new ScriptExpression("row.b13")));
        Binding b13 = new Binding("b13", (IBaseExpression)new ScriptExpression("row.b131"));
        b13.setAggrFunction("SUM");
        qd.addBinding((IBinding)b13);
        Binding b131 = new Binding("b131", (IBaseExpression)new ScriptExpression("row.b132 + row.ROW_AMOUNT"));
        b131.setAggrFunction("SUM");
        b131.addAggregateOn("group0");
        qd.addBinding((IBinding)b131);
        Binding b132 = new Binding("b132", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b132.setAggrFunction("SUM");
        b132.addAggregateOn("group1");
        qd.addBinding((IBinding)b132);
        qd.addBinding((IBinding)new Binding(bindingNameRow[14], (IBaseExpression)new ScriptExpression("row.b14")));
        Binding b14 = new Binding("b14", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT/row.b141"));
        b14.setAggrFunction("SUM");
        qd.addBinding((IBinding)b14);
        Binding b141 = new Binding("b141", (IBaseExpression)new ScriptExpression("row.ROW_AMOUNT"));
        b141.setAggrFunction("SUM");
        b141.addAggregateOn("group0");
        qd.addBinding((IBinding)b141);
        qd.addBinding((IBinding)new Binding(bindingNameRow[15], (IBaseExpression)new ScriptExpression("row.b15")));
        Binding b15 = new Binding("b15", (IBaseExpression)new ScriptExpression("row.ROW_AMOUNT/row.b151"));
        b15.setAggrFunction("SUM");
        qd.addBinding((IBinding)b15);
        Binding b151 = new Binding("b151", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b151.setAggrFunction("SUM");
        b151.addAggregateOn("group0");
        qd.addBinding((IBinding)b151);
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        qd.addGroup((IGroupDefinition)groupDefn[0]);
        qd.addGroup((IGroupDefinition)groupDefn[1]);
        this.executeQuery(qd, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testNestedTotal1() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN", "ROW_TOTALALL1", "ROW_TOTALALL2", "ROW_TOTALALL3", "ROW_TOTALALL4", "ROW_TOTALALL5", "ROW_TOTALALL6", "ROW_TOTALALL7", "ROW_TOTALALL8", "ROW_TOTALALL9", "ROW_TOTALALL10", "ROW_TOTALALL11"};
        QueryDefinition qd = this.newReportQuery();
        qd.addBinding((IBinding)new Binding(bindingNameRow[0], (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[1], (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[2], (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[3], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT")));
        Binding b4 = new Binding(bindingNameRow[4], (IBaseExpression)new ScriptExpression("row.b41"));
        b4.setAggrFunction("ISTOPN");
        b4.addArgument((IBaseExpression)new ScriptExpression("2"));
        qd.addBinding((IBinding)b4);
        Binding b41 = new Binding("b41", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b41.setAggrFunction("SUM");
        b41.addAggregateOn("group1");
        qd.addBinding((IBinding)b41);
        Binding b5 = new Binding(bindingNameRow[5], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b5.setAggrFunction("SUM");
        qd.addBinding((IBinding)b5);
        Binding b6 = new Binding(bindingNameRow[6], (IBaseExpression)new ScriptExpression("row.b61"));
        b6.setAggrFunction("SUM");
        qd.addBinding((IBinding)b6);
        Binding b61 = new Binding("b61", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b61.setAggrFunction("SUM");
        b61.addAggregateOn("group0");
        qd.addBinding((IBinding)b61);
        Binding b7 = new Binding(bindingNameRow[7], (IBaseExpression)new ScriptExpression("row.b71"));
        b7.setAggrFunction("SUM");
        qd.addBinding((IBinding)b7);
        Binding b71 = new Binding("b71", (IBaseExpression)new ScriptExpression("row.b72"));
        b71.setAggrFunction("SUM");
        b71.addAggregateOn("group0");
        qd.addBinding((IBinding)b71);
        Binding b72 = new Binding("b72", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b72.setAggrFunction("SUM");
        b72.addAggregateOn("group1");
        qd.addBinding((IBinding)b72);
        Binding b8 = new Binding(bindingNameRow[8], (IBaseExpression)new ScriptExpression("row.b81"));
        b8.setAggrFunction("SUM");
        qd.addBinding((IBinding)b8);
        Binding b81 = new Binding("b81", (IBaseExpression)new ScriptExpression("row.b82 + 1"));
        b81.setAggrFunction("SUM");
        b81.addAggregateOn("group0");
        qd.addBinding((IBinding)b81);
        Binding b82 = new Binding("b82", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b82.setAggrFunction("SUM");
        b82.addAggregateOn("group1");
        qd.addBinding((IBinding)b82);
        Binding b9 = new Binding(bindingNameRow[9], (IBaseExpression)new ScriptExpression("row.b91 + 1"));
        b9.setAggrFunction("SUM");
        qd.addBinding((IBinding)b9);
        Binding b91 = new Binding("b91", (IBaseExpression)new ScriptExpression("row.b92"));
        b91.setAggrFunction("SUM");
        b91.addAggregateOn("group0");
        qd.addBinding((IBinding)b91);
        Binding b92 = new Binding("b92", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b92.setAggrFunction("SUM");
        b92.addAggregateOn("group1");
        qd.addBinding((IBinding)b92);
        Binding b10 = new Binding(bindingNameRow[10], (IBaseExpression)new ScriptExpression("row.b101 + dataSetRow.AMOUNT"));
        b10.setAggrFunction("SUM");
        qd.addBinding((IBinding)b10);
        Binding b101 = new Binding("b101", (IBaseExpression)new ScriptExpression("row.b102"));
        b101.setAggrFunction("SUM");
        b101.addAggregateOn("group0");
        qd.addBinding((IBinding)b101);
        Binding b102 = new Binding("b102", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b102.setAggrFunction("SUM");
        b102.addAggregateOn("group1");
        qd.addBinding((IBinding)b102);
        Binding b11 = new Binding(bindingNameRow[11], (IBaseExpression)new ScriptExpression("row.b111"));
        b11.setAggrFunction("SUM");
        qd.addBinding((IBinding)b11);
        Binding b111 = new Binding("b111", (IBaseExpression)new ScriptExpression("row.b112 + dataSetRow.AMOUNT"));
        b111.setAggrFunction("SUM");
        b111.addAggregateOn("group0");
        qd.addBinding((IBinding)b111);
        Binding b112 = new Binding("b112", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b112.setAggrFunction("SUM");
        b112.addAggregateOn("group1");
        qd.addBinding((IBinding)b112);
        Binding b12 = new Binding(bindingNameRow[12], (IBaseExpression)new ScriptExpression("row.b121 + row.ROW_AMOUNT"));
        b12.setAggrFunction("SUM");
        qd.addBinding((IBinding)b12);
        Binding b121 = new Binding("b121", (IBaseExpression)new ScriptExpression("row.b122"));
        b121.setAggrFunction("SUM");
        b121.addAggregateOn("group0");
        qd.addBinding((IBinding)b121);
        Binding b122 = new Binding("b122", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b122.setAggrFunction("SUM");
        b122.addAggregateOn("group1");
        qd.addBinding((IBinding)b122);
        Binding b13 = new Binding(bindingNameRow[13], (IBaseExpression)new ScriptExpression("row.b131"));
        b13.setAggrFunction("SUM");
        qd.addBinding((IBinding)b13);
        Binding b131 = new Binding("b131", (IBaseExpression)new ScriptExpression("row.b132+row.ROW_AMOUNT"));
        b131.setAggrFunction("SUM");
        b131.addAggregateOn("group0");
        qd.addBinding((IBinding)b131);
        Binding b132 = new Binding("b132", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b132.setAggrFunction("SUM");
        b132.addAggregateOn("group1");
        qd.addBinding((IBinding)b132);
        Binding b14 = new Binding(bindingNameRow[14], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT/row.b141"));
        b14.setAggrFunction("SUM");
        qd.addBinding((IBinding)b14);
        Binding b141 = new Binding("b141", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b141.addAggregateOn("group0");
        b141.setAggrFunction("SUM");
        qd.addBinding((IBinding)b141);
        Binding b15 = new Binding(bindingNameRow[15], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT/row.b151"));
        b15.setAggrFunction("SUM");
        qd.addBinding((IBinding)b15);
        Binding b151 = new Binding("b151", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b151.addAggregateOn("group0");
        b151.setAggrFunction("SUM");
        qd.addBinding((IBinding)b151);
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        qd.addGroup((IGroupDefinition)groupDefn[0]);
        qd.addGroup((IGroupDefinition)groupDefn[1]);
        this.executeQuery(qd, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testNestedTotal2() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN", "ROW_TOTALALL1", "ROW_TOTALALL2", "ROW_TOTALALL3", "ROW_TOTALALL4", "ROW_TOTALALL5", "ROW_TOTALALL6", "ROW_TOTALALL7", "ROW_TOTALALL8", "ROW_TOTALALL9", "ROW_TOTALALL10", "ROW_TOTALALL11"};
        QueryDefinition qd = this.newReportQuery();
        qd.addBinding((IBinding)new Binding(bindingNameRow[0], (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[1], (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[2], (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[3], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT")));
        Binding b4 = new Binding(bindingNameRow[4], (IBaseExpression)new ScriptExpression("row.b41"));
        b4.setAggrFunction("ISTOPN");
        b4.addArgument((IBaseExpression)new ScriptExpression("1"));
        qd.addBinding((IBinding)b4);
        Binding b41 = new Binding("b41", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b41.setAggrFunction("SUM");
        b41.addAggregateOn("group1");
        qd.addBinding((IBinding)b41);
        Binding b5 = new Binding(bindingNameRow[5], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b5.setAggrFunction("SUM");
        b5.setFilter((IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT>100"));
        qd.addBinding((IBinding)b5);
        Binding b6 = new Binding(bindingNameRow[6], (IBaseExpression)new ScriptExpression("row.b61"));
        b6.setAggrFunction("SUM");
        b6.setFilter((IBaseExpression)new ScriptExpression("row.b61 > 2000"));
        qd.addBinding((IBinding)b6);
        Binding b61 = new Binding("b61", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b61.setAggrFunction("SUM");
        b61.addAggregateOn("group0");
        qd.addBinding((IBinding)b61);
        Binding b7 = new Binding(bindingNameRow[7], (IBaseExpression)new ScriptExpression("row.b71"));
        b7.setAggrFunction("SUM");
        qd.addBinding((IBinding)b7);
        Binding b71 = new Binding("b71", (IBaseExpression)new ScriptExpression("row.b72"));
        b71.setAggrFunction("SUM");
        b71.addAggregateOn("group0");
        qd.addBinding((IBinding)b71);
        Binding b72 = new Binding("b72", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b72.setAggrFunction("SUM");
        b72.setFilter((IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT >400"));
        b72.addAggregateOn("group1");
        qd.addBinding((IBinding)b72);
        Binding b8 = new Binding(bindingNameRow[8], (IBaseExpression)new ScriptExpression("row.b81"));
        b8.setAggrFunction("SUM");
        qd.addBinding((IBinding)b8);
        Binding b81 = new Binding("b81", (IBaseExpression)new ScriptExpression("row.b82"));
        b81.setAggrFunction("SUM");
        b81.addAggregateOn("group0");
        qd.addBinding((IBinding)b81);
        Binding b82 = new Binding("b82", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b82.setAggrFunction("SUM");
        b82.setFilter((IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT > 100 "));
        b82.addAggregateOn("group1");
        qd.addBinding((IBinding)b82);
        Binding b9 = new Binding(bindingNameRow[9], (IBaseExpression)new ScriptExpression("row.b91"));
        b9.setAggrFunction("SUM");
        qd.addBinding((IBinding)b9);
        Binding b91 = new Binding("b91", (IBaseExpression)new ScriptExpression("row.b92"));
        b91.setAggrFunction("SUM");
        b91.setFilter((IBaseExpression)new ScriptExpression("row.b92>1"));
        b91.addAggregateOn("group0");
        qd.addBinding((IBinding)b91);
        Binding b92 = new Binding("b92", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b92.setAggrFunction("SUM");
        b92.addAggregateOn("group1");
        qd.addBinding((IBinding)b92);
        Binding b10 = new Binding(bindingNameRow[10], (IBaseExpression)new ScriptExpression("row.b101 + dataSetRow.AMOUNT"));
        b10.setAggrFunction("SUM");
        qd.addBinding((IBinding)b10);
        Binding b101 = new Binding("b101", (IBaseExpression)new ScriptExpression("row.b102"));
        b101.setAggrFunction("SUM");
        b101.addAggregateOn("group0");
        qd.addBinding((IBinding)b101);
        Binding b102 = new Binding("b102", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b102.setAggrFunction("SUM");
        b102.addAggregateOn("group1");
        qd.addBinding((IBinding)b102);
        Binding b11 = new Binding(bindingNameRow[11], (IBaseExpression)new ScriptExpression("row.b111"));
        b11.setAggrFunction("SUM");
        b11.setFilter((IBaseExpression)new ScriptExpression("row.b111 > 7000"));
        qd.addBinding((IBinding)b11);
        Binding b111 = new Binding("b111", (IBaseExpression)new ScriptExpression("row.b112"));
        b111.setAggrFunction("SUM");
        b111.addAggregateOn("group0");
        qd.addBinding((IBinding)b111);
        Binding b112 = new Binding("b112", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b112.setAggrFunction("SUM");
        b112.addAggregateOn("group1");
        qd.addBinding((IBinding)b112);
        Binding b12 = new Binding(bindingNameRow[12], (IBaseExpression)new ScriptExpression("row.b121 + row.ROW_AMOUNT"));
        b12.setAggrFunction("SUM");
        qd.addBinding((IBinding)b12);
        Binding b121 = new Binding("b121", (IBaseExpression)new ScriptExpression("row.b122"));
        b121.setAggrFunction("SUM");
        b121.addAggregateOn("group0");
        qd.addBinding((IBinding)b121);
        Binding b122 = new Binding("b122", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b122.setAggrFunction("SUM");
        b122.addAggregateOn("group1");
        qd.addBinding((IBinding)b122);
        Binding b13 = new Binding(bindingNameRow[13], (IBaseExpression)new ScriptExpression("row.b131"));
        b13.setAggrFunction("SUM");
        qd.addBinding((IBinding)b13);
        Binding b131 = new Binding("b131", (IBaseExpression)new ScriptExpression("row.b132+row.ROW_AMOUNT"));
        b131.setAggrFunction("SUM");
        b131.addAggregateOn("group0");
        qd.addBinding((IBinding)b131);
        Binding b132 = new Binding("b132", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b132.setAggrFunction("SUM");
        b132.addAggregateOn("group1");
        qd.addBinding((IBinding)b132);
        Binding b14 = new Binding(bindingNameRow[14], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT/row.b141"));
        b14.setAggrFunction("SUM");
        qd.addBinding((IBinding)b14);
        Binding b141 = new Binding("b141", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b141.addAggregateOn("group0");
        b141.setAggrFunction("SUM");
        qd.addBinding((IBinding)b141);
        Binding b15 = new Binding(bindingNameRow[15], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT/row.b151"));
        b15.setAggrFunction("SUM");
        qd.addBinding((IBinding)b15);
        Binding b151 = new Binding("b151", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b151.addAggregateOn("group0");
        b151.setAggrFunction("SUM");
        qd.addBinding((IBinding)b151);
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        qd.addGroup((IGroupDefinition)groupDefn[0]);
        qd.addGroup((IGroupDefinition)groupDefn[1]);
        this.executeQuery(qd, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testNestedTotal3() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN"};
        QueryDefinition qd = this.newReportQuery();
        qd.addBinding((IBinding)new Binding(bindingNameRow[0], (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[1], (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[2], (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[3], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT")));
        Binding b4 = new Binding(bindingNameRow[4], (IBaseExpression)new ScriptExpression("row.b41"));
        b4.setAggrFunction("SUM");
        b4.setFilter((IBaseExpression)new ScriptExpression("row.b41>7000"));
        Binding b41 = new Binding("b41", (IBaseExpression)new ScriptExpression("row.b42"));
        b41.addAggregateOn("group0");
        b41.setAggrFunction("SUM");
        Binding b42 = new Binding("b42", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b42.addAggregateOn("group1");
        b42.setAggrFunction("SUM");
        qd.addBinding((IBinding)b4);
        qd.addBinding((IBinding)b41);
        qd.addBinding((IBinding)b42);
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        qd.addGroup((IGroupDefinition)groupDefn[0]);
        qd.addGroup((IGroupDefinition)groupDefn[1]);
        this.executeQuery(qd, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testNestedTotal4() throws IOException, Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOPN", "ROW_5"};
        QueryDefinition qd = this.newReportQuery();
        qd.addBinding((IBinding)new Binding(bindingNameRow[0], (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[1], (IBaseExpression)new ScriptExpression("dataSetRow.CITY")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[2], (IBaseExpression)new ScriptExpression("dataSetRow.SALE_DATE")));
        qd.addBinding((IBinding)new Binding(bindingNameRow[3], (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT")));
        Binding b4 = new Binding(bindingNameRow[4], (IBaseExpression)new ScriptExpression("row.b41"));
        b4.setAggrFunction("SUM");
        b4.setFilter((IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT>10"));
        Binding b41 = new Binding("b41", (IBaseExpression)new ScriptExpression("row.b42"));
        b41.addAggregateOn("group0");
        b41.setAggrFunction("SUM");
        Binding b42 = new Binding("b42", (IBaseExpression)new ScriptExpression("dataSetRow.AMOUNT"));
        b42.addAggregateOn("group1");
        b42.setAggrFunction("SUM");
        qd.addBinding((IBinding)b4);
        qd.addBinding((IBinding)b41);
        qd.addBinding((IBinding)b42);
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        groupDefn[1].setKeyExpression("row.ROW_CITY");
        qd.addGroup((IGroupDefinition)groupDefn[0]);
        qd.addGroup((IGroupDefinition)groupDefn[1]);
        try {
            this.executeQuery(qd, bindingNameRow);
            this.checkOutputFile();
            Assert.fail((String)"should not arrive here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMixedMultipassFilting() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = new String[]{"FILTER_1", "FILTER_2", "FILTER_3"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("Total.isTopN(dataSetRow.AMOUNT,1,null,1)")};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.AMOUNT,null,1)", 17, "75")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.AMOUNT,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_1", 15, "7")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_2", 3, "700")), new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isTopN(dataSetRow.AMOUNT,1,null,1)", 11))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, filters);
    }

    @Test
    public void testTop_Bottom_FilteringInGroupInstance_1() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isTopN(row.ROW_AMOUNT,3,null,1)", 11))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, filters);
    }

    @Test
    public void testTop_Bottom_FilteringInGroupInstance_2() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.COUNTRY", 0), new ScriptExpression("row.CITY", 0), new ScriptExpression("row.SALE_DATE", 0), new ScriptExpression("row.AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isTopN(dataSetRow.AMOUNT,3,null,1)", 11)), new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isBottomN(dataSetRow.AMOUNT,2,null,2)", 11)), new FilterDefinition((IBaseExpression)new ConditionalExpression("dataSetRow.CITY", 2, "\"Chicago\""))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, filters);
    }

    @Test
    public void testMultipassWithAlias() throws Exception {
        ColumnDefinition cd = new ColumnDefinition("AMOUNT");
        cd.setAlias("A");
        this.dataSet.addResultSetHint((IColumnDefinition)cd);
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = new String[]{"FILTER_1", "FILTER_2", "FILTER_3"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.A"), new ScriptExpression("dataSetRow.A"), new ScriptExpression("Total.isTopN(dataSetRow.A,1,null,1)")};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.A")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[0].addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.sum(dataSetRow.A,null,1)", 17, "75")));
        SortDefinition sortDefn = new SortDefinition();
        sortDefn.setExpression("Total.sum(dataSetRow.A,null,1)");
        sortDefn.setSortDirection(0);
        groupDefn[0].addSort(sortDefn);
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_1", 15, "7")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_2", 3, "700")), new FilterDefinition((IBaseExpression)new ConditionalExpression("Total.isTopN(dataSetRow.A,1,null,1)", 11))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, filters);
    }

    @Test
    public void testIN_FilteringInGroup() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_GROUP0", "GROUP_GROUP1"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        String[] bindingNameSort = new String[]{};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{};
        String[] bindingNameFilter = null;
        IBaseExpression[] bindingExprFilter = null;
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_GROUP0");
        groupDefn[1].setKeyExpression("row.GROUP_GROUP1");
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.ROW_COUNTRY", 0), new ScriptExpression("row.ROW_CITY", 0), new ScriptExpression("row.ROW_SALE_DATE", 0), new ScriptExpression("row.ROW_AMOUNT", 0)};
        ArrayList<String> combinedValue = new ArrayList<String>();
        combinedValue.add("7600");
        combinedValue.add("1000");
        ConditionalExpression expr = new ConditionalExpression("Total.Sum(row.ROW_AMOUNT,null,1)", 22, combinedValue);
        FilterDefinition filters = new FilterDefinition((IBaseExpression)expr);
        groupDefn[0].addFilter((IFilterDefinition)filters);
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, bindingNameSort, bindingExprSort, bindingNameFilter, bindingExprFilter, bindingNameRow, bindingExprRow, expressions, groupDefn, null, null);
    }

    private QueryDefinition createQueryDefn(String[] exprNames, IBaseExpression[] expressions, GroupDefinition[] groupDefn, SortDefinition[] sortDefn, FilterDefinition[] filters) {
        int i;
        QueryDefinition queryDefn = this.newReportQuery();
        if (groupDefn != null) {
            i = 0;
            while (i < groupDefn.length) {
                queryDefn.addGroup((IGroupDefinition)groupDefn[i]);
                ++i;
            }
        }
        if (sortDefn != null) {
            i = 0;
            while (i < sortDefn.length) {
                queryDefn.addSort(sortDefn[i]);
                ++i;
            }
        }
        if (expressions != null) {
            i = 0;
            while (i < expressions.length) {
                queryDefn.addResultSetExpression(exprNames[i], expressions[i]);
                ++i;
            }
        }
        if (filters != null) {
            i = 0;
            while (i < filters.length) {
                queryDefn.addFilter((IFilterDefinition)filters[i]);
                ++i;
            }
        }
        return queryDefn;
    }
}

