/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.binding.APITestCase;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import testutil.ConfigText;

public class DataSetCacheTest
extends APITestCase {
    private List expectedValue;
    private IBaseExpression[] rowBeArray;
    private IBaseExpression[] totalBeArray;
    private String[] bindingNameRow;
    private String[] bindingExprRow;
    Map appContextMap = new HashMap();
    ScriptableObject scope;
    private DataEngineImpl myDataEngine;

    @Before
    public void datasetCacheSetUp() throws Exception {
        Context context = Context.enter();
        this.scope = context.initStandardObjects();
        Context.exit();
        this.expectedValue = new ArrayList();
        this.appContextMap.put(DataEngine.DATASET_CACHE_OPTION, "true");
        this.myDataEngine = this.newDataEngine();
    }

    @After
    public void datasetCacheTearDown() throws Exception {
        this.myDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        this.myDataEngine.shutdown();
    }

    @Test
    public void testCacheIsRealDataSetLevel() throws BirtException {
        this.dataSource.setBeforeOpenScript("i=0");
        this.dataSet.addComputedColumn((IComputedColumn)new ComputedColumn("cc1", "++i", 2));
        this.dataSet.addComputedColumn((IComputedColumn)new ComputedColumn("cc2", null, 2, "COUNT", null, new ArrayList()));
        this.dataSet.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"cc1\"] <= 7")));
        this.dataSet.setCacheRowCount(6);
        this.myDataEngine = this.newDataEngine();
        Assert.assertFalse((boolean)this.getDataSetCacheManager(this.myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(this.myDataEngine).doesSaveToCache());
        QueryDefinition qd = this.newReportQuery(true);
        IQueryResults qr = this.myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        IResultIterator itr = qr.getResultIterator();
        int i = 1;
        while (itr.next()) {
            Assert.assertEquals((long)i, (long)itr.getInteger("cc1").intValue());
            Assert.assertEquals((long)7L, (long)itr.getInteger("cc2").intValue());
            ++i;
        }
        itr.close();
        Assert.assertEquals((long)7L, (long)i);
        qr.close();
        Assert.assertTrue((boolean)this.getDataSetCacheManager(this.myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(this.myDataEngine).doesSaveToCache());
        qd.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ScriptExpression("row[\"cc1\"] >= 5 ")));
        SortDefinition sd = new SortDefinition();
        sd.setExpression("row[\"cc1\"] ");
        sd.setSortDirection(1);
        qd.addSort(sd);
        qr = this.myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        itr = qr.getResultIterator();
        i = 6;
        while (itr.next()) {
            Assert.assertEquals((long)i, (long)itr.getInteger("cc1").intValue());
            Assert.assertEquals((long)7L, (long)itr.getInteger("cc2").intValue());
            --i;
        }
        itr.close();
        Assert.assertEquals((long)4L, (long)i);
        qr.close();
        Assert.assertTrue((boolean)this.getDataSetCacheManager(this.myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(this.myDataEngine).doesSaveToCache());
        qd.getFilters().clear();
        qd.getSorts().clear();
        qr = this.myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        itr = qr.getResultIterator();
        i = 1;
        while (itr.next()) {
            Assert.assertEquals((long)i, (long)itr.getInteger("cc1").intValue());
            Assert.assertEquals((long)7L, (long)itr.getInteger("cc2").intValue());
            ++i;
        }
        itr.close();
        Assert.assertEquals((long)7L, (long)i);
        qr.close();
        this.getDataSetCacheManager(this.myDataEngine).resetForTest();
        this.myDataEngine.shutdown();
    }

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    @Test
    public void testUseCache() throws BirtException {
        this.dataSet.setCacheRowCount(4);
        this.myDataEngine = this.newDataEngine();
        Assert.assertFalse((boolean)this.getDataSetCacheManager(this.myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(this.myDataEngine).doesSaveToCache());
        QueryDefinition qd = this.newReportQuery();
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.bindingNameRow = this.getRowExprName();
        this.bindingExprRow = this.getAggrExprName();
        this.prepareExprNameAndQuery(this.rowBeArray, this.bindingNameRow, this.totalBeArray, this.bindingExprRow, qd);
        IQueryResults qr = this.myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        qr.getResultIterator().next();
        qr.close();
        Assert.assertTrue((boolean)this.getDataSetCacheManager(this.myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(this.myDataEngine).doesSaveToCache());
        this.getDataSetCacheManager(this.myDataEngine).resetForTest();
        this.myDataEngine.shutdown();
    }

    @Test
    public void testUseCache1() throws BirtException, Exception {
        this.dataSet.setCacheRowCount(100);
        this.myDataEngine = this.newDataEngine();
        Assert.assertFalse((boolean)this.getDataSetCacheManager(this.myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(this.myDataEngine).doesSaveToCache());
        this.executeQuery(this.myDataEngine);
    }

    private void executeQuery(DataEngineImpl myDataEngine) throws BirtException, DataException, Exception, IOException {
        QueryDefinition qd = this.newReportQuery();
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.bindingNameRow = this.getRowExprName();
        this.bindingExprRow = this.getAggrExprName();
        this.prepareExprNameAndQuery(this.rowBeArray, this.bindingNameRow, this.totalBeArray, this.bindingExprRow, qd);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        qr.getResultIterator().next();
        qr.close();
        String[] bindingNameGroup = new String[]{"GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_CITY");
        groupDefn[0].setInterval(100);
        groupDefn[0].setIntervalRange(1.0);
        qd.addResultSetExpression(bindingNameGroup[0], bindingExprGroup[0]);
        qd.addGroup((IGroupDefinition)groupDefn[0]);
        String[] columnStr = new String[]{"Country", "City", "date", "amount"};
        String outputStr = this.getOutputStrForGroupTest(30, qd, 0, this.bindingNameRow, columnStr);
        this.testPrint(outputStr);
        this.checkOutputFile();
        this.getDataSetCacheManager(myDataEngine).resetForTest();
    }

    @Test
    public void testUseAppContextCacheRowLimit1() throws BirtException, Exception {
        this.dataSet.setCacheRowCount(100);
        DataEngineContext dec = DataEngineContext.newInstance((int)3, null, null, null);
        dec.setCacheOption(3, 100);
        dec.setTmpdir(DataSetCacheTest.getTempDir());
        this.myDataEngine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)dec);
        this.myDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.appContextMap.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, new Integer(0));
        this.testUseCache1();
    }

    @Test
    public void testUseAppContextCacheRowLimit2() throws BirtException, Exception {
        this.dataSet.setCacheRowCount(2);
        DataEngineContext dec = DataEngineContext.newInstance((int)3, null, null, null);
        dec.setCacheOption(3, 3);
        dec.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngineImpl myDataEngine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)dec);
        myDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        myDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.appContextMap.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, new Integer(-1));
        this.testUseCache1();
    }

    @Test
    public void testUseAppContextCacheRowLimit3() throws BirtException, Exception {
        this.dataSet.setCacheRowCount(100);
        this.dataSet.setBeforeOpenScript("a = 0;");
        this.dataSet.setOnFetchScript("if ( a == 0  ) a = 1;");
        DataEngineContext dec = DataEngineContext.newInstance((int)3, null, null, null);
        dec.setTmpdir(DataSetCacheTest.getTempDir());
        this.myDataEngine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)dec);
        this.myDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.appContextMap.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, new Integer(4));
        this.testUseCache1();
    }

    @Test
    public void testUseCachedMeta1() throws BirtException {
        this.appContextMap.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, new Integer(1));
        this.genCache();
        this.myDataEngine = this.newDataEngine();
        IResultMetaData meta = this.myDataEngine.getCachedDataSetMetaData((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        Assert.assertTrue((meta != null ? 1 : 0) != 0);
        Assert.assertTrue((meta.getColumnCount() == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testUseCachedMeta2() throws BirtException {
        this.appContextMap.put(DataEngine.DATA_SET_CACHE_ROW_LIMIT, new Integer(0));
        this.genCache();
        this.myDataEngine = this.newDataEngine();
        IResultMetaData meta = this.myDataEngine.getCachedDataSetMetaData((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        Assert.assertTrue((meta == null ? 1 : 0) != 0);
    }

    @Test
    public void testUseAppContextMemoryCache1() throws BirtException, Exception {
        this.dataSet.setCacheRowCount(7);
        DataEngineContext dec = DataEngineContext.newInstance((int)3, null, null, null);
        dec.setCacheOption(3, 100);
        dec.setTmpdir(DataSetCacheTest.getTempDir());
        this.myDataEngine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)dec);
        this.myDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.appContextMap.put(DataEngine.MEMORY_DATA_SET_CACHE, new Integer(7));
        this.testUseCache1();
    }

    @Test
    public void testUseAppContextMemoryCache2() throws BirtException, Exception {
        this.dataSet.setCacheRowCount(2);
        DataEngineContext dec = DataEngineContext.newInstance((int)3, null, null, null);
        dec.setCacheOption(3, 3);
        dec.setTmpdir(DataSetCacheTest.getTempDir());
        this.myDataEngine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)dec);
        this.myDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        this.myDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        this.appContextMap.put(DataEngine.MEMORY_DATA_SET_CACHE, new Integer(3));
        this.testUseCache1();
    }

    @Test
    public void testUseMemoryCachedMeta1() throws BirtException {
        this.appContextMap.put(DataEngine.MEMORY_DATA_SET_CACHE, new Integer(1));
        this.genCache();
        this.myDataEngine = this.newDataEngine();
        IResultMetaData meta = this.myDataEngine.getCachedDataSetMetaData((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        Assert.assertTrue((meta != null ? 1 : 0) != 0);
        Assert.assertTrue((meta.getColumnCount() == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testUseMemoryCachedMeta2() throws BirtException {
        this.appContextMap.put(DataEngine.MEMORY_DATA_SET_CACHE, new Integer(0));
        this.myDataEngine = this.newDataEngine();
        IResultIterator ri = this.getResultIterator1((DataEngine)this.myDataEngine);
        while (ri.next()) {
            int i = 0;
            while (i < this.bindingNameRow.length) {
                this.expectedValue.add(ri.getValue(this.bindingNameRow[i]));
                ++i;
            }
            i = 0;
            while (i < this.totalBeArray.length) {
                this.expectedValue.add(ri.getValue(this.bindingExprRow[i]));
                ++i;
            }
        }
        ri.close();
        IResultMetaData meta = this.myDataEngine.getCachedDataSetMetaData((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        Assert.assertTrue((meta == null ? 1 : 0) != 0);
    }

    @Test
    public void testUseCache3() throws BirtException {
        this.dataSet.setCacheRowCount(4);
        DataEngineImpl myDataEngine = this.newDataEngine();
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        QueryDefinition qd = this.newReportQuery();
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.bindingNameRow = this.getRowExprName();
        this.bindingExprRow = this.getAggrExprName();
        String[] ccName = new String[]{"col0 col1", "\"col0+col1\""};
        String[] ccExpr = new String[]{"row.AMOUNT", "row.AMOUNT*2"};
        int i = 0;
        while (i < ccName.length) {
            ComputedColumn computedColumn = new ComputedColumn(ccName[i], ccExpr[i], 4);
            this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
            ++i;
        }
        this.prepareExprNameAndQuery(this.rowBeArray, this.bindingNameRow, this.totalBeArray, this.bindingExprRow, qd);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        qr.getResultIterator().next();
        qr.close();
        myDataEngine.shutdown();
        Assert.assertTrue((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        this.getDataSetCacheManager(myDataEngine).resetForTest();
    }

    private String getOutputStrForGroupTest(int expectedLen, QueryDefinition qd, int groupDefCount, String[] beArray, String[] columStr) throws Exception {
        StringBuffer sBuffer = new StringBuffer();
        IResultIterator ri = this.newDataEngine().prepare((IQueryDefinition)qd, this.appContextMap).execute(null).getResultIterator();
        Object metaData = "";
        int i = 0;
        while (i < columStr.length) {
            metaData = (String)metaData + DataSetCacheTest.formatStr(columStr[i], expectedLen);
            ++i;
        }
        sBuffer.append((String)metaData);
        sBuffer.append("\n");
        int groupCount = groupDefCount;
        while (ri.next()) {
            String value;
            int j;
            Object rowData = "";
            int startLevel = ri.getStartingGroupLevel();
            if (startLevel <= groupCount) {
                if (startLevel == 0) {
                    startLevel = 1;
                }
                j = 0;
                while (j < startLevel - 1) {
                    rowData = (String)rowData + DataSetCacheTest.formatStr("", expectedLen);
                    ++j;
                }
                j = startLevel - 1;
                while (j < beArray.length) {
                    value = ri.getValue(beArray[j]) != null ? ri.getValue(beArray[j]).toString() : "null";
                    rowData = (String)rowData + DataSetCacheTest.formatStr(value, expectedLen);
                    ++j;
                }
            } else {
                j = 0;
                while (j < groupCount) {
                    rowData = (String)rowData + DataSetCacheTest.formatStr("", expectedLen);
                    ++j;
                }
                j = groupCount;
                while (j < beArray.length) {
                    value = ri.getValue(beArray[j]).toString();
                    rowData = (String)rowData + DataSetCacheTest.formatStr(value, expectedLen);
                    ++j;
                }
            }
            sBuffer.append((String)rowData);
            sBuffer.append("\n");
        }
        return new String(sBuffer);
    }

    private static String formatStr(String inputStr, int length) {
        if (inputStr == null) {
            return null;
        }
        int inputLen = inputStr.length();
        if (inputLen >= length) {
            return inputStr;
        }
        int appendLen = length - inputLen;
        char[] appendChar = new char[appendLen];
        int i = 0;
        while (i < appendLen) {
            appendChar[i] = 32;
            ++i;
        }
        String result = inputStr + new String(appendChar);
        return result;
    }

    @Test
    public void testClearCache() throws BirtException {
        this.dataSet.setCacheRowCount(4);
        DataEngineImpl myDataEngine = this.newDataEngine();
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        QueryDefinition qd = this.newReportQuery();
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.bindingNameRow = this.getRowExprName();
        this.bindingExprRow = this.getAggrExprName();
        this.prepareExprNameAndQuery(this.rowBeArray, this.bindingNameRow, this.totalBeArray, this.bindingExprRow, qd);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        qr.getResultIterator().next();
        qr.close();
        myDataEngine.shutdown();
        Assert.assertTrue((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        myDataEngine.clearCache((IBaseDataSourceDesign)this.dataSource, (IBaseDataSetDesign)this.dataSet);
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
    }

    @Test
    public void testEnableCache() throws Exception {
        DataEngineImpl myDataEngine = this.newDataEngine();
        this.getDataSetCacheManager(myDataEngine).resetForTest();
        this.dataSet.setCacheRowCount(4);
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
        QueryDefinition qd = this.newReportQuery();
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.bindingNameRow = this.getRowExprName();
        this.bindingExprRow = this.getAggrExprName();
        this.prepareExprNameAndQuery(this.rowBeArray, this.bindingNameRow, this.totalBeArray, this.bindingExprRow, qd);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd).execute(null);
        qr.getResultIterator().next();
        qr.close();
        myDataEngine.shutdown();
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesLoadFromCache());
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine).doesSaveToCache());
    }

    @Test
    public void testAlwaysCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(3, 4);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngineImpl myDataEngine2 = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        myDataEngine2.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        myDataEngine2.defineDataSet((IBaseDataSetDesign)this.dataSet);
        QueryDefinition qd = this.newReportQuery();
        IQueryResults qr = myDataEngine2.prepare((IQueryDefinition)qd).execute(null);
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        qr.getResultIterator();
        Assert.assertTrue((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        qr.close();
        myDataEngine2.shutdown();
    }

    @Test
    public void testDisableCache() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(2, 4);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngineImpl myDataEngine2 = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        myDataEngine2.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        myDataEngine2.defineDataSet((IBaseDataSetDesign)this.dataSet);
        QueryDefinition qd = this.newReportQuery();
        IQueryResults qr = myDataEngine2.prepare((IQueryDefinition)qd).execute(null);
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        qr.getResultIterator();
        Assert.assertFalse((boolean)this.getDataSetCacheManager(myDataEngine2).doesLoadFromCache());
        qr.close();
        myDataEngine2.shutdown();
    }

    @Test
    public void testOdaCache() throws BirtException {
        this.genCache();
        this.useCache();
    }

    @Test
    public void testSubqueryCache() throws BirtException {
        this.genCache3();
        this.useCache3();
    }

    private void genCache() throws BirtException {
        this.dataSet.setCacheRowCount(4);
        this.myDataEngine = this.newDataEngine();
        IResultIterator ri = this.getResultIterator1((DataEngine)this.myDataEngine);
        while (ri.next()) {
            int i = 0;
            while (i < this.bindingNameRow.length) {
                this.expectedValue.add(ri.getValue(this.bindingNameRow[i]));
                ++i;
            }
            i = 0;
            while (i < this.totalBeArray.length) {
                this.expectedValue.add(ri.getValue(this.bindingExprRow[i]));
                ++i;
            }
        }
        ri.close();
        this.myDataEngine.shutdown();
    }

    private void genCache3() throws BirtException {
        this.dataSet.setCacheRowCount(4);
        this.myDataEngine = this.newDataEngine();
        IResultIterator parentRi = this.getResultIterator1((DataEngine)this.myDataEngine);
        parentRi.next();
        IResultIterator ri = parentRi.getSecondaryIterator("IAMTEST", (Scriptable)this.scope);
        while (ri.next()) {
            this.expectedValue.add(ri.getValue("COL1"));
        }
        Assert.assertEquals((long)this.expectedValue.size(), (long)1L);
        ri.close();
        parentRi.close();
        this.myDataEngine.shutdown();
    }

    private void useCache() throws BirtException {
        this.myDataEngine = this.newDataEngine();
        IResultIterator ri = this.getResultIterator1((DataEngine)this.myDataEngine);
        this.checkResult(ri);
        ri.close();
        this.myDataEngine.shutdown();
    }

    private void useCache3() throws BirtException {
        this.myDataEngine = this.newDataEngine();
        IResultIterator parentRi = this.getResultIterator1((DataEngine)this.myDataEngine);
        parentRi.next();
        IResultIterator ri = parentRi.getSecondaryIterator("IAMTEST", (Scriptable)this.scope);
        Iterator it = this.expectedValue.iterator();
        while (ri.next()) {
            Object str = "";
            Object ob1 = it.next();
            Object ob2 = ri.getValue("COL1");
            Assert.assertEquals(ob1, (Object)ob2);
            str = (String)str + " " + ob2.toString();
            System.out.println("row result set: " + (String)str);
        }
        ri.close();
        parentRi.close();
        this.myDataEngine.shutdown();
    }

    private IResultIterator getResultIterator1(DataEngine myDataEngine) throws BirtException {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        QueryDefinition qd = this.newReportQuery();
        if (groupDefn != null) {
            int i;
            if (bindingNameGroup != null) {
                i = 0;
                while (i < bindingNameGroup.length) {
                    qd.addResultSetExpression(bindingNameGroup[i], bindingExprGroup[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < groupDefn.length) {
                qd.addGroup((IGroupDefinition)groupDefn[i]);
                ++i;
            }
        }
        this.rowBeArray = this.getRowExpr();
        this.totalBeArray = this.getAggrExpr();
        this.bindingNameRow = this.getRowExprName();
        this.bindingExprRow = this.getAggrExprName();
        this.prepareExprNameAndQuery(this.rowBeArray, this.bindingNameRow, this.totalBeArray, this.bindingExprRow, qd);
        SubqueryDefinition subqueryDefn = new SubqueryDefinition("IAMTEST", (IBaseQueryDefinition)qd);
        subqueryDefn.addResultSetExpression("COL1", (IBaseExpression)new ScriptExpression("dataSetRow.CITY"));
        subqueryDefn.setApplyOnGroupFlag(false);
        qd.addSubquery(subqueryDefn);
        IQueryResults qr = myDataEngine.prepare((IQueryDefinition)qd, this.appContextMap).execute(null);
        Assert.assertTrue((qr.getResultMetaData() != null ? 1 : 0) != 0);
        return qr.getResultIterator();
    }

    @Test
    public void testScriptedCache() throws BirtException {
        this.genCache2();
        this.useCache2();
    }

    private void genCache2() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(3, 4);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngine myDataEngine2 = DataEngine.newDataEngine((DataEngineContext)context);
        IResultIterator ri = this.getResultIterator2(myDataEngine2);
        while (ri.next()) {
            int i = 0;
            while (i < this.bindingNameRow.length) {
                this.expectedValue.add(ri.getValue(this.bindingNameRow[i]));
                ++i;
            }
        }
        ri.close();
        myDataEngine2.shutdown();
    }

    private void useCache2() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setCacheOption(3, 4);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngine myDataEngine2 = DataEngine.newDataEngine((DataEngineContext)context);
        IResultIterator ri = this.getResultIterator2(myDataEngine2);
        this.checkResult(ri);
        ri.close();
        myDataEngine2.shutdown();
    }

    private IResultIterator getResultIterator2(DataEngine myDataEngine2) throws BirtException {
        ScriptDataSourceDesign odaDataSource = new ScriptDataSourceDesign("JUST as place folder");
        ScriptDataSetDesign odaDataSet = new ScriptDataSetDesign("ScriptedDataSet");
        odaDataSet.setDataSource(odaDataSource.getName());
        odaDataSet.setOpenScript("count=100;");
        odaDataSet.setFetchScript("if (count==0) {return false; } else { dataSetRow.NUM=count; dataSetRow.SQUARE=count*count; dataSetRow.STR=\"row#\" + count; --count; return true; }");
        String[] scriptColumnNames = new String[]{"NUM", "SQUARE", "STR"};
        int[] scriptColumnTypes = new int[]{2, 3, 5};
        int i = 0;
        while (i < scriptColumnNames.length) {
            ColumnDefinition colInfo = new ColumnDefinition(scriptColumnNames[i]);
            colInfo.setDataType(scriptColumnTypes[i]);
            odaDataSet.getResultSetHints().add(colInfo);
            ++i;
        }
        QueryDefinition queryDefinition = this.newReportQuery();
        queryDefinition.setDataSetName(odaDataSet.getName());
        this.bindingNameRow = new String[3];
        this.bindingNameRow[0] = "ROW_NUM";
        this.bindingNameRow[1] = "ROW_SQUARE";
        this.bindingNameRow[2] = "ROW_STR";
        IBaseExpression[] expressionArray = new IBaseExpression[3];
        ScriptExpression expr = new ScriptExpression("dataSetRow.NUM");
        expressionArray[0] = expr;
        expr = new ScriptExpression("dataSetRow.SQUARE");
        expressionArray[1] = expr;
        expr = new ScriptExpression("dataSetRow.STR");
        expressionArray[2] = expr;
        int i2 = 0;
        while (i2 < this.bindingNameRow.length) {
            queryDefinition.addResultSetExpression(this.bindingNameRow[i2], expressionArray[i2]);
            ++i2;
        }
        this.rowBeArray = expressionArray;
        myDataEngine2.defineDataSource((IBaseDataSourceDesign)odaDataSource);
        myDataEngine2.defineDataSet((IBaseDataSetDesign)odaDataSet);
        IQueryResults qr = myDataEngine2.prepare((IQueryDefinition)queryDefinition).execute(null);
        return qr.getResultIterator();
    }

    private DataEngineImpl newDataEngine() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, null, null, null);
        context.setTmpdir(DataSetCacheTest.getTempDir());
        DataEngineImpl myDataEngine = (DataEngineImpl)DataEngine.newDataEngine((DataEngineContext)context);
        myDataEngine.defineDataSource((IBaseDataSourceDesign)this.dataSource);
        myDataEngine.defineDataSet((IBaseDataSetDesign)this.dataSet);
        return myDataEngine;
    }

    private IBaseExpression[] getRowExpr() {
        int num = 4;
        IBaseExpression[] _rowBeArray = new IBaseExpression[num];
        _rowBeArray[0] = new ScriptExpression("dataSetRow.COUNTRY");
        _rowBeArray[1] = new ScriptExpression("dataSetRow.CITY");
        _rowBeArray[2] = new ScriptExpression("dataSetRow.SALE_DATE");
        _rowBeArray[3] = new ScriptExpression("dataSetRow.AMOUNT");
        return _rowBeArray;
    }

    private String[] getRowExprName() {
        int num = 4;
        String[] _rowNameArray = new String[num];
        _rowNameArray[0] = "ROW_COUNTRY";
        _rowNameArray[1] = "ROW_CITY";
        _rowNameArray[2] = "ROW_SALE_DATE";
        _rowNameArray[3] = "ROW_AMOUNT";
        return _rowNameArray;
    }

    private IBaseExpression[] getAggrExpr() {
        int num2 = 2;
        IBaseExpression[] _totalBeArray = new IBaseExpression[num2];
        _totalBeArray[0] = new ScriptExpression("Total.Count( )");
        _totalBeArray[1] = new ScriptExpression("Total.Sum( dataSetRow.AMOUNT )");
        return _totalBeArray;
    }

    private String[] getAggrExprName() {
        int num = 2;
        String[] _rowAggrArray = new String[num];
        _rowAggrArray[0] = "ROW_AGG1";
        _rowAggrArray[1] = "ROW_AGG2";
        return _rowAggrArray;
    }

    private void prepareExprNameAndQuery(IBaseExpression[] rowBeArray, String[] rowExprName, IBaseExpression[] totalBeArray, String[] rowAggrName, QueryDefinition qd) {
        int i;
        if (rowExprName != null) {
            i = 0;
            while (i < rowExprName.length) {
                qd.addResultSetExpression(rowExprName[i], rowBeArray[i]);
                ++i;
            }
        }
        if (rowAggrName != null) {
            i = 0;
            while (i < rowAggrName.length) {
                qd.addResultSetExpression(rowAggrName[i], totalBeArray[i]);
                ++i;
            }
        }
    }

    private void checkResult(IResultIterator ri) throws BirtException {
        Iterator it = this.expectedValue.iterator();
        while (ri.next()) {
            Object ob2;
            Object ob1;
            Object str = "";
            int i = 0;
            while (i < this.bindingNameRow.length) {
                ob1 = it.next();
                ob2 = ri.getValue(this.bindingNameRow[i]);
                Assert.assertEquals(ob1, (Object)ob2);
                str = (String)str + " " + ob2.toString();
                ++i;
            }
            if (this.totalBeArray != null) {
                i = 0;
                while (i < this.bindingExprRow.length) {
                    ob1 = it.next();
                    ob2 = ri.getValue(this.bindingExprRow[i]);
                    Assert.assertEquals(ob1, (Object)ob2);
                    str = (String)str + " " + ob2.toString();
                    ++i;
                }
            }
            System.out.println("row result set: " + (String)str);
        }
    }

    private DataSetCacheManager getDataSetCacheManager(DataEngineImpl dataEngine) {
        return dataEngine.getSession().getDataSetCacheManager();
    }
}

