/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.TextAndButtonSection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextAndTwoButtonSection
extends TextAndButtonSection {
    private Button secondButton;
    private String secondButtonText;
    private SelectionListener secondButtonListener;
    private int secondButtonWidth = 60;
    private String secondButtonTooltipText;

    public TextAndTwoButtonSection(String labelText, Composite parent, boolean isFormStyle) {
        super(labelText, parent, isFormStyle);
    }

    @Override
    public void createSection() {
        super.createSection();
        this.getSecondButtonControl(this.parent);
    }

    @Override
    public void layout() {
        GridData gd = (GridData)this.textField.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - 3 - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - 3 - this.placeholder;
        if (this.width > -1) {
            gd.widthHint = this.width;
            gd.grabExcessHorizontalSpace = false;
        } else {
            gd.grabExcessHorizontalSpace = this.fillText;
        }
        gd = (GridData)this.button.getLayoutData();
        if (this.buttonWidth > -1) {
            gd.widthHint = !this.isComputeSize ? Math.max(this.button.computeSize((int)-1, (int)-1).x, this.buttonWidth) : this.button.computeSize((int)-1, (int)-1).x;
        }
        gd = (GridData)this.secondButton.getLayoutData();
        if (this.secondButtonWidth > -1) {
            gd.widthHint = !this.isComputeSize ? Math.max(this.secondButton.computeSize((int)-1, (int)-1).x, this.secondButtonWidth) : this.secondButton.computeSize((int)-1, (int)-1).x;
        }
    }

    protected Button getSecondButtonControl(Composite parent) {
        if (this.secondButton == null) {
            this.secondButton = FormWidgetFactory.getInstance().createButton(parent, 8, this.isFormStyle);
            this.secondButton.setFont(parent.getFont());
            this.secondButton.setLayoutData((Object)new GridData());
            String text = this.getSecondButtonText();
            if (text != null) {
                this.secondButton.setText(text);
            }
            if ((text = this.getSecondButtonTooltipText()) != null) {
                this.secondButton.setToolTipText(text);
            }
            this.secondButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TextAndTwoButtonSection.this.secondButton = null;
                }
            });
            if (this.secondButtonListener == null) {
                this.secondButtonListener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextAndTwoButtonSection.this.onClickSecondButton();
                    }
                };
            }
            this.secondButton.addSelectionListener(this.secondButtonListener);
        } else {
            this.checkParent((Control)this.secondButton, parent);
        }
        return this.secondButton;
    }

    private String getSecondButtonTooltipText() {
        return this.secondButtonTooltipText;
    }

    private String getSecondButtonText() {
        return this.secondButtonText;
    }

    public void addSecondSelectionListener(SelectionListener listener) {
        if (this.secondButton != null) {
            this.secondButton.removeSelectionListener(this.secondButtonListener);
            this.secondButton.addSelectionListener(listener);
        }
        this.secondButtonListener = listener;
    }

    public void removeSecondSelectionListener(SelectionListener listener) {
        if (this.secondButton != null) {
            this.secondButton.removeSelectionListener(listener);
        }
        if (this.secondButtonListener == listener) {
            this.secondButtonListener = null;
        }
    }

    protected void onClickSecondButton() {
    }

    public void setSecondButtonWidth(int buttonWidth) {
        this.secondButtonWidth = buttonWidth;
        if (this.secondButton != null) {
            GridData data = new GridData();
            data.widthHint = Math.max(this.secondButton.computeSize((int)-1, (int)-1).x, buttonWidth);
            data.grabExcessHorizontalSpace = false;
            this.secondButton.setLayoutData((Object)data);
        }
    }

    public void setSecondButtonTooltipText(String string) {
        this.secondButtonTooltipText = string;
        if (this.secondButton != null) {
            this.secondButton.setToolTipText(this.secondButtonTooltipText);
        }
    }

    public void setSecondButtonText(String buttonText) {
        this.secondButtonText = buttonText;
        if (this.secondButton != null) {
            this.secondButton.setText(buttonText);
        }
    }
}

