/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.document;

import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.resource.OutdatedStateManager;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.ui.editor.model.DocumentTokenSource;
import org.eclipse.xtext.ui.editor.model.IXtextModelListener;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.ITextEditComposer;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class LibraryElementXtextDocument
extends XtextDocument
implements IAdaptable {
    @Inject
    private OutdatedStateManager outdatedStateManager;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    private final Set<IXtextModelListener> modelListeners = ConcurrentHashMap.newKeySet();

    @Inject
    public LibraryElementXtextDocument(DocumentTokenSource tokenSource, ITextEditComposer composer) {
        super(tokenSource, composer);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType.isAssignableFrom(LibraryElement.class)) {
            return adapterType.cast(this.getResourceLibraryElement());
        }
        return (T)super.getAdapter(adapterType);
    }

    public LibraryElement getResourceLibraryElement() {
        return (LibraryElement)this.readOnly(resource -> {
            LibraryElement libraryElement;
            if (resource instanceof LibraryElementXtextResource) {
                LibraryElementXtextResource libResource = (LibraryElementXtextResource)resource;
                libraryElement = libResource.getLibraryElement();
            } else {
                libraryElement = null;
            }
            return libraryElement;
        });
    }

    public void addModelListener(IXtextModelListener listener) {
        super.addModelListener(listener);
        this.modelListeners.add(listener);
    }

    public void removeModelListener(IXtextModelListener listener) {
        super.removeModelListener(listener);
        this.modelListeners.remove(listener);
    }

    protected XtextDocument.XtextDocumentLocker createDocumentLocker() {
        return new LibraryElementXtextDocumentLocker();
    }

    protected class LibraryElementXtextDocumentLocker
    extends XtextDocument.XtextDocumentLocker {
        private final AtomicInteger potentialUpdaterCount;
        private volatile boolean hadUpdates;
        private final ReentrantReadWriteLock rwLock;
        private final Lock writeLock;
        private final Lock readLock;
        private final ThreadLocal<Integer> readLockCount;

        protected LibraryElementXtextDocumentLocker() {
            super((XtextDocument)LibraryElementXtextDocument.this);
            this.potentialUpdaterCount = new AtomicInteger(0);
            this.rwLock = new ReentrantReadWriteLock();
            this.writeLock = this.rwLock.writeLock();
            this.readLock = this.rwLock.readLock();
            this.readLockCount = ThreadLocal.withInitial(() -> 0);
        }

        public <T> T process(IUnitOfWork<T, XtextResource> transaction) {
            if (this.getReadHoldCount() != 1 || this.getWriteHoldCount() != 0) {
                throw new IllegalStateException("Exactly one read lock and no write locks expected! But was read: " + this.getReadHoldCount() + ", write:" + this.getWriteHoldCount());
            }
            this.releaseReadLock();
            this.acquireWriteLock();
            try {
                T t = this.modify(transaction);
                return t;
            }
            finally {
                this.acquireReadLock();
                this.releaseWriteLock();
            }
        }

        protected int getWriteHoldCount() {
            return this.rwLock.getWriteHoldCount();
        }

        protected int getReadHoldCount() {
            return this.readLockCount.get();
        }

        private void acquireReadLock() {
            this.readLock.lock();
            this.readLockCount.set(this.readLockCount.get() + 1);
        }

        private void releaseReadLock() {
            this.readLock.unlock();
            this.readLockCount.set(this.readLockCount.get() - 1);
        }

        private void acquireWriteLock() {
            Job validationJob = LibraryElementXtextDocument.this.getValidationJob();
            if (validationJob != null) {
                validationJob.cancel();
            }
            LibraryElementXtextDocument.this.setOutdated(true);
            this.writeLock.lock();
            LibraryElementXtextDocument.this.setOutdated(false);
        }

        private void releaseWriteLock() {
            this.writeLock.unlock();
        }

        /*
         * Exception decompiling
         */
        public <T> T modify(IUnitOfWork<T, XtextResource> work) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 15[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected <T> T internalReadOnly(IUnitOfWork<T, XtextResource> work, boolean isCancelReaders) {
            boolean isCancelable = work instanceof CancelableUnitOfWork;
            if (isCancelReaders) {
                if (Display.getCurrent() == null) {
                    FordiacLogHelper.logError((String)"Priority read only called from non UI-thread.", (Throwable)new IllegalStateException());
                }
                this.cancelReaders(this.getState());
            }
            XtextResource state = this.getState();
            Object object = LibraryElementXtextDocument.this.getResourceLock();
            synchronized (object) {
                this.acquireReadLock();
                if (isCancelReaders) {
                    LibraryElementXtextDocument.this.setOutdated(false);
                }
                try {
                    this.potentialUpdaterCount.incrementAndGet();
                    if (this.getReadHoldCount() == 1 && this.getWriteHoldCount() == 0) {
                        this.hadUpdates |= LibraryElementXtextDocument.this.updateContentBeforeRead();
                    }
                    Object exec = LibraryElementXtextDocument.this.outdatedStateManager.exec(work, (Resource)state);
                    LibraryElementXtextDocument.this.ensureThatStateIsNotReturned(exec, work);
                    Object object2 = exec;
                    return (T)object2;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
                catch (OperationCanceledError e) {
                    throw e.getWrapped();
                }
                finally {
                    block28: {
                        block27: {
                            try {
                                try {
                                    if (this.potentialUpdaterCount.decrementAndGet() != 0 || !this.hadUpdates && !isCancelReaders) break block27;
                                    boolean wasHadUpdates = this.hadUpdates;
                                    this.hadUpdates = false;
                                    if (LibraryElementXtextDocument.this.getCancelIndicator().isCanceled() && isCancelable) {
                                        throw new OperationCanceledException();
                                    }
                                    if (wasHadUpdates) {
                                        this.notifyModelListenersOnUiThread();
                                    }
                                    if (isCancelReaders) {
                                        LibraryElementXtextDocument.this.checkAndUpdateAnnotations();
                                    }
                                }
                                catch (RuntimeException e) {
                                    if (!LibraryElementXtextDocument.this.operationCanceledManager.isOperationCanceledException((Throwable)e)) {
                                        throw e;
                                    }
                                    if (isCancelable) {
                                        throw e;
                                    }
                                    this.releaseReadLock();
                                    break block28;
                                }
                            }
                            catch (Throwable throwable) {
                                this.releaseReadLock();
                                throw throwable;
                            }
                        }
                        this.releaseReadLock();
                    }
                }
            }
        }

        private void notifyModelListenersOnUiThread() {
            if (LibraryElementXtextDocument.this.modelListeners.isEmpty()) {
                return;
            }
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (Thread.currentThread() == display.getThread()) {
                LibraryElementXtextDocument.this.notifyModelListeners(this.getState());
            } else {
                display.asyncExec(() -> {
                    Object object = LibraryElementXtextDocument.this.tryReadOnly(resource -> {
                        LibraryElementXtextDocument.this.notifyModelListeners(resource);
                        return null;
                    });
                });
            }
        }

        private Object getResourceLock(XtextResource r) {
            if (r != null) {
                return r instanceof ISynchronizable ? ((ISynchronizable)r).getLock() : r;
            }
            return this;
        }

        private void cancelReaders(XtextResource resource) {
            Job validationJob = LibraryElementXtextDocument.this.getValidationJob();
            if (validationJob != null) {
                validationJob.cancel();
            }
            LibraryElementXtextDocument.this.setOutdated(true);
        }
    }
}

