/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.listeners;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;

public class EditorTabCommandStackListener
implements CommandStackEventListener {
    private final INavigationLocationProvider locationProvider;
    private final Map<Command, EditorLocations> undoHistory = new HashMap<Command, EditorLocations>();
    private final Map<Command, EditorLocations> redoHistory = new HashMap<Command, EditorLocations>();

    public EditorTabCommandStackListener(INavigationLocationProvider locationProvider) {
        this.locationProvider = locationProvider;
    }

    public void stackChanged(CommandStackEvent event) {
        switch (event.getDetail()) {
            case 1: {
                this.recordUndoLocation(event.getCommand());
                break;
            }
            case 8: {
                this.recordRedoLocation(event.getCommand());
                this.clearRedoHistory();
                break;
            }
            case 2: {
                this.restoreRedoLocation(event.getCommand());
                break;
            }
            case 4: {
                this.restoreUndoLocation(event.getCommand());
                break;
            }
            case 64: {
                this.clearLocationStacks();
                break;
            }
        }
    }

    private void recordUndoLocation(Command command) {
        EditorLocations newLocation = new EditorLocations();
        newLocation.undoLocation = this.locationProvider.createNavigationLocation();
        this.undoHistory.put(command, newLocation);
    }

    private void recordRedoLocation(Command command) {
        EditorLocations location = this.undoHistory.computeIfAbsent(command, cmd -> new EditorLocations());
        location.redoLocation = this.locationProvider.createNavigationLocation();
    }

    private void restoreRedoLocation(Command command) {
        EditorLocations location = this.redoHistory.get(command);
        if (location != null) {
            this.redoHistory.remove(command);
            if (location.redoLocation != null) {
                location.redoLocation.restoreLocation();
            }
            this.undoHistory.put(command, location);
        }
    }

    private void restoreUndoLocation(Command command) {
        EditorLocations location = this.undoHistory.get(command);
        if (location != null) {
            this.undoHistory.remove(command);
            if (location.undoLocation != null) {
                location.undoLocation.restoreLocation();
            }
            this.redoHistory.put(command, location);
        }
    }

    private void clearLocationStacks() {
        this.clearUndoHistory();
        this.clearRedoHistory();
    }

    private void clearUndoHistory() {
        this.undoHistory.clear();
    }

    private void clearRedoHistory() {
        this.redoHistory.clear();
    }

    private static class EditorLocations {
        INavigationLocation undoLocation;
        INavigationLocation redoLocation;

        private EditorLocations() {
        }
    }
}

