/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.globalconstantseditor.util;

import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.globalconstantseditor.util.GlobalConstantsPartition;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OriginalSource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartition;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreReconciler;

public class GlobalConstantsReconciler
implements STCoreReconciler {
    public void reconcile(LibraryElement dest, Optional<? extends STCorePartition> source) {
        if (dest instanceof GlobalConstants) {
            STCorePartition sTCorePartition;
            GlobalConstants globalConstants = (GlobalConstants)dest;
            if (source.isPresent() && (sTCorePartition = source.get()) instanceof GlobalConstantsPartition) {
                GlobalConstantsPartition globalConstantsPartition = (GlobalConstantsPartition)sTCorePartition;
                GlobalConstantsReconciler.reconcile(globalConstants, globalConstantsPartition);
            }
        }
    }

    public static void reconcile(GlobalConstants dest, GlobalConstantsPartition source) {
        if (GlobalConstantsReconciler.checkDuplicates(source.getConstants())) {
            return;
        }
        CompilerInfo compilerInfo = dest.getCompilerInfo();
        if (compilerInfo == null) {
            compilerInfo = LibraryElementFactory.eINSTANCE.createCompilerInfo();
            dest.setCompilerInfo(compilerInfo);
        }
        compilerInfo.setPackageName(source.getPackageName());
        ECollections.setEList((EList)compilerInfo.getImports(), (List)source.getImports());
        ECollections.setEList((EList)dest.getConstants(), source.getConstants());
        if (source.getOriginalSource() != null) {
            OriginalSource destOriginalSource = dest.getSource();
            if (destOriginalSource == null) {
                destOriginalSource = LibraryElementFactory.eINSTANCE.createOriginalSource();
                dest.setSource(destOriginalSource);
            }
            destOriginalSource.setText(source.getOriginalSource());
        }
    }

    protected static boolean checkDuplicates(List<? extends VarDeclaration> list) {
        return list.stream().map(INamedElement::getName).distinct().count() != (long)list.size();
    }
}

