/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.tools;

import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.swt.events.MouseEvent;

public final class CanvasHelper {
    public static void bindToContentPane(MouseEvent me, AdvancedScrollingGraphicalViewer viewer, Insets border) {
        Rectangle contentPaneBounds = viewer.translateBoundsToRoute(((FreeformGraphicalRootEditPart)viewer.getRootEditPart()).getContentPane());
        contentPaneBounds.shrink(CanvasHelper.getZooomedBorder(border, viewer));
        Point viewLocation = viewer.getViewLocation();
        me.x += viewLocation.x;
        me.y += viewLocation.y;
        me.x = Math.max(me.x, contentPaneBounds.getTopLeft().x);
        me.y = Math.max(me.y, contentPaneBounds.getTopLeft().y);
        me.x = Math.min(me.x, contentPaneBounds.getBottomRight().x);
        me.y = Math.min(me.y, contentPaneBounds.getBottomRight().y);
        me.x -= viewLocation.x;
        me.y -= viewLocation.y;
    }

    private static Insets getZooomedBorder(Insets border, AdvancedScrollingGraphicalViewer viewer) {
        double zoom = ((ZoomScalableFreeformRootEditPart)viewer.getRootEditPart()).getZoomManager().getZoom();
        Insets zoomedBorder = new Insets((int)((double)border.top * zoom), (int)((double)border.left * zoom), (int)((double)border.bottom * zoom), (int)((double)border.right * zoom));
        if (border.top != 0) {
            zoomedBorder.top = Math.max(zoomedBorder.top, 1);
        }
        if (border.top != 0) {
            zoomedBorder.left = Math.max(zoomedBorder.left, 1);
        }
        if (border.top != 0) {
            zoomedBorder.bottom = Math.max(zoomedBorder.bottom, 1);
        }
        if (border.top != 0) {
            zoomedBorder.right = Math.max(zoomedBorder.right, 1);
        }
        return zoomedBorder;
    }

    private CanvasHelper() {
        throw new UnsupportedOperationException("Utility class should not be instantiated!");
    }
}

