/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.vertiflex.p3absolute;

import org.eclipse.elk.alg.vertiflex.InternalProperties;
import org.eclipse.elk.alg.vertiflex.VertiFlexLayoutPhases;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkNode;

public class AbsoluteXPlacer
implements ILayoutPhase<VertiFlexLayoutPhases, ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("AbsolutPlacer", 1.0f);
        if (!graph.getChildren().isEmpty()) {
            ElkNode parent = (ElkNode)graph.getProperty(InternalProperties.ROOT_NODE);
            parent.setX(parent.getX() - this.findMinimalX(parent));
            this.absoluteTreeCoords(parent);
        }
        progressMonitor.done();
    }

    private double findMinimalX(ElkNode tree) {
        int numOfChildren = tree.getOutgoingEdges().size();
        if (numOfChildren == 0) {
            return tree.getX();
        }
        double minSubtreeX = 0.0;
        double testX = 0.0;
        int i = 0;
        while (i < numOfChildren) {
            testX = this.findMinimalX((ElkNode)((ElkEdge)tree.getOutgoingEdges().get(i)).getTargets().get(0));
            minSubtreeX = testX < minSubtreeX ? testX : minSubtreeX;
            ++i;
        }
        return minSubtreeX + tree.getX();
    }

    private void absoluteTreeCoords(ElkNode tree) {
        int numOfChildren = tree.getOutgoingEdges().size();
        if (numOfChildren > 0) {
            int i = 0;
            while (i < numOfChildren) {
                ElkNode child = (ElkNode)((ElkEdge)tree.getOutgoingEdges().get(i)).getTargets().get(0);
                child.setX(child.getX() + tree.getX());
                this.absoluteTreeCoords(child);
                ++i;
            }
        }
    }

    public LayoutProcessorConfiguration<VertiFlexLayoutPhases, ElkNode> getLayoutProcessorConfiguration(ElkNode graph) {
        return null;
    }
}

