/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.changelistener;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;

public class FordiacResourceChangeListener
implements IResourceChangeListener {
    IResourceDeltaVisitor visitor = delta -> {
        switch (delta.getKind()) {
            case 4: {
                return FordiacResourceChangeListener.handleResourceChanged(delta);
            }
            case 2: {
                return FordiacResourceChangeListener.handleResourceRemoved(delta);
            }
            case 1: {
                return FordiacResourceChangeListener.handleResourceAdded(delta);
            }
        }
        return true;
    };
    private static final IResourceDeltaVisitor projRenameVisitor = delta -> {
        if (delta.getKind() == 1 && delta.getResource().getType() == 1 && FordiacResourceChangeListener.testFlags(delta, 4096)) {
            IFile src = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedFromPath());
            IFile dst = (IFile)delta.getResource();
            FordiacResourceChangeListener.handleFileAfterProjectRename(src, dst);
        }
        return true;
    };

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta rootDelta = event.getDelta();
            try {
                rootDelta.accept(this.visitor);
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)"Couldn't process resource delta", (Throwable)e);
            }
        }
    }

    private static boolean handleResourceChanged(IResourceDelta delta) {
        switch (delta.getResource().getType()) {
            case 1: {
                if (!FordiacResourceChangeListener.testFlags(delta, 256)) break;
                FordiacResourceChangeListener.refreshTypeEntry(delta);
                break;
            }
            case 4: {
                if (FordiacResourceChangeListener.testFlags(delta, 524288)) {
                    TypeLibraryManager.INSTANCE.getTypeLibrary(delta.getResource().getProject()).refresh();
                    SystemManager.validateProjectNature(delta.getResource().getProject());
                }
                if (!FordiacResourceChangeListener.testFlags(delta, 16384)) break;
                if (delta.getResource().isAccessible()) {
                    TypeLibraryManager.INSTANCE.getTypeLibrary(delta.getResource().getProject()).refresh();
                    SystemManager.validateProjectNature(delta.getResource().getProject());
                } else {
                    FordiacResourceChangeListener.handleProjectRemove(delta);
                }
                return false;
            }
        }
        return true;
    }

    private static void refreshTypeEntry(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        TypeEntry typeEntryForFile = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
        if (typeEntryForFile != null) {
            typeEntryForFile.refresh();
        }
    }

    private static boolean handleResourceRemoved(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        if (FordiacResourceChangeListener.testFlags(delta, 8192) || !TypeLibraryManager.INSTANCE.hasTypeLibrary(project)) {
            return false;
        }
        switch (delta.getResource().getType()) {
            case 1: {
                FordiacResourceChangeListener.handleFileDelete(delta);
                break;
            }
            case 4: {
                FordiacResourceChangeListener.handleProjectRemove(delta);
                return false;
            }
        }
        return true;
    }

    private static boolean handleResourceAdded(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        if (delta.getResource().getType() == 4) {
            if (FordiacResourceChangeListener.testFlags(delta, 4096)) {
                FordiacResourceChangeListener.handleProjectRename(delta);
            } else {
                SystemManager.validateProjectNature(project);
            }
        }
        if (!TypeLibraryManager.INSTANCE.hasTypeLibrary(project)) {
            return false;
        }
        if (delta.getResource().getType() == 1) {
            FordiacResourceChangeListener.handleFileAdded(delta);
        }
        return true;
    }

    private static void handleFileDelete(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        if (!TypeLibraryManager.INSTANCE.hasTypeLibrary(file.getProject())) {
            return;
        }
        TypeLibrary typeLib = TypeLibraryManager.INSTANCE.getTypeLibrary(file.getProject());
        TypeEntry entry = typeLib.getTypeEntry(file);
        if (entry != null) {
            FordiacResourceChangeListener.closeAllEditorsForFile(file);
            typeLib.removeTypeEntry(entry);
        }
    }

    private static void handleFileAdded(IResourceDelta delta) {
        IFile file = (IFile)delta.getResource();
        if (!TypeLibraryManager.INSTANCE.hasTypeLibrary(file.getProject())) {
            return;
        }
        if (file.getProject().isOpen() && delta.getFlags() != 131072) {
            TypeLibrary typeLib = TypeLibraryManager.INSTANCE.getTypeLibrary(file.getProject());
            TypeEntry typeEntryForFile = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            if (typeEntryForFile == null) {
                typeLib.createTypeEntry(file);
            }
        }
    }

    private static void handleProjectRename(IResourceDelta delta) {
        IProject oldProject = ResourcesPlugin.getWorkspace().getRoot().getProject(delta.getMovedFromPath().lastSegment());
        IProject newProject = delta.getResource().getProject();
        TypeLibraryManager.INSTANCE.renameProject(oldProject, newProject);
        try {
            delta.accept(projRenameVisitor);
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)"Couldn't handle project rename", (Throwable)e);
        }
    }

    private static void handleFileAfterProjectRename(IFile src, IFile dst) {
        TypeLibrary typeLib = TypeLibraryManager.INSTANCE.getTypeLibrary(dst.getProject());
        TypeEntry entry = typeLib.getTypeEntry(src);
        if (entry == null) {
            typeLib.createTypeEntry(dst);
        } else {
            typeLib.removeTypeEntry(entry);
            entry.setFile(dst);
            typeLib.addTypeEntry(entry);
        }
    }

    private static void handleProjectRemove(IResourceDelta delta) {
        IProject project = delta.getResource().getProject();
        FordiacResourceChangeListener.closeAllProjectRelatedEditors(project);
        TypeLibraryManager.INSTANCE.removeProject(project);
    }

    private static void closeAllProjectRelatedEditors(IProject project) {
        Display.getDefault().asyncExec(() -> EditorUtils.closeEditorsFiltered(editor -> {
            IFileEditorInput fileEditorInput;
            IEditorInput iEditorInput = editor.getEditorInput();
            return iEditorInput instanceof IFileEditorInput && project.equals((Object)(fileEditorInput = (IFileEditorInput)iEditorInput).getFile().getProject());
        }));
    }

    private static void closeAllEditorsForFile(IFile file) {
        Display.getDefault().asyncExec(() -> EditorUtils.closeEditorsFiltered(editor -> {
            IFileEditorInput fileEditorInput;
            IEditorInput iEditorInput = editor.getEditorInput();
            return iEditorInput instanceof IFileEditorInput && file.equals((Object)(fileEditorInput = (IFileEditorInput)iEditorInput).getFile());
        }));
    }

    private static boolean testFlags(IResourceDelta delta, int flags) {
        return (delta.getFlags() & flags) == flags;
    }
}

