/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class HyperedgeDummyMerger
implements ILayoutProcessor<LGraph> {
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Hyperedge merging", 1.0f);
        this.identifyHyperedges(layeredGraph);
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            List<LNode> nodes = layer.getNodes();
            if (nodes.isEmpty()) continue;
            LNode currNode = null;
            LNode.NodeType currNodeType = null;
            LNode lastNode = null;
            LNode.NodeType lastNodeType = null;
            int nodeIndex = 0;
            while (nodeIndex < nodes.size()) {
                currNode = nodes.get(nodeIndex);
                currNodeType = currNode.getType();
                if (currNodeType == LNode.NodeType.LONG_EDGE && lastNodeType == LNode.NodeType.LONG_EDGE) {
                    MergeState state = this.checkMergeAllowed(currNode, lastNode);
                    if (state.allowMerge) {
                        this.mergeNodes(currNode, lastNode, state.sameSource, state.sameTarget);
                        nodes.remove(nodeIndex);
                        --nodeIndex;
                        currNode = lastNode;
                        currNodeType = lastNodeType;
                    }
                }
                lastNode = currNode;
                lastNodeType = currNodeType;
                ++nodeIndex;
            }
        }
        monitor.done();
    }

    private MergeState checkMergeAllowed(LNode currNode, LNode lastNode) {
        boolean sameTarget;
        boolean currHasLabelDummies = (Boolean)currNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES);
        boolean lastHasLabelDummies = (Boolean)lastNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES);
        LPort currNodeSource = (LPort)((Object)currNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
        LPort lastNodeSource = (LPort)((Object)lastNode.getProperty(InternalProperties.LONG_EDGE_SOURCE));
        LPort currNodeTarget = (LPort)((Object)currNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
        LPort lastNodeTarget = (LPort)((Object)lastNode.getProperty(InternalProperties.LONG_EDGE_TARGET));
        boolean sameSource = currNodeSource != null && currNodeSource == lastNodeSource;
        boolean bl = sameTarget = currNodeTarget != null && currNodeTarget == lastNodeTarget;
        if (!currHasLabelDummies && !lastHasLabelDummies) {
            return new MergeState(currNode.getPorts().iterator().next().id == lastNode.getPorts().iterator().next().id, sameSource, sameTarget);
        }
        boolean eligibleForSourceMerging = !((Boolean)currNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES) != false && (Boolean)currNode.getProperty(InternalProperties.LONG_EDGE_BEFORE_LABEL_DUMMY) == false || (Boolean)lastNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES) != false && (Boolean)lastNode.getProperty(InternalProperties.LONG_EDGE_BEFORE_LABEL_DUMMY) == false);
        boolean eligibleForTargetMerging = !((Boolean)currNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES) != false && (Boolean)currNode.getProperty(InternalProperties.LONG_EDGE_BEFORE_LABEL_DUMMY) != false || (Boolean)lastNode.getProperty(InternalProperties.LONG_EDGE_HAS_LABEL_DUMMIES) != false && (Boolean)lastNode.getProperty(InternalProperties.LONG_EDGE_BEFORE_LABEL_DUMMY) != false);
        return new MergeState(sameSource && eligibleForSourceMerging || sameTarget && eligibleForTargetMerging, sameSource, sameTarget);
    }

    private void mergeNodes(LNode mergeSource, LNode mergeTarget, boolean keepSourcePort, boolean keepTargetPort) {
        LPort mergeTargetInputPort = mergeTarget.getPorts(PortSide.WEST).iterator().next();
        LPort mergeTargetOutputPort = mergeTarget.getPorts(PortSide.EAST).iterator().next();
        for (LPort port : mergeSource.getPorts()) {
            while (!port.getIncomingEdges().isEmpty()) {
                port.getIncomingEdges().get(0).setTarget(mergeTargetInputPort);
            }
            while (!port.getOutgoingEdges().isEmpty()) {
                port.getOutgoingEdges().get(0).setSource(mergeTargetOutputPort);
            }
        }
        if (!keepSourcePort) {
            mergeTarget.setProperty(InternalProperties.LONG_EDGE_SOURCE, null);
        }
        if (!keepTargetPort) {
            mergeTarget.setProperty(InternalProperties.LONG_EDGE_TARGET, null);
        }
    }

    private void identifyHyperedges(LGraph lGraph) {
        List<LPort> ports = lGraph.getLayers().stream().flatMap(l -> l.getNodes().stream()).flatMap(n -> n.getPorts().stream()).collect(Collectors.toList());
        ports.forEach(p -> {
            int n = p.id = -1;
        });
        int index = 0;
        for (LPort p2 : ports) {
            if (p2.id != -1) continue;
            this.dfs(p2, index++);
        }
    }

    private void dfs(LPort p, int index) {
        p.id = index;
        for (LPort p2 : p.getConnectedPorts()) {
            if (p2.id != -1) continue;
            this.dfs(p2, index);
        }
        if (p.getNode().getType() == LNode.NodeType.LONG_EDGE) {
            for (LPort p2 : p.getNode().getPorts()) {
                if (p2 == p || p2.id != -1) continue;
                this.dfs(p2, index);
            }
        }
    }

    private static class MergeState {
        final boolean allowMerge;
        final boolean sameSource;
        final boolean sameTarget;

        MergeState(boolean allowMerge, boolean sameSource, boolean sameTarget) {
            this.allowMerge = allowMerge;
            this.sameSource = sameSource;
            this.sameTarget = sameTarget;
        }
    }
}

