/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.widgets;

import java.util.Comparator;
import java.util.function.Supplier;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class PackageSelectionProposalProvider
implements IContentProposalProvider {
    private final Supplier<TypeLibrary> supplier;

    public PackageSelectionProposalProvider(Supplier<TypeLibrary> supplier) {
        this.supplier = supplier;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        TypeLibrary typeLibrary = this.supplier.get();
        if (typeLibrary != null) {
            return (IContentProposal[])typeLibrary.getPackages().stream().filter(proposal -> PackageSelectionProposalProvider.matches(proposal, contents, position)).map(this::createProposal).sorted(Comparator.comparing(IContentProposal::getLabel)).toArray(IContentProposal[]::new);
        }
        return new IContentProposal[0];
    }

    protected static boolean matches(String name, String prefix, int position) {
        return name.regionMatches(true, 0, prefix, 0, position);
    }

    protected ContentProposal createProposal(String packageName) {
        return new ContentProposal(packageName);
    }
}

