/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import java.util.Collection;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.StructuralRefreshCommand;
import org.eclipse.nebula.widgets.nattable.command.StructuralRefreshCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.VisualRefreshCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.command.ClientAreaResizeCommand;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.SizeConfig;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommandHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ResizeStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommandHandler;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnSizeConfigurationCommandHandler;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnWidthResetCommandHandler;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiColumnResizeCommandHandler;
import org.eclipse.nebula.widgets.nattable.resize.command.MultiRowResizeCommandHandler;
import org.eclipse.nebula.widgets.nattable.resize.command.RowHeightResetCommandHandler;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommandHandler;
import org.eclipse.nebula.widgets.nattable.resize.command.RowSizeConfigurationCommandHandler;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEvent;

public class DataLayer
extends AbstractLayer
implements IUniqueIndexLayer {
    public static final String PERSISTENCE_KEY_ROW_HEIGHT = ".rowHeight";
    public static final String PERSISTENCE_KEY_COLUMN_WIDTH = ".columnWidth";
    public static final int DEFAULT_COLUMN_WIDTH = 100;
    public static final int DEFAULT_ROW_HEIGHT = 20;
    protected IDataProvider dataProvider;
    protected SizeConfig columnWidthConfig;
    protected SizeConfig rowHeightConfig;

    public DataLayer(IDataProvider dataProvider) {
        this(dataProvider, 100, 20);
    }

    public DataLayer(IDataProvider dataProvider, int defaultColumnWidth, int defaultRowHeight) {
        this(defaultColumnWidth, defaultRowHeight);
        this.setDataProvider(dataProvider);
    }

    protected DataLayer() {
        this(100, 20);
    }

    protected DataLayer(int defaultColumnWidth, int defaultRowHeight) {
        this.columnWidthConfig = new SizeConfig(defaultColumnWidth);
        this.rowHeightConfig = new SizeConfig(defaultRowHeight);
        this.registerCommandHandlers();
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        this.columnWidthConfig.saveState(prefix + PERSISTENCE_KEY_COLUMN_WIDTH, properties);
        this.rowHeightConfig.saveState(prefix + PERSISTENCE_KEY_ROW_HEIGHT, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.columnWidthConfig.loadState(prefix + PERSISTENCE_KEY_COLUMN_WIDTH, properties);
        this.rowHeightConfig.loadState(prefix + PERSISTENCE_KEY_ROW_HEIGHT, properties);
        if (!properties.containsKey("NatTable.initialPaintComplete")) {
            this.fireLayerEvent(new StructuralRefreshEvent(this));
        }
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new ColumnResizeCommandHandler(this));
        this.registerCommandHandler(new MultiColumnResizeCommandHandler(this));
        this.registerCommandHandler(new ColumnSizeConfigurationCommandHandler(this));
        this.registerCommandHandler(new RowResizeCommandHandler(this));
        this.registerCommandHandler(new MultiRowResizeCommandHandler(this));
        this.registerCommandHandler(new RowSizeConfigurationCommandHandler(this));
        this.registerCommandHandler(new UpdateDataCommandHandler(this));
        this.registerCommandHandler(new StructuralRefreshCommandHandler());
        this.registerCommandHandler(new VisualRefreshCommandHandler());
        this.registerCommandHandler(new ConfigureScalingCommandHandler(this.columnWidthConfig, this.rowHeightConfig));
        this.registerCommandHandler(new ColumnWidthResetCommandHandler(this));
        this.registerCommandHandler(new RowHeightResetCommandHandler(this));
    }

    public IDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(IDataProvider dataProvider) {
        if (this.dataProvider instanceof IPersistable) {
            this.unregisterPersistable((IPersistable)((Object)this.dataProvider));
        }
        this.dataProvider = dataProvider;
        if (dataProvider instanceof IPersistable) {
            this.registerPersistable((IPersistable)((Object)dataProvider));
        }
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        return this.dataProvider.getDataValue(columnIndex, rowIndex);
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        this.dataProvider.setDataValue(columnIndex, rowIndex, newValue);
    }

    @Override
    public int getColumnCount() {
        return this.dataProvider.getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.getColumnCount();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        if (columnPosition >= 0 && columnPosition < this.getColumnCount()) {
            return columnPosition;
        }
        return -1;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            return columnIndex;
        }
        return -1;
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return localColumnPosition;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        return underlyingColumnPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        return underlyingColumnPositionRanges;
    }

    @Override
    public int getWidth() {
        return this.columnWidthConfig.getAggregateSize(this.getColumnCount());
    }

    @Override
    public int getPreferredWidth() {
        return this.getWidth();
    }

    public int getDefaultColumnWidth() {
        return this.columnWidthConfig.getDefaultSize();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return this.columnWidthConfig.getSize(columnPosition);
    }

    public void setColumnWidthByPosition(int columnPosition, int width) {
        this.setColumnWidthByPosition(columnPosition, width, true);
    }

    public void setColumnWidthByPosition(int columnPosition, int width, boolean fireEvent) {
        this.columnWidthConfig.setSize(columnPosition, width);
        if (fireEvent) {
            this.fireLayerEvent(new ColumnResizeEvent((ILayer)this, columnPosition));
        }
    }

    public void setColumnWidthPercentageByPosition(int columnPosition, int width) {
        this.columnWidthConfig.setPercentage(columnPosition, width);
        this.fireLayerEvent(new ColumnResizeEvent((ILayer)this, columnPosition));
    }

    public void setColumnWidthPercentageByPosition(int columnPosition, double width) {
        this.columnWidthConfig.setPercentage(columnPosition, width);
        this.fireLayerEvent(new ColumnResizeEvent((ILayer)this, columnPosition));
    }

    public void setDefaultColumnWidth(int width) {
        this.columnWidthConfig.setDefaultSize(width);
    }

    public void setDefaultColumnWidthByPosition(int columnPosition, int width) {
        this.columnWidthConfig.setDefaultSize(columnPosition, width);
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.columnWidthConfig.isPositionResizable(columnPosition);
    }

    public void setColumnPositionResizable(int columnPosition, boolean resizable) {
        this.columnWidthConfig.setPositionResizable(columnPosition, resizable);
    }

    public void setColumnsResizableByDefault(boolean resizableByDefault) {
        this.columnWidthConfig.setResizableByDefault(resizableByDefault);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByColumnPosition(int columnPosition) {
        return null;
    }

    @Override
    public int getRowCount() {
        return this.dataProvider.getRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        return this.getRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition >= 0 && rowPosition < this.getRowCount()) {
            return rowPosition;
        }
        return -1;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return rowIndex;
        }
        return -1;
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        return localRowPosition;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        return underlyingRowPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        return underlyingRowPositionRanges;
    }

    @Override
    public int getHeight() {
        return this.rowHeightConfig.getAggregateSize(this.getRowCount());
    }

    @Override
    public int getPreferredHeight() {
        return this.getHeight();
    }

    public int getDefaultRowHeight() {
        return this.rowHeightConfig.getDefaultSize();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        return this.rowHeightConfig.getSize(rowPosition);
    }

    public void setRowHeightByPosition(int rowPosition, int height) {
        this.setRowHeightByPosition(rowPosition, height, true);
    }

    public void setRowHeightByPosition(int rowPosition, int height, boolean fireEvent) {
        this.rowHeightConfig.setSize(rowPosition, height);
        if (fireEvent) {
            this.fireLayerEvent(new RowResizeEvent((ILayer)this, rowPosition));
        }
    }

    public void setRowHeightPercentageByPosition(int rowPosition, int height) {
        this.rowHeightConfig.setPercentage(rowPosition, height);
        this.fireLayerEvent(new RowResizeEvent((ILayer)this, rowPosition));
    }

    public void setRowHeightPercentageByPosition(int rowPosition, double height) {
        this.rowHeightConfig.setPercentage(rowPosition, height);
        this.fireLayerEvent(new RowResizeEvent((ILayer)this, rowPosition));
    }

    public void setDefaultRowHeight(int height) {
        this.rowHeightConfig.setDefaultSize(height);
    }

    public void setDefaultRowHeightByPosition(int rowPosition, int height) {
        this.rowHeightConfig.setDefaultSize(rowPosition, height);
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        return this.rowHeightConfig.isPositionResizable(rowPosition);
    }

    public void setRowPositionResizable(int rowPosition, boolean resizable) {
        this.rowHeightConfig.setPositionResizable(rowPosition, resizable);
    }

    public void setRowsResizableByDefault(boolean resizableByDefault) {
        this.rowHeightConfig.setResizableByDefault(resizableByDefault);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByRowPosition(int rowPosition) {
        return null;
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        int rowIndex = this.getRowIndexByPosition(rowPosition);
        return this.getDataValue(columnIndex, rowIndex);
    }

    public void setDataValueByPosition(int columnPosition, int rowPosition, Object newValue) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        int rowIndex = this.getRowIndexByPosition(rowPosition);
        this.setDataValue(columnIndex, rowIndex, newValue);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return LayerUtil.getColumnPositionByX(this, x);
    }

    @Override
    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY(this, y);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.columnWidthConfig.getAggregateSize(columnPosition);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.rowHeightConfig.getAggregateSize(rowPosition);
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(int columnPosition, int rowPosition) {
        return null;
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ClientAreaResizeCommand && command.convertToTargetLayer(this)) {
            ClientAreaResizeCommand clientAreaResizeCommand = (ClientAreaResizeCommand)command;
            boolean refresh = false;
            if (this.isColumnPercentageSizing()) {
                this.columnWidthConfig.calculatePercentages(clientAreaResizeCommand.getCalcArea().width, this.getColumnCount());
                refresh = true;
            }
            if (this.isRowPercentageSizing()) {
                this.rowHeightConfig.calculatePercentages(clientAreaResizeCommand.getCalcArea().height, this.getRowCount());
                refresh = true;
            }
            if (refresh) {
                this.fireLayerEvent(new ResizeStructuralRefreshEvent(this));
            }
            return refresh;
        }
        if (command instanceof StructuralRefreshCommand) {
            if (this.isColumnPercentageSizing()) {
                this.columnWidthConfig.updatePercentageValues(this.getColumnCount());
            }
            if (this.isRowPercentageSizing()) {
                this.rowHeightConfig.updatePercentageValues(this.getRowCount());
            }
        }
        return super.doCommand(command);
    }

    public boolean isColumnPercentageSizing() {
        return this.columnWidthConfig.isPercentageSizing();
    }

    public void setColumnPercentageSizing(boolean percentageSizing) {
        this.columnWidthConfig.setPercentageSizing(percentageSizing);
    }

    public boolean isColumnPercentageSizing(int position) {
        return this.columnWidthConfig.isPercentageSizing(position);
    }

    public void setColumnPercentageSizing(int position, boolean percentageSizing) {
        this.columnWidthConfig.setPercentageSizing(position, percentageSizing);
    }

    public boolean isRowPercentageSizing() {
        return this.rowHeightConfig.isPercentageSizing();
    }

    public void setRowPercentageSizing(boolean percentageSizing) {
        this.rowHeightConfig.setPercentageSizing(percentageSizing);
    }

    public boolean isRowPercentageSizing(int position) {
        return this.rowHeightConfig.isPercentageSizing(position);
    }

    public void setRowPercentageSizing(int position, boolean percentageSizing) {
        this.rowHeightConfig.setPercentageSizing(position, percentageSizing);
    }

    public void resetColumnWidthConfiguration(boolean fireEvent) {
        this.columnWidthConfig.reset();
        if (fireEvent) {
            this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
        }
    }

    public void resetRowHeightConfiguration(boolean fireEvent) {
        this.rowHeightConfig.reset();
        if (fireEvent) {
            this.fireLayerEvent(new RowStructuralRefreshEvent(this));
        }
    }

    public void resetColumnWidth(int position, boolean fireEvent) {
        this.columnWidthConfig.resetConfiguredSize(position);
        if (fireEvent) {
            this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
        }
    }

    public void resetRowHeight(int position, boolean fireEvent) {
        this.rowHeightConfig.resetConfiguredSize(position);
        if (fireEvent) {
            this.fireLayerEvent(new RowStructuralRefreshEvent(this));
        }
    }

    public void resetMinColumnWidth(int position, boolean fireEvent) {
        this.columnWidthConfig.resetConfiguredMinSize(position);
        if (fireEvent) {
            this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
        }
    }

    public void resetMinRowHeight(int position, boolean fireEvent) {
        this.rowHeightConfig.resetConfiguredMinSize(position);
        if (fireEvent) {
            this.fireLayerEvent(new RowStructuralRefreshEvent(this));
        }
    }

    public int getConfiguredColumnWidthByPosition(int columnPosition) {
        return this.columnWidthConfig.getConfiguredSize(columnPosition);
    }

    public double getConfiguredColumnWidthPercentageByPosition(int columnPosition) {
        return this.columnWidthConfig.getConfiguredPercentageSize(columnPosition);
    }

    public int getConfiguredRowHeightByPosition(int rowPosition) {
        return this.rowHeightConfig.getConfiguredSize(rowPosition);
    }

    public double getConfiguredRowHeightPercentageByPosition(int rowPosition) {
        return this.rowHeightConfig.getConfiguredPercentageSize(rowPosition);
    }

    public int getConfiguredMinColumnWidthByPosition(int columnPosition) {
        return this.columnWidthConfig.getConfiguredMinSize(columnPosition);
    }

    public int getConfiguredMinRowHeightByPosition(int rowPosition) {
        return this.rowHeightConfig.getConfiguredMinSize(rowPosition);
    }

    public boolean isDistributeRemainingColumnSpace() {
        return this.columnWidthConfig.isDistributeRemainingSpace();
    }

    public void setDistributeRemainingColumnSpace(boolean distributeRemaining) {
        this.columnWidthConfig.setDistributeRemainingSpace(distributeRemaining);
    }

    public boolean isDistributeRemainingRowSpace() {
        return this.rowHeightConfig.isDistributeRemainingSpace();
    }

    public void setDistributeRemainingRowSpace(boolean distributeRemaining) {
        this.rowHeightConfig.setDistributeRemainingSpace(distributeRemaining);
    }

    public int getDefaultMinColumnWidth() {
        return this.columnWidthConfig.getDefaultMinSize();
    }

    public void setDefaultMinColumnWidth(int defaultMinWidth) {
        this.columnWidthConfig.setDefaultMinSize(defaultMinWidth);
    }

    public int getMinColumnWidth(int position) {
        return this.columnWidthConfig.getMinSize(position);
    }

    public void setMinColumnWidth(int position, int minWidth) {
        this.columnWidthConfig.setMinSize(position, minWidth);
    }

    public boolean isMinColumnWidthConfigured() {
        return this.columnWidthConfig.isMinSizeConfigured();
    }

    public boolean isMinColumnWidthConfigured(int position) {
        return this.columnWidthConfig.isMinSizeConfigured(position);
    }

    public int getDefaultMinRowHeight() {
        return this.rowHeightConfig.getDefaultMinSize();
    }

    public void setDefaultMinRowHeight(int defaultMinHeight) {
        this.rowHeightConfig.setDefaultMinSize(defaultMinHeight);
    }

    public int getMinRowHeight(int position) {
        return this.rowHeightConfig.getMinSize(position);
    }

    public void setMinRowHeight(int position, int minHeight) {
        this.rowHeightConfig.setMinSize(position, minHeight);
    }

    public boolean isMinRowHeightConfigured() {
        return this.rowHeightConfig.isMinSizeConfigured();
    }

    public boolean isMinRowHeightConfigured(int position) {
        return this.rowHeightConfig.isMinSizeConfigured(position);
    }

    public int upScaleColumnWidth(int value) {
        return this.columnWidthConfig.upScale(value);
    }

    public int downScaleColumnWidth(int value) {
        return this.columnWidthConfig.downScale(value);
    }

    public int upScaleRowHeight(int value) {
        return this.rowHeightConfig.upScale(value);
    }

    public int downScaleRowHeight(int value) {
        return this.rowHeightConfig.downScale(value);
    }

    public boolean isFixColumnPercentageValuesOnResize() {
        return this.columnWidthConfig.isFixPercentageValuesOnResize();
    }

    public void setFixColumnPercentageValuesOnResize(boolean enabled) {
        this.columnWidthConfig.setFixPercentageValuesOnResize(enabled);
    }

    public boolean isFixRowPercentageValuesOnResize() {
        return this.rowHeightConfig.isFixPercentageValuesOnResize();
    }

    public void setFixRowPercentageValuesOnResize(boolean enabled) {
        this.rowHeightConfig.setFixPercentageValuesOnResize(enabled);
    }
}

