/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.columnChooser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnChooserUtils;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnEntry;
import org.eclipse.nebula.widgets.nattable.columnChooser.ColumnGroupEntry;
import org.eclipse.nebula.widgets.nattable.columnChooser.ISelectionTreeListener;
import org.eclipse.nebula.widgets.nattable.columnChooser.gui.ColumnChooserDialog;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.command.ColumnGroupExpandCollapseCommand;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnsAndGroupsCommand;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.widgets.Shell;

public class ColumnChooser {
    protected final ColumnChooserDialog columnChooserDialog;
    protected final ColumnHideShowLayer columnHideShowLayer;
    protected final DataLayer columnHeaderDataLayer;
    protected final ColumnHeaderLayer columnHeaderLayer;
    protected List<ColumnEntry> hiddenColumnEntries;
    protected List<ColumnEntry> visibleColumnsEntries;
    protected final ColumnGroupModel columnGroupModel;
    protected final SelectionLayer selectionLayer;
    protected final boolean sortAvailableColumns;
    protected final boolean preventHidingAllColumns;
    private final ColumnGroupHeaderLayer columnGroupHeaderLayer;
    List<Integer> nonModifiableColumns = new ArrayList<Integer>();

    public ColumnChooser(Shell shell, SelectionLayer selectionLayer, ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer columnGroupHeaderLayer, ColumnGroupModel columnGroupModel, boolean sortAvailableColumns) {
        this(shell, selectionLayer, columnHideShowLayer, columnHeaderLayer, columnHeaderDataLayer, columnGroupHeaderLayer, columnGroupModel, sortAvailableColumns, false);
    }

    public ColumnChooser(Shell shell, SelectionLayer selectionLayer, ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer columnGroupHeaderLayer, ColumnGroupModel columnGroupModel, boolean sortAvailableColumns, boolean preventHidingAllColumns) {
        this.selectionLayer = selectionLayer;
        this.columnHideShowLayer = columnHideShowLayer;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.columnGroupModel = columnGroupModel;
        this.sortAvailableColumns = sortAvailableColumns;
        this.preventHidingAllColumns = preventHidingAllColumns;
        this.columnGroupHeaderLayer = null;
        this.columnChooserDialog = new ColumnChooserDialog(shell, Messages.getString("ColumnChooser.availableColumns"), Messages.getString("ColumnChooser.selectedColumns"));
        this.columnChooserDialog.setPreventHidingAllColumns(preventHidingAllColumns);
    }

    public ColumnChooser(Shell shell, ColumnHideShowLayer columnHideShowLayer, ColumnHeaderLayer columnHeaderLayer, DataLayer columnHeaderDataLayer, ColumnGroupHeaderLayer columnGroupHeaderLayer, boolean sortAvailableColumns) {
        if (columnGroupHeaderLayer == null) {
            throw new IllegalArgumentException("columnGroupHeaderLayer cannot be null");
        }
        this.selectionLayer = null;
        this.columnHideShowLayer = columnHideShowLayer;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
        this.columnGroupModel = null;
        this.sortAvailableColumns = sortAvailableColumns;
        this.preventHidingAllColumns = false;
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
        this.columnChooserDialog = new ColumnChooserDialog(shell, Messages.getString("ColumnChooser.availableColumns"), Messages.getString("ColumnChooser.selectedColumns"));
        this.columnChooserDialog.setPreventHidingAllColumns(this.preventHidingAllColumns);
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.columnChooserDialog.setDialogSettings(dialogSettings);
    }

    public void openDialog() {
        this.columnChooserDialog.create();
        this.hiddenColumnEntries = this.getHiddenColumnEntries();
        if (this.columnGroupHeaderLayer != null) {
            this.columnChooserDialog.populateAvailableTree(this.hiddenColumnEntries, this.columnGroupHeaderLayer, this.sortAvailableColumns);
        } else {
            this.columnChooserDialog.populateAvailableTree(this.hiddenColumnEntries, this.columnGroupModel, this.sortAvailableColumns);
        }
        this.visibleColumnsEntries = this.getVisibleColumnEntries();
        if (this.columnGroupHeaderLayer != null) {
            this.columnChooserDialog.populateSelectedTree(this.visibleColumnsEntries, this.columnGroupHeaderLayer);
        } else {
            this.columnChooserDialog.populateSelectedTree(this.visibleColumnsEntries, this.columnGroupModel);
        }
        this.columnChooserDialog.expandAllLeaves();
        this.addListenersOnColumnChooserDialog();
        this.columnChooserDialog.open();
    }

    private void addListenersOnColumnChooserDialog() {
        this.columnChooserDialog.addListener(new ISelectionTreeListener(){

            @Override
            public void itemsRemoved(List<ColumnEntry> removedItems) {
                ColumnChooserUtils.hideColumnEntries(removedItems, ColumnChooser.this.columnHideShowLayer);
                ColumnChooser.this.refreshColumnChooserDialog();
            }

            @Override
            public void itemsSelected(List<ColumnEntry> addedItems) {
                ColumnChooserUtils.showColumnEntries(addedItems, ColumnChooser.this.columnHideShowLayer);
                ColumnChooser.this.refreshColumnChooserDialog();
                ColumnChooser.this.columnChooserDialog.setSelectionIncludingNested(ColumnChooserUtils.getColumnEntryIndexes(addedItems));
            }

            @Override
            public void itemsMoved(SelectionLayer.MoveDirectionEnum direction, List<ColumnGroupEntry> movedColumnGroupEntries, List<ColumnEntry> movedColumnEntries, List<List<Integer>> fromPositions, List<Integer> toPositions) {
                this.moveItems(direction, movedColumnGroupEntries, movedColumnEntries, fromPositions, toPositions);
            }

            private void moveItems(SelectionLayer.MoveDirectionEnum direction, List<ColumnGroupEntry> movedColumnGroupEntries, List<ColumnEntry> movedColumnEntries, List<List<Integer>> fromPositions, List<Integer> toPositions) {
                int i = 0;
                while (i < fromPositions.size()) {
                    boolean columnGroupMoved = this.columnGroupMoved(fromPositions.get(i), movedColumnGroupEntries);
                    boolean multipleColumnsMoved = fromPositions.get(i).size() > 1;
                    ILayerCommand command = null;
                    if (!columnGroupMoved && !multipleColumnsMoved) {
                        int fromPosition = fromPositions.get(i).get(0);
                        int toPosition = this.adjustToPosition(direction, toPositions.get(i));
                        command = new ColumnReorderCommand(ColumnChooser.this.columnHideShowLayer, fromPosition, toPosition);
                    } else if (columnGroupMoved && multipleColumnsMoved) {
                        command = new ReorderColumnsAndGroupsCommand((ILayer)ColumnChooser.this.columnHideShowLayer, fromPositions.get(i), this.adjustToPosition(direction, toPositions.get(i)));
                    } else if (!columnGroupMoved && multipleColumnsMoved) {
                        command = new MultiColumnReorderCommand((ILayer)ColumnChooser.this.columnHideShowLayer, fromPositions.get(i), this.adjustToPosition(direction, toPositions.get(i)));
                    } else if (columnGroupMoved && !multipleColumnsMoved) {
                        command = new ReorderColumnGroupCommand(ColumnChooser.this.columnHideShowLayer, fromPositions.get(i).get(0), this.adjustToPosition(direction, toPositions.get(i)));
                    }
                    ColumnChooser.this.columnHideShowLayer.doCommand(command);
                    ++i;
                }
                ColumnChooser.this.refreshColumnChooserDialog();
                ColumnChooser.this.columnChooserDialog.setSelectionIncludingNested(ColumnChooserUtils.getColumnEntryIndexes(movedColumnEntries));
            }

            private int adjustToPosition(SelectionLayer.MoveDirectionEnum direction, Integer toColumnPosition) {
                if (SelectionLayer.MoveDirectionEnum.DOWN == direction) {
                    return toColumnPosition + 1;
                }
                return toColumnPosition;
            }

            private boolean columnGroupMoved(List<Integer> fromPositions, List<ColumnGroupEntry> movedColumnGroupEntries) {
                for (ColumnGroupEntry columnGroupEntry : movedColumnGroupEntries) {
                    if (!fromPositions.contains(columnGroupEntry.getFirstElementPosition())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void itemsCollapsed(ColumnGroupEntry columnGroupEntry) {
                if (ColumnChooser.this.columnGroupHeaderLayer != null) {
                    int index = columnGroupEntry.getFirstElementIndex();
                    int position = ColumnChooser.this.columnGroupHeaderLayer.getPositionLayer().getColumnPositionByIndex(index);
                    ColumnChooser.this.columnGroupHeaderLayer.doCommand(new ColumnGroupExpandCollapseCommand(ColumnChooser.this.columnGroupHeaderLayer.getPositionLayer(), position));
                } else {
                    int index = columnGroupEntry.getFirstElementIndex();
                    int position = ColumnChooser.this.selectionLayer.getColumnPositionByIndex(index);
                    ColumnChooser.this.selectionLayer.doCommand(new ColumnGroupExpandCollapseCommand(ColumnChooser.this.selectionLayer, position));
                }
            }

            @Override
            public void itemsExpanded(ColumnGroupEntry columnGroupEntry) {
                if (ColumnChooser.this.columnGroupHeaderLayer != null) {
                    int index = columnGroupEntry.getFirstElementIndex();
                    int position = ColumnChooser.this.columnGroupHeaderLayer.getPositionLayer().getColumnPositionByIndex(index);
                    ColumnChooser.this.columnGroupHeaderLayer.doCommand(new ColumnGroupExpandCollapseCommand(ColumnChooser.this.columnGroupHeaderLayer.getPositionLayer(), position));
                } else {
                    int index = columnGroupEntry.getFirstElementIndex();
                    int position = ColumnChooser.this.selectionLayer.getColumnPositionByIndex(index);
                    ColumnChooser.this.selectionLayer.doCommand(new ColumnGroupExpandCollapseCommand(ColumnChooser.this.selectionLayer, position));
                }
            }
        });
    }

    private void refreshColumnChooserDialog() {
        this.hiddenColumnEntries = this.getHiddenColumnEntries();
        this.visibleColumnsEntries = this.getVisibleColumnEntries();
        this.columnChooserDialog.removeAllLeaves();
        if (this.columnGroupHeaderLayer != null) {
            this.columnChooserDialog.populateSelectedTree(this.visibleColumnsEntries, this.columnGroupHeaderLayer);
            this.columnChooserDialog.populateAvailableTree(this.hiddenColumnEntries, this.columnGroupHeaderLayer, this.sortAvailableColumns);
        } else {
            this.columnChooserDialog.populateSelectedTree(this.visibleColumnsEntries, this.columnGroupModel);
            this.columnChooserDialog.populateAvailableTree(this.hiddenColumnEntries, this.columnGroupModel, this.sortAvailableColumns);
        }
        this.columnChooserDialog.expandAllLeaves();
    }

    protected List<ColumnEntry> getHiddenColumnEntries() {
        List<ColumnEntry> columnEntries = ColumnChooserUtils.getHiddenColumnEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer);
        if (!this.nonModifiableColumns.isEmpty()) {
            Iterator<ColumnEntry> it = columnEntries.iterator();
            while (it.hasNext()) {
                ColumnEntry entry = it.next();
                if (!this.nonModifiableColumns.contains(entry.getIndex())) continue;
                it.remove();
            }
        }
        return columnEntries;
    }

    private List<ColumnEntry> getVisibleColumnEntries() {
        List<ColumnEntry> columnEntries = ColumnChooserUtils.getVisibleColumnsEntries(this.columnHideShowLayer, this.columnHeaderLayer, this.columnHeaderDataLayer);
        if (!this.nonModifiableColumns.isEmpty()) {
            Iterator<ColumnEntry> it = columnEntries.iterator();
            while (it.hasNext()) {
                ColumnEntry entry = it.next();
                if (!this.nonModifiableColumns.contains(entry.getIndex())) continue;
                it.remove();
            }
        }
        return columnEntries;
    }

    public void addNonModifiableColumn(Integer ... columnIndexes) {
        Integer[] integerArray = columnIndexes;
        int n = columnIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            Integer column = integerArray[n2];
            this.nonModifiableColumns.add(column);
            ++n2;
        }
    }

    public void removeNonModifiableColumn(Integer ... columnIndexes) {
        Integer[] integerArray = columnIndexes;
        int n = columnIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            Integer column = integerArray[n2];
            this.nonModifiableColumns.remove(column);
            ++n2;
        }
    }
}

