/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.annotation;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotation;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;

public class GraphicalAnnotationModelEvent {
    private final GraphicalAnnotationModel model;
    private final Set<Object> targets;
    private final Map<Object, Set<GraphicalAnnotation>> added;
    private final Map<Object, Set<GraphicalAnnotation>> removed;
    private final Map<Object, Set<GraphicalAnnotation>> changed;
    private final long modificationStamp;

    public GraphicalAnnotationModelEvent(GraphicalAnnotationModel model, Set<GraphicalAnnotation> added, Set<GraphicalAnnotation> removed, Set<GraphicalAnnotation> changed, long modificationStamp) {
        this(model, added.stream().collect(Collectors.groupingBy(GraphicalAnnotation::getTarget, Collectors.toUnmodifiableSet())), removed.stream().collect(Collectors.groupingBy(GraphicalAnnotation::getTarget, Collectors.toUnmodifiableSet())), changed.stream().collect(Collectors.groupingBy(GraphicalAnnotation::getTarget, Collectors.toUnmodifiableSet())), modificationStamp);
    }

    public GraphicalAnnotationModelEvent(GraphicalAnnotationModel model, Map<Object, Set<GraphicalAnnotation>> added, Map<Object, Set<GraphicalAnnotation>> removed, Map<Object, Set<GraphicalAnnotation>> changed, long modificationStamp) {
        this.model = model;
        this.added = added;
        this.removed = removed;
        this.changed = changed;
        this.modificationStamp = modificationStamp;
        this.targets = Stream.of(added, removed, changed).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    public GraphicalAnnotationModel getModel() {
        return this.model;
    }

    public Set<Object> getTargets() {
        return this.targets;
    }

    public Set<GraphicalAnnotation> getAdded(Object target) {
        return Objects.requireNonNullElse(this.added.get(target), Set.of());
    }

    public Set<GraphicalAnnotation> getRemoved(Object target) {
        return Objects.requireNonNullElse(this.removed.get(target), Set.of());
    }

    public Set<GraphicalAnnotation> getChanged(Object target) {
        return Objects.requireNonNullElse(this.changed.get(target), Set.of());
    }

    public long getModificationStamp() {
        return this.modificationStamp;
    }

    public String toString() {
        return String.format("%s [added=%s, removed=%s, changed=%s, modificationStamp=%s]", this.getClass().getName(), this.added, this.removed, this.changed, Long.toString(this.modificationStamp));
    }
}

