/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.operations.OCLExpressionOperations;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.UMLReflection;

public class MessageExpOperations
extends OCLExpressionOperations {
    protected MessageExpOperations() {
    }

    public static <C, COA, SSA> boolean checkOperationArguments(MessageExp<C, COA, SSA> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(messageExp, context);
        if (env != null) {
            UMLReflection uml = env.getUMLReflection();
            if (messageExp.getCalledOperation() == null) {
                return true;
            }
            Object operation = uml.getOperation(messageExp.getCalledOperation());
            if (operation == null) {
                return true;
            }
            List parameters = uml.getParameters(operation);
            EList<OCLExpression<C>> arguments = messageExp.getArgument();
            if (arguments.size() != parameters.size()) {
                result = false;
                message = OCLMessages.bind(OCLMessages.MessageArgumentCount_ERROR_, uml.getName(messageExp.getType()));
            } else {
                Iterator paramsIter = parameters.iterator();
                Iterator argsIter = arguments.iterator();
                while (paramsIter.hasNext()) {
                    Object param = paramsIter.next();
                    OCLExpression arg = (OCLExpression)argsIter.next();
                    if (TypeUtil.compatibleTypeMatch(env, arg.getType(), uml.getOCLType(param))) continue;
                    result = false;
                    message = OCLMessages.bind(OCLMessages.MessageArgConformance_ERROR_, uml.getName(param), arg.toString());
                    break;
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 26, message, new Object[]{messageExp}));
        }
        return result;
    }

    public static <C, COA, SSA> boolean checkSignalArguments(MessageExp<C, COA, SSA> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(messageExp, context);
        if (env != null) {
            UMLReflection uml = env.getUMLReflection();
            if (messageExp.getSentSignal() == null) {
                return true;
            }
            Object signal = uml.getSignal(messageExp.getSentSignal());
            if (signal == null) {
                return true;
            }
            List attributes = uml.getAttributes(signal);
            EList<OCLExpression<C>> arguments = messageExp.getArgument();
            if (arguments.size() != attributes.size()) {
                result = false;
                message = OCLMessages.bind(OCLMessages.MessageArgumentCount_ERROR_, uml.getName(messageExp.getType()));
            } else {
                Iterator attrsIter = attributes.iterator();
                Iterator argsIter = arguments.iterator();
                while (attrsIter.hasNext()) {
                    Object attr = attrsIter.next();
                    OCLExpression arg = (OCLExpression)argsIter.next();
                    if (TypeUtil.compatibleTypeMatch(env, arg.getType(), uml.getOCLType(attr))) continue;
                    result = false;
                    message = OCLMessages.bind(OCLMessages.MessageArgConformance_ERROR_, uml.getName(attr), arg.toString());
                    break;
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 27, message, new Object[]{messageExp}));
        }
        return result;
    }

    public static <C, COA, SSA> boolean checkTargetDefinesOperation(MessageExp<C, COA, SSA> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Environment env = OCLUtil.getValidationEnvironment(messageExp, context);
        if (env != null) {
            UMLReflection uml = env.getUMLReflection();
            if (messageExp.getTarget() == null) {
                return true;
            }
            if (messageExp.getTarget().getType() == null) {
                return true;
            }
            if (messageExp.getCalledOperation() == null) {
                return true;
            }
            Object operation = uml.getOperation(messageExp.getCalledOperation());
            if (operation == null) {
                return true;
            }
            String name = uml.getName(operation);
            EList<OCLExpression<C>> arguments = messageExp.getArgument();
            Object operation1 = env.lookupOperation(messageExp.getTarget().getType(), name, arguments);
            if (operation1 != operation) {
                result = false;
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 28, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkTargetDefinesOperation", EObjectValidator.getObjectLabel(messageExp, context)}), new Object[]{messageExp}));
        }
        return result;
    }

    public static <C, COA, SSA> boolean checkHasOperationOrSignal(MessageExp<C, COA, SSA> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        if (messageExp.getCalledOperation() == null && messageExp.getSentSignal() == null) {
            result = false;
            message = OCLMessages.UnrecognizedMessageType_ERROR_;
        }
        if (messageExp.getCalledOperation() != null && messageExp.getSentSignal() != null) {
            result = false;
            message = OCLMessages.AmbiguousMessageType_ERROR_;
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 29, message, new Object[]{messageExp}));
        }
        return result;
    }

    public static <C, COA, SSA> boolean checkTargetNotCollection(MessageExp<C, COA, SSA> messageExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        OCLExpression<C> target = messageExp.getTarget();
        if (target != null && target.getType() instanceof CollectionType) {
            result = false;
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 30, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"checkTargetNotCollection", EObjectValidator.getObjectLabel(messageExp, context)}), new Object[]{messageExp}));
        }
        return result;
    }
}

