/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.egit.ui.internal.dialogs.BranchRenameDialog;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RenameBranchDialog
extends AbstractBranchSelectionDialog {
    public RenameBranchDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo, 70);
    }

    @Override
    protected void okPressed() {
        final Ref toRename = this.refFromDialog();
        if (toRename != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    BranchRenameDialog dialog = new BranchRenameDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), RenameBranchDialog.this.repo, toRename);
                    dialog.open();
                }
            });
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.RenameBranchDialog_RenameButtonLabel);
        this.getButton(0).setEnabled(!this.branchTree.getSelection().isEmpty());
    }

    @Override
    protected String getMessageText() {
        return UIText.RenameBranchDialog_DialogMessage;
    }

    @Override
    protected void createCustomArea(Composite parent) {
    }

    @Override
    protected String getTitle() {
        return UIText.RenameBranchDialog_DialogTitle;
    }

    @Override
    protected String getWindowTitle() {
        return UIText.RenameBranchDialog_WindowTitle;
    }

    @Override
    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    @Override
    protected void refNameSelected(String refName) {
        boolean branchSelected = refName != null && (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/"));
        this.setOkButtonEnabled(branchSelected);
    }
}

