/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.breakpoint;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.fordiac.ide.model.eval.Evaluator;

public abstract class EvaluatorLineBreakpoint
extends LineBreakpoint {
    public static final String DEBUG_MODEL = "org.eclipse.fordiac.ide.debug.model";
    public static final String BREAKPOINT_MARKER = "org.eclipse.fordiac.ide.debug.evaluatorLineBreakpointMarker";
    public static final String CONDITION = "org.eclipse.fordiac.ide.debug.st.stLineBreakpoint.condition";
    public static final String CONDITION_ENABLED = "org.eclipse.fordiac.ide.debug.st.stLineBreakpoint.conditionEnabled";
    private static final String CONDITION_DEFAULT = "TRUE";

    protected EvaluatorLineBreakpoint() {
    }

    protected EvaluatorLineBreakpoint(IResource resource, int lineNumber) throws CoreException {
        this.run(this.getMarkerRule(resource), monitor -> {
            IMarker iMarker = this.createMarker(resource, lineNumber);
        });
    }

    protected IMarker createMarker(IResource resource, int lineNumber) throws CoreException {
        IMarker marker = resource.createMarker(this.getMarkerId());
        this.setMarker(marker);
        marker.setAttribute("lineNumber", lineNumber);
        marker.setAttribute("message", (Object)("Line Breakpoint: " + resource.getName() + " [line: " + lineNumber + "]"));
        marker.setAttribute("org.eclipse.debug.core.enabled", true);
        marker.setAttribute("org.eclipse.debug.core.persisted", true);
        marker.setAttribute("org.eclipse.debug.core.id", (Object)this.getModelIdentifier());
        return marker;
    }

    public boolean isConditionEnabled() {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute(CONDITION_ENABLED, false);
        }
        return false;
    }

    public void setConditionEnabled(boolean enabled) throws CoreException {
        this.setAttribute(CONDITION_ENABLED, enabled);
    }

    public String getCondition() {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute(CONDITION, CONDITION_DEFAULT);
        }
        return CONDITION_DEFAULT;
    }

    public void setCondition(String condition) throws CoreException {
        this.setAttribute(CONDITION, condition);
    }

    public abstract boolean isApplicable(Evaluator var1);

    public String getMarkerId() {
        return BREAKPOINT_MARKER;
    }

    public String getModelIdentifier() {
        return DEBUG_MODEL;
    }
}

