/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;

public interface IDataProvider<C, T> {
    public Collection<C> provideComments();

    public Collection<T> provideTargets();

    default public Collection<T> provideTargetsFor(C comment) {
        return this.provideTargets();
    }

    public Collection<IDataProvider<C, T>> provideSubHierarchies();

    public void attach(C var1, T var2);

    default public IDataProvider<C, T> cached() {
        return new IDataProvider<C, T>(){
            private List<C> commentsCache = null;
            private List<T> targetsCache = null;
            private final Multimap<C, T> commentTargetsCache = HashMultimap.create();
            private List<IDataProvider<C, T>> subProviderCache = null;

            @Override
            public Collection<C> provideComments() {
                if (this.commentsCache == null) {
                    this.commentsCache = Lists.newArrayList();
                    this.commentsCache.addAll(IDataProvider.this.provideComments());
                }
                return this.commentsCache;
            }

            @Override
            public Collection<T> provideTargets() {
                if (this.targetsCache == null) {
                    this.targetsCache = Lists.newArrayList();
                    this.targetsCache.addAll(IDataProvider.this.provideTargets());
                }
                return this.targetsCache;
            }

            @Override
            public Collection<T> provideTargetsFor(C comment) {
                if (this.commentTargetsCache.containsKey(comment)) {
                    return this.commentTargetsCache.get(comment);
                }
                Collection targets = IDataProvider.this.provideTargetsFor(comment);
                this.commentTargetsCache.putAll(comment, targets);
                return targets;
            }

            @Override
            public Collection<IDataProvider<C, T>> provideSubHierarchies() {
                if (this.subProviderCache == null) {
                    this.subProviderCache = Lists.newArrayList();
                    IDataProvider.this.provideSubHierarchies().stream().map(provider -> provider.cached()).forEach(provider -> {
                        boolean bl = this.subProviderCache.add((IDataProvider)provider);
                    });
                }
                return this.subProviderCache;
            }

            @Override
            public void attach(C comment, T target) {
                IDataProvider.this.attach(comment, target);
            }
        };
    }
}

