/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateECStateCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands.CreateTransitionCommand;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.ActionCreationFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editors.StateCreationFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionAlgorithmEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECActionOutputEventEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.ecc.editparts.ECStateEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ConnCreateDirectEditDragTrackerProxy;
import org.eclipse.fordiac.ide.gef.tools.AdvancedPanningSelectionTool;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.ui.IEditorPart;

final class ECCEditorEditDomain
extends DefaultEditDomain {
    private final StateCreationTool stateCreationTool = new StateCreationTool();
    private final TransitionStateCreationTool transitionStateCreationTool = new TransitionStateCreationTool();
    private boolean transition = false;
    private boolean createTransitionAndState = false;

    ECCEditorEditDomain(IEditorPart editorPart) {
        super(editorPart);
    }

    public void keyDown(KeyEvent keyEvent, EditPartViewer viewer) {
        if (keyEvent.keyCode == SWT.MOD1) {
            if (this.transition) {
                this.createTransitionAndState = true;
                ((ECCPanningSelectionTool)this.getDefaultTool()).changeCursor();
                super.keyDown(keyEvent, viewer);
            } else {
                this.setActiveTool((Tool)this.stateCreationTool);
                super.keyDown(keyEvent, viewer);
                this.stateCreationTool.setLocationActivation(((ECCPanningSelectionTool)this.getDefaultTool()).getLastLocation());
            }
        } else {
            super.keyDown(keyEvent, viewer);
        }
    }

    public void keyUp(KeyEvent keyEvent, EditPartViewer viewer) {
        if (keyEvent.keyCode == SWT.MOD1 && !this.transition) {
            this.setActiveTool(this.getDefaultTool());
        }
        super.keyUp(keyEvent, viewer);
    }

    public void mouseDrag(MouseEvent mouseEvent, EditPartViewer viewer) {
        if (((AdvancedPanningSelectionTool)this.getDefaultTool()).getTargetEditPart() instanceof ECStateEditPart) {
            this.transition = true;
            this.transitionStateCreationTool.setSourceState(((ECStateEditPart)((AdvancedPanningSelectionTool)this.getDefaultTool()).getTargetEditPart()).getModel());
        }
        super.mouseDrag(mouseEvent, viewer);
    }

    public void mouseUp(MouseEvent mouseEvent, EditPartViewer viewer) {
        super.mouseUp(mouseEvent, viewer);
        if (this.transition) {
            if (this.createTransitionAndState && ((AdvancedPanningSelectionTool)this.getDefaultTool()).getTargetEditPart() instanceof FreeformGraphicalRootEditPart) {
                this.transitionStateCreationTool.setLocationActivation(((ECCPanningSelectionTool)this.getDefaultTool()).getLastLocation());
                this.setActiveTool((Tool)this.transitionStateCreationTool);
                this.transitionStateCreationTool.performCreation();
                this.setActiveTool(this.getDefaultTool());
                this.createTransitionAndState = false;
            }
            this.transition = false;
            this.setActiveTool(this.getDefaultTool());
        }
    }

    public static class ECCPanningSelectionTool
    extends AdvancedPanningSelectionTool {
        public Point getLastLocation() {
            return ((LocationRequest)super.getTargetHoverRequest()).getLocation();
        }

        public void changeCursor() {
            DragTracker dragTracker = this.getDragTracker();
            if (dragTracker instanceof ConnCreateDirectEditDragTrackerProxy) {
                ConnCreateDirectEditDragTrackerProxy ccdProxy = (ConnCreateDirectEditDragTrackerProxy)dragTracker;
                ccdProxy.getConnectionTool().setDisabledCursor(SharedCursors.CURSOR_TREE_ADD);
            }
        }
    }

    private static class StateCreationTool
    extends CreationTool {
        private final StateCreationFactory stateFactory = new StateCreationFactory();
        private final ActionCreationFactory actionFactory = new ActionCreationFactory();

        public StateCreationTool() {
            this.setFactory(this.stateFactory);
            this.setUnloadWhenFinished(false);
        }

        protected void handleFinished() {
            super.handleFinished();
            this.handleMove();
        }

        protected boolean updateTargetUnderMouse() {
            boolean changed = super.updateTargetUnderMouse();
            if (changed) {
                if (this.getTargetEditPart() instanceof ECStateEditPart || this.getTargetEditPart() instanceof ECActionAlgorithmEditPart || this.getTargetEditPart() instanceof ECActionOutputEventEditPart) {
                    this.setFactory(this.actionFactory);
                } else {
                    this.setFactory(this.stateFactory);
                }
            }
            return changed;
        }

        public void setLocationActivation(Point point) {
            this.getCurrentInput().setMouseLocation(point.x, point.y);
            this.handleMove();
        }
    }

    private static class TransitionStateCreationTool
    extends CreationTool {
        private Point point;
        private ECState sourceState;

        public TransitionStateCreationTool() {
            this.setFactory(new StateCreationFactory());
            this.setUnloadWhenFinished(false);
        }

        public void setSourceState(ECState state) {
            this.sourceState = state;
        }

        public void setLocationActivation(Point point) {
            this.point = point;
            this.handleMove();
        }

        public void performCreation() {
            ECState destState = (ECState)this.getFactory().getNewObject();
            CreateECStateCommand createStateCommand = new CreateECStateCommand(destState, this.point, this.getECC());
            CreateTransitionCommand createTransitionCommand = new CreateTransitionCommand(this.sourceState, destState, null);
            createTransitionCommand.setDestinationLocation(this.point);
            CompoundCommand compCom = new CompoundCommand();
            compCom.add((Command)createStateCommand);
            compCom.add((Command)createTransitionCommand);
            this.setCurrentCommand((Command)compCom);
            this.performCreation(1);
        }

        private ECC getECC() {
            if (this.sourceState != null) {
                return this.sourceState.getECC();
            }
            return null;
        }
    }
}

