/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.wizard;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public final class New4diacExampleProjectPage
extends WizardNewProjectCreationPage {
    private ListViewer exampleListViewer;
    private Text projectNameText;

    public New4diacExampleProjectPage() {
        super(Messages.New4diacExampleWizard_WizardTitle);
        this.setPageComplete(false);
        this.setDescription(Messages.New4diacExampleWizard_WizardDesc);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite container = (Composite)this.getControl();
        this.projectNameText = (Text)((Composite)container.getChildren()[0]).getChildren()[1];
        this.createExampleList(container);
        this.setControl((Control)container);
    }

    protected boolean validatePage() {
        boolean validatePage = super.validatePage();
        if (validatePage && this.getExample() == null) {
            this.setErrorMessage(null);
            this.setMessage(Messages.New4diacExampleWizard_NoExampleSelected);
        }
        return validatePage;
    }

    public File getExample() {
        Object object;
        IStructuredSelection structuredSelection = this.exampleListViewer.getStructuredSelection();
        if (!structuredSelection.isEmpty() && (object = structuredSelection.getFirstElement()) instanceof File) {
            File file = (File)object;
            return file;
        }
        return null;
    }

    public static String getExampleName(File exampleFile) {
        String exampleName = New4diacExampleProjectPage.removeFileEnding(exampleFile.getName());
        StringBuilder result = new StringBuilder();
        result.append(exampleName.charAt(0));
        int i = 1;
        while (i < exampleName.length()) {
            char c = exampleName.charAt(i);
            if (Character.isUpperCase(c) && i != 0) {
                result.append(' ');
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    private void createExampleList(Composite parent) {
        Composite listComposite = new Composite(parent, 0);
        listComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)listComposite);
        listComposite.moveAbove(parent.getChildren()[0]);
        Label label = new Label(listComposite, 0);
        label.setText(Messages.New4diacExampleWizard_SelectExample);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)label);
        this.exampleListViewer = new ListViewer(listComposite, 2564);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.exampleListViewer.getControl());
        this.exampleListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.exampleListViewer.setLabelProvider((IBaseLabelProvider)new ExamplesLabelProvider());
        this.exampleListViewer.setInput((Object)New4diacExampleProjectPage.getExamples());
        this.exampleListViewer.addSelectionChangedListener(ev -> this.handleExampleListSelection());
    }

    private void handleExampleListSelection() {
        File example = this.getExample();
        if (example != null) {
            String projectName = New4diacExampleProjectPage.removeFileEnding(example.getName());
            this.projectNameText.setText(projectName);
            this.setInitialProjectName(projectName);
        }
        this.setPageComplete(this.validatePage());
    }

    private static File[] getExamples() {
        Object[] files;
        File templateFolder = New4diacExampleProjectPage.getTypeExamplesFolder();
        if (templateFolder.isDirectory() && (files = templateFolder.listFiles(pn -> pn.getName().toUpperCase().endsWith(".ZIP"))) != null) {
            Arrays.sort(files);
            return files;
        }
        return new File[0];
    }

    private static File getTypeExamplesFolder() {
        String installLocPath = Platform.getInstallLocation().getURL().getFile();
        return new File(installLocPath + File.separatorChar + "examples");
    }

    private static String removeFileEnding(String name) {
        String exampleName = name;
        int lastDotIndex = exampleName.lastIndexOf(46);
        if (lastDotIndex > 0) {
            exampleName = exampleName.substring(0, lastDotIndex);
        }
        return exampleName;
    }

    private static final class ExamplesLabelProvider
    extends LabelProvider {
        private ExamplesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof File) {
                File file = (File)element;
                return New4diacExampleProjectPage.getExampleName(file);
            }
            return super.getText(element);
        }
    }
}

